/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfoTypes;
import org.bukkit.ChatColor;

public class ParamInfoManager {
    private static List<ParamInfo> paramList = new ParamInfoTypes().getParamInfos();

    public static List<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static ParamInfo getParamInfo(Class c) {
        for (ParamInfo info : ParamInfoManager.getParamInfos()) {
            if (!info.isParam(c)) continue;
            return info;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguisePerm disguiseType, String methodName) {
        return ParamInfoManager.getParamInfo(disguiseType.getType(), methodName);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String methodName) {
        for (Method method : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!method.getName().toLowerCase().equals(methodName.toLowerCase()) || method.getParameterTypes().length != 1 || method.getAnnotation(Deprecated.class) != null) continue;
            return ParamInfoManager.getParamInfo(method.getParameterTypes()[0]);
        }
        return null;
    }

    public static Method[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> watcherClass) {
        if (watcherClass == null) {
            return new Method[0];
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(watcherClass.getMethods()));
        Iterator<Method> itel = methods.iterator();
        while (itel.hasNext()) {
            Method method = itel.next();
            if (method.getParameterTypes().length != 1) {
                itel.remove();
                continue;
            }
            if (method.getName().startsWith("get")) {
                itel.remove();
                continue;
            }
            if (method.isAnnotationPresent(Deprecated.class)) {
                itel.remove();
                continue;
            }
            if (ParamInfoManager.getParamInfo(method.getParameterTypes()[0]) == null) {
                itel.remove();
                continue;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                itel.remove();
                continue;
            }
            if (!method.getName().equals("removePotionEffect")) continue;
            itel.remove();
        }
        methods.sort((m1, m2) -> {
            int v2;
            int v1 = ParamInfoManager.getValue(m1);
            if (v1 != (v2 = ParamInfoManager.getValue(m2))) {
                return v1 - v2;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
        });
        for (String methodName : new String[]{"setViewSelfDisguise", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer"}) {
            try {
                methods.add(Disguise.class.getMethod(methodName, Boolean.TYPE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return methods.toArray(new Method[0]);
    }

    public static int getValue(Method method) {
        ChatColor methodColor = ChatColor.YELLOW;
        Class<?> declaring = method.getDeclaringClass();
        if (declaring == LivingWatcher.class) {
            return 1;
        }
        if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
            return 2;
        }
        return 0;
    }
}

