/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerMain
extends PacketAdapter {
    public PacketListenerMain(LibsDisguises plugin, ArrayList<PacketType> packetsToListen) {
        super((Plugin)plugin, ListenerPriority.HIGH, packetsToListen);
    }

    public void onPacketSending(PacketEvent event) {
        LibsPackets packets;
        if (event.isCancelled()) {
            return;
        }
        Player observer = event.getPlayer();
        if (observer.getName().contains("UNKNOWN[")) {
            return;
        }
        StructureModifier entityModifer = event.getPacket().getEntityModifier(observer.getWorld());
        Entity entity = (Entity)entityModifer.read(PacketType.Play.Server.COLLECT == event.getPacketType() ? 1 : 0);
        if (entity == observer) {
            return;
        }
        Disguise disguise = DisguiseAPI.getDisguise(observer, entity);
        if (disguise == null) {
            return;
        }
        try {
            packets = PacketsManager.getPacketsHandler().transformPacket(event.getPacket(), disguise, observer, entity);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.setCancelled(true);
            return;
        }
        if (packets.isUnhandled()) {
            return;
        }
        packets.setSpawnPacketCheck(event.getPacketType());
        event.setCancelled(true);
        try {
            for (PacketContainer packet : packets.getPackets()) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
            }
            packets.sendDelayed(observer);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}

