/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.events.DisguiseInteractEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketListenerClientInteract
extends PacketAdapter {
    public PacketListenerClientInteract(LibsDisguises plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.USE_ENTITY});
    }

    public void onPacketReceiving(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player observer = event.getPlayer();
        if (observer.getName().contains("UNKNOWN[")) {
            return;
        }
        PacketContainer packet = event.getPacket();
        StructureModifier entityModifer = packet.getEntityModifier(observer.getWorld());
        Entity entity = (Entity)entityModifer.read(0);
        if (entity instanceof ExperienceOrb || entity instanceof Item || entity instanceof Arrow || entity == observer) {
            event.setCancelled(true);
        } else if ((Integer)packet.getIntegers().read(0) == DisguiseAPI.getSelfDisguiseId()) {
            event.setCancelled(true);
            Disguise disguise = DisguiseAPI.getDisguise(observer, (Entity)observer);
            if (disguise != null) {
                EnumWrappers.EntityUseAction interactType = (EnumWrappers.EntityUseAction)packet.getEntityUseActions().read(0);
                EquipmentSlot handUsed = EquipmentSlot.HAND;
                if (interactType != EnumWrappers.EntityUseAction.ATTACK && packet.getHands().read(0) == EnumWrappers.Hand.OFF_HAND) {
                    handUsed = EquipmentSlot.OFF_HAND;
                }
                final DisguiseInteractEvent selfEvent = new DisguiseInteractEvent((TargetedDisguise)disguise, handUsed, interactType == EnumWrappers.EntityUseAction.ATTACK);
                new BukkitRunnable(){

                    public void run() {
                        Bukkit.getPluginManager().callEvent((Event)selfEvent);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }
        for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
            AgeableWatcher watcher;
            Disguise disguise;
            AnimalColor color;
            if (item == null || (color = AnimalColor.getColorByMaterial(item.getType())) == null || (disguise = DisguiseAPI.getDisguise(observer, entity)) == null || disguise.getType() != DisguiseType.SHEEP && disguise.getType() != DisguiseType.WOLF) continue;
            if (disguise.getType() == DisguiseType.SHEEP) {
                watcher = (SheepWatcher)disguise.getWatcher();
                ((SheepWatcher)watcher).setColor(DisguiseConfig.isSheepDyeable() ? color : ((SheepWatcher)watcher).getColor());
                continue;
            }
            watcher = (WolfWatcher)disguise.getWatcher();
            ((WolfWatcher)watcher).setCollarColor(DisguiseConfig.isWolfDyeable() ? color : ((WolfWatcher)watcher).getCollarColor());
        }
    }
}

