/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientInteract;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerInventory;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerMain;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerSounds;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerTabList;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerViewSelfDisguise;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketsManager {
    private static PacketListener clientInteractEntityListener;
    private static PacketListener inventoryListener;
    private static boolean inventoryModifierEnabled;
    private static LibsDisguises libsDisguises;
    private static PacketListener mainListener;
    private static PacketListener soundsListener;
    private static boolean soundsListenerEnabled;
    private static PacketListener viewDisguisesListener;
    private static boolean viewDisguisesListenerEnabled;
    private static PacketsHandler packetsHandler;

    public static void addPacketListeners() {
        clientInteractEntityListener = new PacketListenerClientInteract(libsDisguises);
        PacketListenerTabList tabListListener = new PacketListenerTabList(libsDisguises);
        ProtocolLibrary.getProtocolManager().addPacketListener(clientInteractEntityListener);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)tabListListener);
        PacketsManager.setupMainPacketsListener();
    }

    public static void init(LibsDisguises plugin) {
        libsDisguises = plugin;
        soundsListener = new PacketListenerSounds(libsDisguises);
        viewDisguisesListener = new PacketListenerViewSelfDisguise(libsDisguises);
        inventoryListener = new PacketListenerInventory(libsDisguises);
        packetsHandler = new PacketsHandler();
    }

    public static PacketsHandler getPacketsHandler() {
        return packetsHandler;
    }

    public static boolean isHearDisguisesEnabled() {
        return soundsListenerEnabled;
    }

    public static boolean isInventoryListenerEnabled() {
        return inventoryModifierEnabled;
    }

    public static boolean isViewDisguisesListenerEnabled() {
        return viewDisguisesListenerEnabled;
    }

    public static void setHearDisguisesListener(boolean enabled) {
        if (soundsListenerEnabled != enabled) {
            soundsListenerEnabled = enabled;
            if (soundsListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(soundsListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(soundsListener);
            }
        }
    }

    public static void setInventoryListenerEnabled(boolean enabled) {
        if (inventoryModifierEnabled != enabled) {
            inventoryModifierEnabled = enabled;
            if (inventoryModifierEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(inventoryListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(inventoryListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !viewDisguisesListenerEnabled || !disguise.isSelfDisguiseVisible() || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }

    public static void setupMainPacketsListener() {
        if (clientInteractEntityListener != null) {
            if (mainListener != null) {
                ProtocolLibrary.getProtocolManager().removePacketListener(mainListener);
            }
            ArrayList<PacketType> packetsToListen = new ArrayList<PacketType>();
            packetsToListen.add(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            packetsToListen.add(PacketType.Play.Server.ENTITY_METADATA);
            if (DisguiseConfig.isCollectPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.COLLECT);
            }
            if (DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
                packetsToListen.add(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            }
            if (DisguiseConfig.isBedPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.BED);
            }
            if (DisguiseConfig.isMovementPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_LOOK);
                packetsToListen.add(PacketType.Play.Server.REL_ENTITY_MOVE_LOOK);
                packetsToListen.add(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                packetsToListen.add(PacketType.Play.Server.ENTITY_TELEPORT);
                packetsToListen.add(PacketType.Play.Server.REL_ENTITY_MOVE);
                packetsToListen.add(PacketType.Play.Server.ENTITY_VELOCITY);
            }
            if (DisguiseConfig.isEquipmentPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_EQUIPMENT);
            }
            if (DisguiseConfig.isAnimationPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ANIMATION);
            }
            if (DisguiseConfig.isEntityStatusPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_STATUS);
            }
            mainListener = new PacketListenerMain(libsDisguises, packetsToListen);
            ProtocolLibrary.getProtocolManager().addPacketListener(mainListener);
        }
    }

    public static void setViewDisguisesListener(boolean enabled) {
        if (viewDisguisesListenerEnabled != enabled) {
            viewDisguisesListenerEnabled = enabled;
            if (viewDisguisesListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(viewDisguisesListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(viewDisguisesListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !disguise.isSelfDisguiseVisible()) continue;
                if (enabled) {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                } else {
                    DisguiseUtilities.removeSelfDisguise(player);
                }
                if (!inventoryModifierEnabled || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }
}

