/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LibsPackets {
    private ArrayList<PacketContainer> packets = new ArrayList();
    private HashMap<Integer, ArrayList<PacketContainer>> delayedPackets = new HashMap();
    private boolean isSpawnPacket;
    private Disguise disguise;
    private boolean doNothing;

    public LibsPackets(Disguise disguise) {
        this.disguise = disguise;
    }

    public void setUnhandled() {
        this.doNothing = true;
    }

    public boolean isUnhandled() {
        return this.doNothing;
    }

    public Disguise getDisguise() {
        return this.disguise;
    }

    public void setSpawnPacketCheck(PacketType type) {
        this.isSpawnPacket = type.name().contains("SPAWN") && type.name().contains("ENTITY");
    }

    public void addPacket(PacketContainer packet) {
        this.packets.add(packet);
    }

    public void addDelayedPacket(PacketContainer packet) {
        this.addDelayedPacket(packet, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketContainer packet, int ticksDelayed) {
        if (!this.delayedPackets.containsKey(ticksDelayed)) {
            this.delayedPackets.put(ticksDelayed, new ArrayList());
        }
        this.delayedPackets.get(ticksDelayed).add(packet);
    }

    public ArrayList<PacketContainer> getPackets() {
        return this.packets;
    }

    public Collection<ArrayList<PacketContainer>> getDelayedPackets() {
        return this.delayedPackets.values();
    }

    public void sendDelayed(Player observer) {
        Iterator<Map.Entry<Integer, ArrayList<PacketContainer>>> itel = this.delayedPackets.entrySet().iterator();
        Optional largestTick = this.delayedPackets.keySet().stream().max(Integer::compare);
        if (!largestTick.isPresent()) {
            return;
        }
        while (itel.hasNext()) {
            Map.Entry<Integer, ArrayList<PacketContainer>> entry = itel.next();
            boolean isRemoveCancel = this.isSpawnPacket && ((Integer)largestTick.get()).equals(entry.getKey());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                try {
                    for (PacketContainer packet : (ArrayList)entry.getValue()) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (isRemoveCancel) {
                    PacketsManager.getPacketsHandler().removeCancel(this.disguise, observer);
                }
            }, (long)entry.getKey().intValue());
        }
    }
}

