/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.metrics.Metrics;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;

public class MetricsInitalizer {
    public MetricsInitalizer() {
        this.infectWithMetrics();
    }

    private void infectWithMetrics() {
        LibsDisguises plugin = LibsDisguises.getInstance();
        String version = plugin.getDescription().getVersion();
        if (!plugin.isReleaseBuild() || !LibsPremium.isPremium().booleanValue()) {
            version = version + "-";
            if (plugin.isNumberedBuild()) {
                version = version + "b";
            }
            version = version + plugin.getBuildNo();
        }
        Metrics metrics = new Metrics(plugin, version);
        final String premiumType = LibsPremium.isPremium().booleanValue() ? (plugin.isReleaseBuild() ? "Paid Plugin" : "Paid Builds") : "Free Builds";
        metrics.addCustomChart(new Metrics.SimplePie("premium"){

            @Override
            public String getValue() {
                return premiumType;
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("translations"){

            @Override
            public String getValue() {
                return LibsPremium.isPremium() != false && DisguiseConfig.isUseTranslations() ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("custom_disguises"){

            @Override
            public String getValue() {
                HashMap<DisguisePerm, String> map = DisguiseConfig.getCustomDisguises();
                return map.size() + (map.containsKey("libraryaddict") ? -1 : 0) > 0 ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.MultiLineChart("disguised_entities"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> hashMap) {
                for (HashSet<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
                    for (Disguise disguise : list) {
                        String name;
                        if (disguise.getEntity() == null || !disguise.isDisguiseInUse()) continue;
                        hashMap.put(name, hashMap.containsKey(name = disguise.getEntity().getType().name()) ? hashMap.get(name) + 1 : 1);
                    }
                }
                return hashMap;
            }
        });
        metrics.addCustomChart(new Metrics.MultiLineChart("disguises_used"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> hashMap) {
                for (HashSet<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
                    for (Disguise disguise : list) {
                        String name;
                        if (disguise.getEntity() == null || !disguise.isDisguiseInUse()) continue;
                        hashMap.put(name, hashMap.containsKey(name = disguise.getType().name()) ? hashMap.get(name) + 1 : 1);
                    }
                }
                return hashMap;
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("disguised_using"){

            @Override
            public String getValue() {
                if (DisguiseUtilities.isPluginsUsed()) {
                    if (DisguiseUtilities.isCommandsUsed()) {
                        return "Plugins and Commands";
                    }
                    return "Plugins";
                }
                if (DisguiseUtilities.isCommandsUsed()) {
                    return "Commands";
                }
                return "Unknown";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("active_disguises"){

            @Override
            public String getValue() {
                int disgs = 0;
                for (HashSet<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
                    disgs += set.size();
                }
                if (disgs == 0) {
                    return "0";
                }
                if (disgs <= 5) {
                    return "1 to 5";
                }
                if (disgs <= 15) {
                    return "6 to 15";
                }
                if (disgs <= 30) {
                    return "16 to 30";
                }
                if (disgs <= 60) {
                    return "30 to 60";
                }
                if (disgs <= 100) {
                    return "60 to 100";
                }
                if (disgs <= 200) {
                    return "100 to 200";
                }
                return "More than 200";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("self_disguises"){

            @Override
            public String getValue() {
                return DisguiseConfig.isViewDisguises() ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("commands"){

            @Override
            public String getValue() {
                return DisguiseConfig.isDisableCommands() ? "Enabled" : "Disabled";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("spigot"){

            @Override
            public String getValue() {
                try {
                    Class.forName("org.spigotmc.SpigotConfig");
                    return "Yes";
                }
                catch (Exception ex) {
                    return "No";
                }
            }
        });
        final boolean updates = plugin.getConfig().getBoolean("NotifyUpdate");
        metrics.addCustomChart(new Metrics.SimplePie("updates"){

            @Override
            public String getValue() {
                return updates ? "Enabled" : "Disabled";
            }
        });
        if (plugin.getBuildNo() != null) {
            final String buildNo = plugin.getBuildNo();
            metrics.addCustomChart(new Metrics.SimplePie("build_number"){

                @Override
                public String getValue() {
                    return buildNo;
                }
            });
        }
        metrics.addCustomChart(new Metrics.SimplePie("targeted_disguises"){
            private boolean targetedDisguises;

            @Override
            public String getValue() {
                if (this.targetedDisguises) {
                    return "Yes";
                }
                Collection<HashSet<TargetedDisguise>> list = DisguiseUtilities.getDisguises().values();
                if (list.isEmpty()) {
                    return "Unknown";
                }
                for (HashSet<TargetedDisguise> dList : list) {
                    for (TargetedDisguise disg : dList) {
                        if (disg.getObservers().isEmpty()) continue;
                        this.targetedDisguises = true;
                        return "Yes";
                    }
                }
                return "No";
            }
        });
    }
}

