/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.json;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;

public class SerializerFlagWatcher
implements JsonDeserializer<FlagWatcher>,
JsonSerializer<FlagWatcher>,
InstanceCreator<FlagWatcher> {
    public FlagWatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            FlagWatcher watcher = (FlagWatcher)context.deserialize(json, Class.forName(((JsonObject)json).get("flagType").getAsString()));
            DisguiseType entity = DisguiseType.valueOf(((JsonObject)json).get("entityType").getAsString());
            this.correct(watcher, watcher.getClass(), "entityValues");
            this.correct(watcher, entity.getWatcherClass(), "backupEntityValues");
            return watcher;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void correct(FlagWatcher watcher, Class<? extends FlagWatcher> flagWatcher, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = FlagWatcher.class.getDeclaredField(name);
        field.setAccessible(true);
        HashMap map = (HashMap)field.get(watcher);
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Double)) continue;
            MetaIndex index = MetaIndex.getMetaIndex(flagWatcher, (Integer)entry.getKey());
            Object def = index.getDefault();
            if (def instanceof Long) {
                entry.setValue(((Double)entry.getValue()).longValue());
                continue;
            }
            if (def instanceof Float) {
                entry.setValue(Float.valueOf(((Double)entry.getValue()).floatValue()));
                continue;
            }
            if (def instanceof Integer) {
                entry.setValue(((Double)entry.getValue()).intValue());
                continue;
            }
            if (def instanceof Short) {
                entry.setValue(((Double)entry.getValue()).shortValue());
                continue;
            }
            if (!(def instanceof Byte)) continue;
            entry.setValue(((Double)entry.getValue()).byteValue());
        }
    }

    public FlagWatcher createInstance(Type type) {
        try {
            return (FlagWatcher)type.getClass().getConstructor(Disguise.class).newInstance(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JsonElement serialize(FlagWatcher src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = (JsonObject)context.serialize((Object)src);
        obj.addProperty("flagType", src.getClass().getName());
        try {
            Method method = FlagWatcher.class.getDeclaredMethod("getDisguise", new Class[0]);
            method.setAccessible(true);
            Disguise disguise = (Disguise)method.invoke((Object)src, new Object[0]);
            obj.addProperty("entityType", disguise.getType().name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }
}

