/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class LibsPremium {
    private static Boolean thisPluginIsPaidFor;

    public static String getUserID() {
        return "%%__USER__%%";
    }

    public static String getResourceID() {
        return "%%__RESOURCE__%%";
    }

    public static String getDownloadID() {
        return "%%__NONCE__%%";
    }

    private static Boolean isPremium(String userID) {
        return !userID.contains("__USER__");
    }

    public static Boolean isPremium() {
        return thisPluginIsPaidFor == null ? !LibsPremium.getUserID().contains("__USER__") : thisPluginIsPaidFor;
    }

    private static boolean isValidVersion(String currentVersion, String premiumVersion) {
        String[] nSplit;
        currentVersion = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        if (!premiumVersion.matches("[0-9]+(\\.[0-9]+)+")) {
            return false;
        }
        if (!currentVersion.matches("[0-9]+(\\.[0-9]+)+")) {
            return true;
        }
        String[] cSplit = currentVersion.split("\\.");
        return cSplit[0].compareTo((nSplit = premiumVersion.split("\\."))[0]) <= 0;
    }

    private static PluginInformation getInformation(File file) throws Exception {
        try (URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});){
            Boolean premium;
            Class<?> c = cl.loadClass(LibsPremium.class.getName());
            boolean oldJarFile = true;
            try {
                c.getMethod("getUserID", new Class[0]);
                oldJarFile = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            YamlConfiguration config = ReflectionManager.getPluginYaml(cl);
            String userId = null;
            if (oldJarFile) {
                premium = (Boolean)c.getMethod("isPremium", new Class[0]).invoke(null, new Object[0]);
            } else {
                userId = (String)c.getMethod("getUserID", new Class[0]).invoke(null, new Object[0]);
                premium = LibsPremium.isPremium(userId);
            }
            String pluginBuildDate = "??/??/????";
            if (config.contains("build-date")) {
                pluginBuildDate = config.getString("build-date");
            }
            String pluginBuildNumber = "???";
            if (config.contains("build-number") && (pluginBuildNumber = config.getString("build-number")).matches("[0-9]+")) {
                pluginBuildNumber = "#" + pluginBuildNumber;
            }
            String pluginVersion = config.getString("version");
            PluginInformation pluginInformation = new PluginInformation(userId, premium, pluginVersion, pluginBuildNumber, pluginBuildDate);
            return pluginInformation;
        }
    }

    private static void doSecondaryCheck(String version) {
        File[] files = new File("plugins/LibsDisguises/").listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            PluginInformation plugin;
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try {
                plugin = LibsPremium.getInformation(file);
            }
            catch (ClassNotFoundException ex) {
                DisguiseUtilities.getLogger().warning("Found an unrecognized jar in the LibsDisguises folder (" + file.getName() + ")");
                continue;
            }
            catch (Exception ex) {
                DisguiseUtilities.getLogger().warning("Error while trying to handle the file " + file.getName());
                ex.printStackTrace();
                continue;
            }
            String fileInfo = String.format("v%s, build %s, created %s", plugin.getVersion(), plugin.getBuildNumber(), plugin.getBuildDate());
            if (plugin.isPremium()) {
                if (!LibsPremium.isValidVersion(version, plugin.getVersion())) {
                    DisguiseUtilities.getLogger().warning("You have an old Lib's Disguises jar (" + file.getName() + " " + fileInfo + ") in the LibsDisguises folder! For security purposes, please replace this with a new version from SpigotMC - https://www.spigotmc.org/resources/libs-disguises.32453/");
                    continue;
                }
                thisPluginIsPaidFor = true;
                DisguiseUtilities.getLogger().info("Found a premium Lib's Disguises jar (" + fileInfo + ")");
                DisguiseUtilities.getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(plugin.getUserID()));
                break;
            }
            DisguiseUtilities.getLogger().warning("You have a non-premium Lib's Disguises jar (" + file.getName() + " " + fileInfo + ") in the LibsDisguises folder!");
        }
    }

    private static String getSanitizedUser(String userID) {
        if (userID == null) {
            return "N/A";
        }
        if (!userID.matches("[0-9]+")) {
            return String.format("... %s? Am I reading this right?", userID);
        }
        return userID;
    }

    public static void check(String version) {
        thisPluginIsPaidFor = LibsPremium.isPremium();
        if (!LibsPremium.isPremium().booleanValue()) {
            LibsPremium.doSecondaryCheck(version);
        } else {
            DisguiseUtilities.getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(LibsPremium.getUserID()));
        }
        if (LibsPremium.isPremium().booleanValue()) {
            DisguiseUtilities.getLogger().info("Premium enabled, thank you for supporting Lib's Disguises!");
        }
    }

    private static class PluginInformation {
        private String userID;
        private boolean premium;
        private String version;
        private String buildNumber;
        private String buildDate;

        public PluginInformation(String userID, boolean premium, String version, String buildNumber, String buildDate) {
            this.userID = userID;
            this.premium = premium;
            this.version = version;
            this.buildNumber = buildNumber;
            this.buildDate = buildDate;
        }

        public String getUserID() {
            return this.userID;
        }

        public boolean isPremium() {
            return this.premium;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getBuildDate() {
            return this.buildDate;
        }

        public Date getParsedBuildDate() {
            try {
                return new SimpleDateFormat("dd/MM/yyyy HH:mm").parse(this.getBuildDate());
            }
            catch (ParseException e) {
                return null;
            }
        }
    }
}

