/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.json.SerializerChatComponent;
import me.libraryaddict.disguise.utilities.json.SerializerDisguise;
import me.libraryaddict.disguise.utilities.json.SerializerFlagWatcher;
import me.libraryaddict.disguise.utilities.json.SerializerGameProfile;
import me.libraryaddict.disguise.utilities.json.SerializerItemStack;
import me.libraryaddict.disguise.utilities.json.SerializerMetaIndex;
import me.libraryaddict.disguise.utilities.json.SerializerWrappedBlockData;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.reflection.DisguiseValues;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.util.Strings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class DisguiseUtilities {
    public static final Random random = new Random();
    private static LinkedHashMap<String, Disguise> clonedDisguises = new LinkedHashMap();
    private static HashMap<UUID, HashSet<TargetedDisguise>> disguisesInUse = new HashMap();
    private static HashMap<Integer, HashSet<TargetedDisguise>> futureDisguises = new HashMap();
    private static HashSet<UUID> savedDisguiseList = new HashSet();
    private static HashSet<String> cachedNames = new HashSet();
    private static HashMap<String, ArrayList<Object>> runnables = new HashMap();
    private static HashSet<UUID> selfDisguised = new HashSet();
    private static Thread mainThread;
    private static PacketContainer spawnChunk;
    private static HashMap<UUID, String> preDisguiseTeam;
    private static HashMap<UUID, String> disguiseTeam;
    private static File profileCache;
    private static File savedDisguises;
    private static Gson gson;
    private static boolean pluginsUsed;
    private static boolean commandsUsed;
    private static long libsDisguisesCalled;
    private static long velocityTime;
    private static int velocityID;

    public static void setPlayerVelocity(Player player) {
        velocityID = player.getEntityId();
        velocityTime = player.getWorld().getTime();
    }

    public static boolean isPlayerVelocity(Player player) {
        return player.getEntityId() == velocityID && player.getWorld().getTime() - velocityTime < 3L;
    }

    public static void setPluginsUsed() {
        if (libsDisguisesCalled > System.currentTimeMillis()) {
            return;
        }
        pluginsUsed = true;
    }

    public static void resetPluginTimer() {
        libsDisguisesCalled = System.currentTimeMillis() + 100L;
    }

    public static void setCommandsUsed() {
        DisguiseUtilities.resetPluginTimer();
        commandsUsed = true;
    }

    public static boolean isPluginsUsed() {
        return pluginsUsed;
    }

    public static boolean isCommandsUsed() {
        return commandsUsed;
    }

    public static void saveDisguises() {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!DisguiseConfig.isSaveEntityDisguises() && !DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        DisguiseUtilities.getLogger().info("Now saving disguises..");
        block0: for (HashSet<TargetedDisguise> list : disguisesInUse.values()) {
            for (TargetedDisguise disg : list) {
                if (disg.getEntity() == null || (disg.getEntity() instanceof Player ? DisguiseConfig.isSavePlayerDisguises() : DisguiseConfig.isSaveEntityDisguises())) continue;
                DisguiseUtilities.saveDisguises(disg.getEntity().getUniqueId(), list.toArray(new Disguise[0]));
                continue block0;
            }
        }
        DisguiseUtilities.getLogger().info("Saved disguises.");
    }

    public static boolean hasGameProfile(String playername) {
        return cachedNames.contains(playername.toLowerCase());
    }

    public static void createClonedDisguise(Player player, Entity toClone, Boolean[] options) {
        Disguise disguise = DisguiseAPI.getDisguise(player, toClone);
        disguise = disguise == null ? DisguiseAPI.constructDisguise(toClone, options[0], options[1], options[2]) : disguise.clone();
        char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        String reference = null;
        int referenceLength = Math.max(2, (int)Math.ceil((0.1 + (double)DisguiseConfig.getMaxClonedDisguises()) / 26.0));
        int attempts = 0;
        while (reference == null && attempts++ < 1000) {
            reference = "@";
            for (int i = 0; i < referenceLength; ++i) {
                reference = reference + alphabet[random.nextInt(alphabet.length)];
            }
            if (DisguiseUtilities.getClonedDisguise(reference) == null) continue;
            reference = null;
        }
        if (reference != null && DisguiseUtilities.addClonedDisguise(reference, disguise)) {
            String entityName = DisguiseType.getType(toClone).toReadable();
            player.sendMessage(LibsMsg.MADE_REF.get(entityName, reference));
            player.sendMessage(LibsMsg.MADE_REF_EXAMPLE.get(reference));
        } else {
            player.sendMessage(LibsMsg.REF_TOO_MANY.get(new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveDisguises(UUID owningEntity, Disguise[] disguise) {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        try {
            File disguiseFile = new File(savedDisguises, owningEntity.toString());
            if (disguise == null || disguise.length == 0) {
                if (!savedDisguiseList.contains(owningEntity)) return;
                disguiseFile.delete();
                return;
            } else {
                Disguise[] disguises = new Disguise[disguise.length];
                for (int i = 0; i < disguise.length; ++i) {
                    Disguise dis = disguise[i].clone();
                    dis.setEntity(null);
                    disguises[i] = dis;
                }
                PrintWriter writer = new PrintWriter(disguiseFile);
                writer.write(gson.toJson((Object)disguises));
                writer.close();
                savedDisguiseList.add(owningEntity);
            }
            return;
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    public static Disguise[] getSavedDisguises(UUID entityUUID) {
        return DisguiseUtilities.getSavedDisguises(entityUUID, false);
    }

    public static Disguise[] getSavedDisguises(UUID entityUUID, boolean remove) {
        File disguiseFile;
        if (!DisguiseUtilities.isSavedDisguise(entityUUID) || !LibsPremium.isPremium().booleanValue()) {
            return new Disguise[0];
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        if (!(disguiseFile = new File(savedDisguises, entityUUID.toString())).exists()) {
            savedDisguiseList.remove(entityUUID);
            return new Disguise[0];
        }
        try {
            Disguise[] disguises;
            String cached = FileUtils.readFileToString((File)disguiseFile, (String)"UTF-8");
            if (remove) {
                DisguiseUtilities.removeSavedDisguise(entityUUID);
            }
            if ((disguises = (Disguise[])gson.fromJson(cached, Disguise[].class)) == null) {
                return new Disguise[0];
            }
            return disguises;
        }
        catch (Exception e) {
            DisguiseUtilities.getLogger().severe("Malformed disguise for " + entityUUID);
            e.printStackTrace();
            return new Disguise[0];
        }
    }

    public static void removeSavedDisguise(UUID entityUUID) {
        if (!savedDisguiseList.remove(entityUUID)) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        File disguiseFile = new File(savedDisguises, entityUUID.toString());
        disguiseFile.delete();
    }

    public static boolean isSavedDisguise(UUID entityUUID) {
        return savedDisguiseList.contains(entityUUID);
    }

    public static boolean addClonedDisguise(String key, Disguise disguise) {
        if (DisguiseConfig.getMaxClonedDisguises() > 0) {
            if (clonedDisguises.containsKey(key)) {
                clonedDisguises.remove(key);
            } else if (DisguiseConfig.getMaxClonedDisguises() == clonedDisguises.size()) {
                clonedDisguises.remove(clonedDisguises.keySet().iterator().next());
            }
            if (DisguiseConfig.getMaxClonedDisguises() > clonedDisguises.size()) {
                clonedDisguises.put(key, disguise);
                return true;
            }
        }
        return false;
    }

    public static void addDisguise(UUID entityId, TargetedDisguise disguise) {
        if (!DisguiseUtilities.getDisguises().containsKey(entityId)) {
            DisguiseUtilities.getDisguises().put(entityId, new HashSet());
        }
        DisguiseUtilities.getDisguises().get(entityId).add(disguise);
        DisguiseUtilities.checkConflicts(disguise, null);
        if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox(disguise);
        }
    }

    public static void addFutureDisguise(final int entityId, final TargetedDisguise disguise) {
        if (!futureDisguises.containsKey(entityId)) {
            futureDisguises.put(entityId, new HashSet());
        }
        futureDisguises.get(entityId).add(disguise);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (futureDisguises.containsKey(entityId) && ((HashSet)futureDisguises.get(entityId)).contains(disguise)) {
                    for (World world : Bukkit.getWorlds()) {
                        for (Entity entity : world.getEntities()) {
                            if (entity.getEntityId() != entityId) continue;
                            UUID uniqueId = entity.getUniqueId();
                            for (TargetedDisguise disguise2 : (HashSet)futureDisguises.remove(entityId)) {
                                DisguiseUtilities.addDisguise(uniqueId, disguise2);
                            }
                            return;
                        }
                    }
                    ((HashSet)futureDisguises.get(entityId)).remove(disguise);
                    if (((HashSet)futureDisguises.get(entityId)).isEmpty()) {
                        futureDisguises.remove(entityId);
                    }
                }
            }
        };
        runnable.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
    }

    public static void addGameProfile(String string, WrappedGameProfile gameProfile) {
        try {
            if (!profileCache.exists()) {
                profileCache.mkdirs();
            }
            File file = new File(profileCache, string.toLowerCase());
            PrintWriter writer = new PrintWriter(file);
            writer.write(gson.toJson((Object)gameProfile));
            writer.close();
            cachedNames.add(string.toLowerCase());
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    public static void checkConflicts(TargetedDisguise disguise, String name) {
        if (DisguiseAPI.isDisguiseInUse(disguise)) {
            Iterator<TargetedDisguise> disguiseItel = DisguiseUtilities.getDisguises().get(disguise.getEntity().getUniqueId()).iterator();
            while (disguiseItel.hasNext()) {
                TargetedDisguise d = disguiseItel.next();
                if (d == disguise) continue;
                if (d.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                        if (name != null) {
                            d.removePlayer(name);
                            continue;
                        }
                        for (String playername : disguise.getObservers()) {
                            d.silentlyRemovePlayer(playername);
                        }
                        continue;
                    }
                    if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                    if (name != null) {
                        if (disguise.getObservers().contains(name)) continue;
                        d.removePlayer(name);
                        continue;
                    }
                    for (String playername : new ArrayList<String>(d.getObservers())) {
                        if (disguise.getObservers().contains(playername)) continue;
                        d.silentlyRemovePlayer(playername);
                    }
                    continue;
                }
                if (d.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (name != null) {
                        d.addPlayer(name);
                        continue;
                    }
                    for (String playername : disguise.getObservers()) {
                        d.silentlyAddPlayer(playername);
                    }
                    continue;
                }
                if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                disguiseItel.remove();
                d.removeDisguise(true);
            }
        }
    }

    public static void destroyEntity(TargetedDisguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (entityTrackerEntry == null) {
                return;
            }
            Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
            trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
            PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            destroyPacket.getIntegerArrays().write(0, (Object)new int[]{disguise.getEntity().getEntityId()});
            for (Object p : trackedPlayers) {
                Player player = (Player)ReflectionManager.getBukkitEntity(p);
                if (player != disguise.getEntity() && !disguise.canSee(player)) continue;
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void doBoundingBox(TargetedDisguise disguise) {
        Entity entity = disguise.getEntity();
        if (entity == null) {
            return;
        }
        if (DisguiseUtilities.isDisguiseInUse(disguise)) {
            DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(disguise.getType());
            FakeBoundingBox disguiseBox = disguiseValues.getAdultBox();
            if (disguiseValues.getBabyBox() != null && (disguise.getWatcher() instanceof AgeableWatcher && ((AgeableWatcher)disguise.getWatcher()).isBaby() || disguise.getWatcher() instanceof ZombieWatcher && ((ZombieWatcher)disguise.getWatcher()).isBaby())) {
                disguiseBox = disguiseValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, disguiseBox);
        } else {
            DisguiseValues entityValues = DisguiseValues.getDisguiseValues(DisguiseType.getType(entity.getType()));
            FakeBoundingBox entityBox = entityValues.getAdultBox();
            if (entityValues.getBabyBox() != null && (entity instanceof Ageable && !((Ageable)entity).isAdult() || entity instanceof Zombie && ((Zombie)entity).isBaby())) {
                entityBox = entityValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, entityBox);
        }
    }

    public static int getChunkCord(int blockCord) {
        int cord = (int)Math.floor((double)blockCord / 16.0) - 17;
        cord -= cord % 8;
        return cord;
    }

    public static PacketContainer[] getBedChunkPacket(Location newLoc, Location oldLoc) {
        StructureModifier modifier;
        int i = 0;
        PacketContainer[] packets = new PacketContainer[(newLoc != null ? 1 : 0) + (oldLoc != null ? 1 : 0)];
        if (oldLoc != null) {
            PacketContainer despawn = new PacketContainer(PacketType.Play.Server.UNLOAD_CHUNK);
            modifier = despawn.getModifier();
            modifier.write(0, (Object)DisguiseUtilities.getChunkCord(oldLoc.getBlockX()));
            modifier.write(1, (Object)DisguiseUtilities.getChunkCord(oldLoc.getBlockZ()));
            packets[i++] = despawn;
        }
        if (newLoc != null) {
            PacketContainer spawn = spawnChunk.shallowClone();
            modifier = spawn.getModifier();
            modifier.write(0, (Object)DisguiseUtilities.getChunkCord(newLoc.getBlockX()));
            modifier.write(1, (Object)DisguiseUtilities.getChunkCord(newLoc.getBlockZ()));
            packets[i++] = spawn;
        }
        return packets;
    }

    public static PacketContainer[] getBedPackets(Location sleepingLocation, Location playerLocation, PlayerDisguise disguise) {
        int entity = disguise.getEntity().getEntityId();
        PlayerWatcher watcher = disguise.getWatcher();
        PacketContainer setBed = new PacketContainer(PacketType.Play.Server.BED);
        int bX = DisguiseUtilities.getChunkCord(playerLocation.getBlockX()) * 16 + 1 + watcher.getSleepingDirection().getModX();
        int bZ = DisguiseUtilities.getChunkCord(playerLocation.getBlockZ()) * 16 + 1 + watcher.getSleepingDirection().getModZ();
        setBed.getIntegers().write(0, (Object)entity);
        setBed.getBlockPositionModifier().write(0, (Object)new BlockPosition(bX, 0, bZ));
        PacketContainer teleport = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        StructureModifier doubles = teleport.getDoubles();
        teleport.getIntegers().write(0, (Object)entity);
        doubles.write(0, (Object)sleepingLocation.getX());
        doubles.write(1, (Object)(DisguiseUtilities.getYModifier(disguise.getEntity(), disguise) + sleepingLocation.getY()));
        doubles.write(2, (Object)sleepingLocation.getZ());
        return new PacketContainer[]{setBed, teleport};
    }

    public static Disguise getClonedDisguise(String key) {
        if (clonedDisguises.containsKey(key)) {
            return clonedDisguises.get(key).clone();
        }
        return null;
    }

    public static PacketContainer getDestroyPacket(int ... ids) {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntegerArrays().write(0, (Object)ids);
        return destroyPacket;
    }

    public static TargetedDisguise getDisguise(Player observer, Entity entity) {
        UUID entityId = entity.getUniqueId();
        if (futureDisguises.containsKey(entity.getEntityId())) {
            for (TargetedDisguise disguise : futureDisguises.remove(entity.getEntityId())) {
                DisguiseUtilities.addDisguise(entityId, disguise);
            }
        }
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (!disguise.canSee(observer)) continue;
                return disguise;
            }
        }
        return null;
    }

    public static HashMap<UUID, HashSet<TargetedDisguise>> getDisguises() {
        return disguisesInUse;
    }

    public static TargetedDisguise[] getDisguises(UUID entityId) {
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            HashSet<TargetedDisguise> disguises = DisguiseUtilities.getDisguises().get(entityId);
            return disguises.toArray(new TargetedDisguise[disguises.size()]);
        }
        return new TargetedDisguise[0];
    }

    public static HashMap<Integer, HashSet<TargetedDisguise>> getFutureDisguises() {
        return futureDisguises;
    }

    public static WrappedGameProfile getGameProfile(String playerName) {
        File file;
        if (!DisguiseUtilities.hasGameProfile(playerName)) {
            return null;
        }
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        if (!(file = new File(profileCache, playerName.toLowerCase())).exists()) {
            cachedNames.remove(playerName.toLowerCase());
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String cached = reader.readLine();
            reader.close();
            return (WrappedGameProfile)gson.fromJson(cached, WrappedGameProfile.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TargetedDisguise getMainDisguise(UUID entityId) {
        TargetedDisguise toReturn = null;
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    return disguise;
                }
                toReturn = disguise;
            }
        }
        return toReturn;
    }

    public static List<Player> getPerverts(Disguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (disguise.getEntity() == null) {
            throw new IllegalStateException("The entity for the disguisetype " + disguise.getType().name() + " is null!");
        }
        ArrayList<Player> players = new ArrayList<Player>();
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (entityTrackerEntry != null) {
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (Object p : trackedPlayers) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(p);
                    if (!((TargetedDisguise)disguise).canSee(player)) continue;
                    players.add(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return players;
    }

    public static WrappedGameProfile getProfileFromMojang(final PlayerDisguise disguise) {
        String nameToFetch = disguise.getSkin() != null ? disguise.getSkin() : disguise.getName();
        return DisguiseUtilities.getProfileFromMojang(nameToFetch, new LibsProfileLookup(){

            @Override
            public void onLookup(WrappedGameProfile gameProfile) {
                if (!(!DisguiseAPI.isDisguiseInUse(disguise) || gameProfile.getName().equals(disguise.getSkin() != null ? disguise.getSkin() : disguise.getName()) && gameProfile.getProperties().isEmpty())) {
                    disguise.setGameProfile(gameProfile);
                    DisguiseUtilities.refreshTrackers(disguise);
                }
            }
        }, LibsDisguises.getInstance().getConfig().getBoolean("ContactMojangServers", true));
    }

    private static boolean isHashSet(Object obj) {
        if (obj instanceof HashSet) {
            return true;
        }
        if (obj instanceof Set) {
            return false;
        }
        throw new IllegalArgumentException("Object passed was not either a hashset or set!");
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    private static WrappedGameProfile getProfileFromMojang(final String origName, Object runnable, boolean contactMojang) {
        final String playerName = origName.toLowerCase();
        if (DisguiseConfig.isSaveGameProfiles() && DisguiseUtilities.hasGameProfile(playerName)) {
            return DisguiseUtilities.getGameProfile(playerName);
        }
        if (Pattern.matches("([A-Za-z0-9_]){1,16}", origName)) {
            WrappedGameProfile gameProfile;
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && !(gameProfile = ReflectionManager.getGameProfile(player)).getProperties().isEmpty()) {
                if (DisguiseConfig.isSaveGameProfiles()) {
                    DisguiseUtilities.addGameProfile(playerName, gameProfile);
                }
                return gameProfile;
            }
            if (contactMojang && !runnables.containsKey(playerName)) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)LibsDisguises.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final WrappedGameProfile gameProfile = DisguiseUtilities.lookupGameProfile(origName);
                            Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

                                @Override
                                public void run() {
                                    if (gameProfile.getProperties().isEmpty()) {
                                        return;
                                    }
                                    if (DisguiseConfig.isSaveGameProfiles()) {
                                        DisguiseUtilities.addGameProfile(playerName, gameProfile);
                                    }
                                    if (runnables.containsKey(playerName)) {
                                        for (Object obj : (ArrayList)runnables.remove(playerName)) {
                                            if (obj instanceof Runnable) {
                                                ((Runnable)obj).run();
                                                continue;
                                            }
                                            if (!(obj instanceof LibsProfileLookup)) continue;
                                            ((LibsProfileLookup)obj).onLookup(gameProfile);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            runnables.remove(playerName);
                            DisguiseUtilities.getLogger().severe("Error when fetching " + playerName + "'s uuid from mojang: " + e.getMessage());
                        }
                    }
                });
                if (runnable != null && contactMojang) {
                    if (!runnables.containsKey(playerName)) {
                        runnables.put(playerName, new ArrayList());
                    }
                    runnables.get(playerName).add(runnable);
                }
                return null;
            }
        }
        return ReflectionManager.getGameProfile(null, origName);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    public static HashSet<UUID> getSelfDisguised() {
        return selfDisguised;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void init(LibsDisguises disguises) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(MetaIndex.class, (Object)new SerializerMetaIndex());
        gsonBuilder.registerTypeAdapter(WrappedGameProfile.class, (Object)new SerializerGameProfile());
        gsonBuilder.registerTypeAdapter(WrappedBlockData.class, (Object)new SerializerWrappedBlockData());
        gsonBuilder.registerTypeAdapter(Disguise.class, (Object)new SerializerDisguise());
        gsonBuilder.registerTypeAdapter(FlagWatcher.class, (Object)new SerializerFlagWatcher());
        gsonBuilder.registerTypeAdapter(FlagWatcher.class, (Object)new SerializerChatComponent());
        gsonBuilder.registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer());
        gsonBuilder.registerTypeAdapter(ItemStack.class, (Object)new SerializerItemStack());
        gson = gsonBuilder.create();
        try {
            Object world = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            Class chunkClass = ReflectionManager.getNmsClass("Chunk");
            Object bedChunk = null;
            Object[] biomes = (Object[])Array.newInstance(ReflectionManager.getNmsClass("BiomeBase"), 256);
            Class registry = ReflectionManager.getNmsClass("IRegistry");
            Field biomeRegistry = ReflectionManager.getNmsField(registry, "BIOME");
            Iterator itel = (Iterator)registry.getMethod("iterator", new Class[0]).invoke(biomeRegistry.get(null), new Object[0]);
            for (int i = 0; i < biomes.length && itel.hasNext(); ++i) {
                while (itel.hasNext()) {
                    biomes[i] = itel.next();
                }
            }
            for (Constructor<?> constructor : chunkClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 8) continue;
                bedChunk = constructor.newInstance(world, 0, 0, biomes, null, null, null, 0L);
                break;
            }
            if (bedChunk == null) {
                throw new IllegalStateException("[LibsDisguises] Cannot find constructor to create world chunk");
            }
            Field cSection = chunkClass.getDeclaredField("sections");
            cSection.setAccessible(true);
            Object chunkSection = ReflectionManager.getNmsClass("ChunkSection").getConstructor(Integer.TYPE, Boolean.TYPE).newInstance(0, true);
            Class blockClass = ReflectionManager.getNmsClass("Block");
            Object REGISTRY = ReflectionManager.getNmsField("IRegistry", "BLOCK").get(null);
            Object minecraftKey = ReflectionManager.createMinecraftKey("white_bed");
            Object block = REGISTRY.getClass().getMethod("get", minecraftKey.getClass()).invoke(REGISTRY, minecraftKey);
            Object blockData = ReflectionManager.getNmsMethod(blockClass, "getBlockData", new Class[0]).invoke(block, new Object[0]);
            Method method = null;
            for (Method method2 : blockData.getClass().getMethods()) {
                if (!method2.getName().equals("set") || method2.getParameterTypes().length != 2) continue;
                method = method2;
                break;
            }
            Method setType = chunkSection.getClass().getMethod("setType", Integer.TYPE, Integer.TYPE, Integer.TYPE, ReflectionManager.getNmsClass("IBlockData"));
            Method setSky = chunkSection.getClass().getMethod("a", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method setEmitted = chunkSection.getClass().getMethod("b", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            for (BlockFace face : new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH}) {
                int x = 1 + face.getModX();
                int z = 1 + face.getModZ();
                Object data = method.invoke(blockData, block.getClass().getField("FACING").get(null), ReflectionManager.getEnumDirection(face.ordinal()));
                setType.invoke(chunkSection, x, 0, z, data);
            }
            Object[] objectArray = (Object[])Array.newInstance(chunkSection.getClass(), 16);
            objectArray[0] = chunkSection;
            cSection.set(bedChunk, objectArray);
            spawnChunk = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.MAP_CHUNK, new Object[]{bedChunk, 65535}).createPacket(new Object[]{bedChunk, 65535});
            Field threadField = ReflectionManager.getNmsField("MinecraftServer", "primaryThread");
            threadField.setAccessible(true);
            mainThread = (Thread)threadField.get(ReflectionManager.getMinecraftServer());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        cachedNames.addAll(Arrays.asList(profileCache.list()));
        for (String key : savedDisguises.list()) {
            savedDisguiseList.add(UUID.fromString(key));
        }
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.getEntity() != null && DisguiseUtilities.getDisguises().containsKey(disguise.getEntity().getUniqueId()) && DisguiseUtilities.getDisguises().get(disguise.getEntity().getUniqueId()).contains(disguise);
    }

    public static WrappedGameProfile lookupGameProfile(String playerName) {
        return ReflectionManager.getSkullBlob(ReflectionManager.grabProfileAddUUID(playerName));
    }

    public static void refreshTracker(TargetedDisguise disguise, String player) {
        block8: {
            if (mainThread != Thread.currentThread()) {
                throw new IllegalStateException("Cannot modify disguises on an async thread");
            }
            if (disguise.getEntity() == null || !disguise.getEntity().isValid()) {
                return;
            }
            try {
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
                if (disguise.isDisguiseInUse() && disguise.getEntity() instanceof Player && disguise.getEntity().getName().equalsIgnoreCase(player)) {
                    DisguiseUtilities.removeSelfDisguise((Player)disguise.getEntity());
                    if (disguise.isSelfDisguiseVisible()) {
                        selfDisguised.add(disguise.getEntity().getUniqueId());
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)disguise.getEntity(), destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    break block8;
                }
                Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
                if (entityTrackerEntry == null) {
                    return;
                }
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (Object p : trackedPlayers) {
                    Player pl = (Player)ReflectionManager.getBukkitEntity(p);
                    if (pl == null || !player.equalsIgnoreCase(pl.getName())) continue;
                    clear.invoke(entityTrackerEntry, p);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(pl, destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            updatePlayer.invoke(entityTrackerEntry, p);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(Entity entity) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (entity.isValid()) {
            try {
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(entity.getEntityId());
                Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(entity);
                if (entityTrackerEntry != null) {
                    Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                    Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                    Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                    trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                    for (Object p : trackedPlayers) {
                        Player player = (Player)ReflectionManager.getBukkitEntity(p);
                        if (player == entity) continue;
                        clear.invoke(entityTrackerEntry, p);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                            try {
                                updatePlayer.invoke(entityTrackerEntry, p);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }, 2L);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(TargetedDisguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!disguise.getEntity().isValid()) {
            return;
        }
        PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
        try {
            Object entityTrackerEntry;
            if (selfDisguised.contains(disguise.getEntity().getUniqueId()) && disguise.isDisguiseInUse()) {
                DisguiseUtilities.removeSelfDisguise((Player)disguise.getEntity());
                selfDisguised.add(disguise.getEntity().getUniqueId());
                ProtocolLibrary.getProtocolManager().sendServerPacket((Player)disguise.getEntity(), destroyPacket);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                    try {
                        DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }, 2L);
            }
            if ((entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity())) != null) {
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (Object p : trackedPlayers) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(p);
                    if (disguise.getEntity() == player || !disguise.canSee(player)) continue;
                    clear.invoke(entityTrackerEntry, p);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            updatePlayer.invoke(entityTrackerEntry, p);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean removeDisguise(TargetedDisguise disguise) {
        UUID entityId = disguise.getEntity().getUniqueId();
        if (DisguiseUtilities.getDisguises().containsKey(entityId) && DisguiseUtilities.getDisguises().get(entityId).remove(disguise)) {
            if (DisguiseUtilities.getDisguises().get(entityId).isEmpty()) {
                DisguiseUtilities.getDisguises().remove(entityId);
            }
            if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
                DisguiseUtilities.doBoundingBox(disguise);
            }
            return true;
        }
        return false;
    }

    public static void removeGameProfile(String string) {
        cachedNames.remove(string.toLowerCase());
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        File file = new File(profileCache, string.toLowerCase());
        file.delete();
    }

    public static void removeSelfDisguise(Player player) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!selfDisguised.contains(player.getUniqueId())) {
            return;
        }
        PacketContainer packet = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DisguiseUtilities.removeSelfDisguiseScoreboard(player);
        selfDisguised.remove(player.getUniqueId());
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (entityTrackerEntry != null) {
                Object trackedPlayersObj = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                if (DisguiseUtilities.isHashSet(trackedPlayersObj)) {
                    ((Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry)).remove(ReflectionManager.getNmsEntity((Entity)player));
                } else {
                    ((Map)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap").get(entityTrackerEntry)).remove(ReflectionManager.getNmsEntity((Entity)player));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}).createPacket(new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        player.updateInventory();
    }

    public static void removeSelfDisguiseScoreboard(Player player) {
        String originalTeam = preDisguiseTeam.remove(player.getUniqueId());
        String teamDisguise = disguiseTeam.remove(player.getUniqueId());
        if (teamDisguise == null || DisguiseConfig.getPushingOption() == DisguiseConfig.DisguisePushing.IGNORE_SCOREBOARD) {
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        Team team = originalTeam == null ? null : scoreboard.getTeam(originalTeam);
        Team ldTeam = null;
        for (Team t : scoreboard.getTeams()) {
            if (!t.hasEntry(player.getName())) continue;
            ldTeam = t;
            break;
        }
        if (DisguiseConfig.isWarnScoreboardConflict()) {
            if (ldTeam == null || !ldTeam.getName().equals(teamDisguise)) {
                DisguiseUtilities.getLogger().warning("Scoreboard conflict, the self disguise player was not on the expected team!");
            } else {
                Team.OptionStatus collisions = ldTeam.getOption(Team.Option.COLLISION_RULE);
                if (collisions != Team.OptionStatus.NEVER && collisions != Team.OptionStatus.FOR_OTHER_TEAMS) {
                    DisguiseUtilities.getLogger().warning("Scoreboard conflict, the collisions for a self disguise player team has been unexpectedly modifed!");
                }
            }
        }
        if (ldTeam != null && !ldTeam.getName().equals("LD_Pushing") && !ldTeam.getName().endsWith("_LDP")) {
            ldTeam = null;
        }
        if (team != null) {
            team.addEntry(player.getName());
        } else if (ldTeam != null) {
            ldTeam.removeEntry(player.getName());
        }
        if (ldTeam != null && ldTeam.getEntries().isEmpty()) {
            ldTeam.unregister();
        }
    }

    public static void setupSelfDisguiseScoreboard(Player player) {
        if (disguiseTeam.containsKey(player.getUniqueId())) {
            return;
        }
        DisguiseConfig.DisguisePushing pOption = DisguiseConfig.getPushingOption();
        if (pOption == DisguiseConfig.DisguisePushing.IGNORE_SCOREBOARD) {
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        Team prevTeam = null;
        Team ldTeam = null;
        String ldTeamName = "LD_Pushing";
        for (Team t : scoreboard.getTeams()) {
            if (!t.hasEntry(player.getName())) continue;
            prevTeam = t;
            break;
        }
        if (prevTeam != null && !prevTeam.getName().equals("LD_Pushing") && !prevTeam.getName().endsWith("_LDP")) {
            if (pOption == DisguiseConfig.DisguisePushing.CREATE_SCOREBOARD) {
                preDisguiseTeam.put(player.getUniqueId(), prevTeam.getName());
            } else {
                ldTeam = prevTeam;
            }
        } else {
            prevTeam = null;
        }
        if (pOption == DisguiseConfig.DisguisePushing.CREATE_SCOREBOARD) {
            ldTeamName = prevTeam == null ? "NoTeam" : prevTeam.getName();
            ldTeamName = ldTeamName.substring(0, Math.min(12, ldTeamName.length())) + "_LDP";
        }
        if (ldTeam == null && (ldTeam = scoreboard.getTeam(ldTeamName)) == null) {
            ldTeam = scoreboard.registerNewTeam(ldTeamName);
        }
        disguiseTeam.put(player.getUniqueId(), ldTeam.getName());
        if (!ldTeam.hasEntry(player.getName())) {
            ldTeam.addEntry(player.getName());
        }
        if (pOption == DisguiseConfig.DisguisePushing.CREATE_SCOREBOARD && prevTeam != null) {
            ldTeam.setAllowFriendlyFire(prevTeam.allowFriendlyFire());
            ldTeam.setCanSeeFriendlyInvisibles(prevTeam.canSeeFriendlyInvisibles());
            ldTeam.setDisplayName(prevTeam.getDisplayName());
            ldTeam.setPrefix(prevTeam.getPrefix());
            ldTeam.setSuffix(prevTeam.getSuffix());
            for (Team.Option option : Team.Option.values()) {
                ldTeam.setOption(option, prevTeam.getOption(option));
            }
        }
        if (ldTeam.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.NEVER && DisguiseConfig.isModifyCollisions()) {
            ldTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        }
        if (ldTeam.canSeeFriendlyInvisibles() && DisguiseConfig.isDisableFriendlyInvisibles()) {
            ldTeam.setCanSeeFriendlyInvisibles(false);
        }
    }

    public static String[] split(String string) {
        Pattern endsWithQuote = Pattern.compile("^([^\\\\]|\\\\(?!\\\\*\"$))*(\\\\\\\\)*\"$");
        Pattern removeSlashes = Pattern.compile("^\\\\(\")|\\\\(?:(\\\\)(?=\\\\*\"$)|(\")$)");
        ArrayList<String> list = new ArrayList<String>();
        String[] split = string.split(" ");
        String[] unescapedSplit = new String[split.length];
        block0: for (int i = 0; i < split.length; ++i) {
            if (split[i].startsWith("\"")) {
                for (int a = i; a < split.length; ++a) {
                    if (a == i && split[i].length() == 1 || !endsWithQuote.matcher(split[a]).matches()) continue;
                    StringBuilder builder = new StringBuilder();
                    for (int b = i; b <= a; ++b) {
                        Matcher matcher = removeSlashes.matcher(split[b]);
                        String word = matcher.replaceAll("$1$2$3");
                        if (b == i || b == a) {
                            word = word.substring(b == i ? 1 : 0, word.length() - (b == a ? 1 : 0));
                        }
                        if (b > i) {
                            builder.append(" ");
                        }
                        builder.append(word);
                    }
                    list.add(builder.toString());
                    i = a;
                    continue block0;
                }
            }
            Matcher matcher = removeSlashes.matcher(split[i]);
            String word = matcher.replaceAll("$1$2$3");
            list.add(word);
        }
        return list.toArray(new String[0]);
    }

    public static void sendSelfDisguise(Player player, TargetedDisguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            if (!(disguise.isDisguiseInUse() && player.isValid() && player.isOnline() && disguise.isSelfDisguiseVisible() && disguise.canSee(player))) {
                return;
            }
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (entityTrackerEntry == null) {
                Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                    if (DisguiseAPI.getDisguise(player, (Entity)player) == disguise) {
                        DisguiseUtilities.sendSelfDisguise(player, disguise);
                    }
                });
                return;
            }
            DisguiseUtilities.setupSelfDisguiseScoreboard(player);
            Object trackedPlayersObj = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
            if (DisguiseUtilities.isHashSet(trackedPlayersObj)) {
                ((Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry)).add(ReflectionManager.getNmsEntity((Entity)player));
            } else {
                ((Map)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap").get(entityTrackerEntry)).put(ReflectionManager.getNmsEntity((Entity)player), true);
            }
            ProtocolManager manager = ProtocolLibrary.getProtocolManager();
            manager.sendServerPacket(player, manager.createPacketConstructor(PacketType.Play.Server.NAMED_ENTITY_SPAWN, new Object[]{player}).createPacket(new Object[]{player}));
            WrappedDataWatcher dataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)player);
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), dataWatcher, true}).createPacket(new Object[]{player.getEntityId(), dataWatcher, true}));
            boolean isMoving = false;
            try {
                Field field = ReflectionManager.getNmsClass("EntityTrackerEntry").getDeclaredField("isMoving");
                field.setAccessible(true);
                isMoving = field.getBoolean(entityTrackerEntry);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (isMoving) {
                Vector velocity = player.getVelocity();
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_VELOCITY, new Object[]{player.getEntityId(), velocity.getX(), velocity.getY(), velocity.getZ()}).createPacket(new Object[]{player.getEntityId(), velocity.getX(), velocity.getY(), velocity.getZ()}));
            }
            if (player.getVehicle() != null && player.getEntityId() > player.getVehicle().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{0, player, player.getVehicle()}).createPacket(new Object[]{0, player, player.getVehicle()}));
            } else if (player.getPassenger() != null && player.getEntityId() > player.getPassenger().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{0, player.getPassenger(), player}).createPacket(new Object[]{0, player.getPassenger(), player}));
            }
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(player.getInventory().getHelmet())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.CHEST), ReflectionManager.getNmsItem(player.getInventory().getChestplate())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.LEGS), ReflectionManager.getNmsItem(player.getInventory().getLeggings())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.FEET), ReflectionManager.getNmsItem(player.getInventory().getBoots())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.HAND), ReflectionManager.getNmsItem(player.getInventory().getItemInMainHand())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.OFF_HAND), ReflectionManager.getNmsItem(player.getInventory().getItemInOffHand())}));
            Location loc = player.getLocation();
            if (player.isSleeping()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.BED, new Object[]{player, ReflectionManager.getBlockPosition(0, 0, 0)}).createPacket(new Object[]{player, ReflectionManager.getBlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())}));
            }
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                Object mobEffect = ReflectionManager.createMobEffect(potionEffect);
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EFFECT, new Object[]{player.getEntityId(), mobEffect}).createPacket(new Object[]{player.getEntityId(), mobEffect}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getPlayerListName(Player player) {
        return Strings.isEmpty((CharSequence)player.getPlayerListName()) ? player.getName() : player.getPlayerListName();
    }

    public static Logger getLogger() {
        return LibsDisguises.getInstance().getLogger();
    }

    private static void sendSelfPacket(Player player, PacketContainer packet) {
        Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
        if (disguise == null) {
            return;
        }
        LibsPackets transformed = PacketsManager.getPacketsHandler().transformPacket(packet, disguise, player, (Entity)player);
        try {
            if (transformed.isUnhandled()) {
                transformed.addPacket(packet);
            }
            transformed.setSpawnPacketCheck(packet.getType());
            for (PacketContainer p : transformed.getPackets()) {
                p = p.deepClone();
                p.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, p, false);
            }
            transformed.sendDelayed(player);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setupFakeDisguise(Disguise disguise) {
        Entity e = disguise.getEntity();
        if (!(e instanceof Player && DisguiseUtilities.getDisguises().containsKey(e.getUniqueId()) && DisguiseUtilities.getDisguises().get(e.getUniqueId()).contains(disguise))) {
            return;
        }
        Player player = (Player)e;
        if (!((TargetedDisguise)disguise).canSee(player)) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(player);
        if (!disguise.isSelfDisguiseVisible() || !PacketsManager.isViewDisguisesListenerEnabled() || player.getVehicle() != null) {
            return;
        }
        selfDisguised.add(player.getUniqueId());
        DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise);
        if ((disguise.isHidingArmorFromSelf() || disguise.isHidingHeldItemFromSelf()) && PacketsManager.isInventoryListenerEnabled()) {
            player.updateInventory();
        }
    }

    public static WrappedDataWatcher createSanitizedDataWatcher(WrappedDataWatcher entityWatcher, FlagWatcher disguiseWatcher) {
        WrappedDataWatcher newWatcher = new WrappedDataWatcher();
        try {
            List<WrappedWatchableObject> list = DisguiseConfig.isMetadataPacketsEnabled() ? disguiseWatcher.convert(entityWatcher.getWatchableObjects()) : disguiseWatcher.getWatchableObjects();
            for (WrappedWatchableObject watchableObject : list) {
                if (watchableObject == null || watchableObject.getValue() == null) continue;
                WrappedDataWatcher.WrappedDataWatcherObject obj = ReflectionManager.createDataWatcherObject(watchableObject.getIndex(), watchableObject.getValue());
                newWatcher.setObject(obj, watchableObject.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newWatcher;
    }

    public static byte getPitch(DisguiseType disguiseType, EntityType entityType, byte value) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(DisguiseType.getType(entityType), value));
    }

    public static byte getPitch(DisguiseType disguiseType, DisguiseType entityType, byte value) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(entityType, value));
    }

    public static byte getPitch(DisguiseType disguiseType, byte value) {
        if (disguiseType.isMisc()) {
            return -value;
        }
        switch (disguiseType) {
            case PHANTOM: {
                return -value;
            }
        }
        return value;
    }

    public static byte getYaw(DisguiseType disguiseType, EntityType entityType, byte value) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(DisguiseType.getType(entityType), value));
    }

    public static byte getYaw(DisguiseType disguiseType, DisguiseType entityType, byte value) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(entityType, value));
    }

    public static byte getYaw(DisguiseType disguiseType, byte value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                return (byte)(value + 64);
            }
            case BOAT: 
            case ENDER_DRAGON: 
            case WITHER_SKULL: {
                return (byte)(value - 128);
            }
            case ARROW: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: {
                return -value;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                return (byte)(-(value + 128));
            }
        }
        if (disguiseType.isMisc() && disguiseType != DisguiseType.ARMOR_STAND) {
            return (byte)(value - 64);
        }
        return value;
    }

    public static double getYModifier(Entity entity, Disguise disguise) {
        double yMod = 0.0;
        if (!(disguise.getType() == DisguiseType.PLAYER && ((PlayerWatcher)disguise.getWatcher()).isSleeping() || entity.getType() != EntityType.DROPPED_ITEM)) {
            yMod -= 0.13;
        }
        switch (disguise.getType()) {
            case BAT: {
                if (entity instanceof LivingEntity) {
                    return yMod + ((LivingEntity)entity).getEyeHeight();
                }
            }
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                switch (entity.getType()) {
                    case MINECART: 
                    case MINECART_CHEST: 
                    case MINECART_FURNACE: 
                    case MINECART_HOPPER: 
                    case MINECART_MOB_SPAWNER: 
                    case MINECART_TNT: {
                        return yMod;
                    }
                }
                return yMod + 0.4;
            }
            case BOAT: 
            case WITHER_SKULL: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: 
            case PAINTING: 
            case EGG: 
            case ENDER_PEARL: 
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: {
                return yMod + 0.7;
            }
            case PLAYER: {
                if (!DisguiseConfig.isBedPacketsEnabled() || !((PlayerWatcher)disguise.getWatcher()).isSleeping()) break;
                return yMod + 0.35;
            }
            case DROPPED_ITEM: {
                return yMod + 0.13;
            }
        }
        return yMod;
    }

    static {
        preDisguiseTeam = new HashMap();
        disguiseTeam = new HashMap();
        profileCache = new File("plugins/LibsDisguises/GameProfiles");
        savedDisguises = new File("plugins/LibsDisguises/SavedDisguises");
    }
}

