/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;

public class TropicalFishWatcher
extends FishWatcher {
    public TropicalFishWatcher(Disguise disguise) {
        super(disguise);
        Random random = new Random();
        int n = random.nextInt(2);
        int n2 = random.nextInt(6);
        int n3 = random.nextInt(15);
        int n4 = random.nextInt(15);
        this.setVariant(n | n2 << 8 | n3 << 16 | n4 << 24);
    }

    public DyeColor getPatternColor() {
        return DyeColor.getByWoolData((byte)((byte)(this.getVariant() >> 24 & 0xFF)));
    }

    public void setPatternColor(DyeColor dyeColor) {
        this.setVariant(this.getData(dyeColor, this.getBodyColor(), this.getPattern()));
    }

    private int getData(DyeColor patternColor, DyeColor bodyColor, TropicalFish.Pattern type) {
        return patternColor.getWoolData() << 24 | bodyColor.getWoolData() << 16 | CraftPattern.values()[type.ordinal()].getDataValue();
    }

    public DyeColor getBodyColor() {
        return DyeColor.getByWoolData((byte)((byte)(this.getVariant() >> 16 & 0xFF)));
    }

    public void setBodyColor(DyeColor dyeColor) {
        this.setVariant(this.getData(dyeColor, dyeColor, this.getPattern()));
    }

    public TropicalFish.Pattern getPattern() {
        return CraftPattern.fromData(this.getVariant() & 0xFFFF);
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        this.setVariant(this.getData(this.getPatternColor(), this.getBodyColor(), pattern));
    }

    @Deprecated
    public int getVariant() {
        return this.getData(MetaIndex.TROPICAL_FISH_VARIANT);
    }

    @Deprecated
    public void setVariant(int variant) {
        this.setData(MetaIndex.TROPICAL_FISH_VARIANT, variant);
        this.sendData(MetaIndex.TROPICAL_FISH_VARIANT);
    }

    private static enum CraftPattern {
        KOB("KOB", 0, 0, false),
        SUNSTREAK("SUNSTREAK", 1, 1, false),
        SNOOPER("SNOOPER", 2, 2, false),
        DASHER("DASHER", 3, 3, false),
        BRINELY("BRINELY", 4, 4, false),
        SPOTTY("SPOTTY", 5, 5, false),
        FLOPPER("FLOPPER", 6, 0, true),
        STRIPEY("STRIPEY", 7, 1, true),
        GLITTER("GLITTER", 8, 2, true),
        BLOCKFISH("BLOCKFISH", 9, 3, true),
        BETTY("BETTY", 10, 4, true),
        CLAYFISH("CLAYFISH", 11, 5, true);

        private final int variant;
        private final boolean large;
        private static final Map<Integer, TropicalFish.Pattern> BY_DATA;

        static TropicalFish.Pattern fromData(int data) {
            return BY_DATA.get(data);
        }

        private CraftPattern(String s, int n2, int variant, boolean large) {
            this.variant = variant;
            this.large = large;
        }

        public int getDataValue() {
            return this.variant << 8 | (this.large ? 1 : 0);
        }

        static {
            BY_DATA = new HashMap<Integer, TropicalFish.Pattern>();
            for (CraftPattern type : CraftPattern.values()) {
                BY_DATA.put(type.getDataValue(), TropicalFish.Pattern.values()[type.ordinal()]);
            }
        }
    }
}

