/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import org.bukkit.block.BlockFace;

public class ShulkerWatcher
extends InsentientWatcher {
    public ShulkerWatcher(Disguise disguise) {
        super(disguise);
    }

    public BlockFace getFacingDirection() {
        return BlockFace.valueOf((String)this.getData(MetaIndex.SHULKER_FACING).name());
    }

    public void setFacingDirection(BlockFace face) {
        this.setData(MetaIndex.SHULKER_FACING, EnumWrappers.Direction.valueOf((String)face.name()));
        this.sendData(MetaIndex.SHULKER_FACING);
    }

    public BlockPosition getAttachmentPosition() {
        return this.getData(MetaIndex.SHULKER_ATTACHED).get();
    }

    public void setAttachmentPosition(BlockPosition pos) {
        this.setData(MetaIndex.SHULKER_ATTACHED, Optional.of(pos));
        this.sendData(MetaIndex.SHULKER_ATTACHED);
    }

    public int getShieldHeight() {
        return this.getData(MetaIndex.SHULKER_PEEKING).byteValue();
    }

    public void setShieldHeight(int newHeight) {
        if (newHeight < 0) {
            newHeight = 0;
        }
        if (newHeight > 127) {
            newHeight = 127;
        }
        this.setData(MetaIndex.SHULKER_PEEKING, (byte)newHeight);
        this.sendData(MetaIndex.SHULKER_PEEKING);
    }

    public void setColor(AnimalColor color) {
        this.setData(MetaIndex.SHULKER_COLOR, color.getDyeColor().getWoolData());
        this.sendData(MetaIndex.SHULKER_COLOR);
    }

    public AnimalColor getColor() {
        return AnimalColor.getColorByWool(this.getData(MetaIndex.SHULKER_COLOR).byteValue());
    }
}

