/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LivingWatcher
extends FlagWatcher {
    private double maxHealth;
    private boolean maxHealthSet;
    private HashSet<String> potionEffects = new HashSet();

    public LivingWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public LivingWatcher clone(Disguise disguise) {
        LivingWatcher clone = (LivingWatcher)super.clone(disguise);
        clone.potionEffects = (HashSet)this.potionEffects.clone();
        clone.maxHealth = this.maxHealth;
        clone.maxHealthSet = this.maxHealthSet;
        return clone;
    }

    public float getHealth() {
        return this.getData(MetaIndex.LIVING_HEALTH).floatValue();
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public boolean isPotionParticlesAmbient() {
        return this.getData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public Color getParticlesColor() {
        int color = this.getData(MetaIndex.LIVING_POTIONS);
        return Color.fromRGB((int)color);
    }

    public void setParticlesColor(Color color) {
        this.potionEffects.clear();
        this.setData(MetaIndex.LIVING_POTIONS, color.asRGB());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    private int getPotions() {
        if (this.potionEffects.isEmpty()) {
            return 0;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String typeId : this.potionEffects) {
            Color color;
            PotionEffectType type = PotionEffectType.getByName((String)typeId);
            if (type == null || (color = type.getColor()) == null) continue;
            colors.add(color);
        }
        if (colors.isEmpty()) {
            return 0;
        }
        Color color = (Color)colors.remove(0);
        return color.mixColors(colors.toArray(new Color[0])).asRGB();
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.potionEffects.contains(type.getName());
    }

    public boolean isMaxHealthSet() {
        return this.maxHealthSet;
    }

    public void addPotionEffect(PotionEffectType potionEffect) {
        if (!this.hasPotionEffect(potionEffect)) {
            this.potionEffects.add(potionEffect.getName());
        }
        this.sendPotionEffects();
    }

    public void removePotionEffect(PotionEffectType potionEffect) {
        if (this.hasPotionEffect(potionEffect)) {
            this.potionEffects.remove(potionEffect.getId());
        }
        this.sendPotionEffects();
    }

    public void setPotionParticlesAmbient(boolean particles) {
        this.setData(MetaIndex.LIVING_POTION_AMBIENT, particles);
        this.sendData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    private void sendPotionEffects() {
        this.setData(MetaIndex.LIVING_POTIONS, this.getPotions());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    public void setHealth(float health) {
        this.setData(MetaIndex.LIVING_HEALTH, Float.valueOf(health));
        this.sendData(MetaIndex.LIVING_HEALTH);
    }

    public int getArrowsSticking() {
        return this.getData(MetaIndex.LIVING_ARROWS);
    }

    public void setArrowsSticking(int arrowsNo) {
        this.setData(MetaIndex.LIVING_ARROWS, Math.max(0, Math.min(127, arrowsNo)));
        this.sendData(MetaIndex.LIVING_ARROWS);
    }

    public void setMaxHealth(double newHealth) {
        this.maxHealth = newHealth;
        this.maxHealthSet = true;
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder();
            builder.attributeKey("generic.maxHealth");
            builder.baseValue(this.getMaxHealth());
            builder.packet(packet);
            attributes.add(builder.build());
            Entity entity = this.getDisguise().getEntity();
            packet.getIntegers().write(0, (Object)entity.getEntityId());
            packet.getAttributeCollectionModifier().write(0, attributes);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

