/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.WrappedBlockData;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class EndermanWatcher
extends InsentientWatcher {
    public EndermanWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public ItemStack getItemInMainHand() {
        Optional<WrappedBlockData> value = this.getData(MetaIndex.ENDERMAN_ITEM);
        if (value.isPresent()) {
            WrappedBlockData pair = value.get();
            Material id = pair.getType();
            int data = pair.getData();
            return new ItemStack(id, 1, (short)data);
        }
        return null;
    }

    @Override
    public void setItemInMainHand(ItemStack itemstack) {
        this.setItemInMainHand(itemstack.getType(), itemstack.getDurability());
    }

    public void setItemInMainHand(Material type) {
        this.setItemInMainHand(type, 0);
    }

    public void setItemInMainHand(Material type, int data) {
        Optional<Object> optional = type == null ? Optional.empty() : Optional.of(WrappedBlockData.createData((Material)type, (int)data));
        this.setData(MetaIndex.ENDERMAN_ITEM, optional);
    }

    public boolean isAggressive() {
        return this.getData(MetaIndex.ENDERMAN_AGRESSIVE);
    }

    public void setAggressive(boolean isAggressive) {
        this.setData(MetaIndex.ENDERMAN_AGRESSIVE, isAggressive);
        this.sendData(MetaIndex.ENDERMAN_AGRESSIVE);
    }
}

