/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;

public abstract class AbstractHorseWatcher
extends AgeableWatcher {
    public AbstractHorseWatcher(Disguise disguise) {
        super(disguise);
    }

    public Optional<UUID> getOwner() {
        return this.getData(MetaIndex.HORSE_OWNER);
    }

    public boolean hasChest() {
        return this.isHorseFlag(8);
    }

    public boolean isBreedable() {
        return this.isHorseFlag(16);
    }

    public boolean isGrazing() {
        return this.isHorseFlag(32);
    }

    public boolean isMouthOpen() {
        return this.isHorseFlag(128);
    }

    public boolean isRearing() {
        return this.isHorseFlag(64);
    }

    public boolean isSaddled() {
        return this.isHorseFlag(4);
    }

    public boolean isTamed() {
        return this.isHorseFlag(2);
    }

    private boolean isHorseFlag(int i) {
        return (this.getHorseFlag() & i) != 0;
    }

    private byte getHorseFlag() {
        return this.getData(MetaIndex.HORSE_META);
    }

    public void setCanBreed(boolean breed) {
        this.setHorseFlag(16, breed);
    }

    public void setCarryingChest(boolean chest) {
        this.setHorseFlag(8, chest);
    }

    private void setHorseFlag(int i, boolean flag) {
        byte j = this.getData(MetaIndex.HORSE_META);
        if (flag) {
            this.setData(MetaIndex.HORSE_META, (byte)(j | i));
        } else {
            this.setData(MetaIndex.HORSE_META, (byte)(j & ~i));
        }
        this.sendData(MetaIndex.HORSE_META);
    }

    public void setGrazing(boolean grazing) {
        this.setHorseFlag(32, grazing);
    }

    public void setMouthOpen(boolean mouthOpen) {
        this.setHorseFlag(128, mouthOpen);
    }

    public void setOwner(UUID uuid) {
        this.setData(MetaIndex.HORSE_OWNER, Optional.of(uuid));
        this.sendData(MetaIndex.HORSE_OWNER);
    }

    public void setRearing(boolean rear) {
        this.setHorseFlag(64, rear);
    }

    public void setSaddled(boolean saddled) {
        this.setHorseFlag(4, saddled);
    }

    public void setTamed(boolean tamed) {
        this.setHorseFlag(2, tamed);
    }
}

