/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.UUID;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerDisguise
extends TargetedDisguise {
    private transient LibsProfileLookup currentLookup;
    private WrappedGameProfile gameProfile;
    private String playerName;
    private String skinToUse;
    private UUID uuid = UUID.randomUUID();

    private PlayerDisguise() {
        super(DisguiseType.PLAYER);
    }

    public PlayerDisguise(Player player) {
        this(ReflectionManager.getGameProfile(player));
    }

    public PlayerDisguise(Player player, Player skinToUse) {
        this(ReflectionManager.getGameProfile(player), ReflectionManager.getGameProfile(skinToUse));
    }

    public PlayerDisguise(String name) {
        this();
        this.setName(name);
        this.setSkin(name);
        this.createDisguise();
    }

    public PlayerDisguise(String name, String skinToUse) {
        this();
        this.setName(name);
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile gameProfile) {
        this();
        this.setName(gameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, gameProfile.getName(), gameProfile);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile gameProfile, WrappedGameProfile skinToUse) {
        this();
        this.setName(gameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfile(this.uuid, gameProfile.getName());
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public PlayerDisguise addPlayer(Player player) {
        return (PlayerDisguise)super.addPlayer(player);
    }

    @Override
    public PlayerDisguise addPlayer(String playername) {
        return (PlayerDisguise)super.addPlayer(playername);
    }

    @Override
    public PlayerDisguise clone() {
        PlayerDisguise disguise = new PlayerDisguise();
        disguise.playerName = this.getName();
        if (this.currentLookup == null && this.gameProfile != null) {
            disguise.skinToUse = this.getSkin();
            disguise.gameProfile = ReflectionManager.getGameProfileWithThisSkin(disguise.uuid, this.getGameProfile().getName(), this.getGameProfile());
        } else {
            disguise.setSkin(this.getSkin());
        }
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
        return disguise;
    }

    public WrappedGameProfile getGameProfile() {
        if (this.gameProfile == null) {
            this.gameProfile = this.getSkin() != null ? ReflectionManager.getGameProfile(this.uuid, this.getName()) : ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getName(), DisguiseUtilities.getProfileFromMojang(this));
        }
        return this.gameProfile;
    }

    public String getName() {
        return this.playerName;
    }

    public String getSkin() {
        return this.skinToUse;
    }

    @Override
    public PlayerWatcher getWatcher() {
        return (PlayerWatcher)super.getWatcher();
    }

    public boolean isDisplayedInTab() {
        return this.getWatcher().isDisplayedInTab();
    }

    @Override
    public boolean isPlayerDisguise() {
        return true;
    }

    @Override
    public PlayerDisguise removePlayer(Player player) {
        return (PlayerDisguise)super.removePlayer(player);
    }

    @Override
    public PlayerDisguise removePlayer(String playername) {
        return (PlayerDisguise)super.removePlayer(playername);
    }

    @Override
    public PlayerDisguise setDisguiseTarget(TargetedDisguise.TargetType newTargetType) {
        return (PlayerDisguise)super.setDisguiseTarget(newTargetType);
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        this.getWatcher().setDisplayedInTab(showPlayerInTab);
    }

    @Override
    public PlayerDisguise setEntity(Entity entity) {
        return (PlayerDisguise)super.setEntity(entity);
    }

    public void setGameProfile(WrappedGameProfile gameProfile) {
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, gameProfile.getName(), gameProfile);
    }

    @Override
    public PlayerDisguise setHearSelfDisguise(boolean hearSelfDisguise) {
        return (PlayerDisguise)super.setHearSelfDisguise(hearSelfDisguise);
    }

    @Override
    public PlayerDisguise setHideArmorFromSelf(boolean hideArmor) {
        return (PlayerDisguise)super.setHideArmorFromSelf(hideArmor);
    }

    @Override
    public PlayerDisguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        return (PlayerDisguise)super.setHideHeldItemFromSelf(hideHeldItem);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerDeath(keepDisguise);
    }

    @Override
    public PlayerDisguise setModifyBoundingBox(boolean modifyBox) {
        return (PlayerDisguise)super.setModifyBoundingBox(modifyBox);
    }

    private void setName(String name) {
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        this.playerName = name;
    }

    @Override
    public PlayerDisguise setReplaceSounds(boolean areSoundsReplaced) {
        return (PlayerDisguise)super.setReplaceSounds(areSoundsReplaced);
    }

    @Override
    public boolean startDisguise() {
        if (!this.isDisguiseInUse() && this.skinToUse != null && this.gameProfile == null) {
            this.currentLookup = new LibsProfileLookup(){

                @Override
                public void onLookup(WrappedGameProfile gameProfile) {
                    if (PlayerDisguise.this.currentLookup != this || gameProfile == null) {
                        return;
                    }
                    PlayerDisguise.this.setSkin(gameProfile);
                    PlayerDisguise.this.currentLookup = null;
                }
            };
            WrappedGameProfile gameProfile = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, LibsDisguises.getInstance().getConfig().getBoolean("ContactMojangServers", true));
            if (gameProfile != null) {
                this.setSkin(gameProfile);
            }
        }
        return super.startDisguise();
    }

    public PlayerDisguise setSkin(String newSkin) {
        if (newSkin != null && newSkin.length() > 50) {
            try {
                return this.setSkin((WrappedGameProfile)DisguiseUtilities.getGson().fromJson(newSkin, WrappedGameProfile.class));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("The skin %s is too long to be a playername, but cannot be parsed to a GameProfile!", newSkin));
            }
        }
        this.skinToUse = newSkin;
        if (newSkin == null) {
            this.currentLookup = null;
            this.gameProfile = null;
        } else if (newSkin.length() > 16) {
            this.skinToUse = newSkin.substring(0, 16);
        }
        return this;
    }

    public PlayerDisguise setSkin(WrappedGameProfile gameProfile) {
        if (gameProfile == null) {
            this.gameProfile = null;
            this.skinToUse = null;
            return this;
        }
        Validate.notEmpty((String)gameProfile.getName(), (String)"Name must be set");
        this.currentLookup = null;
        this.skinToUse = gameProfile.getName();
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getName(), gameProfile);
        if (DisguiseUtilities.isDisguiseInUse(this)) {
            if (this.isDisplayedInTab()) {
                PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                addTab.getPlayerInfoDataLists().write(0, Arrays.asList(new PlayerInfoData(this.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)this.getName()))));
                PacketContainer deleteTab = addTab.shallowClone();
                deleteTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                try {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!this.canSee(player)) continue;
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, deleteTab);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            DisguiseUtilities.refreshTrackers(this);
        }
        return this;
    }

    @Override
    public PlayerDisguise setVelocitySent(boolean sendVelocity) {
        return (PlayerDisguise)super.setVelocitySent(sendVelocity);
    }

    @Override
    public PlayerDisguise setViewSelfDisguise(boolean viewSelfDisguise) {
        return (PlayerDisguise)super.setViewSelfDisguise(viewSelfDisguise);
    }

    @Override
    public PlayerDisguise setWatcher(FlagWatcher newWatcher) {
        return (PlayerDisguise)super.setWatcher(newWatcher);
    }

    @Override
    public PlayerDisguise silentlyAddPlayer(String playername) {
        return (PlayerDisguise)super.silentlyAddPlayer(playername);
    }

    @Override
    public PlayerDisguise silentlyRemovePlayer(String playername) {
        return (PlayerDisguise)super.silentlyRemovePlayer(playername);
    }
}

