/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class UndisguiseRadiusCommand
implements CommandExecutor {
    private int maxRadius = 30;

    public UndisguiseRadiusCommand(int maxRadius) {
        this.maxRadius = maxRadius;
    }

    private boolean isNumeric(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        if (sender.hasPermission("libsdisguises.undisguiseradius")) {
            int radius = this.maxRadius;
            if (args.length > 0) {
                if (!this.isNumeric(args[0])) {
                    sender.sendMessage(LibsMsg.NOT_NUMBER.get(args[0]));
                    return true;
                }
                radius = Integer.parseInt(args[0]);
                if (radius > this.maxRadius) {
                    sender.sendMessage(LibsMsg.LIMITED_RADIUS.get(this.maxRadius));
                    radius = this.maxRadius;
                }
            }
            int disguisedEntitys = 0;
            for (Entity entity : ((Player)sender).getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                if (entity == sender || !DisguiseAPI.isDisguised(entity)) continue;
                DisguiseAPI.undisguiseToAll(entity);
                ++disguisedEntitys;
            }
            sender.sendMessage(LibsMsg.UNDISRADIUS.get(disguisedEntitys));
        } else {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
        }
        return true;
    }
}

