/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.DisguiseListener;
import me.libraryaddict.disguise.commands.DisguiseCloneCommand;
import me.libraryaddict.disguise.commands.DisguiseCommand;
import me.libraryaddict.disguise.commands.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.DisguiseHelpCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.DisguiseViewSelfCommand;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.UndisguiseCommand;
import me.libraryaddict.disguise.commands.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SkeletonWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseSound;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.metrics.MetricsInitalizer;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.reflection.DisguiseValues;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fish;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;
    private String buildNumber;

    public void onEnable() {
        instance = this;
        if (!new File(this.getDataFolder(), "disguises.yml").exists()) {
            this.saveResource("disguises.yml", false);
        }
        YamlConfiguration pluginYml = ReflectionManager.getPluginYaml(this.getClassLoader());
        this.buildNumber = StringUtils.stripToNull((String)pluginYml.getString("build-number"));
        this.getLogger().info("Discovered nms version: " + ReflectionManager.getBukkitVersion());
        this.getLogger().info("Jenkins Build: " + (this.isNumberedBuild() ? "#" : "") + this.getBuildNo());
        this.getLogger().info("Build Date: " + pluginYml.getString("build-date"));
        LibsPremium.check(this.getDescription().getVersion());
        if (!ReflectionManager.getMinecraftVersion().startsWith("1.13")) {
            this.getLogger().severe("You're using the wrong version of Lib's Disguises for your server! This is intended for 1.13!");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        PacketsManager.init(this);
        DisguiseUtilities.init(this);
        this.registerValues();
        DisguiseConfig.loadConfig();
        PacketsManager.addPacketListeners();
        this.listener = new DisguiseListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        if (!DisguiseConfig.isDisableCommands()) {
            this.registerCommand("disguise", new DisguiseCommand());
            this.registerCommand("undisguise", new UndisguiseCommand());
            this.registerCommand("disguiseplayer", new DisguisePlayerCommand());
            this.registerCommand("undisguiseplayer", new UndisguisePlayerCommand());
            this.registerCommand("undisguiseentity", new UndisguiseEntityCommand());
            this.registerCommand("disguiseentity", new DisguiseEntityCommand());
            this.registerCommand("disguiseradius", new DisguiseRadiusCommand(this.getConfig().getInt("DisguiseRadiusMax")));
            this.registerCommand("undisguiseradius", new UndisguiseRadiusCommand(this.getConfig().getInt("UndisguiseRadiusMax")));
            this.registerCommand("disguisehelp", new DisguiseHelpCommand());
            this.registerCommand("disguiseclone", new DisguiseCloneCommand());
            this.registerCommand("libsdisguises", new LibsDisguisesCommand());
            this.registerCommand("disguiseviewself", new DisguiseViewSelfCommand());
            this.registerCommand("disguisemodify", new DisguiseModifyCommand());
            this.registerCommand("disguisemodifyentity", new DisguiseModifyEntityCommand());
            this.registerCommand("disguisemodifyplayer", new DisguiseModifyPlayerCommand());
            this.registerCommand("disguisemodifyradius", new DisguiseModifyRadiusCommand(this.getConfig().getInt("DisguiseRadiusMax")));
        } else {
            this.getLogger().info("Commands has been disabled, as per config");
        }
        new MetricsInitalizer();
    }

    public void onDisable() {
        DisguiseUtilities.saveDisguises();
        for (Player player : Bukkit.getOnlinePlayers()) {
            DisguiseUtilities.removeSelfDisguiseScoreboard(player);
        }
    }

    public boolean isReleaseBuild() {
        return !this.getDescription().getVersion().contains("-SNAPSHOT");
    }

    public String getBuildNo() {
        return this.buildNumber;
    }

    public boolean isNumberedBuild() {
        return this.getBuildNo() != null && this.getBuildNo().matches("[0-9]+");
    }

    private void registerCommand(String commandName, CommandExecutor executioner) {
        PluginCommand command = this.getCommand(commandName);
        command.setExecutor(executioner);
        if (executioner instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executioner);
        }
    }

    @Deprecated
    public void reload() {
        DisguiseConfig.loadConfig();
    }

    private void registerValues() {
        for (DisguiseType disguiseType : DisguiseType.values()) {
            Class watcherClass;
            if (disguiseType.getEntityType() == null) continue;
            try {
                switch (disguiseType) {
                    case ARROW: {
                        watcherClass = TippedArrowWatcher.class;
                        break;
                    }
                    case COD: 
                    case SALMON: {
                        watcherClass = FishWatcher.class;
                        break;
                    }
                    case SPECTRAL_ARROW: {
                        watcherClass = ArrowWatcher.class;
                        break;
                    }
                    case PRIMED_TNT: {
                        watcherClass = TNTWatcher.class;
                        break;
                    }
                    case MINECART_CHEST: 
                    case MINECART_HOPPER: 
                    case MINECART_MOB_SPAWNER: 
                    case MINECART_TNT: {
                        watcherClass = MinecartWatcher.class;
                        break;
                    }
                    case SPIDER: 
                    case CAVE_SPIDER: {
                        watcherClass = SpiderWatcher.class;
                        break;
                    }
                    case PIG_ZOMBIE: 
                    case HUSK: 
                    case DROWNED: {
                        watcherClass = ZombieWatcher.class;
                        break;
                    }
                    case MAGMA_CUBE: {
                        watcherClass = SlimeWatcher.class;
                        break;
                    }
                    case ELDER_GUARDIAN: {
                        watcherClass = GuardianWatcher.class;
                        break;
                    }
                    case WITHER_SKELETON: 
                    case STRAY: {
                        watcherClass = SkeletonWatcher.class;
                        break;
                    }
                    case ILLUSIONER: 
                    case EVOKER: {
                        watcherClass = IllagerWizardWatcher.class;
                        break;
                    }
                    case PUFFERFISH: {
                        watcherClass = PufferFishWatcher.class;
                        break;
                    }
                    default: {
                        watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + this.toReadable(disguiseType.name()) + "Watcher");
                        break;
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                Class entityClass = disguiseType.getEntityType().getEntityClass();
                if (entityClass != null) {
                    watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : (Fish.class.isAssignableFrom(entityClass) ? FishWatcher.class : FlagWatcher.class))));
                }
                watcherClass = FlagWatcher.class;
            }
            if (watcherClass == null) {
                this.getLogger().severe("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                continue;
            }
            disguiseType.setWatcherClass(watcherClass);
            if (DisguiseValues.getDisguiseValues(disguiseType) != null) continue;
            String nmsEntityName = this.toReadable(disguiseType.name());
            Class nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
            if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                Object[] split = this.splitReadable(disguiseType.name());
                ArrayUtils.reverse((Object[])split);
                nmsEntityName = StringUtils.join((Object[])split);
                nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
                if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                    nmsEntityName = null;
                }
            }
            if (nmsEntityName == null) {
                switch (disguiseType) {
                    case DONKEY: {
                        nmsEntityName = "HorseDonkey";
                        break;
                    }
                    case ARROW: {
                        nmsEntityName = "TippedArrow";
                        break;
                    }
                    case DROPPED_ITEM: {
                        nmsEntityName = "Item";
                        break;
                    }
                    case FIREBALL: {
                        nmsEntityName = "LargeFireball";
                        break;
                    }
                    case FIREWORK: {
                        nmsEntityName = "Fireworks";
                        break;
                    }
                    case GIANT: {
                        nmsEntityName = "GiantZombie";
                        break;
                    }
                    case HUSK: {
                        nmsEntityName = "ZombieHusk";
                        break;
                    }
                    case ILLUSIONER: {
                        nmsEntityName = "IllagerIllusioner";
                        break;
                    }
                    case LEASH_HITCH: {
                        nmsEntityName = "Leash";
                        break;
                    }
                    case MINECART: {
                        nmsEntityName = "MinecartRideable";
                        break;
                    }
                    case MINECART_COMMAND: {
                        nmsEntityName = "MinecartCommandBlock";
                        break;
                    }
                    case MINECART_TNT: {
                        nmsEntityName = "MinecartTNT";
                        break;
                    }
                    case MULE: {
                        nmsEntityName = "HorseMule";
                        break;
                    }
                    case PRIMED_TNT: {
                        nmsEntityName = "TNTPrimed";
                        break;
                    }
                    case PUFFERFISH: {
                        nmsEntityName = "PufferFish";
                        break;
                    }
                    case SPLASH_POTION: {
                        nmsEntityName = "Potion";
                        break;
                    }
                    case STRAY: {
                        nmsEntityName = "SkeletonStray";
                        break;
                    }
                    case TRIDENT: {
                        nmsEntityName = "ThrownTrident";
                        break;
                    }
                }
            }
            try {
                Float soundStrength;
                if (disguiseType == DisguiseType.UNKNOWN) {
                    DisguiseValues disguiseValues = new DisguiseValues(disguiseType, null, 0, 0.0);
                    disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                    DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
                    if (sound == null) continue;
                    sound.setDamageAndIdleSoundVolume(1.0f);
                    continue;
                }
                if (nmsEntityName == null) {
                    this.getLogger().warning("Entity name not found! (" + disguiseType.name() + ")");
                    continue;
                }
                Object nmsEntity = ReflectionManager.createEntityInstance(nmsEntityName);
                if (nmsEntity == null) {
                    this.getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                    continue;
                }
                disguiseType.setTypeId(ReflectionManager.getEntityType(nmsEntity));
                Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
                int entitySize = 0;
                for (Field field : ReflectionManager.getNmsClass("Entity").getFields()) {
                    if (!field.getType().getName().equals("EnumEntitySize")) continue;
                    Iterator<MetaIndex> enumEntitySize = (Enum)field.get(nmsEntity);
                    entitySize = ((Enum)((Object)enumEntitySize)).ordinal();
                    break;
                }
                DisguiseValues disguiseValues = new DisguiseValues(disguiseType, nmsEntity.getClass(), entitySize, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0);
                WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)bukkitEntity);
                ArrayList<MetaIndex> indexes = MetaIndex.getMetaIndexes(disguiseType.getWatcherClass());
                boolean loggedName = false;
                for (WrappedWatchableObject watch : watcher.getWatchableObjects()) {
                    MetaIndex flagType = MetaIndex.getMetaIndex(watcherClass, watch.getIndex());
                    if (flagType == null) {
                        this.getLogger().severe("MetaIndex not found for " + (Object)((Object)disguiseType) + "! Index: " + watch.getIndex());
                        this.getLogger().severe("Value: " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + watcherClass.getSimpleName());
                        continue;
                    }
                    indexes.remove(flagType);
                    Object ourValue = ReflectionManager.convertInvalidMeta(flagType.getDefault());
                    Object nmsValue = ReflectionManager.convertInvalidMeta(watch.getValue());
                    if (ourValue.getClass() == nmsValue.getClass()) continue;
                    if (!loggedName) {
                        this.getLogger().severe(StringUtils.repeat((String)"=", (int)20));
                        this.getLogger().severe("MetaIndex mismatch! Disguise " + (Object)((Object)disguiseType) + ", Entity " + nmsEntityName);
                        loggedName = true;
                    }
                    this.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                    this.getLogger().severe("Index: " + watch.getIndex() + " | " + flagType.getFlagWatcher().getSimpleName() + " | " + MetaIndex.getName(flagType));
                    Object flagDefault = flagType.getDefault();
                    this.getLogger().severe("LibsDisguises: " + flagDefault + " (" + flagDefault.getClass() + ")");
                    this.getLogger().severe("LibsDisguises Converted: " + ourValue + " (" + ourValue.getClass() + ")");
                    this.getLogger().severe("Minecraft: " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ")");
                    this.getLogger().severe("Minecraft Converted: " + nmsValue + " (" + nmsValue.getClass() + ")");
                    this.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                }
                for (MetaIndex index : indexes) {
                    this.getLogger().warning((Object)((Object)disguiseType) + " has MetaIndex remaining! " + index.getFlagWatcher().getSimpleName() + " at index " + index.getIndex());
                }
                DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
                if (sound != null && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                    sound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
                }
                disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
                if (bukkitEntity instanceof Ageable) {
                    ((Ageable)bukkitEntity).setBaby();
                    disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
                } else if (bukkitEntity instanceof Zombie) {
                    ((Zombie)bukkitEntity).setBaby(true);
                    disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
                }
                disguiseValues.setEntitySize(ReflectionManager.getSize(bukkitEntity));
            }
            catch (FieldAccessException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                this.getLogger().severe("Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
                this.getLogger().severe("Before reporting this error, please make sure you are using the latest version of LibsDisguises and ProtocolLib.");
                this.getLogger().severe("Development builds are available at (ProtocolLib) http://ci.dmulloy2.net/job/ProtocolLib/ and (LibsDisguises) https://ci.md-5.net/job/LibsDisguises/");
                ex.printStackTrace();
            }
        }
    }

    private String[] splitReadable(String string) {
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].substring(0, 1) + split[i].substring(1).toLowerCase();
        }
        return split;
    }

    private String toReadable(String string) {
        return StringUtils.join((Object[])this.splitReadable(string));
    }

    public DisguiseListener getListener() {
        return this.listener;
    }

    public static LibsDisguises getInstance() {
        return instance;
    }
}

