/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.TranslateFiller;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public enum TranslateType {
    DISGUISES("disguises"),
    MESSAGES("messages"),
    DISGUISE_OPTIONS("disguise_options"),
    DISGUISE_OPTIONS_PARAMETERS("disguise_option_parameters");

    private File file;
    private HashMap<String, String> translated = new HashMap();
    private FileWriter writer;

    private TranslateType(String fileName) {
        this.file = new File("plugins/LibsDisguises/Translations", fileName + ".yml");
    }

    public static void reloadTranslations() {
        for (TranslateType type : TranslateType.values()) {
            type.reload();
        }
        if (!LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            System.out.println("[LibsDisguises] You must purchase the plugin to use translations!");
        }
        TranslateFiller.fillConfigs();
    }

    protected void removeDuplicates() {
        Iterator<Map.Entry<String, String>> itel = this.translated.entrySet().iterator();
        while (itel.hasNext()) {
            Map.Entry<String, String> entry = itel.next();
            if (!entry.getKey().equals(entry.getValue())) continue;
            itel.remove();
        }
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void wipeTranslations() {
        this.translated.clear();
    }

    private void reload() {
        this.wipeTranslations();
        if (LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            System.out.println("[LibsDisguises] Loading translations: " + this.name());
        }
        if (!this.getFile().exists()) {
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.options().pathSeparator(Character.toChars(0)[0]);
        try {
            config.load(this.getFile());
            for (String key : config.getKeys(false)) {
                String value;
                if (Objects.equals(key, value = config.getString(key))) continue;
                if (value == null) {
                    System.err.println("Translation for " + this.name() + " has a null value for the key '" + key + "'");
                    continue;
                }
                this.translated.put(ChatColor.translateAlternateColorCodes((char)'&', (String)key), ChatColor.translateAlternateColorCodes((char)'&', (String)value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            System.out.println("[LibsDisguises] Loaded " + this.translated.size() + " translations for " + this.name());
        }
    }

    private File getFile() {
        return this.file;
    }

    public void save(String msg) {
        if (this != MESSAGES) {
            throw new IllegalArgumentException("Can't set no comment for '" + msg + "'");
        }
        this.save(msg, null);
    }

    public void save(String message, String comment) {
        if (this.translated.containsKey(message)) {
            return;
        }
        this.translated.put(message, message);
        message = StringEscapeUtils.escapeJava((String)message.replaceAll("\u00a7", "&"));
        try {
            boolean exists = this.getFile().exists();
            if (!exists) {
                this.getFile().getParentFile().mkdirs();
                this.getFile().createNewFile();
            }
            if (this.writer == null) {
                this.writer = new FileWriter(this.getFile(), true);
                if (!exists) {
                    this.writer.write("# To use translations in Lib's Disguises, you must have the purchased plugin\n");
                    if (this == MESSAGES) {
                        this.writer.write("# %s is where text is inserted, look up printf format codes if you're interested\n");
                    }
                }
            }
            this.writer.write("\n" + (comment != null ? "# " + comment + "\n" : "") + "\"" + message + "\": \"" + message + "\"\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String reverseGet(String translated) {
        if (translated == null || !LibsPremium.isPremium().booleanValue() || !DisguiseConfig.isUseTranslations()) {
            return translated;
        }
        String lowerCase = translated.toLowerCase();
        for (Map.Entry<String, String> entry : this.translated.entrySet()) {
            if (!Objects.equals(entry.getValue().toLowerCase(), lowerCase)) continue;
            return entry.getKey();
        }
        return translated;
    }

    public String get(String msg) {
        if (msg == null || !LibsPremium.isPremium().booleanValue() || !DisguiseConfig.isUseTranslations()) {
            return msg;
        }
        String toReturn = this.translated.get(msg);
        return toReturn == null ? msg : toReturn;
    }
}

