/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Sound;

public enum DisguiseSound {
    ARROW(null, null, null, null, "entity.arrow.hit", "entity.arrow.shoot"),
    BAT((Object)"entity.bat.hurt", null, (Object)"entity.bat.death", (Object)"entity.bat.ambient", "entity.player.small_fall", "entity.bat.loop", "entity.player.big_fall", "entity.bat.takeoff"),
    BLAZE((Object)"entity.blaze.hurt", null, (Object)"entity.blaze.death", (Object)"entity.blaze.ambient", "entity.player.small_fall", "entity.player.big_fall"),
    CAVE_SPIDER((Object)"entity.spider.ambient", "entity.spider.step", (Object)"entity.spider.death", (Object)"entity.spider.ambient", new Object[0]),
    CHICKEN((Object)"entity.chicken.hurt", "entity.chicken.step", (Object)"entity.chicken.hurt", (Object)"entity.chicken.ambient", "entity.player.small_fall", "entity.chicken.egg", "entity.player.big_fall"),
    COW((Object)"entity.cow.hurt", "entity.cow.step", (Object)"entity.cow.death", (Object)"entity.cow.ambient", new Object[0]),
    CREEPER((Object)"entity.creeper.hurt", "block.grass.step", (Object)"entity.creeper.death", null, "entity.creeper.primed"),
    DONKEY((Object)"entity.donkey.hurt", "block.grass.step", (Object)"entity.donkey.death", (Object)"entity.donkey.ambient", "entity.horse.gallop", "entity.horse.saddle", "entity.donkey.angry", "entity.horse.step_wood", "entity.horse.armor", "entity.horse.land", "entity.horse.jump", "entity.horse.angry"),
    ELDER_GUARDIAN((Object)"entity.elder_guardian.hurt", null, (Object)"entity.elder_guardian.death", (Object)"entity.elder_guardian.ambient", new Object[0]),
    ENDER_DRAGON((Object)"entity.enderdragon.hurt", null, (Object)"entity.enderdragon.death", (Object)"entity.enderdragon.ambient", "entity.player.small_fall", "entity.enderdragon.flap", "entity.player.big_fall"),
    ENDERMAN((Object)"entity.endermen.hurt", "block.grass.step", (Object)"entity.endermen.death", (Object)"entity.endermen.ambient", "entity.endermen.scream", "entity.endermen.teleport", "entity.endermen.stare"),
    ENDERMITE((Object)"entity.silverfish.hurt", "entity.endermite.step", (Object)"entity.endermite.death", (Object)"entity.endermite.ambient", new Object[0]),
    EVOKER((Object)"entity.evocation_illager.hurt", null, (Object)"entity.evocation_illager.death", (Object)"entity.evocation_illager.ambient", "entity.evocation_illager.cast_spell", "entity.evocation_illager.prepare_attack", "entity.evocation_illager.prepare_summon", "entity.evocation_illager.prepare_wololo"),
    EVOKER_FANGS(null, null, null, null, "entity.evocation_fangs.attack"),
    GHAST((Object)"entity.ghast.hurt", null, (Object)"entity.ghast.death", (Object)"entity.ghast.ambient", "entity.player.small_fall", "entity.ghast.shoot", "entity.player.big_fall", "entity.ghast.scream", "entity.ghast.warn"),
    GIANT((Object)"entity.player.hurt", "block.grass.step", null, null, new Object[0]),
    GUARDIAN((Object)"entity.guardian.hurt", null, (Object)"entity.guardian.death", (Object)"entity.elder_guardian.ambient", new Object[0]),
    HORSE((Object)"entity.horse.hurt", "block.grass.step", (Object)"entity.horse.death", (Object)"entity.horse.ambient", "entity.horse.gallop", "entity.horse.saddle", "entity.donkey.angry", "entity.horse.step_wood", "entity.horse.armor", "entity.horse.land", "entity.horse.jump", "entity.horse.angry"),
    ILLUSIONER((Object)"entity.illusion_illager.hurt", null, (Object)"entity.illusion_illager.death", (Object)"entity.illusion_illager.ambient", "entity.illusion_illager.cast_spell", "entity.illusion_illager.prepare_blindness", "entity.illusion_illager.prepare_mirror", "entity.illusion_illager.mirror_move"),
    IRON_GOLEM((Object)"entity.irongolem.hurt", "entity.irongolem.step", (Object)"entity.irongolem.death", (Object)"entity.irongolem.attack", new Object[0]),
    LLAMA((Object)"entity.llama.hurt", "entity.llama.step", (Object)"entity.llama.death", (Object)"entity.llama.ambient", "entity.llama.angry", "entity.llama.chest", "entity.llama.eat", "entity.llama.swag"),
    MAGMA_CUBE((Object)"entity.magmacube.hurt", "entity.magmacube.jump", null, null, new Object[0]),
    MULE((Object)"entity.mule.hurt", "block.grass.step", (Object)"entity.mule.death", (Object)"entity.mule.ambient", new Object[0]),
    MUSHROOM_COW((Object)"entity.cow.hurt", "entity.cow.step", (Object)"entity.cow.hurt", (Object)"entity.cow.ambient", new Object[0]),
    OCELOT((Object)"entity.cat.hurt", "block.grass.step", (Object)"entity.cat.hurt", (Object)"entity.cat.ambient", "entity.cat.purr", "entity.cat.purreow"),
    PARROT((Object)"entity.parrot.hurt", "entity.parrot.step", (Object)"entity.parrot.death", (Object)"entity.parrot.ambient", "entity.parrot.eat", "entity.parrot.fly", "entity.parrot.imitate.blaze", "entity.parrot.imitate.creeper", "entity.parrot.imitate.elder_guardian", "entity.parrot.imitate.enderdragon", "entity.parrot.imitate.enderman", "entity.parrot.imitate.endermite", "entity.parrot.imitate.evocation_illager", "entity.parrot.imitate.ghast", "entity.parrot.imitate.husk", "entity.parrot.imitate.illusion_illager", "entity.parrot.imitate.magmacube", "entity.parrot.imitate.polar_bear", "entity.parrot.imitate.shulker", "entity.parrot.imitate.silverfish", "entity.parrot.imitate.skeleton", "entity.parrot.imitate.slime", "entity.parrot.imitate.spider", "entity.parrot.imitate.stray", "entity.parrot.imitate.vex", "entity.parrot.imitate.vindication_illager", "entity.parrot.imitate.witch", "entity.parrot.imitate.wither", "entity.parrot.imitate.wither_skeleton", "entity.parrot.imitate.wolf", "entity.parrot.imitate.zombie", "entity.parrot.imitate.zombie_pigman", "entity.parrot.imitate.zombie_villager"),
    PIG((Object)"entity.pig.hurt", "entity.pig.step", (Object)"entity.pig.death", (Object)"entity.pig.ambient", new Object[0]),
    PIG_ZOMBIE((Object)"entity.zombie_pig.hurt", null, (Object)"entity.zombie_pig.death", (Object)"entity.zombie_pig.ambient", "entity.zombie_pig.angry"),
    PLAYER((Object)"entity.player.hurt", new String[]{"block.stone.step", "block.grass.step", "block.anvil.step", "block.cloth.step", "block.glass.step", "block.gravel.step", "block.ladder.step", "block.metal.step", "block.sand.step", "block.slime.step", "block.snow.step", "block.wood.step"}, (Object)"entity.player.death", (Object)null, new Object[0]),
    RABBIT((Object)"entity.rabbit.hurt", "entity.rabbit.jump", (Object)"entity.rabbit.death", (Object)"entity.rabbit.ambient", new Object[0]),
    SHEEP((Object)"entity.sheep.hurt", "entity.sheep.step", null, (Object)"entity.sheep.ambient", "entity.sheep.shear"),
    SHULKER((Object)"entity.shulker.hurt", null, (Object)"entity.shulker.death", (Object)"entity.shulker.ambient", "entity.shulker.open", "entity.shulker.close", "entity.shulker.hurt_closed", "entity.shulker.teleport"),
    SILVERFISH((Object)"entity.silverfish.hurt", "entity.silverfish.step", (Object)"entity.silverfish.death", (Object)"entity.silverfish.ambient", new Object[0]),
    SKELETON((Object)"entity.skeleton.hurt", "entity.skeleton.step", (Object)"entity.skeleton.death", (Object)"entity.skeleton.ambient", new Object[0]),
    SKELETON_HORSE((Object)"entity.skeleton_horse.hurt", "block.grass.step", (Object)"entity.skeleton_horse.death", (Object)"entity.skeleton_horse.ambient", "entity.horse.gallop", "entity.horse.saddle", "entity.donkey.angry", "entity.horse.step_wood", "entity.horse.armor", "entity.horse.land", "entity.horse.jump", "entity.horse.angry"),
    SLIME((Object)"entity.slime.hurt", "entity.slime.jump", (Object)"entity.slime.death", null, new Object[0]),
    SNOWMAN((Object)"entity.snowman.hurt", null, (Object)"entity.snowman.death", (Object)"entity.snowman.ambient", "entity.snowman.shoot"),
    SPIDER((Object)"entity.spider.ambient", "entity.spider.step", (Object)"entity.spider.death", (Object)"entity.spider.ambient", new Object[0]),
    SQUID((Object)"entity.squid.hurt", null, (Object)"entity.squid.death", (Object)"entity.squid.ambient", new Object[0]),
    ZOMBIE_HORSE((Object)"entity.zombie_horse.hurt", "block.grass.step", (Object)"entity.zombie_horse.death", (Object)"entity.zombie_horse.ambient", "entity.horse.gallop", "entity.horse.saddle", "entity.donkey.angry", "entity.horse.step_wood", "entity.horse.armor", "entity.horse.land", "entity.horse.jump", "entity.horse.angry"),
    VEX((Object)"entity.vex.hurt", null, (Object)"entity.vex.death", (Object)"entity.vex.ambient", "entity.vex.charge"),
    VILLAGER((Object)"entity.villager.hurt", null, (Object)"entity.villager.death", (Object)"entity.villager.ambient", "entity.villager.trading", "entity.villager.no", "entity.villager.yes"),
    VINDICATOR((Object)"entity.vindication_illager.hurt", null, (Object)"entity.vindication_illager.death", (Object)"entity.vindication_illager.ambient", new Object[0]),
    WITCH((Object)"entity.witch.hurt", null, (Object)"entity.witch.death", (Object)"entity.witch.ambient", new Object[0]),
    WITHER((Object)"entity.wither.hurt", null, (Object)"entity.wither.death", (Object)"entity.wither.ambient", "entity.player.small_fall", "entity.wither.spawn", "entity.player.big_fall", "entity.wither.shoot"),
    WITHER_SKELETON((Object)"entity.skeleton.hurt", "entity.skeleton.step", (Object)"entity.skeleton.death", (Object)"entity.skeleton.ambient", new Object[0]),
    WOLF((Object)"entity.wolf.hurt", "entity.wolf.step", (Object)"entity.wolf.death", (Object)"entity.wolf.ambient", "entity.wolf.growl", "entity.wolf.pant", "entity.wolf.howl", "entity.wolf.shake", "entity.wolf.whine"),
    ZOMBIE((Object)"entity.zombie.hurt", "entity.zombie.step", (Object)"entity.zombie.death", (Object)"entity.zombie.ambient", "entity.zombie.infect", "entity.zombie.break_door_wood", "entity.zombie.attack_door_wood", "entity.zombie.attack_iron_door"),
    ZOMBIE_VILLAGER((Object)"entity.zombie_villager.hurt", "entity.zombie_villager.step", (Object)"entity.zombie_villager.death", (Object)"entity.zombie_villager.ambient", "entity.zombie.infect", "entity.zombie.break_door_wood", "entity.zombie.attack_door_wood", "entity.zombie.attack_iron_door");

    private float damageSoundVolume = 1.0f;
    private HashMap<Object, Object> disguiseSounds = new HashMap();

    public static DisguiseSound getType(String name) {
        try {
            return DisguiseSound.valueOf(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private DisguiseSound(Object hurt, Object step, Object death, Object idle, Object ... sounds) {
        this.addSound(hurt, SoundType.HURT);
        this.addSound(step, SoundType.STEP);
        this.addSound(death, SoundType.DEATH);
        this.addSound(idle, SoundType.IDLE);
        for (Object obj : sounds) {
            this.addSound(obj, SoundType.CANCEL);
        }
    }

    private DisguiseSound(Object hurt, Object[] step, Object death, Object idle, Object ... sounds) {
        this.addSound(hurt, SoundType.HURT);
        if (step != null) {
            for (Object obj : step) {
                this.addSound(obj, SoundType.STEP);
            }
        }
        this.addSound(death, SoundType.DEATH);
        this.addSound(idle, SoundType.IDLE);
        for (Object obj : sounds) {
            this.addSound(obj, SoundType.CANCEL);
        }
    }

    public static void replace(String oldString, String newString) {
        for (DisguiseSound sound : DisguiseSound.values()) {
            if (sound.disguiseSounds.containsKey(oldString)) {
                sound.disguiseSounds.put(newString, sound.disguiseSounds.get(oldString));
            }
            for (Map.Entry<Object, Object> entry : sound.disguiseSounds.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().equals(oldString)) continue;
                entry.setValue(newString);
            }
        }
    }

    private void addSound(Object sound, SoundType type) {
        String s;
        if (sound == null) {
            return;
        }
        if (sound instanceof String) {
            s = (String)sound;
        } else if (sound instanceof Sound) {
            s = ReflectionManager.getCraftSound((Sound)sound);
        } else {
            throw new RuntimeException("Was given a unknown object " + sound);
        }
        switch (type) {
            case HURT: {
                this.disguiseSounds.put((Object)SoundType.HURT, s);
                break;
            }
            case STEP: {
                this.disguiseSounds.put(s, (Object)SoundType.STEP);
                break;
            }
            case DEATH: {
                this.disguiseSounds.put((Object)SoundType.DEATH, s);
                break;
            }
            case IDLE: {
                this.disguiseSounds.put((Object)SoundType.IDLE, s);
                break;
            }
            case CANCEL: {
                this.disguiseSounds.put(s, (Object)SoundType.CANCEL);
            }
        }
    }

    public float getDamageAndIdleSoundVolume() {
        return this.damageSoundVolume;
    }

    public String getSound(SoundType type) {
        if (type == null) {
            return null;
        }
        if (this.disguiseSounds.containsKey((Object)type)) {
            return (String)this.disguiseSounds.get((Object)type);
        }
        if (this.disguiseSounds.containsValue((Object)type)) {
            for (Map.Entry<Object, Object> entry : this.disguiseSounds.entrySet()) {
                if (entry.getValue() != type) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public SoundType getSound(String sound) {
        if (sound == null) {
            return null;
        }
        if (this.disguiseSounds.containsKey(sound)) {
            return (SoundType)((Object)this.disguiseSounds.get(sound));
        }
        if (this.disguiseSounds.containsValue(sound)) {
            for (Map.Entry<Object, Object> entry : this.disguiseSounds.entrySet()) {
                if (!Objects.equals(sound, entry.getValue())) continue;
                return (SoundType)((Object)entry.getKey());
            }
        }
        return null;
    }

    public SoundType getType(String sound, boolean ignoreDamage) {
        if (sound == null) {
            return SoundType.CANCEL;
        }
        if (this.isCancelSound(sound)) {
            return SoundType.CANCEL;
        }
        for (SoundType type : SoundType.values()) {
            if (!this.disguiseSounds.containsKey((Object)type) || type == SoundType.DEATH || ignoreDamage && type == SoundType.HURT) continue;
            Object s = this.disguiseSounds.get((Object)type);
            if (s != null) {
                if (!Objects.equals(s, sound)) continue;
                return type;
            }
            for (Map.Entry<Object, Object> entry : this.disguiseSounds.entrySet()) {
                if (!Objects.equals(sound, entry.getKey())) continue;
                return (SoundType)((Object)entry.getValue());
            }
        }
        return null;
    }

    public boolean isCancelSound(String sound) {
        return this.getSound(sound) == SoundType.CANCEL;
    }

    public void setDamageAndIdleSoundVolume(float strength) {
        this.damageSoundVolume = strength;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

