/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsMsg;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import me.libraryaddict.disguise.utilities.TranslateType;
import org.bukkit.Art;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class DisguiseParser {
    private static Object callValueOf(Class<?> param, String valueString, String methodName) throws DisguiseParseException {
        Object value;
        try {
            value = param.getMethod("valueOf", String.class).invoke(null, valueString.toUpperCase());
        }
        catch (Exception ex) {
            throw DisguiseParser.parseToException(param, valueString, methodName);
        }
        return value;
    }

    private static void doCheck(CommandSender sender, HashMap<ArrayList<String>, Boolean> optionPermissions, ArrayList<String> usedOptions) throws DisguiseParseException {
        if (!DisguiseParser.passesCheck(sender, optionPermissions, usedOptions)) {
            throw new DisguiseParseException(LibsMsg.D_PARSE_NOPERM, usedOptions.get(usedOptions.size() - 1));
        }
    }

    private static HashMap<String, Boolean> getDisguiseOptions(CommandSender sender, String permNode, DisguisePerm type) {
        switch (type.getType()) {
            case PLAYER: 
            case FALLING_BLOCK: 
            case PAINTING: 
            case SPLASH_POTION: 
            case FISHING_HOOK: 
            case DROPPED_ITEM: {
                HashMap<String, Boolean> returns = new HashMap<String, Boolean>();
                String beginning = "libsdisguises.options." + permNode + ".";
                for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
                    String[] split;
                    String lowerPerm = permission.getPermission().toLowerCase();
                    if (!lowerPerm.startsWith(beginning) || (split = lowerPerm.substring(beginning.length()).split("\\.")).length <= 1 || !split[0].replace("_", "").equals(type.toReadable().toLowerCase().replace(" ", ""))) continue;
                    for (int i = 1; i < split.length; ++i) {
                        returns.put(split[i], permission.getValue());
                    }
                }
                return returns;
            }
        }
        return new HashMap<String, Boolean>();
    }

    public static DisguisePerm getDisguisePerm(String name) {
        for (DisguisePerm perm : DisguiseParser.getDisguisePerms()) {
            if (!perm.toReadable().replaceAll("[ |_]", "").equalsIgnoreCase(name.replaceAll("[ |_]", ""))) continue;
            return perm;
        }
        if (name.equalsIgnoreCase("p")) {
            return DisguiseParser.getDisguisePerm(DisguiseType.PLAYER.toReadable());
        }
        return null;
    }

    public static DisguisePerm[] getDisguisePerms() {
        DisguisePerm[] perms = new DisguisePerm[DisguiseType.values().length + DisguiseConfig.getCustomDisguises().size()];
        int i = 0;
        for (DisguiseType disguiseType : DisguiseType.values()) {
            perms[i++] = new DisguisePerm(disguiseType);
        }
        for (Map.Entry entry : DisguiseConfig.getCustomDisguises().entrySet()) {
            perms[i++] = new DisguisePerm(((Disguise)entry.getValue()).getType(), (String)entry.getKey());
        }
        return perms;
    }

    private static Map.Entry<Method, Integer> getMethod(Method[] methods, String methodName, int toStart) {
        for (int i = toStart; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return new AbstractMap.SimpleEntry<Method, Integer>(method, ++i);
        }
        return null;
    }

    private static HashMap<ArrayList<String>, Boolean> getOptions(String perm) {
        ArrayList<String> list = new ArrayList<String>();
        boolean isRemove = true;
        String[] split = perm.split("\\.");
        for (int i = 1; i < split.length; ++i) {
            String option = split[i];
            boolean value = option.startsWith("-");
            if (value) {
                option = option.substring(1);
                isRemove = false;
            }
            if (option.equals("baby")) {
                option = "setbaby";
            }
            list.add(option);
        }
        HashMap<ArrayList<String>, Boolean> options = new HashMap<ArrayList<String>, Boolean>();
        options.put(list, isRemove);
        return options;
    }

    public static HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>> getPermissions(CommandSender sender, String permissionNode) {
        Class entityClass;
        String disguiseType;
        HashMap<DisguisePerm, Object> singleDisguises = new HashMap<DisguisePerm, Object>();
        HashMap<DisguisePerm, HashMap> rangeDisguises = new HashMap<DisguisePerm, HashMap>();
        HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
        for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
            String perm = permission.getPermission().toLowerCase();
            if (!perm.startsWith(permissionNode) || perms.containsKey(perm) && permission.getValue()) continue;
            perms.put(perm, permission.getValue());
        }
        if (!perms.containsKey(permissionNode + "*") && sender.hasPermission(permissionNode + "*")) {
            perms.put(permissionNode + "*", true);
        }
        if (!perms.containsKey(permissionNode + "*.*") && sender.hasPermission(permissionNode + "*.*")) {
            perms.put(permissionNode + "*.*", true);
        }
        for (String perm : perms.keySet()) {
            if (!((Boolean)perms.get(perm)).booleanValue()) continue;
            disguiseType = (perm = perm.substring(permissionNode.length())).split("\\.")[0];
            DisguisePerm dPerm = DisguiseParser.getDisguisePerm(disguiseType);
            if (dPerm != null) {
                Object list;
                if (singleDisguises.containsKey(dPerm)) {
                    list = (HashMap)singleDisguises.get(dPerm);
                } else {
                    list = new HashMap();
                    singleDisguises.put(dPerm, list);
                }
                HashMap<ArrayList<String>, Boolean> map1 = DisguiseParser.getOptions(perm);
                ((HashMap)list).put(map1.keySet().iterator().next(), map1.values().iterator().next());
                continue;
            }
            for (DisguisePerm type : DisguiseParser.getDisguisePerms()) {
                HashMap list;
                HashMap<ArrayList<String>, Boolean> options = null;
                entityClass = type.getEntityClass();
                if (disguiseType.equals("mob")) {
                    if (type.isMob()) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("animal") || disguiseType.equals("animals")) {
                    if (Animals.class.isAssignableFrom(entityClass)) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("monster") || disguiseType.equals("monsters")) {
                    if (Monster.class.isAssignableFrom(entityClass)) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("misc")) {
                    if (type.isMisc()) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("ageable")) {
                    if (Ageable.class.isAssignableFrom(entityClass)) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("*")) {
                    options = DisguiseParser.getOptions(perm);
                }
                if (options == null) continue;
                if (rangeDisguises.containsKey(type)) {
                    list = (HashMap)rangeDisguises.get(type);
                } else {
                    list = new HashMap();
                    rangeDisguises.put(type, list);
                }
                HashMap<ArrayList<String>, Boolean> map1 = DisguiseParser.getOptions(perm);
                list.put(map1.keySet().iterator().next(), map1.values().iterator().next());
            }
        }
        for (String perm : perms.keySet()) {
            if (((Boolean)perms.get(perm)).booleanValue()) continue;
            disguiseType = (perm = perm.substring(permissionNode.length())).split("\\.")[0];
            DisguisePerm dType = DisguiseParser.getDisguisePerm(disguiseType);
            if (dType != null) {
                singleDisguises.remove(dType);
                rangeDisguises.remove(dType);
                continue;
            }
            for (DisguisePerm type : DisguiseParser.getDisguisePerms()) {
                boolean foundHim = false;
                entityClass = type.getEntityClass();
                switch (disguiseType) {
                    case "mob": {
                        if (!type.isMob()) break;
                        foundHim = true;
                        break;
                    }
                    case "animal": 
                    case "animals": {
                        if (!Animals.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "monster": 
                    case "monsters": {
                        if (!Monster.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "misc": {
                        if (!type.isMisc()) break;
                        foundHim = true;
                        break;
                    }
                    case "ageable": {
                        if (!Ageable.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "*": {
                        foundHim = true;
                    }
                }
                if (!foundHim) continue;
                rangeDisguises.remove(type);
            }
        }
        HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = new HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>>();
        for (DisguisePerm type : DisguiseParser.getDisguisePerms()) {
            HashMap temp = new HashMap();
            if (singleDisguises.containsKey(type)) {
                temp.putAll((Map)singleDisguises.get(type));
            }
            if (rangeDisguises.containsKey(type)) {
                temp.putAll((Map)rangeDisguises.get(type));
            }
            if (temp.isEmpty()) continue;
            map.put(type, temp);
        }
        return map;
    }

    private static boolean isDouble(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String[] split(String string) {
        String[] strings = ChatColor.translateAlternateColorCodes((char)'&', (String)string).split(" ");
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            String a = s.replaceAll("\\\\", "");
            if (builder.length() != 0 || s.startsWith("\"")) {
                if (builder.length() != 0) {
                    builder.append(' ');
                }
                if (s.startsWith("\"")) {
                    builder.append(s.substring(1));
                } else if (a.endsWith("\"") && !a.endsWith("\\\"")) {
                    builder.append(s.substring(0, s.length() - 1));
                } else {
                    builder.append(s);
                }
                if (!a.endsWith("\"") || a.endsWith("\\\"")) continue;
                list.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            list.add(s);
        }
        if (builder.length() != 0) {
            list.addAll(Arrays.asList(("\"" + builder.toString()).split(" ")));
        }
        return list.toArray(new String[list.size()]);
    }

    public static Disguise parseDisguise(CommandSender sender, String permNode, String[] args, HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>> permissionMap) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        HashMap<ArrayList<String>, Boolean> optionPermissions;
        if (sender instanceof Player) {
            DisguiseUtilities.setCommandsUsed();
        }
        if (permissionMap.isEmpty()) {
            throw new DisguiseParseException(LibsMsg.NO_PERM, new String[0]);
        }
        if (args.length == 0) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_ARGS, new String[0]);
        }
        int toSkip = 1;
        ArrayList<String> usedOptions = new ArrayList<String>();
        Disguise disguise = null;
        if (args[0].startsWith("@")) {
            if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
                disguise = DisguiseUtilities.getClonedDisguise(args[0].toLowerCase());
                if (disguise == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_REF, args[0]);
                }
            } else {
                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_REF, new String[0]);
            }
            optionPermissions = permissionMap.containsKey(new DisguisePerm(disguise.getType())) ? permissionMap.get(new DisguisePerm(disguise.getType())) : new HashMap();
        } else {
            DisguisePerm disguisePerm = DisguiseParser.getDisguisePerm(args[0]);
            Map.Entry<String, Disguise> customDisguise = DisguiseConfig.getCustomDisguise(args[0]);
            if (customDisguise != null) {
                disguise = customDisguise.getValue().clone();
            }
            if (disguisePerm == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_DISG_NO_EXIST, args[0]);
            }
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!permissionMap.containsKey(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
            optionPermissions = permissionMap.get(disguisePerm);
            HashMap<String, Boolean> disguiseOptions = DisguiseParser.getDisguiseOptions(sender, permNode, disguisePerm);
            if (disguise == null) {
                if (disguisePerm.isPlayer()) {
                    if (args.length == 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_SUPPLY_PLAYER, new String[0]);
                    }
                    if (!(disguiseOptions.isEmpty() || disguiseOptions.containsKey(args[1].toLowerCase()) && disguiseOptions.get(args[1].toLowerCase()).booleanValue())) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_NAME, new String[0]);
                    }
                    args[1] = args[1].replace("\\_", " ");
                    disguise = new PlayerDisguise(ChatColor.translateAlternateColorCodes((char)'&', (String)args[1]));
                    ++toSkip;
                } else if (disguisePerm.isMob()) {
                    boolean adult = true;
                    if (args.length > 1 && (args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("baby")) || args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult")))) {
                        usedOptions.add("setbaby");
                        DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        adult = args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult"));
                        ++toSkip;
                    }
                    disguise = new MobDisguise(disguisePerm.getType(), adult);
                } else if (disguisePerm.isMisc()) {
                    int miscId = -1;
                    int miscData = -1;
                    String secondArg = null;
                    if (args.length > 1) {
                        if (args[1].contains(":")) {
                            String[] split = args[1].split(":");
                            if (DisguiseParser.isInteger(split[1])) {
                                secondArg = split[1];
                            }
                            args[1] = split[0];
                        }
                        if (DisguiseParser.isInteger(args[1])) {
                            miscId = Integer.parseInt(args[1]);
                        } else if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK || disguisePerm.getType() == DisguiseType.DROPPED_ITEM) {
                            for (String string : Material.values()) {
                                if (!string.name().replace("_", "").equalsIgnoreCase(args[1].replace("_", ""))) continue;
                                miscId = string.getId();
                                break;
                            }
                        }
                        if (miscId != -1) {
                            switch (disguisePerm.getType()) {
                                case FALLING_BLOCK: 
                                case PAINTING: 
                                case SPLASH_POTION: 
                                case FISHING_HOOK: 
                                case DROPPED_ITEM: 
                                case ARROW: 
                                case TIPPED_ARROW: 
                                case SPECTRAL_ARROW: 
                                case SMALL_FIREBALL: 
                                case FIREBALL: 
                                case WITHER_SKULL: {
                                    break;
                                }
                                default: {
                                    throw new DisguiseParseException(LibsMsg.PARSE_TOO_MANY_ARGS, disguisePerm.toReadable(), args[1]);
                                }
                            }
                            ++toSkip;
                            if (args.length > 2 && secondArg == null && DisguiseParser.isInteger(args[2])) {
                                secondArg = args[2];
                                ++toSkip;
                            }
                            if (secondArg != null) {
                                if (disguisePerm.getType() != DisguiseType.FALLING_BLOCK && disguisePerm.getType() != DisguiseType.DROPPED_ITEM) {
                                    throw new DisguiseParseException(LibsMsg.PARSE_USE_SECOND_NUM, DisguiseType.FALLING_BLOCK.toReadable(), DisguiseType.DROPPED_ITEM.toReadable());
                                }
                                miscData = Integer.parseInt(secondArg);
                            }
                        }
                    }
                    if (!disguiseOptions.isEmpty() && miscId != -1) {
                        String toCheck = "" + miscId;
                        if (miscData == 0 || miscData == -1) {
                            if (!disguiseOptions.containsKey(toCheck) || !disguiseOptions.get(toCheck).booleanValue()) {
                                toCheck = toCheck + ":0";
                            }
                        } else {
                            toCheck = toCheck + ":" + miscData;
                        }
                        if (!disguiseOptions.containsKey(toCheck) || !disguiseOptions.get(toCheck).booleanValue()) {
                            throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, toCheck, disguisePerm.toReadable());
                        }
                    }
                    if (miscId != -1) {
                        if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                            usedOptions.add("setblock");
                            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        } else if (disguisePerm.getType() == DisguiseType.PAINTING) {
                            usedOptions.add("setpainting");
                            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        } else if (disguisePerm.getType() == DisguiseType.SPLASH_POTION) {
                            usedOptions.add("setpotionid");
                            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        }
                    }
                    disguise = new MiscDisguise(disguisePerm.getType(), miscId, miscData);
                }
            }
        }
        String[] newArgs = new String[args.length - toSkip];
        System.arraycopy(args, toSkip, newArgs, 0, args.length - toSkip);
        DisguiseParser.callMethods(sender, disguise, optionPermissions, usedOptions, newArgs);
        return disguise;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void callMethods(CommandSender sender, Disguise disguise, HashMap<ArrayList<String>, Boolean> optionPermissions, ArrayList<String> usedOptions, String[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DisguiseParseException {
        Method[] methods = ReflectionFlagWatchers.getDisguiseWatcherMethods(disguise.getWatcher().getClass());
        for (int i = 0; i < args.length; i += 2) {
            void var11_11;
            String methodNameRaw = args[i];
            String methodName = TranslateType.DISGUISE_OPTIONS.reverseGet(methodNameRaw);
            String valueString = TranslateType.DISGUISE_OPTIONS_PARAMETERS.reverseGet(args.length - 1 == i ? null : args[i + 1]);
            Method methodToUse = null;
            Object var11_12 = null;
            DisguiseParseException storedEx = null;
            int c = 0;
            while (c < methods.length) {
                try {
                    Class<?> param;
                    block87: {
                        Map.Entry<Method, Integer> entry = DisguiseParser.getMethod(methods, methodName, c);
                        if (entry == null) break;
                        methodToUse = entry.getKey();
                        c = entry.getValue();
                        methodNameRaw = methodToUse.getName();
                        methodName = TranslateType.DISGUISE_OPTIONS.reverseGet(methodNameRaw);
                        Class<?>[] types = methodToUse.getParameterTypes();
                        param = types[0];
                        if (valueString != null) {
                            if (Integer.TYPE == param) {
                                if (!DisguiseParser.isInteger(valueString)) throw DisguiseParser.parseToException(param, valueString, methodName);
                                Integer n = Integer.parseInt(valueString);
                            } else {
                                if (WrappedGameProfile.class == param && valueString.length() > 20) {
                                    try {
                                        Object object = DisguiseUtilities.getGson().fromJson(valueString, WrappedGameProfile.class);
                                    }
                                    catch (Exception ex) {
                                        throw DisguiseParser.parseToException(WrappedGameProfile.class, valueString, methodName);
                                    }
                                }
                                if (Float.TYPE == param || Double.TYPE == param) {
                                    if (!DisguiseParser.isDouble(valueString)) throw DisguiseParser.parseToException(param, valueString, methodName);
                                    float obj = Float.parseFloat(valueString);
                                    if (param == Float.TYPE) {
                                        Float f = Float.valueOf(obj);
                                    } else if (param == Double.TYPE) {
                                        Double d = obj;
                                    }
                                } else if (param == String.class) {
                                    if (methodNameRaw.equalsIgnoreCase("setskin") && valueString.length() > 20) {
                                        String string = valueString;
                                    } else {
                                        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)valueString);
                                    }
                                } else if (param == EulerAngle.class) {
                                    String[] split = valueString.split(",");
                                    if (split.length != 3) {
                                        throw DisguiseParser.parseToException(param, valueString, methodName);
                                    }
                                    if (!(DisguiseParser.isDouble(split[0]) && DisguiseParser.isDouble(split[1]) && DisguiseParser.isDouble(split[2]))) {
                                        throw DisguiseParser.parseToException(param, valueString, methodName);
                                    }
                                    EulerAngle eulerAngle = new EulerAngle(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
                                } else {
                                    if (param == Villager.Profession.class) {
                                        try {
                                            Villager.Profession profession = Villager.Profession.valueOf((String)valueString.toUpperCase());
                                        }
                                        catch (Exception ex) {
                                            throw DisguiseParser.parseToException(param, valueString, methodName);
                                        }
                                    }
                                    if (param == AnimalColor.class) {
                                        try {
                                            AnimalColor animalColor = AnimalColor.valueOf(valueString.toUpperCase());
                                        }
                                        catch (Exception ex) {
                                            throw DisguiseParser.parseToException(param, valueString, methodName);
                                        }
                                    }
                                    if (param.getName().equals("org.bukkit.entity.Llama$Color")) {
                                        try {
                                            Llama.Color color = Llama.Color.valueOf((String)valueString.toUpperCase());
                                        }
                                        catch (Exception ex) {
                                            throw DisguiseParser.parseToException(param, valueString, methodName);
                                        }
                                    }
                                    if (param == ItemStack.class) {
                                        ItemStack itemStack = DisguiseParser.parseToItemstack(param, methodName, valueString);
                                    } else if (param == ItemStack[].class) {
                                        ItemStack[] items = new ItemStack[4];
                                        String[] split = valueString.split(",", -1);
                                        if (split.length != 4) throw DisguiseParser.parseToException(param, valueString, methodName);
                                        for (int a = 0; a < 4; ++a) {
                                            try {
                                                items[a] = DisguiseParser.parseToItemstack(param, methodName, split[a]);
                                                continue;
                                            }
                                            catch (Exception ex) {
                                                throw DisguiseParser.parseToException(param, valueString, methodName);
                                            }
                                        }
                                        ItemStack[] itemStackArray = items;
                                    } else if (param == Horse.Color.class) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName);
                                    } else if (param == Horse.Style.class) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName);
                                    } else if (param == Art.class) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName);
                                    } else if (param == Ocelot.Type.class) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName);
                                    } else if (param.getSimpleName().equals("TreeSpecies")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName);
                                    } else {
                                        if (param == PotionEffectType.class) {
                                            try {
                                                PotionEffectType potionType = PotionEffectType.getByName((String)valueString.toUpperCase());
                                                if (potionType == null && DisguiseParser.isInteger(valueString)) {
                                                    potionType = PotionEffectType.getById((int)Integer.parseInt(valueString));
                                                }
                                                if (potionType == null) {
                                                    throw new DisguiseParseException();
                                                }
                                                PotionEffectType potionEffectType = potionType;
                                            }
                                            catch (Exception ex) {
                                                throw DisguiseParser.parseToException(param, valueString, methodName);
                                            }
                                        }
                                        if (param == int[].class) {
                                            String[] split = valueString.split(",");
                                            int[] values = new int[split.length];
                                            for (int b = 0; b < values.length; ++b) {
                                                try {
                                                    values[b] = Integer.parseInt(split[b]);
                                                    continue;
                                                }
                                                catch (NumberFormatException ex) {
                                                    throw DisguiseParser.parseToException(param, valueString, methodName);
                                                }
                                            }
                                            int[] nArray = values;
                                        } else {
                                            if (param == BlockFace.class) {
                                                try {
                                                    BlockFace face = BlockFace.valueOf((String)valueString.toUpperCase());
                                                    if (face.ordinal() > 5) {
                                                        throw new DisguiseParseException();
                                                    }
                                                    BlockFace blockFace = face;
                                                }
                                                catch (Exception ex) {
                                                    throw DisguiseParser.parseToException(param, valueString, methodName);
                                                }
                                            }
                                            if (param == RabbitType.class) {
                                                try {
                                                    for (RabbitType type : RabbitType.values()) {
                                                        if (!type.name().replace("_", "").equalsIgnoreCase(valueString.replace("_", "").replace(" ", ""))) continue;
                                                        RabbitType rabbitType = type;
                                                        break;
                                                    }
                                                    if (var11_11 == null) {
                                                        throw new Exception();
                                                    }
                                                    break block87;
                                                }
                                                catch (Exception ex) {
                                                    throw DisguiseParser.parseToException(param, valueString, methodName);
                                                }
                                            }
                                            if (param == BlockPosition.class) {
                                                try {
                                                    String[] split = valueString.split(",");
                                                    assert (split.length == 3);
                                                    BlockPosition blockPosition = new BlockPosition(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                                                }
                                                catch (Exception ex) {
                                                    throw DisguiseParser.parseToException(param, valueString, methodName);
                                                }
                                            } else if (param.getName().equals("org.bukkit.entity.Parrot$Variant")) {
                                                Object object = DisguiseParser.callValueOf(param, valueString, methodName);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (var11_11 == null && Boolean.TYPE == param) {
                        if (valueString == null) {
                            Boolean bl = true;
                            --i;
                        } else if (valueString.equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("true"))) {
                            Boolean bl = true;
                        } else if (valueString.equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("false"))) {
                            Boolean bl = false;
                        } else {
                            if (DisguiseParser.getMethod(methods, valueString, 0) == null) {
                                throw DisguiseParser.parseToException(param, valueString, methodName);
                            }
                            Boolean bl = true;
                            --i;
                        }
                    }
                    if (var11_11 == null) continue;
                    break;
                }
                catch (DisguiseParseException ex) {
                    storedEx = ex;
                    methodToUse = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    methodToUse = null;
                }
            }
            if (methodToUse == null) {
                if (storedEx == null) throw new DisguiseParseException(LibsMsg.PARSE_OPTION_NA, methodName);
                throw storedEx;
            }
            if (var11_11 == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_NO_OPTION_VALUE, methodName);
            }
            if (!usedOptions.contains(methodNameRaw.toLowerCase())) {
                usedOptions.add(methodNameRaw.toLowerCase());
            }
            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
            if (FlagWatcher.class.isAssignableFrom(methodToUse.getDeclaringClass())) {
                methodToUse.invoke((Object)disguise.getWatcher(), var11_11);
                continue;
            }
            methodToUse.invoke((Object)disguise, var11_11);
        }
    }

    private static DisguiseParseException parseToException(Class paramType, String receivedInstead, String methodName) {
        return new DisguiseParseException(LibsMsg.PARSE_EXPECTED_RECEIVED, ReflectionFlagWatchers.getParamInfo(paramType).getName(), receivedInstead, methodName);
    }

    private static ItemStack parseToItemstack(Class param, String method, String string) throws DisguiseParseException {
        String[] split = string.split(":", -1);
        int itemId = -1;
        if (split[0].isEmpty() || split[0].equalsIgnoreCase("null")) {
            return null;
        }
        if (DisguiseParser.isInteger(split[0])) {
            itemId = Integer.parseInt(split[0]);
        } else {
            try {
                itemId = Material.valueOf((String)split[0].toUpperCase()).getId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (itemId != -1) {
            short itemDura = 0;
            if (split.length > 1) {
                if (DisguiseParser.isInteger(split[1])) {
                    itemDura = Short.parseShort(split[1]);
                } else {
                    throw DisguiseParser.parseToException(param, string, "%s");
                }
            }
            return new ItemStack(itemId, 1, itemDura);
        }
        if (split.length == 1) {
            throw DisguiseParser.parseToException(param, string, "%s");
        }
        throw DisguiseParser.parseToException(param, string, "%s");
    }

    public static boolean passesCheck(CommandSender sender, HashMap<ArrayList<String>, Boolean> theirPermissions, ArrayList<String> usedOptions) {
        if (theirPermissions == null) {
            return false;
        }
        boolean hasPermission = false;
        for (ArrayList<String> list : theirPermissions.keySet()) {
            boolean myPerms = true;
            for (String option : usedOptions) {
                if (!sender.getName().equals("CONSOLE") && option.equalsIgnoreCase("setInvisible") && DisguiseConfig.isDisabledInvisibility()) {
                    myPerms = false;
                }
                if (theirPermissions.get(list).booleanValue() && list.contains("*") || list.contains(option) == theirPermissions.get(list).booleanValue()) continue;
                myPerms = false;
                break;
            }
            if (!myPerms) continue;
            hasPermission = true;
        }
        return hasPermission;
    }

    public static class DisguisePerm {
        private DisguiseType disguiseType;
        private String permName;

        public DisguisePerm(DisguiseType disguiseType) {
            this.disguiseType = disguiseType;
        }

        public DisguisePerm(DisguiseType disguiseType, String disguisePerm) {
            this.disguiseType = disguiseType;
            this.permName = disguisePerm;
        }

        public Class getEntityClass() {
            return this.getType().getEntityClass();
        }

        public EntityType getEntityType() {
            return this.getType().getEntityType();
        }

        public DisguiseType getType() {
            return this.disguiseType;
        }

        public Class<? extends FlagWatcher> getWatcherClass() {
            return this.getType().getWatcherClass();
        }

        public boolean isMisc() {
            return this.getType().isMisc();
        }

        public boolean isMob() {
            return this.getType().isMob();
        }

        public boolean isPlayer() {
            return this.getType().isPlayer();
        }

        public boolean isUnknown() {
            return this.getType().isUnknown();
        }

        public String toReadable() {
            return this.permName == null ? this.getType().toReadable() : this.permName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.disguiseType == null ? 0 : this.disguiseType.hashCode());
            result = 31 * result + (this.permName == null ? 0 : this.permName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DisguisePerm)) {
                return false;
            }
            DisguisePerm other = (DisguisePerm)obj;
            if (this.disguiseType != other.disguiseType) {
                return false;
            }
            return !(this.permName == null ? other.permName != null : !this.permName.equals(other.permName));
        }
    }

    public static class DisguiseParseException
    extends Exception {
        private static final long serialVersionUID = 1276971370793124510L;

        public DisguiseParseException() {
        }

        public DisguiseParseException(LibsMsg message, String ... params) {
            super(message.get(params));
        }
    }
}

