/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MainHand;

public class PlayerWatcher
extends LivingWatcher {
    private boolean isInBed;
    private BlockFace sleepingDirection;
    private boolean alwaysShowInTab = DisguiseConfig.isShowDisguisedPlayersInTab();

    public PlayerWatcher(Disguise disguise) {
        super(disguise);
        this.setData(MetaIndex.PLAYER_SKIN, MetaIndex.PLAYER_SKIN.getDefault());
    }

    public boolean isDisplayedInTab() {
        return this.alwaysShowInTab;
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        if (this.getDisguise().isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.alwaysShowInTab = showPlayerInTab;
    }

    @Override
    public PlayerWatcher clone(Disguise disguise) {
        PlayerWatcher watcher = (PlayerWatcher)super.clone(disguise);
        watcher.isInBed = this.isInBed;
        watcher.sleepingDirection = this.sleepingDirection;
        watcher.alwaysShowInTab = this.alwaysShowInTab;
        return watcher;
    }

    public void setMainHand(MainHand mainHand) {
        this.setData(MetaIndex.PLAYER_HAND, (byte)mainHand.ordinal());
        this.sendData(MetaIndex.PLAYER_HAND);
    }

    public MainHand getMainHand() {
        return MainHand.values()[this.getData(MetaIndex.PLAYER_HAND)];
    }

    public BlockFace getSleepingDirection() {
        if (this.sleepingDirection == null) {
            if (this.getDisguise().getEntity() != null && this.isSleeping()) {
                this.sleepingDirection = BlockFace.values()[Math.round(this.getDisguise().getEntity().getLocation().getYaw() / 90.0f) & 3];
            } else {
                return BlockFace.EAST;
            }
        }
        return this.sleepingDirection;
    }

    private boolean isSkinFlag(int i) {
        return (this.getData(MetaIndex.PLAYER_SKIN) & 1 << i) != 0;
    }

    public boolean isCapeEnabled() {
        return this.isSkinFlag(1);
    }

    public boolean isJackedEnabled() {
        return this.isSkinFlag(2);
    }

    public boolean isLeftSleeveEnabled() {
        return this.isSkinFlag(3);
    }

    public boolean isRightSleeveEnabled() {
        return this.isSkinFlag(4);
    }

    public boolean isLeftPantsEnabled() {
        return this.isSkinFlag(5);
    }

    public boolean isRightPantsEnabled() {
        return this.isSkinFlag(6);
    }

    public boolean isHatEnabled() {
        return this.isSkinFlag(7);
    }

    public void setCapeEnabled(boolean enabled) {
        this.setSkinFlags(1, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setJacketEnabled(boolean enabled) {
        this.setSkinFlags(2, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setLeftSleeveEnabled(boolean enabled) {
        this.setSkinFlags(3, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setRightSleeveEnabled(boolean enabled) {
        this.setSkinFlags(4, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setLeftPantsEnabled(boolean enabled) {
        this.setSkinFlags(5, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setRightPantsEnabled(boolean enabled) {
        this.setSkinFlags(6, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setHatEnabled(boolean enabled) {
        this.setSkinFlags(7, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isSleeping() {
        return this.isInBed;
    }

    public void setSkin(String playerName) {
        ((PlayerDisguise)this.getDisguise()).setSkin(playerName);
    }

    public void setSkin(WrappedGameProfile profile) {
        ((PlayerDisguise)this.getDisguise()).setSkin(profile);
    }

    public void setSleeping(BlockFace sleepingDirection) {
        this.setSleeping(true, sleepingDirection);
    }

    public void setSleeping(boolean sleep) {
        this.setSleeping(sleep, null);
    }

    public void setSleeping(boolean sleeping, BlockFace sleepingDirection) {
        block10: {
            if (sleepingDirection != null) {
                this.sleepingDirection = BlockFace.values()[sleepingDirection.ordinal() % 4];
            }
            this.isInBed = sleeping;
            if (DisguiseConfig.isBedPacketsEnabled() && DisguiseUtilities.isDisguiseInUse(this.getDisguise())) {
                try {
                    if (this.isSleeping()) {
                        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                            PacketContainer[] packets = DisguiseUtilities.getBedPackets(this.getDisguise().getEntity().getLocation(), player.getLocation(), (PlayerDisguise)this.getDisguise());
                            if (this.getDisguise().getEntity() == player) {
                                for (PacketContainer packet : packets) {
                                    packet = packet.shallowClone();
                                    packet.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                                }
                                continue;
                            }
                            for (PacketContainer packet : packets) {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                            }
                        }
                        break block10;
                    }
                    PacketContainer packet = new PacketContainer(PacketType.Play.Server.ANIMATION);
                    StructureModifier mods = packet.getIntegers();
                    mods.write(0, (Object)this.getDisguise().getEntity().getEntityId());
                    mods.write(1, (Object)3);
                    for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void setSkinFlags(int i, boolean flag) {
        byte b0 = this.getData(MetaIndex.PLAYER_SKIN);
        if (flag) {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 | 1 << i));
        } else {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 & -2 << i));
        }
    }
}

