/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LivingWatcher
extends FlagWatcher {
    static Map<Integer, Object> list = new HashMap<Integer, Object>();
    static Method getId;
    private double maxHealth;
    private boolean maxHealthSet;
    private HashSet<Integer> potionEffects = new HashSet();

    public LivingWatcher(Disguise disguise) {
        super(disguise);
    }

    public void addPotionEffect(PotionEffectType potionEffect) {
        if (!this.hasPotionEffect(potionEffect)) {
            this.removePotionEffect(potionEffect);
            this.potionEffects.add(potionEffect.getId());
            this.sendPotionEffects();
        }
    }

    @Override
    public LivingWatcher clone(Disguise disguise) {
        LivingWatcher clone = (LivingWatcher)super.clone(disguise);
        clone.potionEffects = (HashSet)this.potionEffects.clone();
        clone.maxHealth = this.maxHealth;
        clone.maxHealthSet = this.maxHealthSet;
        return clone;
    }

    public float getHealth() {
        return this.getData(MetaIndex.LIVING_HEALTH).floatValue();
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public boolean isPotionParticlesAmbient() {
        return this.getData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    private int getPotions() {
        int m = 3694022;
        if (this.potionEffects.isEmpty()) {
            return m;
        }
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        try {
            for (int localMobEffect : this.potionEffects) {
                int n = (Integer)getId.invoke(null, list.get(localMobEffect));
                f1 += (float)(n >> 16 & 0xFF) / 255.0f;
                f2 += (float)(n >> 8 & 0xFF) / 255.0f;
                f3 += (float)(n & 0xFF) / 255.0f;
                f4 += 1.0f;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        f1 = f1 / f4 * 255.0f;
        f2 = f2 / f4 * 255.0f;
        f3 = f3 / f4 * 255.0f;
        return (int)f1 << 16 | (int)f2 << 8 | (int)f3;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.potionEffects.contains(type.getId());
    }

    public boolean isMaxHealthSet() {
        return this.maxHealthSet;
    }

    public void removePotionEffect(PotionEffectType type) {
        if (this.potionEffects.contains(type.getId())) {
            this.potionEffects.remove(type.getId());
            this.sendPotionEffects();
        }
    }

    public void setPotionParticlesAmbient(boolean particles) {
        this.setData(MetaIndex.LIVING_POTION_AMBIENT, particles);
        this.sendData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    private void sendPotionEffects() {
        this.setData(MetaIndex.LIVING_POTIONS, this.getPotions());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    public void setHealth(float health) {
        this.setData(MetaIndex.LIVING_HEALTH, Float.valueOf(health));
        this.sendData(MetaIndex.LIVING_HEALTH);
    }

    public int getArrowsSticking() {
        return this.getData(MetaIndex.LIVING_ARROWS);
    }

    public void setArrowsSticking(int arrowsNo) {
        this.setData(MetaIndex.LIVING_ARROWS, Math.max(0, Math.min(127, arrowsNo)));
        this.sendData(MetaIndex.LIVING_ARROWS);
    }

    public void setMaxHealth(double newHealth) {
        this.maxHealth = newHealth;
        this.maxHealthSet = true;
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder();
            builder.attributeKey("generic.maxHealth");
            builder.baseValue(this.getMaxHealth());
            builder.packet(packet);
            attributes.add(builder.build());
            Entity entity = this.getDisguise().getEntity();
            packet.getIntegers().write(0, (Object)entity.getEntityId());
            packet.getAttributeCollectionModifier().write(0, attributes);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        try {
            getId = ReflectionManager.getNmsMethod("MobEffectList", "getId", ReflectionManager.getNmsClass("MobEffectList"));
            Object REGISTRY = ReflectionManager.getNmsField("MobEffectList", "REGISTRY").get(null);
            for (Object next : (Iterable)REGISTRY) {
                int id = (Integer)getId.invoke(null, next);
                list.put(id, next);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

