/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.ClassGetter;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.LibsMsg;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import me.libraryaddict.disguise.utilities.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisguiseRadiusCommand
extends DisguiseBaseCommand
implements TabCompleter {
    private int maxRadius = 30;
    private ArrayList<Class<? extends Entity>> validClasses = new ArrayList();

    public DisguiseRadiusCommand(int maxRadius) {
        this.maxRadius = maxRadius;
        for (Class<?> c : ClassGetter.getClassesForPackage("org.bukkit.entity")) {
            if (c == Entity.class || !Entity.class.isAssignableFrom(c) || c.getAnnotation(Deprecated.class) != null) continue;
            this.validClasses.add(c);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = this.getPermissions(sender);
        if (map.isEmpty()) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        if (args[0].equalsIgnoreCase(TranslateType.DISGUISES.get("EntityType")) || args[0].equalsIgnoreCase(TranslateType.DISGUISES.get("EntityType") + "s")) {
            ArrayList<String> classes = new ArrayList<String>();
            for (Class<? extends Entity> c : this.validClasses) {
                classes.add(TranslateType.DISGUISES.get(c.getSimpleName()));
            }
            Collections.sort(classes);
            sender.sendMessage(LibsMsg.DRADIUS_ENTITIES.get(ChatColor.GREEN + StringUtils.join(classes, (String)(ChatColor.DARK_GREEN + ", " + ChatColor.GREEN))));
            return true;
        }
        Class<Entity> entityClass = Entity.class;
        EntityType type = null;
        int starting = 0;
        if (!this.isNumeric(args[0])) {
            for (Class<? extends Entity> c : this.validClasses) {
                if (!TranslateType.DISGUISES.get(c.getSimpleName()).equalsIgnoreCase(args[0])) continue;
                entityClass = c;
                starting = 1;
                break;
            }
            if (starting == 0) {
                try {
                    type = EntityType.valueOf((String)args[0].toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type == null) {
                    sender.sendMessage(LibsMsg.DMODRADIUS_UNRECOGNIZED.get(args[0]));
                    return true;
                }
            }
        }
        if (args.length == starting + 1) {
            sender.sendMessage((starting == 0 ? LibsMsg.DRADIUS_NEEDOPTIONS : LibsMsg.DRADIUS_NEEDOPTIONS_ENTITY).get(new Object[0]));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(LibsMsg.DRADIUS_NEEDOPTIONS.get(new Object[0]));
            return true;
        }
        if (!this.isNumeric(args[starting])) {
            sender.sendMessage(LibsMsg.NOT_NUMBER.get(args[starting]));
            return true;
        }
        int radius = Integer.parseInt(args[starting]);
        if (radius > this.maxRadius) {
            sender.sendMessage(LibsMsg.LIMITED_RADIUS.get(this.maxRadius));
            radius = this.maxRadius;
        }
        Object[] newArgs = new String[args.length - (starting + 1)];
        System.arraycopy(args, starting + 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, this.getPermNode(), DisguiseParser.split(StringUtils.join((Object[])newArgs, (String)" ")), map);
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        int disguisedEntitys = 0;
        int miscDisguises = 0;
        Location center = sender instanceof Player ? ((Player)sender).getLocation() : ((BlockCommandSender)sender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        for (Entity entity : center.getWorld().getNearbyEntities(center, (double)radius, (double)radius, (double)radius)) {
            if (entity == sender || !(type != null ? entity.getType() == type : entityClass.isAssignableFrom(entity.getClass()))) continue;
            if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
                ++miscDisguises;
                continue;
            }
            disguise = disguise.clone();
            if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
                disguise.getWatcher().setCustomName(this.getDisplayName((CommandSender)entity));
                if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                    disguise.getWatcher().setCustomNameVisible(true);
                }
            }
            disguise.setEntity(entity);
            if (!this.setViewDisguise(args) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewDisguises()) {
                disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
            }
            disguise.startDisguise();
            DisguiseAPI.disguiseEntity(entity, disguise);
            if (!disguise.isDisguiseInUse()) continue;
            ++disguisedEntitys;
        }
        if (disguisedEntitys > 0) {
            sender.sendMessage(LibsMsg.DISRADIUS.get(disguisedEntitys));
        } else {
            sender.sendMessage(LibsMsg.DISRADIUS_FAIL.get(new Object[0]));
        }
        if (miscDisguises > 0) {
            sender.sendMessage(LibsMsg.DRADIUS_MISCDISG.get(miscDisguises));
        }
        return true;
    }

    private boolean setViewDisguise(String[] strings) {
        for (String string : strings) {
            if (!string.equalsIgnoreCase("setViewSelfDisguise")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs;
        block19: {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            DisguiseParser.DisguisePerm disguiseType;
            int starting;
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms;
            String[] args;
            block20: {
                block18: {
                    tabs = new ArrayList<String>();
                    args = this.getArgs(origArgs);
                    perms = this.getPermissions(sender);
                    if (args.length == 0) {
                        for (Class<? extends Entity> entityClass : this.validClasses) {
                            tabs.add(TranslateType.DISGUISES.get(entityClass.getSimpleName()));
                        }
                        return this.filterTabs(tabs, origArgs);
                    }
                    starting = 1;
                    if (!this.isNumeric(args[0])) {
                        for (Class<? extends Entity> c : this.validClasses) {
                            if (!TranslateType.DISGUISES.get(c.getSimpleName()).equalsIgnoreCase(args[0])) continue;
                            starting = 2;
                            break;
                        }
                        if (starting == 1 || args.length == 1 || !this.isNumeric(args[1])) {
                            return this.filterTabs(tabs, origArgs);
                        }
                    }
                    if (args.length != starting) break block18;
                    tabs.addAll(this.getAllowedDisguises(perms));
                    break block19;
                }
                disguiseType = DisguiseParser.getDisguisePerm(args[starting]);
                if (disguiseType == null) {
                    return this.filterTabs(tabs, origArgs);
                }
                if (args.length != 1 + starting || disguiseType.getType() != DisguiseType.PLAYER) break block20;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tabs.add(player.getName());
                }
                break block19;
            }
            ArrayList<String> usedOptions = new ArrayList<String>();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                int i;
                int n = i = disguiseType.getType() == DisguiseType.PLAYER ? starting + 2 : starting + 1;
                while (i < args.length) {
                    String arg = args[i];
                    if (method.getName().equalsIgnoreCase(arg)) {
                        usedOptions.add(arg);
                    }
                    ++i;
                }
            }
            if (!this.passesCheck(sender, perms.get(disguiseType), usedOptions)) break block19;
            boolean addMethods = true;
            if (args.length > 1 + starting && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    tabs.addAll(Arrays.asList(info.getEnums(origArgs[origArgs.length - 1])));
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(LibsMsg.DRADIUS_HELP1.get(this.maxRadius));
        sender.sendMessage(LibsMsg.CAN_USE_DISGS.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(LibsMsg.DRADIUS_HELP3.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.DRADIUS_HELP4.get(new Object[0]));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(LibsMsg.DRADIUS_HELP5.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.DRADIUS_HELP6.get(new Object[0]));
    }
}

