/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.LibsMsg;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguisePlayerCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = this.getPermissions(sender);
        if (map.isEmpty()) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        if (args.length == 1) {
            sender.sendMessage(LibsMsg.DPLAYER_SUPPLY.get(new Object[0]));
            return true;
        }
        Player player = Bukkit.getPlayer((String)args[0]);
        if (player == null && args[0].contains("-")) {
            try {
                player = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (player == null) {
            sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[0]));
            return true;
        }
        Object[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, this.getPermNode(), DisguiseParser.split(StringUtils.join((Object[])newArgs, (String)" ")), map);
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            sender.sendMessage(LibsMsg.DISABLED_LIVING_TO_MISC.get(new Object[0]));
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(this.getDisplayName((CommandSender)player));
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        disguise.setEntity((Entity)player);
        if (!this.setViewDisguise(args) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewDisguises()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        disguise.startDisguise();
        if (disguise.isDisguiseInUse()) {
            sender.sendMessage(LibsMsg.DISG_PLAYER_AS_DISG.get(player instanceof Player ? player.getName() : DisguiseType.getType((Entity)player).toReadable(), disguise.getType().toReadable()));
        } else {
            sender.sendMessage(LibsMsg.DISG_PLAYER_AS_DISG_FAIL.get(player instanceof Player ? player.getName() : DisguiseType.getType((Entity)player).toReadable(), disguise.getType().toReadable()));
        }
        return true;
    }

    private boolean setViewDisguise(String[] strings) {
        for (String string : strings) {
            if (!string.equalsIgnoreCase("setViewSelfDisguise")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs;
        block15: {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            DisguiseParser.DisguisePerm disguiseType;
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms;
            String[] args;
            block17: {
                block16: {
                    block14: {
                        tabs = new ArrayList<String>();
                        args = this.getArgs(origArgs);
                        perms = this.getPermissions(sender);
                        if (args.length != 0) break block14;
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            tabs.add(player.getName());
                        }
                        break block15;
                    }
                    if (args.length != 1) break block16;
                    tabs.addAll(this.getAllowedDisguises(perms));
                    break block15;
                }
                disguiseType = DisguiseParser.getDisguisePerm(args[1]);
                if (disguiseType == null) {
                    return this.filterTabs(tabs, origArgs);
                }
                if (args.length != 2 || disguiseType.getType() != DisguiseType.PLAYER) break block17;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tabs.add(player.getName());
                }
                break block15;
            }
            ArrayList<String> usedOptions = new ArrayList<String>();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                int i;
                int n = i = disguiseType.getType() == DisguiseType.PLAYER ? 3 : 2;
                while (i < args.length) {
                    String arg = args[i];
                    if (method.getName().equalsIgnoreCase(arg)) {
                        usedOptions.add(arg);
                    }
                    ++i;
                }
            }
            if (!this.passesCheck(sender, perms.get(disguiseType), usedOptions)) break block15;
            boolean addMethods = true;
            if (args.length > 2 && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    tabs.addAll(Arrays.asList(info.getEnums(origArgs[origArgs.length - 1])));
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(LibsMsg.D_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.CAN_USE_DISGS.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(LibsMsg.D_HELP3.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.D_HELP4.get(new Object[0]));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(LibsMsg.D_HELP5.get(new Object[0]));
        }
    }
}

