/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.LibsMsg;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisguiseModifyEntityCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        if (this.getPermissions(sender).isEmpty()) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, this.getPermissions(sender));
            return true;
        }
        LibsDisguises.getInstance().getListener().setDisguiseModify(sender.getName(), DisguiseParser.split(StringUtils.join((Object[])args, (String)" ")));
        sender.sendMessage(LibsMsg.DMODIFYENT_CLICK.get(DisguiseConfig.getDisguiseEntityExpire()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return tabs;
        }
        String[] args = this.getArgs(origArgs);
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms = this.getPermissions(sender);
        if (perms.isEmpty()) {
            return tabs;
        }
        for (DisguiseParser.DisguisePerm perm : perms.keySet()) {
            boolean addMethods = true;
            if (args.length > 0) {
                String prevArg = args[args.length - 1];
                ReflectionFlagWatchers.ParamInfo info = ReflectionFlagWatchers.getParamInfo(perm.getType(), prevArg);
                if (info != null) {
                    if (info.getParamClass() != Boolean.TYPE) {
                        addMethods = false;
                    }
                    if (info.isEnums()) {
                        tabs.addAll(Arrays.asList(info.getEnums(origArgs[origArgs.length - 1])));
                    } else if (info.getParamClass() == String.class) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            tabs.add(player.getName());
                        }
                    }
                }
            }
            if (!addMethods) continue;
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(perm.getType().getWatcherClass())) {
                tabs.add(method.getName());
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(LibsMsg.DMODENT_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.DMODIFY_HELP3.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
    }
}

