/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.LibsMsg;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (!(sender instanceof Entity)) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, this.getPermissions(sender));
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, this.getPermNode(), DisguiseParser.split(StringUtils.join((Object[])args, (String)" ")), this.getPermissions(sender));
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(this.getDisplayName(sender));
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        disguise.setEntity((Entity)((Player)sender));
        if (!this.setViewDisguise(args) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewDisguises()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        disguise.startDisguise();
        if (disguise.isDisguiseInUse()) {
            sender.sendMessage(LibsMsg.DISGUISED.get(disguise.getType().toReadable()));
        } else {
            sender.sendMessage(LibsMsg.FAILED_DISGIUSE.get(disguise.getType().toReadable()));
        }
        return true;
    }

    private boolean setViewDisguise(String[] strings) {
        for (String string : strings) {
            if (!string.equalsIgnoreCase("setViewSelfDisguise")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs;
        block14: {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            DisguiseParser.DisguisePerm disguiseType;
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms;
            String[] args;
            block15: {
                block13: {
                    tabs = new ArrayList<String>();
                    args = this.getArgs(origArgs);
                    perms = this.getPermissions(sender);
                    if (args.length != 0) break block13;
                    tabs.addAll(this.getAllowedDisguises(perms));
                    break block14;
                }
                disguiseType = DisguiseParser.getDisguisePerm(args[0]);
                if (disguiseType == null) {
                    return this.filterTabs(tabs, origArgs);
                }
                if (args.length != 1 || disguiseType.getType() != DisguiseType.PLAYER) break block15;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tabs.add(player.getName());
                }
                break block14;
            }
            ArrayList<String> usedOptions = new ArrayList<String>();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                int i;
                int n = i = disguiseType.getType() == DisguiseType.PLAYER ? 2 : 1;
                while (i < args.length) {
                    String arg = args[i];
                    if (method.getName().equalsIgnoreCase(arg)) {
                        usedOptions.add(arg);
                    }
                    ++i;
                }
            }
            if (!this.passesCheck(sender, perms.get(disguiseType), usedOptions)) break block14;
            boolean addMethods = true;
            if (args.length > 1 && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    tabs.addAll(Arrays.asList(info.getEnums(origArgs[origArgs.length - 1])));
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(LibsMsg.DISG_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.CAN_USE_DISGS.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(LibsMsg.DISG_HELP2.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.DISG_HELP3.get(new Object[0]));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(LibsMsg.DISG_HELP4.get(new Object[0]));
        }
    }
}

