/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCloneCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
            int i;
            boolean doEquipment = true;
            boolean doSneak = false;
            boolean doSprint = false;
            Player player = null;
            if (args.length > 0) {
                player = Bukkit.getPlayerExact((String)args[0]);
            }
            int n = i = player == null ? 0 : 1;
            while (i < args.length) {
                String option = args[i];
                if (StringUtils.startsWithIgnoreCase((String)option, (String)LibsMsg.DCLONE_EQUIP.get(new Object[0]))) {
                    doEquipment = false;
                } else if (option.equalsIgnoreCase(LibsMsg.DCLONE_SNEAKSPRINT.get(new Object[0]))) {
                    doSneak = true;
                    doSprint = true;
                } else if (option.equalsIgnoreCase(LibsMsg.DCLONE_SNEAK.get(new Object[0]))) {
                    doSneak = true;
                } else if (option.equalsIgnoreCase(LibsMsg.DCLONE_SPRINT.get(new Object[0]))) {
                    doSprint = true;
                } else {
                    sender.sendMessage(LibsMsg.INVALID_CLONE.get(option));
                    return true;
                }
                ++i;
            }
            Boolean[] options = new Boolean[]{doEquipment, doSneak, doSprint};
            if (player != null) {
                DisguiseUtilities.createClonedDisguise((Player)sender, (Entity)player, options);
            } else {
                LibsDisguises.getInstance().getListener().setDisguiseClone(sender.getName(), options);
                sender.sendMessage(LibsMsg.CLICK_TIMER.get(DisguiseConfig.getDisguiseCloneExpire()));
            }
        } else {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        if (args.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                tabs.add(player.getName());
            }
        }
        tabs.add(LibsMsg.DCLONE_EQUIP.get(new Object[0]));
        tabs.add(LibsMsg.DCLONE_SNEAKSPRINT.get(new Object[0]));
        tabs.add(LibsMsg.DCLONE_SNEAK.get(new Object[0]));
        tabs.add(LibsMsg.DCLONE_SPRINT.get(new Object[0]));
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        sender.sendMessage(LibsMsg.CLONE_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.CLONE_HELP2.get(new Object[0]));
        sender.sendMessage(LibsMsg.CLONE_HELP3.get(new Object[0]));
    }
}

