/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.DisguiseListener;
import me.libraryaddict.disguise.commands.DisguiseCloneCommand;
import me.libraryaddict.disguise.commands.DisguiseCommand;
import me.libraryaddict.disguise.commands.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.DisguiseHelpCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.DisguiseViewSelfCommand;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.UndisguiseCommand;
import me.libraryaddict.disguise.commands.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SkeletonWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieVillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseSound;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.Metrics;
import me.libraryaddict.disguise.utilities.PacketsManager;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getLogger().info("Discovered nms version: " + ReflectionManager.getBukkitVersion());
        if (!new File(this.getDataFolder(), "disguises.yml").exists()) {
            this.saveResource("disguises.yml", false);
        }
        LibsPremium.check(this.getDescription().getVersion());
        PacketsManager.init(this);
        DisguiseUtilities.init(this);
        this.registerValues();
        DisguiseConfig.initConfig((ConfigurationSection)this.getConfig());
        PacketsManager.addPacketListeners();
        this.listener = new DisguiseListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        this.registerCommand("disguise", new DisguiseCommand());
        this.registerCommand("undisguise", new UndisguiseCommand());
        this.registerCommand("disguiseplayer", new DisguisePlayerCommand());
        this.registerCommand("undisguiseplayer", new UndisguisePlayerCommand());
        this.registerCommand("undisguiseentity", new UndisguiseEntityCommand());
        this.registerCommand("disguiseentity", new DisguiseEntityCommand());
        this.registerCommand("disguiseradius", new DisguiseRadiusCommand(this.getConfig().getInt("DisguiseRadiusMax")));
        this.registerCommand("undisguiseradius", new UndisguiseRadiusCommand(this.getConfig().getInt("UndisguiseRadiusMax")));
        this.registerCommand("disguisehelp", new DisguiseHelpCommand());
        this.registerCommand("disguiseclone", new DisguiseCloneCommand());
        this.registerCommand("libsdisguises", new LibsDisguisesCommand());
        this.registerCommand("disguiseviewself", new DisguiseViewSelfCommand());
        this.registerCommand("disguisemodify", new DisguiseModifyCommand());
        this.registerCommand("disguisemodifyentity", new DisguiseModifyEntityCommand());
        this.registerCommand("disguisemodifyplayer", new DisguiseModifyPlayerCommand());
        this.registerCommand("disguisemodifyradius", new DisguiseModifyRadiusCommand(this.getConfig().getInt("DisguiseRadiusMax")));
        this.infectWithMetrics();
    }

    private void infectWithMetrics() {
        Metrics metrics = new Metrics(this);
        final String premium = LibsPremium.isPremium().booleanValue() ? (this.getDescription().getVersion().contains("SNAPSHOT") ? "Paid Builds" : "Paid Plugin") : "Free Builds";
        metrics.addCustomChart(new Metrics.SimplePie("premium"){

            @Override
            public String getValue() {
                return premium;
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("translations"){

            @Override
            public String getValue() {
                return LibsPremium.isPremium() != false && DisguiseConfig.isUseTranslations() ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("custom_disguises"){

            @Override
            public String getValue() {
                HashMap<String, Disguise> map = DisguiseConfig.getCustomDisguises();
                return map.size() + (map.containsKey("libraryaddict") ? -1 : 0) > 0 ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.MultiLineChart("disguised_entities"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> hashMap) {
                for (HashSet<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
                    for (Disguise disguise : list) {
                        String name;
                        if (disguise.getEntity() == null || !disguise.isDisguiseInUse()) continue;
                        hashMap.put(name, hashMap.containsKey(name = disguise.getEntity().getType().name()) ? hashMap.get(name) + 1 : 1);
                    }
                }
                return hashMap;
            }
        });
        metrics.addCustomChart(new Metrics.MultiLineChart("disguises_used"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> hashMap) {
                for (HashSet<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
                    for (Disguise disguise : list) {
                        String name;
                        if (disguise.getEntity() == null || !disguise.isDisguiseInUse()) continue;
                        hashMap.put(name, hashMap.containsKey(name = disguise.getType().name()) ? hashMap.get(name) + 1 : 1);
                    }
                }
                return hashMap;
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("disguised_using"){

            @Override
            public String getValue() {
                if (DisguiseUtilities.isPluginsUsed()) {
                    if (DisguiseUtilities.isCommandsUsed()) {
                        return "Plugins and Commands";
                    }
                    return "Plugins";
                }
                if (DisguiseUtilities.isCommandsUsed()) {
                    return "Commands";
                }
                return "Unknown";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("active_disguises"){

            @Override
            public String getValue() {
                int disgs = 0;
                for (HashSet<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
                    disgs += set.size();
                }
                if (disgs == 0) {
                    return "0";
                }
                if (disgs <= 5) {
                    return "1 to 5";
                }
                if (disgs <= 15) {
                    return "6 to 15";
                }
                if (disgs <= 30) {
                    return "16 to 30";
                }
                return "More than 30";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("self_disguises"){

            @Override
            public String getValue() {
                return DisguiseConfig.isViewDisguises() ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("spigot"){

            @Override
            public String getValue() {
                try {
                    Class.forName("org.spigotmc.SpigotConfig");
                    return "Yes";
                }
                catch (Exception ex) {
                    return "No";
                }
            }
        });
        final boolean updates = this.getConfig().getBoolean("NotifyUpdate");
        metrics.addCustomChart(new Metrics.SimplePie("updates"){

            @Override
            public String getValue() {
                return updates ? "Enabled" : "Disabled";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("targeted_disguises"){

            @Override
            public String getValue() {
                Collection<HashSet<TargetedDisguise>> list = DisguiseUtilities.getDisguises().values();
                if (list.isEmpty()) {
                    return "Unknown";
                }
                for (HashSet<TargetedDisguise> dList : list) {
                    for (TargetedDisguise disg : dList) {
                        if (disg.getObservers().isEmpty()) continue;
                        return "Yes";
                    }
                }
                return "No";
            }
        });
    }

    public void onDisable() {
        DisguiseUtilities.saveDisguises();
    }

    private void registerCommand(String commandName, CommandExecutor executioner) {
        PluginCommand command = this.getCommand(commandName);
        command.setExecutor(executioner);
        if (executioner instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executioner);
        }
    }

    public void reload() {
        this.reloadConfig();
        DisguiseConfig.initConfig((ConfigurationSection)this.getConfig());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerValues() {
        DisguiseType[] disguiseTypeArray = DisguiseType.values();
        int n = disguiseTypeArray.length;
        int n2 = 0;
        while (true) {
            block47: {
                Class watcherClass;
                DisguiseType disguiseType;
                block48: {
                    if (n2 >= n) {
                        return;
                    }
                    disguiseType = disguiseTypeArray[n2];
                    if (disguiseType.getEntityType() == null) break block47;
                    try {
                        switch (disguiseType) {
                            case SPECTRAL_ARROW: {
                                watcherClass = ArrowWatcher.class;
                                break;
                            }
                            case PRIMED_TNT: {
                                watcherClass = TNTWatcher.class;
                                break;
                            }
                            case MINECART_CHEST: 
                            case MINECART_COMMAND: 
                            case MINECART_FURNACE: 
                            case MINECART_HOPPER: 
                            case MINECART_MOB_SPAWNER: 
                            case MINECART_TNT: {
                                watcherClass = MinecartWatcher.class;
                                break;
                            }
                            case SPIDER: 
                            case CAVE_SPIDER: {
                                watcherClass = SpiderWatcher.class;
                                break;
                            }
                            case ZOMBIE_VILLAGER: {
                                watcherClass = ZombieVillagerWatcher.class;
                                break;
                            }
                            case PIG_ZOMBIE: 
                            case HUSK: {
                                watcherClass = ZombieWatcher.class;
                                break;
                            }
                            case MAGMA_CUBE: {
                                watcherClass = SlimeWatcher.class;
                                break;
                            }
                            case ELDER_GUARDIAN: {
                                watcherClass = GuardianWatcher.class;
                                break;
                            }
                            case WITHER_SKELETON: 
                            case STRAY: {
                                watcherClass = SkeletonWatcher.class;
                                break;
                            }
                            case ILLUSIONER: 
                            case EVOKER: {
                                watcherClass = IllagerWizardWatcher.class;
                                break;
                            }
                            default: {
                                watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + this.toReadable(disguiseType.name()) + "Watcher");
                                break;
                            }
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        Class entityClass = disguiseType.getEntityType().getEntityClass();
                        if (entityClass != null) {
                            watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : FlagWatcher.class)));
                        }
                        watcherClass = FlagWatcher.class;
                    }
                    if (watcherClass != null) break block48;
                    System.err.println("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                    break block47;
                }
                disguiseType.setWatcherClass(watcherClass);
                if (DisguiseValues.getDisguiseValues(disguiseType) == null) {
                    String nmsEntityName = this.toReadable(disguiseType.name());
                    switch (disguiseType) {
                        case ZOMBIE_VILLAGER: 
                        case HUSK: 
                        case WITHER_SKELETON: 
                        case STRAY: 
                        case DONKEY: 
                        case MULE: 
                        case ZOMBIE_HORSE: 
                        case SKELETON_HORSE: {
                            break block47;
                        }
                        case PRIMED_TNT: {
                            nmsEntityName = "TNTPrimed";
                            break;
                        }
                        case MINECART_TNT: {
                            nmsEntityName = "MinecartTNT";
                            break;
                        }
                        case MINECART: {
                            nmsEntityName = "MinecartRideable";
                            break;
                        }
                        case FIREWORK: {
                            nmsEntityName = "Fireworks";
                            break;
                        }
                        case SPLASH_POTION: {
                            nmsEntityName = "Potion";
                            break;
                        }
                        case GIANT: {
                            nmsEntityName = "GiantZombie";
                            break;
                        }
                        case DROPPED_ITEM: {
                            nmsEntityName = "Item";
                            break;
                        }
                        case FIREBALL: {
                            nmsEntityName = "LargeFireball";
                            break;
                        }
                        case LEASH_HITCH: {
                            nmsEntityName = "Leash";
                            break;
                        }
                        case ELDER_GUARDIAN: {
                            nmsEntityName = "Guardian";
                            break;
                        }
                        case SPECTRAL_ARROW: 
                        case ARROW: {
                            nmsEntityName = "TippedArrow";
                            break;
                        }
                        case ILLUSIONER: {
                            nmsEntityName = "IllagerIllusioner";
                        }
                    }
                    try {
                        if (nmsEntityName.equalsIgnoreCase("Unknown")) {
                            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, null, 0, 0.0);
                            disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                            DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
                            if (sound != null) {
                                sound.setDamageAndIdleSoundVolume(1.0f);
                            }
                            break block47;
                        }
                        Object nmsEntity = ReflectionManager.createEntityInstance(nmsEntityName);
                        if (nmsEntity == null) {
                            this.getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                        } else {
                            Float soundStrength;
                            Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
                            int entitySize = 0;
                            for (Field field : ReflectionManager.getNmsClass("Entity").getFields()) {
                                if (!field.getType().getName().equals("EnumEntitySize")) continue;
                                Enum enumEntitySize = (Enum)field.get(nmsEntity);
                                entitySize = enumEntitySize.ordinal();
                                break;
                            }
                            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, nmsEntity.getClass(), entitySize, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0);
                            WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)bukkitEntity);
                            ArrayList<MetaIndex> indexes = MetaIndex.getFlags(disguiseType.getWatcherClass());
                            for (WrappedWatchableObject watch : watcher.getWatchableObjects()) {
                                Object obj2;
                                MetaIndex flagType = MetaIndex.getFlag(watcherClass, watch.getIndex());
                                if (flagType == null) {
                                    System.err.println("Error finding the FlagType for " + disguiseType.name() + "! Index " + watch.getIndex() + " can't be found!");
                                    System.err.println("Value is " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + watcherClass.getSimpleName());
                                    System.err.println("Lib's Disguises will continue to load, but this will not work properly!");
                                    continue;
                                }
                                indexes.remove(flagType);
                                Object obj1 = ReflectionManager.convertInvalidItem(flagType.getDefault());
                                if (obj1 == (obj2 = ReflectionManager.convertInvalidItem(watch.getValue())) || obj1 != null && obj2 != null && obj1.getClass() == obj2.getClass()) continue;
                                System.err.println("Mismatch of FlagType's for " + disguiseType.name() + "! Index " + watch.getIndex() + " has the wrong classtype!");
                                System.err.println("MetaIndex has the default of " + flagType.getDefault() + " (" + flagType.getDefault().getClass() + ") (" + nmsEntity.getClass() + ") & " + watcherClass.getSimpleName());
                                System.err.println("Where the internals is " + watch.getRawValue() + " (" + watch.getRawValue().getClass());
                                System.err.println("Lib's Disguises will continue to load, but this will not work properly!");
                            }
                            for (MetaIndex index : indexes) {
                                System.out.println((Object)((Object)disguiseType) + " has MetaIndex remaining! " + index.getFlagWatcher().getSimpleName() + " at index " + index.getIndex());
                            }
                            DisguiseSound disguiseSound = DisguiseSound.getType(disguiseType.name());
                            if (disguiseSound != null && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                                disguiseSound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
                            }
                            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
                            if (bukkitEntity instanceof Ageable) {
                                ((Ageable)bukkitEntity).setBaby();
                                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
                            } else if (bukkitEntity instanceof Zombie) {
                                ((Zombie)bukkitEntity).setBaby(true);
                                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
                            }
                            disguiseValues.setEntitySize(ReflectionManager.getSize(bukkitEntity));
                        }
                    }
                    catch (FieldAccessException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                        System.out.print("[LibsDisguises] Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
                        System.out.print("[LibsDisguises] Before reporting this error, please make sure you are using the latest version of LibsDisguises and ProtocolLib.");
                        System.out.print("[LibsDisguises] Development builds are available at (ProtocolLib) http://ci.dmulloy2.net/job/ProtocolLib/ and (LibsDisguises) http://server.o2gaming.com:8080/job/LibsDisguises%201.9+/");
                        ex.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    private String toReadable(String string) {
        StringBuilder builder = new StringBuilder();
        for (String s : string.split("_")) {
            builder.append(s.substring(0, 1)).append(s.substring(1).toLowerCase());
        }
        return builder.toString();
    }

    public DisguiseListener getListener() {
        return this.listener;
    }

    public static LibsDisguises getInstance() {
        return instance;
    }
}

