/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsMsg;
import me.libraryaddict.disguise.utilities.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Team;

public class DisguiseListener
implements Listener {
    private String currentVersion;
    private HashMap<String, Boolean[]> disguiseClone = new HashMap();
    private HashMap<String, Disguise> disguiseEntity = new HashMap();
    private HashMap<String, String[]> disguiseModify = new HashMap();
    private HashMap<String, BukkitRunnable> disguiseRunnable = new HashMap();
    private String latestVersion;
    private LibsDisguises plugin;
    private BukkitTask updaterTask;

    public DisguiseListener(LibsDisguises libsDisguises) {
        this.plugin = libsDisguises;
        if (this.plugin.getConfig().getBoolean("NotifyUpdate")) {
            this.currentVersion = this.plugin.getDescription().getVersion();
            this.updaterTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdateChecker updateChecker = new UpdateChecker();
                        updateChecker.checkUpdate("v" + DisguiseListener.this.currentVersion);
                        DisguiseListener.this.latestVersion = updateChecker.getLatestVersion();
                        if (DisguiseListener.this.latestVersion == null) {
                            return;
                        }
                        DisguiseListener.this.latestVersion = "v" + DisguiseListener.this.latestVersion;
                        Bukkit.getScheduler().runTask((Plugin)DisguiseListener.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                for (Player p : Bukkit.getOnlinePlayers()) {
                                    if (!p.hasPermission(DisguiseConfig.getUpdateNotificationPermission())) continue;
                                    p.sendMessage(LibsMsg.UPDATE_READY.get(DisguiseListener.this.currentVersion, DisguiseListener.this.latestVersion));
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        System.out.print(String.format("[LibsDisguises] Failed to check for update: %s", ex.getMessage()));
                    }
                }
            }, 0L, 432000L);
        }
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
                if (disguises.length <= 0) continue;
                DisguiseUtilities.resetPluginTimer();
                for (Disguise disguise : disguises) {
                    disguise.setEntity(entity);
                    disguise.startDisguise();
                }
            }
        }
    }

    public void cleanup() {
        for (BukkitRunnable r : this.disguiseRunnable.values()) {
            r.cancel();
        }
        for (Disguise d : this.disguiseEntity.values()) {
            d.removeDisguise();
        }
        this.disguiseClone.clear();
        this.updaterTask.cancel();
    }

    private void checkPlayerCanBlowDisguise(Player player) {
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)player);
        if (disguises.length > 0) {
            DisguiseAPI.undisguiseToAll((Entity)player);
            String blown = LibsMsg.BLOWN_DISGUISE.get(new Object[0]);
            if (blown.length() > 0) {
                player.sendMessage(blown);
            }
        }
    }

    private void chunkMove(Player player, Location newLoc, Location oldLoc) {
        try {
            for (PacketContainer packet : DisguiseUtilities.getBedChunkPacket(newLoc, oldLoc)) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
            }
            if (newLoc != null) {
                for (HashSet hashSet : DisguiseUtilities.getDisguises().values()) {
                    for (TargetedDisguise disguise : hashSet) {
                        if (disguise.getEntity() == null || !disguise.isPlayerDisguise() || !disguise.canSee(player) || !((PlayerDisguise)disguise).getWatcher().isSleeping() || !DisguiseUtilities.getPerverts(disguise).contains(player)) continue;
                        PacketContainer[] packets = DisguiseUtilities.getBedPackets(disguise.getEntity() == player ? newLoc : disguise.getEntity().getLocation(), newLoc, (PlayerDisguise)disguise);
                        if (disguise.getEntity() == player) {
                            for (PacketContainer packet : packets) {
                                packet.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                            }
                        }
                        for (PacketContainer packet : packets) {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                        }
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent event) {
        if (DisguiseConfig.isDisguiseBlownWhenAttacked() && event.getEntity() instanceof Player) {
            this.checkPlayerCanBlowDisguise((Player)event.getEntity());
        }
        if (DisguiseConfig.isDisguiseBlownWhenAttacking() && event.getDamager() instanceof Player) {
            this.checkPlayerCanBlowDisguise((Player)event.getDamager());
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            Disguise[] disguises = DisguiseAPI.getDisguises(entity);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguises);
        }
    }

    @EventHandler
    public void onChunkUnload(WorldUnloadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getWorld().getEntities()) {
            Disguise[] disguises;
            if (entity instanceof Player || (disguises = DisguiseAPI.getDisguises(entity)).length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguises);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguises) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getWorld().getEntities()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguises) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        WrappedGameProfile profile;
        Player p = event.getPlayer();
        if (this.latestVersion != null && p.hasPermission(DisguiseConfig.getUpdateNotificationPermission())) {
            p.sendMessage(LibsMsg.UPDATE_READY.get(this.currentVersion, this.latestVersion));
        }
        if (DisguiseConfig.isBedPacketsEnabled()) {
            this.chunkMove(p, p.getLocation(), null);
        }
        if (DisguiseConfig.isSaveGameProfiles() && DisguiseConfig.isUpdateGameProfiles() && DisguiseUtilities.hasGameProfile(p.getName()) && !(profile = WrappedGameProfile.fromPlayer((Player)p)).getProperties().isEmpty()) {
            DisguiseUtilities.addGameProfile(p.getName(), profile);
        }
        if (DisguiseConfig.isSavePlayerDisguises()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(p.getUniqueId(), true);
            if (disguises.length > 0) {
                DisguiseUtilities.resetPluginTimer();
            }
            for (Disguise disguise : disguises) {
                disguise.setEntity((Entity)p);
                disguise.startDisguise();
            }
        }
        for (HashSet<TargetedDisguise> disguiseList : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise targetedDisguise : disguiseList) {
                Disguise disguise;
                if (targetedDisguise.getEntity() == null || !targetedDisguise.canSee(p) || !(targetedDisguise instanceof PlayerDisguise) || !((PlayerDisguise)(disguise = (PlayerDisguise)targetedDisguise)).isDisplayedInTab()) continue;
                try {
                    PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    addTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(((PlayerDisguise)disguise).getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)((PlayerDisguise)disguise).getGameProfile().getName()))));
                    ProtocolLibrary.getProtocolManager().sendServerPacket(p, addTab);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        Disguise disguise;
        Location from;
        if (DisguiseConfig.isBedPacketsEnabled()) {
            Location to = event.getTo();
            from = event.getFrom();
            if (DisguiseUtilities.getChunkCord(to.getBlockX()) != DisguiseUtilities.getChunkCord(from.getBlockX()) || DisguiseUtilities.getChunkCord(to.getBlockZ()) != DisguiseUtilities.getChunkCord(from.getBlockZ())) {
                this.chunkMove(event.getPlayer(), to, from);
            }
        }
        if (DisguiseConfig.isStopShulkerDisguisesFromMoving() && (disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer())) != null && disguise.getType() == DisguiseType.SHULKER) {
            from = event.getFrom();
            Location to = event.getTo();
            to.setX(from.getX());
            to.setZ(from.getZ());
            event.setTo(to);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        if (!DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        Player player = event.getPlayer();
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)player);
        if (disguises.length <= 0) {
            return;
        }
        DisguiseUtilities.saveDisguises(player.getUniqueId(), disguises);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        if (DisguiseConfig.isBedPacketsEnabled()) {
            final Player player = event.getPlayer();
            this.chunkMove(event.getPlayer(), null, player.getLocation());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseListener.this.chunkMove(player, player.getLocation(), null);
                }
            });
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent event) {
        Player p = event.getPlayer();
        if (!(this.disguiseEntity.containsKey(p.getName()) || this.disguiseClone.containsKey(p.getName()) || this.disguiseModify.containsKey(p.getName()))) {
            return;
        }
        event.setCancelled(true);
        this.disguiseRunnable.remove(p.getName()).cancel();
        Entity entity = event.getRightClicked();
        String entityName = entity instanceof Player && !this.disguiseClone.containsKey(p.getName()) ? entity.getName() : DisguiseType.getType(entity).toReadable();
        if (this.disguiseClone.containsKey(p.getName())) {
            Boolean[] options = this.disguiseClone.remove(p.getName());
            DisguiseUtilities.createClonedDisguise(p, entity, options);
        } else if (this.disguiseEntity.containsKey(p.getName())) {
            Disguise disguise = this.disguiseEntity.remove(p.getName());
            if (disguise != null) {
                if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
                    p.sendMessage(LibsMsg.DISABLED_LIVING_TO_MISC.get(new Object[0]));
                } else {
                    if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
                        Team team = ((Player)entity).getScoreboard().getEntryTeam(entity.getName());
                        disguise.getWatcher().setCustomName((team == null ? "" : team.getPrefix()) + entity.getName() + (team == null ? "" : team.getSuffix()));
                        if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                            disguise.getWatcher().setCustomNameVisible(true);
                        }
                    }
                    DisguiseAPI.disguiseEntity(entity, disguise);
                    String disguiseName = disguise instanceof PlayerDisguise ? ((PlayerDisguise)disguise).getName() : disguise.getType().toReadable();
                    if (disguise.isDisguiseInUse()) {
                        if (disguise.isPlayerDisguise()) {
                            if (entity instanceof Player) {
                                p.sendMessage(LibsMsg.LISTEN_ENTITY_PLAYER_DISG_PLAYER.get(entityName, disguiseName));
                            } else {
                                p.sendMessage(LibsMsg.LISTEN_ENTITY_ENTITY_DISG_PLAYER.get(entityName, disguiseName));
                            }
                        } else if (entity instanceof Player) {
                            p.sendMessage(LibsMsg.LISTEN_ENTITY_PLAYER_DISG_ENTITY.get(entityName, disguiseName));
                        } else {
                            p.sendMessage(LibsMsg.LISTEN_ENTITY_ENTITY_DISG_ENTITY.get(entityName, disguiseName));
                        }
                    } else if (disguise.isPlayerDisguise()) {
                        if (entity instanceof Player) {
                            p.sendMessage(LibsMsg.LISTEN_ENTITY_PLAYER_DISG_PLAYER_FAIL.get(entityName, disguiseName));
                        } else {
                            p.sendMessage(LibsMsg.LISTEN_ENTITY_ENTITY_DISG_PLAYER_FAIL.get(entityName, disguiseName));
                        }
                    } else if (entity instanceof Player) {
                        p.sendMessage(LibsMsg.LISTEN_ENTITY_PLAYER_DISG_ENTITY_FAIL.get(entityName, disguiseName));
                    } else {
                        p.sendMessage(LibsMsg.LISTEN_ENTITY_ENTITY_DISG_ENTITY_FAIL.get(entityName, disguiseName));
                    }
                }
            } else if (DisguiseAPI.isDisguised(entity)) {
                DisguiseAPI.undisguiseToAll(entity);
                if (entity instanceof Player) {
                    p.sendMessage(LibsMsg.LISTEN_UNDISG_PLAYER.get(entityName));
                } else {
                    p.sendMessage(LibsMsg.LISTEN_UNDISG_ENT.get(entityName));
                }
            } else if (entity instanceof Player) {
                p.sendMessage(LibsMsg.LISTEN_UNDISG_PLAYER_FAIL.get(entityName));
            } else {
                p.sendMessage(LibsMsg.LISTEN_UNDISG_ENT_FAIL.get(entityName));
            }
        } else if (this.disguiseModify.containsKey(p.getName())) {
            String[] options = this.disguiseModify.remove(p.getName());
            Disguise disguise = DisguiseAPI.getDisguise(p, entity);
            if (disguise == null) {
                p.sendMessage(LibsMsg.UNDISG_PLAYER_FAIL.get(entityName));
                return;
            }
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms = DisguiseParser.getPermissions((CommandSender)p, "libsdisguises.disguiseentitymodify.");
            if (!perms.containsKey(new DisguiseParser.DisguisePerm(disguise.getType()))) {
                p.sendMessage(LibsMsg.DMODPLAYER_NOPERM.get(new Object[0]));
                return;
            }
            try {
                DisguiseParser.callMethods((CommandSender)p, disguise, perms.get(new DisguiseParser.DisguisePerm(disguise.getType())), new ArrayList<String>(), options);
                p.sendMessage(LibsMsg.LISTENER_MODIFIED_DISG.get(new Object[0]));
            }
            catch (DisguiseParser.DisguiseParseException ex) {
                if (ex.getMessage() != null) {
                    p.sendMessage(ex.getMessage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onTarget(EntityTargetEvent event) {
        if (DisguiseConfig.isMonstersIgnoreDisguises() && event.getTarget() != null && event.getTarget() instanceof Player && DisguiseAPI.isDisguised(event.getTarget())) {
            switch (event.getReason()) {
                case TARGET_ATTACKED_ENTITY: 
                case TARGET_ATTACKED_OWNER: 
                case OWNER_ATTACKED_TARGET: 
                case CUSTOM: {
                    break;
                }
                default: {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        final Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (DisguiseConfig.isBedPacketsEnabled() && (DisguiseUtilities.getChunkCord(to.getBlockX()) != DisguiseUtilities.getChunkCord(from.getBlockX()) || DisguiseUtilities.getChunkCord(to.getBlockZ()) != DisguiseUtilities.getChunkCord(from.getBlockZ()))) {
            this.chunkMove(player, null, from);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseListener.this.chunkMove(player, player.getLocation(), null);
                }
            });
        }
        if (!DisguiseAPI.isDisguised((Entity)player)) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange() && to.getWorld() != null && from.getWorld() != null && to.getWorld() != from.getWorld()) {
            for (Disguise disguise : DisguiseAPI.getDisguises((Entity)event.getPlayer())) {
                disguise.removeDisguise();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (event.getEntered() instanceof Player && DisguiseAPI.isDisguised((Player)event.getEntered(), event.getEntered())) {
            DisguiseUtilities.removeSelfDisguise((Player)event.getEntered());
            ((Player)event.getEntered()).updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleLeave(VehicleExitEvent event) {
        Disguise disguise;
        if (event.getExited() instanceof Player && (disguise = DisguiseAPI.getDisguise((Player)event.getExited(), (Entity)event.getExited())) != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                    ((Player)disguise.getEntity()).updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        if (DisguiseConfig.isBedPacketsEnabled()) {
            this.chunkMove(event.getPlayer(), event.getPlayer().getLocation(), null);
        }
        if (!DisguiseAPI.isDisguised((Entity)event.getPlayer())) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange()) {
            for (Disguise disguise : DisguiseAPI.getDisguises((Entity)event.getPlayer())) {
                disguise.removeDisguise();
            }
        } else {
            boolean viewSelfToggled = DisguiseAPI.isViewSelfToggled((Entity)event.getPlayer());
            if (viewSelfToggled) {
                final Disguise disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer());
                disguise.setViewSelfDisguise(false);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        disguise.setViewSelfDisguise(true);
                    }
                }, 20L);
            }
        }
    }

    public void setDisguiseClone(final String player, Boolean[] options) {
        if (this.disguiseRunnable.containsKey(player)) {
            BukkitRunnable run = this.disguiseRunnable.remove(player);
            run.cancel();
            run.run();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.disguiseClone.remove(player);
                DisguiseListener.this.disguiseRunnable.remove(player);
            }
        };
        runnable.runTaskLater((Plugin)this.plugin, (long)(20 * DisguiseConfig.getDisguiseCloneExpire()));
        this.disguiseRunnable.put(player, runnable);
        this.disguiseClone.put(player, options);
    }

    public void setDisguiseEntity(final String player, Disguise disguise) {
        if (this.disguiseRunnable.containsKey(player)) {
            BukkitRunnable run = this.disguiseRunnable.remove(player);
            run.cancel();
            run.run();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.disguiseEntity.remove(player);
                DisguiseListener.this.disguiseRunnable.remove(player);
            }
        };
        runnable.runTaskLater((Plugin)this.plugin, (long)(20 * DisguiseConfig.getDisguiseEntityExpire()));
        this.disguiseRunnable.put(player, runnable);
        this.disguiseEntity.put(player, disguise);
    }

    public void setDisguiseModify(final String player, String[] args) {
        if (this.disguiseRunnable.containsKey(player)) {
            BukkitRunnable run = this.disguiseRunnable.remove(player);
            run.cancel();
            run.run();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.disguiseModify.remove(player);
                DisguiseListener.this.disguiseRunnable.remove(player);
            }
        };
        runnable.runTaskLater((Plugin)this.plugin, (long)(20 * DisguiseConfig.getDisguiseEntityExpire()));
        this.disguiseRunnable.put(player, runnable);
        this.disguiseModify.put(player, args);
    }
}

