/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class ReflectionFlagWatchers {
    private static ArrayList<ParamInfo> paramList = new ArrayList();

    public static ArrayList<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static ParamInfo getParamInfo(Class c) {
        for (ParamInfo info : ReflectionFlagWatchers.getParamInfos()) {
            if (info.getParamClass() != c) continue;
            return info;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguiseParser.DisguisePerm disguiseType, String methodName) {
        return ReflectionFlagWatchers.getParamInfo(disguiseType.getType(), methodName);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String methodName) {
        for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!method.getName().toLowerCase().equals(methodName.toLowerCase()) || method.getParameterTypes().length != 1 || method.getAnnotation(Deprecated.class) != null) continue;
            return ReflectionFlagWatchers.getParamInfo(method.getParameterTypes()[0]);
        }
        return null;
    }

    public static Method[] getDisguiseWatcherMethods(Class<? extends FlagWatcher> watcherClass) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(watcherClass.getMethods()));
        Iterator<Method> itel = methods.iterator();
        while (itel.hasNext()) {
            Method method = itel.next();
            if (method.getParameterTypes().length != 1) {
                itel.remove();
                continue;
            }
            if (method.getName().startsWith("get")) {
                itel.remove();
                continue;
            }
            if (method.getAnnotation(Deprecated.class) != null) {
                itel.remove();
                continue;
            }
            if (ReflectionFlagWatchers.getParamInfo(method.getParameterTypes()[0]) == null) {
                itel.remove();
                continue;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                itel.remove();
                continue;
            }
            if (!method.getName().equals("removePotionEffect")) continue;
            itel.remove();
        }
        for (String methodName : new String[]{"setViewSelfDisguise", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer"}) {
            try {
                methods.add(Disguise.class.getMethod(methodName, Boolean.TYPE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return methods.toArray(new Method[0]);
    }

    private static String toReadable(String string) {
        Object[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = ((String)split[i]).substring(0, 1) + ((String)split[i]).substring(1).toLowerCase();
        }
        return StringUtils.join((Object[])split, (String)"_");
    }

    static {
        paramList.add(new ParamInfo(AnimalColor.class, "Animal Color", "View all the colors you can use for an animal color"));
        paramList.add(new ParamInfo(Art.class, "Art", "View all the paintings you can use for a painting disguise"));
        paramList.add(new ParamInfo(Llama.Color.class, "Llama Color", "View all the colors you can use for a llama color"));
        paramList.add(new ParamInfo(Horse.Color.class, "Horse Color", "View all the colors you can use for a horses color"));
        paramList.add(new ParamInfo(Ocelot.Type.class, "Ocelot Type", "View all the ocelot types you can use for ocelots"));
        paramList.add(new ParamInfo(Villager.Profession.class, "Villager Profession", "View all the professions you can set on a villager"));
        paramList.add(new ParamInfo(BlockFace.class, (Enum[])Arrays.copyOf(BlockFace.values(), 5), "Direction", "View the five directions usable on player setSleeping disguise"));
        paramList.add(new ParamInfo(Rabbit.Type.class, "Rabbit Type", "View the kinds of rabbits you can turn into"));
        paramList.add(new ParamInfo(TreeSpecies.class, "Tree Species", "View the different types of tree species"));
        ArrayList<String> potionEnums = new ArrayList<String>();
        for (PotionEffectType effectType : PotionEffectType.values()) {
            if (effectType == null) continue;
            potionEnums.add(ReflectionFlagWatchers.toReadable(effectType.getName()));
        }
        String[] materials = new String[Material.values().length];
        for (int i = 0; i < Material.values().length; ++i) {
            materials[i] = Material.values()[i].name();
        }
        paramList.add(new ParamInfo(ItemStack.class, "Item (id:damage)", "An ItemStack compromised of ID:Durability", materials));
        paramList.add(new ParamInfo(ItemStack[].class, "Four ItemStacks (id:damage,id:damage..)", "Four ItemStacks seperated by an ,", materials){

            @Override
            public String[] getEnums(String tabComplete) {
                String beginning = tabComplete.substring(0, tabComplete.contains(",") ? tabComplete.lastIndexOf(",") + 1 : 0);
                String end = tabComplete.substring(tabComplete.contains(",") ? tabComplete.lastIndexOf(",") + 1 : 0);
                ArrayList<String> toReturn = new ArrayList<String>();
                for (String material : super.getEnums("")) {
                    if (!material.toLowerCase().startsWith(end.toLowerCase())) continue;
                    toReturn.add(beginning + material);
                }
                return toReturn.toArray(new String[0]);
            }
        });
        paramList.add(new ParamInfo(PotionEffectType.class, "Potion Effect", "View all the potion effects you can add", potionEnums.toArray(new String[0])));
        paramList.add(new ParamInfo(String.class, "Text", "A line of text"));
        paramList.add(new ParamInfo(Boolean.TYPE, "True/False", "True or False", new String[]{"true", "false"}));
        paramList.add(new ParamInfo(Integer.TYPE, "Number", "A whole number, no decimcals"));
        paramList.add(new ParamInfo(Double.TYPE, "Number", "A number which can have decimals"));
        paramList.add(new ParamInfo(Float.TYPE, "Number", "A number which can have decimals"));
        paramList.add(new ParamInfo(Horse.Style.class, "Horse Style", "Horse style which is the patterns on the horse"));
        paramList.add(new ParamInfo(int[].class, "number,number,number...", "Numbers seperated by an ,"));
        paramList.add(new ParamInfo(BlockPosition.class, "Block Position (num,num,num)", "Three numbers seperated by an ,"));
        paramList.add(new ParamInfo(GameProfile.class, "GameProfile", "Get the gameprofile here https://sessionserver.mojang.com/session/minecraft/profile/PLAYER_UUID_GOES_HERE?unsigned=false"));
        Collections.sort(paramList, new Comparator<ParamInfo>(){

            @Override
            public int compare(ParamInfo o1, ParamInfo o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
    }

    public static class ParamInfo {
        private Class paramClass;
        private String name;
        private String[] enums;
        private String description;

        public ParamInfo(Class paramClass, String name, String description) {
            this.name = name;
            this.description = description;
            this.paramClass = paramClass;
            Enum[] enums = (Enum[])paramClass.getEnumConstants();
            if (enums != null) {
                this.enums = new String[enums.length];
                for (int i = 0; i < enums.length; ++i) {
                    this.enums[i] = enums[i].name();
                }
            }
        }

        public ParamInfo(Class paramClass, Enum[] enums, String name, String description) {
            this.name = name;
            this.enums = new String[enums.length];
            this.description = description;
            this.paramClass = paramClass;
            for (int i = 0; i < enums.length; ++i) {
                this.enums[i] = enums[i].name();
            }
        }

        public ParamInfo(Class paramClass, String name, String description, String[] enums) {
            this.name = name;
            this.enums = enums;
            this.description = description;
            this.paramClass = paramClass;
        }

        public boolean isEnums() {
            return this.enums != null;
        }

        public Class getParamClass() {
            return this.paramClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getEnums(String tabComplete) {
            return this.enums;
        }
    }
}

