/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerClientInteract;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerInventory;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerMain;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerSounds;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerTabList;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerViewDisguises;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PacketsManager {
    private static PacketListener clientInteractEntityListener;
    private static PacketListener inventoryListener;
    private static boolean inventoryModifierEnabled;
    private static LibsDisguises libsDisguises;
    private static PacketListener mainListener;
    private static PacketListener soundsListener;
    private static boolean soundsListenerEnabled;
    private static PacketListener viewDisguisesListener;
    private static PacketListener tabListListener;
    private static boolean viewDisguisesListenerEnabled;
    private static HashMap<Disguise, ArrayList<UUID>> cancelMeta;

    public static void addPacketListeners() {
        clientInteractEntityListener = new PacketListenerClientInteract(libsDisguises);
        tabListListener = new PacketListenerTabList(libsDisguises);
        ProtocolLibrary.getProtocolManager().addPacketListener(clientInteractEntityListener);
        ProtocolLibrary.getProtocolManager().addPacketListener(tabListListener);
        PacketsManager.setupMainPacketsListener();
    }

    public static void removeCancel(Disguise disguise, Player observer) {
        ArrayList<UUID> cancel = cancelMeta.get(disguise);
        if (cancel == null) {
            return;
        }
        cancel.remove(observer.getUniqueId());
        if (!cancel.isEmpty()) {
            return;
        }
        cancelMeta.remove(disguise);
    }

    private static LibsPackets constructSpawnPackets(Player observer, LibsPackets packets, Entity disguisedEntity) {
        StructureModifier mods;
        Disguise disguise = packets.getDisguise();
        if (disguise.getEntity() == null) {
            disguise.setEntity(disguisedEntity);
        }
        if (DisguiseConfig.isEquipmentPacketsEnabled()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemstack = disguise.getWatcher().getItemStack(slot);
                if (itemstack == null || itemstack.getType() == Material.AIR) continue;
                ItemStack item = null;
                if (disguisedEntity instanceof LivingEntity) {
                    item = ReflectionManager.getEquipment(slot, disguisedEntity);
                }
                if (item != null && item.getType() != Material.AIR) continue;
                PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
                StructureModifier mods2 = packet.getModifier();
                mods2.write(0, (Object)disguisedEntity.getEntityId());
                mods2.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
                mods2.write(2, ReflectionManager.getNmsItem(itemstack));
                packets.addPacket(packet);
            }
        }
        if (DisguiseConfig.isMiscDisguisesForLivingEnabled() && disguise.getWatcher() instanceof LivingWatcher) {
            ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder().attributeKey("generic.maxHealth");
            if (((LivingWatcher)disguise.getWatcher()).isMaxHealthSet()) {
                builder.baseValue(((LivingWatcher)disguise.getWatcher()).getMaxHealth());
            } else if (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity() && disguisedEntity instanceof Damageable) {
                builder.baseValue(((Damageable)disguisedEntity).getMaxHealth());
            } else {
                builder.baseValue(DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
            }
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            builder.packet(packet);
            attributes.add(builder.build());
            packet.getIntegers().write(0, (Object)disguisedEntity.getEntityId());
            packet.getAttributeCollectionModifier().write(0, attributes);
            packets.addPacket(packet);
        }
        Location loc = disguisedEntity.getLocation().clone().add(0.0, PacketsManager.getYModifier(disguisedEntity, disguise), 0.0);
        byte yaw = (byte)(loc.getYaw() * 256.0f / 360.0f);
        byte pitch = (byte)(loc.getPitch() * 256.0f / 360.0f);
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            yaw = PacketsManager.getYaw(disguise.getType(), disguisedEntity.getType(), yaw);
            pitch = PacketsManager.getPitch(disguise.getType(), DisguiseType.getType(disguisedEntity.getType()), pitch);
        }
        if (disguise.getType() == DisguiseType.EXPERIENCE_ORB) {
            PacketContainer spawnOrb = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            packets.addPacket(spawnOrb);
            mods = spawnOrb.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)loc.getX());
            mods.write(2, (Object)(loc.getY() + 0.06));
            mods.write(3, (Object)loc.getZ());
            mods.write(4, (Object)1);
        } else if (disguise.getType() == DisguiseType.PAINTING) {
            PacketContainer spawnPainting = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            packets.addPacket(spawnPainting);
            mods = spawnPainting.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)disguisedEntity.getUniqueId());
            mods.write(2, ReflectionManager.getBlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            mods.write(3, (Object)ReflectionManager.getEnumDirection((int)loc.getYaw() % 4));
            int id = ((MiscDisguise)disguise).getData();
            mods.write(4, (Object)ReflectionManager.getEnumArt(Art.values()[id]));
            PacketContainer teleportPainting = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
            packets.addPacket(teleportPainting);
            mods = teleportPainting.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)loc.getX());
            mods.write(2, (Object)loc.getY());
            mods.write(3, (Object)loc.getZ());
            mods.write(4, (Object)yaw);
            mods.write(5, (Object)pitch);
        } else if (disguise.getType().isPlayer()) {
            WrappedDataWatcher newWatcher;
            boolean selfDisguise;
            PlayerDisguise playerDisguise = (PlayerDisguise)disguise;
            String name = playerDisguise.getName();
            int entityId = disguisedEntity.getEntityId();
            boolean removeName = false;
            if (!DisguiseUtilities.hasGameProfile(name)) {
                removeName = !DisguiseUtilities.getAddedByPlugins().contains(name);
            }
            WrappedGameProfile gameProfile = playerDisguise.getGameProfile();
            if (removeName) {
                DisguiseUtilities.getAddedByPlugins().remove(name);
            }
            PacketContainer sendTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            if (!((PlayerDisguise)disguise).isDisplayedInTab()) {
                packets.addPacket(sendTab);
            }
            sendTab.getModifier().write(0, (Object)ReflectionManager.getEnumPlayerInfoAction(0));
            ArrayList<Object> playerList = new ArrayList<Object>();
            playerList.add(ReflectionManager.getPlayerInfoData(sendTab.getHandle(), playerDisguise.getGameProfile()));
            sendTab.getModifier().write(1, playerList);
            PacketContainer spawnPlayer = new PacketContainer(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            spawnPlayer.getIntegers().write(0, (Object)entityId);
            spawnPlayer.getModifier().write(1, (Object)gameProfile.getUUID());
            Location spawnAt = disguisedEntity.getLocation();
            boolean bl = selfDisguise = observer == disguisedEntity;
            if (selfDisguise) {
                newWatcher = PacketsManager.createDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher());
            } else {
                newWatcher = new WrappedDataWatcher();
                spawnAt = observer.getLocation();
                spawnAt.add(spawnAt.getDirection().normalize().multiply(20));
            }
            StructureModifier doubles = spawnPlayer.getDoubles();
            doubles.write(0, (Object)spawnAt.getX());
            doubles.write(1, (Object)spawnAt.getY());
            doubles.write(2, (Object)spawnAt.getZ());
            StructureModifier bytes = spawnPlayer.getBytes();
            bytes.write(0, (Object)((byte)(loc.getYaw() * 256.0f / 360.0f)));
            bytes.write(1, (Object)((byte)(loc.getPitch() * 256.0f / 360.0f)));
            spawnPlayer.getDataWatcherModifier().write(0, (Object)newWatcher);
            newWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(MetaIndex.ENTITY_META.getIndex(), WrappedDataWatcher.Registry.get(Byte.class)), (Object)32);
            packets.addPacket(spawnPlayer);
            if (DisguiseConfig.isBedPacketsEnabled() && ((PlayerWatcher)disguise.getWatcher()).isSleeping()) {
                PacketContainer[] bedPackets;
                for (PacketContainer packet : bedPackets = DisguiseUtilities.getBedPackets(loc.clone().subtract(0.0, PacketsManager.getYModifier(disguisedEntity, disguise), 0.0), observer.getLocation(), (PlayerDisguise)disguise)) {
                    packets.addPacket(packet);
                }
            } else if (!selfDisguise) {
                PacketContainer teleportPacket = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
                doubles = teleportPacket.getDoubles();
                teleportPacket.getIntegers().write(0, (Object)entityId);
                doubles.write(0, (Object)loc.getX());
                doubles.write(1, (Object)loc.getY());
                doubles.write(2, (Object)loc.getZ());
                bytes = teleportPacket.getBytes();
                bytes.write(0, (Object)((byte)(loc.getYaw() * 256.0f / 360.0f)));
                bytes.write(1, (Object)((byte)(loc.getPitch() * 256.0f / 360.0f)));
                packets.addPacket(teleportPacket);
            }
            if (!selfDisguise) {
                PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                newWatcher = PacketsManager.createDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher());
                metaPacket.getIntegers().write(0, (Object)entityId);
                metaPacket.getWatchableCollectionModifier().write(0, (Object)newWatcher.getWatchableObjects());
                if (!cancelMeta.containsKey(disguise)) {
                    cancelMeta.put(disguise, new ArrayList());
                }
                cancelMeta.get(disguise).add(observer.getUniqueId());
                packets.addDelayedPacket(metaPacket, 4);
            }
            PacketContainer deleteTab = sendTab.shallowClone();
            deleteTab.getModifier().write(0, (Object)ReflectionManager.getEnumPlayerInfoAction(4));
            if (!((PlayerDisguise)disguise).isDisplayedInTab()) {
                packets.addDelayedPacket(deleteTab, 40);
            }
        } else if (disguise.getType().isMob() || disguise.getType() == DisguiseType.ARMOR_STAND) {
            Vector vec = disguisedEntity.getVelocity();
            PacketContainer spawnEntity = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            packets.addPacket(spawnEntity);
            StructureModifier mods3 = spawnEntity.getModifier();
            mods3.write(0, (Object)disguisedEntity.getEntityId());
            mods3.write(1, (Object)UUID.randomUUID());
            mods3.write(2, (Object)disguise.getType().getTypeId());
            double d1 = 3.9;
            double d2 = vec.getX();
            double d3 = vec.getY();
            double d4 = vec.getZ();
            if (d2 < -d1) {
                d2 = -d1;
            }
            if (d3 < -d1) {
                d3 = -d1;
            }
            if (d4 < -d1) {
                d4 = -d1;
            }
            if (d2 > d1) {
                d2 = d1;
            }
            if (d3 > d1) {
                d3 = d1;
            }
            if (d4 > d1) {
                d4 = d1;
            }
            mods3.write(3, (Object)loc.getX());
            mods3.write(4, (Object)loc.getY());
            mods3.write(5, (Object)loc.getZ());
            mods3.write(6, (Object)((int)(d2 * 8000.0)));
            mods3.write(7, (Object)((int)(d3 * 8000.0)));
            mods3.write(8, (Object)((int)(d4 * 8000.0)));
            mods3.write(9, (Object)yaw);
            mods3.write(10, (Object)pitch);
            spawnEntity.getDataWatcherModifier().write(0, (Object)PacketsManager.createDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher()));
        } else if (disguise.getType().isMisc()) {
            int objectId = disguise.getType().getObjectId();
            int data = ((MiscDisguise)disguise).getData();
            if (disguise.getType() == DisguiseType.FALLING_BLOCK) {
                data = ReflectionManager.getCombinedId(((MiscDisguise)disguise).getId(), data);
            } else if (disguise.getType() == DisguiseType.FISHING_HOOK && data == -1) {
                data = observer.getEntityId();
            } else if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                data = ((int)loc.getYaw() % 360 + 720 + 45) / 90 % 4;
            }
            Object nmsEntity = ReflectionManager.getNmsEntity(disguisedEntity);
            PacketContainer spawnEntity = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY, new Object[]{nmsEntity, objectId, data}).createPacket(new Object[]{nmsEntity, objectId, data});
            packets.addPacket(spawnEntity);
            spawnEntity.getModifier().write(8, (Object)pitch);
            spawnEntity.getModifier().write(9, (Object)yaw);
            if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                if (data % 2 == 0) {
                    spawnEntity.getModifier().write(4, (Object)(loc.getZ() + (double)(data == 0 ? -1 : 1)));
                } else {
                    spawnEntity.getModifier().write(2, (Object)(loc.getX() + (double)(data == 3 ? -1 : 1)));
                }
            }
        }
        if (packets.getPackets().size() <= 1 || disguise.isPlayerDisguise()) {
            PacketContainer rotateHead = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
            packets.addPacket(rotateHead);
            StructureModifier mods4 = rotateHead.getModifier();
            mods4.write(0, (Object)disguisedEntity.getEntityId());
            mods4.write(1, (Object)yaw);
        }
        if (disguise.getType() == DisguiseType.EVOKER_FANGS) {
            PacketContainer newPacket = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
            StructureModifier mods5 = newPacket.getModifier();
            mods5.write(0, (Object)disguise.getEntity().getEntityId());
            mods5.write(1, (Object)4);
            packets.addPacket(newPacket);
        }
        return packets;
    }

    private static WrappedDataWatcher createDataWatcher(WrappedDataWatcher watcher, FlagWatcher flagWatcher) {
        WrappedDataWatcher newWatcher = new WrappedDataWatcher();
        try {
            List<WrappedWatchableObject> list = DisguiseConfig.isMetadataPacketsEnabled() ? flagWatcher.convert(watcher.getWatchableObjects()) : flagWatcher.getWatchableObjects();
            for (WrappedWatchableObject watchableObject : list) {
                if (watchableObject == null || watchableObject.getValue() == null || WrappedDataWatcher.Registry.get(watchableObject.getValue().getClass()) == null) continue;
                WrappedDataWatcher.WrappedDataWatcherObject obj = new WrappedDataWatcher.WrappedDataWatcherObject(watchableObject.getIndex(), WrappedDataWatcher.Registry.get(watchableObject.getValue().getClass()));
                newWatcher.setObject(obj, watchableObject.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newWatcher;
    }

    public static byte getPitch(DisguiseType disguiseType, DisguiseType entityType, byte value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = -value;
                break;
            }
        }
        switch (entityType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = -value;
                break;
            }
        }
        return value;
    }

    public static byte getYaw(DisguiseType disguiseType, EntityType entityType, byte value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = (byte)(value + 64);
                break;
            }
            case BOAT: 
            case ENDER_DRAGON: 
            case WITHER_SKULL: {
                value = (byte)(value - 128);
                break;
            }
            case ARROW: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: {
                value = -value;
                break;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                value = (byte)(-(value + 128));
                break;
            }
            default: {
                if (!disguiseType.isMisc() || disguiseType == DisguiseType.ARMOR_STAND) break;
                value = (byte)(value - 64);
            }
        }
        switch (entityType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = (byte)(value - 64);
                break;
            }
            case ENDER_DRAGON: 
            case WITHER_SKULL: {
                value = (byte)(value + 128);
                break;
            }
            case ARROW: {
                value = -value;
                break;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                value = (byte)(-(value - 128));
                break;
            }
            default: {
                if (entityType.isAlive()) break;
                value = (byte)(value + 64);
            }
        }
        return value;
    }

    public static double getYModifier(Entity entity, Disguise disguise) {
        double yMod = 0.0;
        if (!(disguise.getType() == DisguiseType.PLAYER && ((PlayerWatcher)disguise.getWatcher()).isSleeping() || entity.getType() != EntityType.DROPPED_ITEM)) {
            yMod -= 0.13;
        }
        switch (disguise.getType()) {
            case BAT: {
                if (entity instanceof LivingEntity) {
                    return yMod + ((LivingEntity)entity).getEyeHeight();
                }
            }
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                switch (entity.getType()) {
                    case MINECART: 
                    case MINECART_CHEST: 
                    case MINECART_FURNACE: 
                    case MINECART_HOPPER: 
                    case MINECART_MOB_SPAWNER: 
                    case MINECART_TNT: {
                        return yMod;
                    }
                }
                return yMod + 0.4;
            }
            case BOAT: 
            case WITHER_SKULL: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: 
            case PAINTING: 
            case EGG: 
            case ENDER_PEARL: 
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: {
                return yMod + 0.7;
            }
            case PLAYER: {
                if (!DisguiseConfig.isBedPacketsEnabled() || !((PlayerWatcher)disguise.getWatcher()).isSleeping()) break;
                return yMod + 0.35;
            }
            case DROPPED_ITEM: {
                return yMod + 0.13;
            }
        }
        return yMod;
    }

    public static void init(LibsDisguises plugin) {
        libsDisguises = plugin;
        soundsListener = new PacketListenerSounds(libsDisguises);
        viewDisguisesListener = new PacketListenerViewDisguises(libsDisguises);
        inventoryListener = new PacketListenerInventory(libsDisguises);
    }

    public static boolean isHearDisguisesEnabled() {
        return soundsListenerEnabled;
    }

    public static boolean isInventoryListenerEnabled() {
        return inventoryModifierEnabled;
    }

    public static boolean isViewDisguisesListenerEnabled() {
        return viewDisguisesListenerEnabled;
    }

    public static void setHearDisguisesListener(boolean enabled) {
        if (soundsListenerEnabled != enabled) {
            soundsListenerEnabled = enabled;
            if (soundsListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(soundsListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(soundsListener);
            }
        }
    }

    public static void setInventoryListenerEnabled(boolean enabled) {
        if (inventoryModifierEnabled != enabled) {
            inventoryModifierEnabled = enabled;
            if (inventoryModifierEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(inventoryListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(inventoryListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !viewDisguisesListenerEnabled || !disguise.isSelfDisguiseVisible() || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }

    public static void setupMainPacketsListener() {
        if (clientInteractEntityListener != null) {
            if (mainListener != null) {
                ProtocolLibrary.getProtocolManager().removePacketListener(mainListener);
            }
            ArrayList<PacketType> packetsToListen = new ArrayList<PacketType>();
            packetsToListen.add(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            packetsToListen.add(PacketType.Play.Server.ENTITY_METADATA);
            if (DisguiseConfig.isCollectPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.COLLECT);
            }
            if (DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
                packetsToListen.add(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            }
            if (DisguiseConfig.isBedPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.BED);
            }
            if (DisguiseConfig.isMovementPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_LOOK);
                packetsToListen.add(PacketType.Play.Server.REL_ENTITY_MOVE_LOOK);
                packetsToListen.add(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                packetsToListen.add(PacketType.Play.Server.ENTITY_TELEPORT);
                packetsToListen.add(PacketType.Play.Server.REL_ENTITY_MOVE);
            }
            if (DisguiseConfig.isEquipmentPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_EQUIPMENT);
            }
            if (DisguiseConfig.isAnimationPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ANIMATION);
            }
            if (DisguiseConfig.isEntityStatusPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_STATUS);
            }
            mainListener = new PacketListenerMain(libsDisguises, packetsToListen);
            ProtocolLibrary.getProtocolManager().addPacketListener(mainListener);
        }
    }

    public static void setViewDisguisesListener(boolean enabled) {
        if (viewDisguisesListenerEnabled != enabled) {
            viewDisguisesListenerEnabled = enabled;
            if (viewDisguisesListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(viewDisguisesListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(viewDisguisesListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !disguise.isSelfDisguiseVisible()) continue;
                if (enabled) {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                } else {
                    DisguiseUtilities.removeSelfDisguise(player);
                }
                if (!inventoryModifierEnabled || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }

    public static LibsPackets transformPacket(PacketContainer sentPacket, Disguise disguise, Player observer, Entity entity) {
        LibsPackets packets = new LibsPackets(disguise);
        try {
            packets.addPacket(sentPacket);
            if (sentPacket.getType() == PacketType.Play.Server.UPDATE_ATTRIBUTES) {
                if (disguise.isMiscDisguise()) {
                    packets.clear();
                } else {
                    ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
                    for (WrappedAttribute attribute : (List)sentPacket.getAttributeCollectionModifier().read(0)) {
                        WrappedAttribute.Builder builder;
                        if (!attribute.getAttributeKey().equals("generic.maxHealth")) continue;
                        packets.clear();
                        PacketContainer updateAttributes = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
                        packets.addPacket(updateAttributes);
                        if (((LivingWatcher)disguise.getWatcher()).isMaxHealthSet()) {
                            builder = WrappedAttribute.newBuilder();
                            builder.attributeKey("generic.maxHealth");
                            builder.baseValue(((LivingWatcher)disguise.getWatcher()).getMaxHealth());
                        } else if (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity()) {
                            builder = WrappedAttribute.newBuilder((WrappedAttribute)attribute);
                        } else {
                            builder = WrappedAttribute.newBuilder();
                            builder.attributeKey("generic.maxHealth");
                            builder.baseValue(DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
                        }
                        builder.packet(updateAttributes);
                        attributes.add(builder.build());
                        break;
                    }
                    if (!attributes.isEmpty()) {
                        packets.getPackets().get(0).getIntegers().write(0, (Object)entity.getEntityId());
                        packets.getPackets().get(0).getAttributeCollectionModifier().write(0, attributes);
                    } else {
                        packets.clear();
                    }
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_METADATA) {
                packets.clear();
                if (!(!DisguiseConfig.isMetadataPacketsEnabled() || cancelMeta.containsKey(disguise) && cancelMeta.get(disguise).contains(observer.getUniqueId()))) {
                    List<WrappedWatchableObject> watchableObjects = disguise.getWatcher().convert((List)sentPacket.getWatchableCollectionModifier().read(0));
                    PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                    packets.addPacket(metaPacket);
                    StructureModifier newMods = metaPacket.getModifier();
                    newMods.write(0, (Object)entity.getEntityId());
                    metaPacket.getWatchableCollectionModifier().write(0, watchableObjects);
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.NAMED_ENTITY_SPAWN || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY_LIVING || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY_PAINTING) {
                packets.clear();
                PacketsManager.constructSpawnPackets(observer, packets, entity);
            } else if (sentPacket.getType() == PacketType.Play.Server.ANIMATION) {
                if (disguise.getType().isMisc() || (Integer)sentPacket.getIntegers().read(1) == 2 && (!disguise.getType().isPlayer() || DisguiseConfig.isBedPacketsEnabled() && ((PlayerWatcher)disguise.getWatcher()).isSleeping())) {
                    packets.clear();
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.COLLECT) {
                if (disguise.getType().isMisc()) {
                    packets.clear();
                } else if (DisguiseConfig.isBedPacketsEnabled() && disguise.getType().isPlayer() && ((PlayerWatcher)disguise.getWatcher()).isSleeping()) {
                    PacketContainer newPacket = new PacketContainer(PacketType.Play.Server.ANIMATION);
                    StructureModifier mods = newPacket.getIntegers();
                    mods.write(0, (Object)disguise.getEntity().getEntityId());
                    mods.write(1, (Object)3);
                    packets.clear();
                    packets.addPacket(newPacket);
                    packets.addPacket(sentPacket);
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK || sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK || sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT || sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE) {
                if (!(disguise.getType() != DisguiseType.RABBIT || sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE && sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE_LOOK || !entity.getMetadata("LibsRabbitHop").isEmpty() && System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong() >= 100L && System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong() <= 500L)) {
                    if (entity.getMetadata("LibsRabbitHop").isEmpty() || System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong() > 500L) {
                        entity.removeMetadata("LibsRabbitHop", (Plugin)libsDisguises);
                        entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)libsDisguises, (Object)System.currentTimeMillis()));
                    }
                    PacketContainer statusPacket = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
                    packets.addPacket(statusPacket);
                    statusPacket.getIntegers().write(0, (Object)entity.getEntityId());
                    statusPacket.getBytes().write(0, (Object)1);
                }
                if (sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.WITHER_SKULL) {
                    packets.clear();
                } else if (sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE) {
                    packets.clear();
                    PacketContainer movePacket = sentPacket.shallowClone();
                    packets.addPacket(movePacket);
                    StructureModifier bytes = movePacket.getBytes();
                    byte yawValue = (Byte)bytes.read(0);
                    byte pitchValue = (Byte)bytes.read(1);
                    bytes.write(0, (Object)PacketsManager.getYaw(disguise.getType(), entity.getType(), yawValue));
                    bytes.write(1, (Object)PacketsManager.getPitch(disguise.getType(), DisguiseType.getType(entity.getType()), pitchValue));
                    if (sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT && disguise.getType() == DisguiseType.ITEM_FRAME) {
                        double y;
                        StructureModifier doubles = movePacket.getDoubles();
                        Location loc = entity.getLocation();
                        double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                        if (data % 2.0 == 0.0) {
                            if (data % 2.0 == 0.0) {
                                doubles.write(3, (Object)loc.getZ());
                            } else {
                                doubles.write(1, (Object)loc.getZ());
                            }
                        }
                        if ((y = PacketsManager.getYModifier(entity, disguise)) != 0.0) {
                            doubles.write(2, (Object)((Double)doubles.read(2) + y));
                        }
                    }
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_EQUIPMENT) {
                ItemStack heldItem;
                EquipmentSlot slot = ReflectionManager.createEquipmentSlot(packets.getPackets().get(0).getModifier().read(1));
                ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
                if (itemStack != null) {
                    packets.clear();
                    PacketContainer equipPacket = sentPacket.shallowClone();
                    packets.addPacket(equipPacket);
                    equipPacket.getModifier().write(2, ReflectionManager.getNmsItem(itemStack.getType() == Material.AIR ? null : itemStack));
                }
                if (disguise.getWatcher().isRightClicking() && slot == EquipmentSlot.HAND && (heldItem = (ItemStack)packets.getPackets().get(0).getItemModifier().read(0)) != null && heldItem.getType() != Material.AIR) {
                    List<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
                    if (DisguiseConfig.isMetadataPacketsEnabled()) {
                        WrappedWatchableObject watch = ReflectionManager.createWatchable(0, WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(0));
                        list.add(watch);
                        list = disguise.getWatcher().convert(list);
                    } else {
                        for (WrappedWatchableObject obj : disguise.getWatcher().getWatchableObjects()) {
                            if (obj.getIndex() != 0) continue;
                            list.add(obj);
                            break;
                        }
                    }
                    PacketContainer packetBlock = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                    packetBlock.getModifier().write(0, (Object)entity.getEntityId());
                    packetBlock.getWatchableCollectionModifier().write(0, list);
                    PacketContainer packetUnblock = packetBlock.deepClone();
                    for (WrappedWatchableObject watcher : (List)packetUnblock.getWatchableCollectionModifier().read(0)) {
                        watcher.setValue((Object)((byte)((Byte)watcher.getValue() & 0xFFFFFFEF)));
                    }
                    PacketContainer packet1 = packets.getPackets().get(0);
                    packets.clear();
                    packets.addPacket(packetUnblock);
                    packets.addPacket(packet1);
                    packets.addPacket(packetBlock);
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.BED) {
                if (!disguise.getType().isPlayer()) {
                    packets.clear();
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_STATUS) {
                if ((Byte)packets.getPackets().get(0).getBytes().read(0) == 3) {
                    packets.clear();
                }
            } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_HEAD_ROTATION) {
                if (disguise.getType().isPlayer() && entity.getType() != EntityType.PLAYER) {
                    Location loc = entity.getLocation();
                    byte pitch = PacketsManager.getPitch(disguise.getType(), DisguiseType.getType(entity.getType()), (byte)(loc.getPitch() * 256.0f / 360.0f));
                    byte yaw = PacketsManager.getYaw(disguise.getType(), entity.getType(), (Byte)sentPacket.getBytes().read(0));
                    PacketContainer rotation = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                    StructureModifier mods = rotation.getModifier();
                    mods.write(0, (Object)entity.getEntityId());
                    mods.write(1, (Object)yaw);
                    PacketContainer look = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
                    look.getIntegers().write(0, (Object)entity.getEntityId());
                    look.getBytes().write(0, (Object)yaw);
                    look.getBytes().write(1, (Object)pitch);
                    packets.clear();
                    packets.addPacket(look);
                    packets.addPacket(rotation);
                }
            } else {
                packets.setUnhandled();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packets;
    }

    static {
        cancelMeta = new HashMap();
    }

    public static class LibsPackets {
        private ArrayList<PacketContainer> packets = new ArrayList();
        private HashMap<Integer, ArrayList<PacketContainer>> delayedPackets = new HashMap();
        private boolean isSpawnPacket;
        private Disguise disguise;
        private boolean doNothing;

        public void setUnhandled() {
            this.doNothing = true;
        }

        public boolean isUnhandled() {
            return this.doNothing;
        }

        private LibsPackets(Disguise disguise) {
            this.disguise = disguise;
        }

        public Disguise getDisguise() {
            return this.disguise;
        }

        public void setPacketType(PacketType type) {
            this.isSpawnPacket = type.name().contains("SPAWN") && type.name().contains("ENTITY");
        }

        public void addPacket(PacketContainer packet) {
            this.packets.add(packet);
        }

        public void addDelayedPacket(PacketContainer packet) {
            this.addDelayedPacket(packet, 2);
        }

        public void clear() {
            this.getPackets().clear();
        }

        public void addDelayedPacket(PacketContainer packet, int ticksDelayed) {
            if (!this.delayedPackets.containsKey(ticksDelayed)) {
                this.delayedPackets.put(ticksDelayed, new ArrayList());
            }
            this.delayedPackets.get(ticksDelayed).add(packet);
        }

        public ArrayList<PacketContainer> getPackets() {
            return this.packets;
        }

        public Collection<ArrayList<PacketContainer>> getDelayedPackets() {
            return this.delayedPackets.values();
        }

        public void sendDelayed(final Player observer) {
            for (final Map.Entry<Integer, ArrayList<PacketContainer>> entry : this.delayedPackets.entrySet()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (PacketContainer packet : (ArrayList)entry.getValue()) {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
                            }
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        if (LibsPackets.this.isSpawnPacket) {
                            PacketsManager.removeCancel(LibsPackets.this.disguise, observer);
                        }
                    }
                }, (long)entry.getKey().intValue());
            }
        }
    }
}

