/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Sound;

public enum DisguiseSound {
    ARROW(null, null, null, null, Sound.ENTITY_ARROW_HIT, Sound.ENTITY_ARROW_SHOOT),
    BAT((Object)Sound.ENTITY_BAT_HURT, null, (Object)Sound.ENTITY_BAT_DEATH, (Object)Sound.ENTITY_BAT_AMBIENT, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_BAT_LOOP, Sound.ENTITY_PLAYER_BIG_FALL, Sound.ENTITY_BAT_TAKEOFF),
    BLAZE((Object)Sound.ENTITY_BLAZE_HURT, null, (Object)Sound.ENTITY_BLAZE_DEATH, (Object)Sound.ENTITY_BLAZE_AMBIENT, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_PLAYER_BIG_FALL),
    CAVE_SPIDER((Object)Sound.ENTITY_SPIDER_AMBIENT, Sound.ENTITY_SPIDER_STEP, (Object)Sound.ENTITY_SPIDER_DEATH, (Object)Sound.ENTITY_SPIDER_AMBIENT, new Object[0]),
    CHICKEN((Object)Sound.ENTITY_CHICKEN_HURT, Sound.ENTITY_CHICKEN_STEP, (Object)Sound.ENTITY_CHICKEN_HURT, (Object)Sound.ENTITY_CHICKEN_AMBIENT, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_CHICKEN_EGG, Sound.ENTITY_PLAYER_BIG_FALL),
    COW((Object)Sound.ENTITY_COW_HURT, Sound.ENTITY_COW_STEP, (Object)Sound.ENTITY_COW_DEATH, (Object)Sound.ENTITY_COW_AMBIENT, new Object[0]),
    CREEPER((Object)Sound.ENTITY_CREEPER_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_CREEPER_DEATH, null, new Object[0]),
    DONKEY((Object)Sound.ENTITY_DONKEY_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_DONKEY_DEATH, (Object)Sound.ENTITY_DONKEY_AMBIENT, Sound.ENTITY_HORSE_GALLOP, Sound.ENTITY_HORSE_SADDLE, Sound.ENTITY_DONKEY_ANGRY, Sound.ENTITY_HORSE_STEP_WOOD, Sound.ENTITY_HORSE_ARMOR, Sound.ENTITY_HORSE_LAND, Sound.ENTITY_HORSE_JUMP, Sound.ENTITY_HORSE_ANGRY),
    ELDER_GUARDIAN((Object)Sound.ENTITY_ELDER_GUARDIAN_HURT, null, (Object)Sound.ENTITY_ELDER_GUARDIAN_DEATH, (Object)Sound.ENTITY_ELDER_GUARDIAN_AMBIENT, new Object[0]),
    ENDER_DRAGON((Object)Sound.ENTITY_ENDERDRAGON_HURT, null, (Object)Sound.ENTITY_ENDERDRAGON_DEATH, (Object)Sound.ENTITY_ENDERDRAGON_AMBIENT, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_ENDERDRAGON_FLAP, Sound.ENTITY_PLAYER_BIG_FALL),
    ENDERMAN((Object)Sound.ENTITY_ENDERMEN_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_ENDERMEN_DEATH, (Object)Sound.ENTITY_ENDERMEN_AMBIENT, Sound.ENTITY_ENDERMEN_SCREAM, Sound.ENTITY_ENDERMEN_TELEPORT, Sound.ENTITY_ENDERMEN_STARE),
    ENDERMITE((Object)Sound.ENTITY_SILVERFISH_HURT, Sound.ENTITY_ENDERMITE_STEP, (Object)Sound.ENTITY_ENDERMITE_DEATH, (Object)Sound.ENTITY_ENDERMITE_AMBIENT, new Object[0]),
    EVOKER((Object)Sound.ENTITY_EVOCATION_ILLAGER_HURT, null, (Object)Sound.ENTITY_EVOCATION_ILLAGER_DEATH, (Object)Sound.ENTITY_EVOCATION_ILLAGER_AMBIENT, Sound.ENTITY_EVOCATION_ILLAGER_CAST_SPELL, Sound.ENTITY_EVOCATION_ILLAGER_PREPARE_ATTACK, Sound.ENTITY_EVOCATION_ILLAGER_PREPARE_SUMMON, Sound.ENTITY_EVOCATION_ILLAGER_PREPARE_WOLOLO),
    EVOKER_FANGS(null, null, null, null, Sound.ENTITY_EVOCATION_FANGS_ATTACK),
    GHAST((Object)Sound.ENTITY_GHAST_HURT, null, (Object)Sound.ENTITY_GHAST_DEATH, (Object)Sound.ENTITY_GHAST_AMBIENT, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_GHAST_SHOOT, Sound.ENTITY_PLAYER_BIG_FALL, Sound.ENTITY_GHAST_SCREAM, Sound.ENTITY_GHAST_WARN),
    GIANT((Object)Sound.ENTITY_PLAYER_HURT, Sound.BLOCK_GRASS_STEP, null, null, new Object[0]),
    GUARDIAN((Object)Sound.ENTITY_GUARDIAN_HURT, null, (Object)Sound.ENTITY_GUARDIAN_DEATH, (Object)Sound.ENTITY_ELDER_GUARDIAN_AMBIENT, new Object[0]),
    HORSE((Object)Sound.ENTITY_HORSE_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_HORSE_DEATH, (Object)Sound.ENTITY_HORSE_AMBIENT, Sound.ENTITY_HORSE_GALLOP, Sound.ENTITY_HORSE_SADDLE, Sound.ENTITY_DONKEY_ANGRY, Sound.ENTITY_HORSE_STEP_WOOD, Sound.ENTITY_HORSE_ARMOR, Sound.ENTITY_HORSE_LAND, Sound.ENTITY_HORSE_JUMP, Sound.ENTITY_HORSE_ANGRY),
    IRON_GOLEM((Object)Sound.ENTITY_IRONGOLEM_HURT, Sound.ENTITY_IRONGOLEM_STEP, (Object)Sound.ENTITY_IRONGOLEM_DEATH, (Object)Sound.ENTITY_IRONGOLEM_ATTACK, new Object[0]),
    LLAMA((Object)Sound.ENTITY_LLAMA_HURT, Sound.ENTITY_LLAMA_STEP, (Object)Sound.ENTITY_LLAMA_DEATH, (Object)Sound.ENTITY_LLAMA_AMBIENT, Sound.ENTITY_LLAMA_ANGRY, Sound.ENTITY_LLAMA_CHEST, Sound.ENTITY_LLAMA_EAT, Sound.ENTITY_LLAMA_SWAG),
    MAGMA_CUBE((Object)Sound.ENTITY_MAGMACUBE_HURT, Sound.ENTITY_MAGMACUBE_JUMP, null, null, new Object[0]),
    MULE((Object)Sound.ENTITY_MULE_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_MULE_DEATH, (Object)Sound.ENTITY_MULE_AMBIENT, new Object[0]),
    MUSHROOM_COW((Object)Sound.ENTITY_COW_HURT, Sound.ENTITY_COW_STEP, (Object)Sound.ENTITY_COW_HURT, (Object)Sound.ENTITY_COW_AMBIENT, new Object[0]),
    OCELOT((Object)Sound.ENTITY_CAT_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_CAT_HURT, (Object)Sound.ENTITY_CAT_AMBIENT, Sound.ENTITY_CAT_PURR, Sound.ENTITY_CAT_PURREOW),
    PIG((Object)Sound.ENTITY_PIG_HURT, Sound.ENTITY_PIG_STEP, (Object)Sound.ENTITY_PIG_DEATH, (Object)Sound.ENTITY_PIG_AMBIENT, new Object[0]),
    PIG_ZOMBIE((Object)Sound.ENTITY_ZOMBIE_PIG_HURT, null, (Object)Sound.ENTITY_ZOMBIE_PIG_DEATH, (Object)Sound.ENTITY_ZOMBIE_PIG_AMBIENT, Sound.ENTITY_ZOMBIE_PIG_ANGRY),
    PLAYER((Object)Sound.ENTITY_PLAYER_HURT, new Sound[]{Sound.BLOCK_ANVIL_STEP, Sound.BLOCK_CLOTH_STEP, Sound.BLOCK_GLASS_STEP, Sound.BLOCK_GRASS_STEP, Sound.BLOCK_GRAVEL_STEP, Sound.BLOCK_LADDER_STEP, Sound.BLOCK_METAL_STEP, Sound.BLOCK_SAND_STEP, Sound.BLOCK_SLIME_STEP, Sound.BLOCK_SNOW_STEP, Sound.BLOCK_STONE_STEP, Sound.BLOCK_WOOD_STEP}, (Object)Sound.ENTITY_PLAYER_DEATH, (Object)null, new Object[0]),
    RABBIT((Object)Sound.ENTITY_RABBIT_HURT, Sound.ENTITY_RABBIT_JUMP, (Object)Sound.ENTITY_RABBIT_DEATH, (Object)Sound.ENTITY_RABBIT_AMBIENT, new Object[0]),
    SHEEP((Object)Sound.ENTITY_SHEEP_HURT, Sound.ENTITY_SHEEP_STEP, null, (Object)Sound.ENTITY_SHEEP_AMBIENT, Sound.ENTITY_SHEEP_SHEAR),
    SHULKER((Object)Sound.ENTITY_SHULKER_HURT, null, (Object)Sound.ENTITY_SHULKER_DEATH, (Object)Sound.ENTITY_SHULKER_AMBIENT, Sound.ENTITY_SHULKER_OPEN, Sound.ENTITY_SHULKER_CLOSE, Sound.ENTITY_SHULKER_HURT_CLOSED, Sound.ENTITY_SHULKER_TELEPORT),
    SILVERFISH((Object)Sound.ENTITY_SILVERFISH_HURT, Sound.ENTITY_SILVERFISH_STEP, (Object)Sound.ENTITY_SILVERFISH_DEATH, (Object)Sound.ENTITY_SILVERFISH_AMBIENT, new Object[0]),
    SKELETON((Object)Sound.ENTITY_SKELETON_HURT, Sound.ENTITY_SKELETON_STEP, (Object)Sound.ENTITY_SKELETON_DEATH, (Object)Sound.ENTITY_SKELETON_AMBIENT, new Object[0]),
    SKELETON_HORSE((Object)Sound.ENTITY_SKELETON_HORSE_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_SKELETON_HORSE_DEATH, (Object)Sound.ENTITY_SKELETON_HORSE_AMBIENT, Sound.ENTITY_HORSE_GALLOP, Sound.ENTITY_HORSE_SADDLE, Sound.ENTITY_DONKEY_ANGRY, Sound.ENTITY_HORSE_STEP_WOOD, Sound.ENTITY_HORSE_ARMOR, Sound.ENTITY_HORSE_LAND, Sound.ENTITY_HORSE_JUMP, Sound.ENTITY_HORSE_ANGRY),
    SLIME((Object)Sound.ENTITY_SLIME_HURT, Sound.ENTITY_SLIME_JUMP, (Object)Sound.ENTITY_SLIME_DEATH, null, new Object[0]),
    SNOWMAN((Object)Sound.ENTITY_SNOWMAN_HURT, null, (Object)Sound.ENTITY_SNOWMAN_DEATH, (Object)Sound.ENTITY_SNOWMAN_AMBIENT, Sound.ENTITY_SNOWMAN_SHOOT),
    SPIDER((Object)Sound.ENTITY_SPIDER_AMBIENT, Sound.ENTITY_SPIDER_STEP, (Object)Sound.ENTITY_SPIDER_DEATH, (Object)Sound.ENTITY_SPIDER_AMBIENT, new Object[0]),
    SQUID((Object)Sound.ENTITY_SQUID_HURT, null, (Object)Sound.ENTITY_SQUID_DEATH, (Object)Sound.ENTITY_SQUID_AMBIENT, new Object[0]),
    UNDEAD_HORSE((Object)Sound.ENTITY_ZOMBIE_HORSE_HURT, Sound.BLOCK_GRASS_STEP, (Object)Sound.ENTITY_ZOMBIE_HORSE_DEATH, (Object)Sound.ENTITY_ZOMBIE_HORSE_AMBIENT, Sound.ENTITY_HORSE_GALLOP, Sound.ENTITY_HORSE_SADDLE, Sound.ENTITY_DONKEY_ANGRY, Sound.ENTITY_HORSE_STEP_WOOD, Sound.ENTITY_HORSE_ARMOR, Sound.ENTITY_HORSE_LAND, Sound.ENTITY_HORSE_JUMP, Sound.ENTITY_HORSE_ANGRY),
    VEX((Object)Sound.ENTITY_VEX_HURT, null, (Object)Sound.ENTITY_VEX_DEATH, (Object)Sound.ENTITY_VEX_AMBIENT, Sound.ENTITY_VEX_CHARGE),
    VILLAGER((Object)Sound.ENTITY_VILLAGER_HURT, null, (Object)Sound.ENTITY_VILLAGER_DEATH, (Object)Sound.ENTITY_VILLAGER_AMBIENT, Sound.ENTITY_VILLAGER_TRADING, Sound.ENTITY_VILLAGER_NO, Sound.ENTITY_VILLAGER_YES),
    VINDICATOR((Object)Sound.ENTITY_VINDICATION_ILLAGER_HURT, null, (Object)Sound.ENTITY_VINDICATION_ILLAGER_DEATH, (Object)Sound.ENTITY_VINDICATION_ILLAGER_AMBIENT, new Object[0]),
    WITCH((Object)Sound.ENTITY_WITCH_HURT, null, (Object)Sound.ENTITY_WITCH_DEATH, (Object)Sound.ENTITY_WITCH_AMBIENT, new Object[0]),
    WITHER((Object)Sound.ENTITY_WITHER_HURT, null, (Object)Sound.ENTITY_WITHER_DEATH, (Object)Sound.ENTITY_WITHER_AMBIENT, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_WITHER_SPAWN, Sound.ENTITY_PLAYER_BIG_FALL, Sound.ENTITY_WITHER_SHOOT),
    WITHER_SKELETON((Object)Sound.ENTITY_SKELETON_HURT, Sound.ENTITY_SKELETON_STEP, (Object)Sound.ENTITY_SKELETON_DEATH, (Object)Sound.ENTITY_SKELETON_AMBIENT, new Object[0]),
    WOLF((Object)Sound.ENTITY_WOLF_HURT, Sound.ENTITY_WOLF_STEP, (Object)Sound.ENTITY_WOLF_DEATH, (Object)Sound.ENTITY_WOLF_AMBIENT, Sound.ENTITY_WOLF_GROWL, Sound.ENTITY_WOLF_PANT, Sound.ENTITY_WOLF_HOWL, Sound.ENTITY_WOLF_SHAKE, Sound.ENTITY_WOLF_WHINE),
    ZOMBIE((Object)Sound.ENTITY_ZOMBIE_HURT, Sound.ENTITY_ZOMBIE_STEP, (Object)Sound.ENTITY_ZOMBIE_DEATH, (Object)Sound.ENTITY_ZOMBIE_AMBIENT, Sound.ENTITY_ZOMBIE_INFECT, Sound.ENTITY_ZOMBIE_BREAK_DOOR_WOOD, Sound.ENTITY_ZOMBIE_ATTACK_DOOR_WOOD, Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR),
    ZOMBIE_VILLAGER((Object)Sound.ENTITY_ZOMBIE_VILLAGER_HURT, Sound.ENTITY_ZOMBIE_VILLAGER_STEP, (Object)Sound.ENTITY_ZOMBIE_VILLAGER_DEATH, (Object)Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT, Sound.ENTITY_ZOMBIE_INFECT, Sound.ENTITY_ZOMBIE_BREAK_DOOR_WOOD, Sound.ENTITY_ZOMBIE_ATTACK_DOOR_WOOD, Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR);

    private float damageSoundVolume = 1.0f;
    private HashMap<Object, Object> disguiseSounds = new HashMap();

    public static DisguiseSound getType(String name) {
        try {
            return DisguiseSound.valueOf(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private DisguiseSound(Object hurt, Object step, Object death, Object idle, Object ... sounds) {
        this.addSound(hurt, SoundType.HURT);
        this.addSound(step, SoundType.STEP);
        this.addSound(death, SoundType.DEATH);
        this.addSound(idle, SoundType.IDLE);
        for (Object obj : sounds) {
            this.addSound(obj, SoundType.CANCEL);
        }
    }

    private DisguiseSound(Object hurt, Object[] step, Object death, Object idle, Object ... sounds) {
        this.addSound(hurt, SoundType.HURT);
        if (step != null) {
            for (Object obj : step) {
                this.addSound(obj, SoundType.STEP);
            }
        }
        this.addSound(death, SoundType.DEATH);
        this.addSound(idle, SoundType.IDLE);
        for (Object obj : sounds) {
            this.addSound(obj, SoundType.CANCEL);
        }
    }

    private void addSound(Object sound, SoundType type) {
        String s;
        if (sound == null) {
            return;
        }
        if (sound instanceof String) {
            s = (String)sound;
        } else if (sound instanceof Sound) {
            s = ReflectionManager.getCraftSound((Sound)sound);
        } else {
            throw new RuntimeException("Was given a unknown object " + sound);
        }
        switch (type) {
            case HURT: {
                this.disguiseSounds.put((Object)SoundType.HURT, s);
                break;
            }
            case STEP: {
                this.disguiseSounds.put((Object)SoundType.STEP, s);
                break;
            }
            case DEATH: {
                this.disguiseSounds.put((Object)SoundType.DEATH, s);
                break;
            }
            case IDLE: {
                this.disguiseSounds.put((Object)SoundType.IDLE, s);
                break;
            }
            case CANCEL: {
                this.disguiseSounds.put(s, (Object)SoundType.CANCEL);
            }
        }
    }

    public float getDamageAndIdleSoundVolume() {
        return this.damageSoundVolume;
    }

    public String getSound(SoundType type) {
        if (type == null) {
            return null;
        }
        if (this.disguiseSounds.containsKey((Object)type)) {
            return (String)this.disguiseSounds.get((Object)type);
        }
        if (this.disguiseSounds.containsValue((Object)type)) {
            for (Map.Entry<Object, Object> entry : this.disguiseSounds.entrySet()) {
                if (entry.getValue() != type) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public SoundType getSound(String sound) {
        if (sound == null) {
            return null;
        }
        if (this.disguiseSounds.containsKey(sound)) {
            return (SoundType)((Object)this.disguiseSounds.get(sound));
        }
        if (this.disguiseSounds.containsValue(sound)) {
            for (Map.Entry<Object, Object> entry : this.disguiseSounds.entrySet()) {
                if (!Objects.equals(sound, entry.getValue())) continue;
                return (SoundType)((Object)entry.getKey());
            }
        }
        return null;
    }

    public SoundType getType(String sound, boolean ignoreDamage) {
        if (sound == null) {
            return SoundType.CANCEL;
        }
        if (this.isCancelSound(sound)) {
            return SoundType.CANCEL;
        }
        for (SoundType type : SoundType.values()) {
            if (!this.disguiseSounds.containsKey((Object)type) || type == SoundType.DEATH || ignoreDamage && type == SoundType.HURT) continue;
            Object s = this.disguiseSounds.get((Object)type);
            if (s != null) {
                if (!Objects.equals(s, sound)) continue;
                return type;
            }
            for (Map.Entry<Object, Object> entry : this.disguiseSounds.entrySet()) {
                if (!Objects.equals(sound, entry.getKey())) continue;
                return (SoundType)((Object)entry.getValue());
            }
        }
        return null;
    }

    public boolean isCancelSound(String sound) {
        return this.getSound(sound) == SoundType.CANCEL;
    }

    public void setDamageAndIdleSoundVolume(float strength) {
        this.damageSoundVolume = strength;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

