/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Monster;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;

public class DisguiseParser {
    private static Object callValueOf(Class<?> param, String valueString, String methodName, String description) throws DisguiseParseException {
        Object value;
        try {
            value = param.getMethod("valueOf", String.class).invoke(null, valueString.toUpperCase());
        }
        catch (Exception ex) {
            throw DisguiseParser.parseToException(description, valueString, methodName);
        }
        return value;
    }

    private static void doCheck(CommandSender sender, HashMap<ArrayList<String>, Boolean> optionPermissions, ArrayList<String> usedOptions) throws DisguiseParseException {
        if (!DisguiseParser.passesCheck(sender, optionPermissions, usedOptions)) {
            throw new DisguiseParseException(ChatColor.RED + "You do not have permission to use the option " + usedOptions.get(usedOptions.size() - 1));
        }
    }

    private static HashMap<String, Boolean> getDisguiseOptions(CommandSender sender, String permNode, DisguisePerm type) {
        switch (type.getType()) {
            case PLAYER: 
            case FALLING_BLOCK: 
            case PAINTING: 
            case SPLASH_POTION: 
            case FISHING_HOOK: 
            case DROPPED_ITEM: {
                HashMap<String, Boolean> returns = new HashMap<String, Boolean>();
                String beginning = "libsdisguises.options." + permNode + ".";
                for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
                    String[] split;
                    String lowerPerm = permission.getPermission().toLowerCase();
                    if (!lowerPerm.startsWith(beginning) || (split = lowerPerm.substring(beginning.length()).split("\\.")).length <= 1 || !split[0].replace("_", "").equals(type.name().toLowerCase().replace("_", ""))) continue;
                    for (int i = 1; i < split.length; ++i) {
                        returns.put(split[i], permission.getValue());
                    }
                }
                return returns;
            }
        }
        return new HashMap<String, Boolean>();
    }

    public static DisguisePerm getDisguisePerm(String name) {
        for (DisguisePerm perm : DisguiseParser.getDisguisePerms()) {
            if (!perm.name().equalsIgnoreCase(name) && !perm.name().replace("_", "").equalsIgnoreCase(name)) continue;
            return perm;
        }
        return null;
    }

    public static DisguisePerm[] getDisguisePerms() {
        DisguisePerm[] perms = new DisguisePerm[DisguiseType.values().length + DisguiseConfig.getCustomDisguises().size()];
        int i = 0;
        for (DisguiseType disguiseType : DisguiseType.values()) {
            perms[i++] = new DisguisePerm(disguiseType);
        }
        for (Map.Entry entry : DisguiseConfig.getCustomDisguises().entrySet()) {
            perms[i++] = new DisguisePerm(((Disguise)entry.getValue()).getType(), (String)entry.getKey());
        }
        return perms;
    }

    private static Map.Entry<Method, Integer> getMethod(Method[] methods, String methodName, int toStart) {
        for (int i = toStart; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return new AbstractMap.SimpleEntry<Method, Integer>(method, ++i);
        }
        return null;
    }

    private static HashMap<ArrayList<String>, Boolean> getOptions(String perm) {
        ArrayList<String> list = new ArrayList<String>();
        boolean isRemove = true;
        String[] split = perm.split("\\.");
        for (int i = 1; i < split.length; ++i) {
            String option = split[i];
            boolean value = option.startsWith("-");
            if (value) {
                option = option.substring(1);
                isRemove = false;
            }
            if (option.equals("baby")) {
                option = "setbaby";
            }
            list.add(option);
        }
        HashMap<ArrayList<String>, Boolean> options = new HashMap<ArrayList<String>, Boolean>();
        options.put(list, isRemove);
        return options;
    }

    public static HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>> getPermissions(CommandSender sender, String permissionNode) {
        Class entityClass;
        String disguiseType;
        HashMap<DisguisePerm, Object> singleDisguises = new HashMap<DisguisePerm, Object>();
        HashMap<DisguisePerm, HashMap> rangeDisguises = new HashMap<DisguisePerm, HashMap>();
        HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
        for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
            String perm = permission.getPermission().toLowerCase();
            if (!perm.startsWith(permissionNode) || perms.containsKey(perm) && permission.getValue()) continue;
            perms.put(perm, permission.getValue());
        }
        if (!perms.containsKey(permissionNode + "*") && sender.hasPermission(permissionNode + "*")) {
            perms.put(permissionNode + "*", true);
        }
        if (!perms.containsKey(permissionNode + "*.*") && sender.hasPermission(permissionNode + "*.*")) {
            perms.put(permissionNode + "*.*", true);
        }
        for (String perm : perms.keySet()) {
            if (!((Boolean)perms.get(perm)).booleanValue()) continue;
            disguiseType = (perm = perm.substring(permissionNode.length())).split("\\.")[0];
            DisguisePerm dPerm = DisguiseParser.getDisguisePerm(disguiseType);
            if (dPerm != null) {
                Object list;
                if (singleDisguises.containsKey(dPerm)) {
                    list = (HashMap)singleDisguises.get(dPerm);
                } else {
                    list = new HashMap();
                    singleDisguises.put(dPerm, list);
                }
                HashMap<ArrayList<String>, Boolean> map1 = DisguiseParser.getOptions(perm);
                ((HashMap)list).put(map1.keySet().iterator().next(), map1.values().iterator().next());
                continue;
            }
            for (DisguisePerm type : DisguiseParser.getDisguisePerms()) {
                HashMap list;
                HashMap<ArrayList<String>, Boolean> options = null;
                entityClass = type.getEntityClass();
                if (disguiseType.equals("mob")) {
                    if (type.isMob()) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("animal") || disguiseType.equals("animals")) {
                    if (Animals.class.isAssignableFrom(entityClass)) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("monster") || disguiseType.equals("monsters")) {
                    if (Monster.class.isAssignableFrom(entityClass)) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("misc")) {
                    if (type.isMisc()) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("ageable")) {
                    if (Ageable.class.isAssignableFrom(entityClass)) {
                        options = DisguiseParser.getOptions(perm);
                    }
                } else if (disguiseType.equals("*")) {
                    options = DisguiseParser.getOptions(perm);
                }
                if (options == null) continue;
                if (rangeDisguises.containsKey(type)) {
                    list = (HashMap)rangeDisguises.get(type);
                } else {
                    list = new HashMap();
                    rangeDisguises.put(type, list);
                }
                HashMap<ArrayList<String>, Boolean> map1 = DisguiseParser.getOptions(perm);
                list.put(map1.keySet().iterator().next(), map1.values().iterator().next());
            }
        }
        for (String perm : perms.keySet()) {
            if (((Boolean)perms.get(perm)).booleanValue()) continue;
            disguiseType = (perm = perm.substring(permissionNode.length())).split("\\.")[0];
            DisguisePerm dType = DisguiseParser.getDisguisePerm(disguiseType);
            if (dType != null) {
                singleDisguises.remove(dType);
                rangeDisguises.remove(dType);
                continue;
            }
            for (DisguisePerm type : DisguiseParser.getDisguisePerms()) {
                boolean foundHim = false;
                entityClass = type.getEntityClass();
                switch (disguiseType) {
                    case "mob": {
                        if (!type.isMob()) break;
                        foundHim = true;
                        break;
                    }
                    case "animal": 
                    case "animals": {
                        if (!Animals.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "monster": 
                    case "monsters": {
                        if (!Monster.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "misc": {
                        if (!type.isMisc()) break;
                        foundHim = true;
                        break;
                    }
                    case "ageable": {
                        if (!Ageable.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "*": {
                        foundHim = true;
                    }
                }
                if (!foundHim) continue;
                rangeDisguises.remove(type);
            }
        }
        HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = new HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>>();
        for (DisguisePerm type : DisguiseParser.getDisguisePerms()) {
            HashMap temp = new HashMap();
            if (singleDisguises.containsKey(type)) {
                temp.putAll((Map)singleDisguises.get(type));
            }
            if (rangeDisguises.containsKey(type)) {
                temp.putAll((Map)rangeDisguises.get(type));
            }
            if (temp.isEmpty()) continue;
            map.put(type, temp);
        }
        return map;
    }

    private static boolean isDouble(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isNumeric(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Disguise parseDisguise(CommandSender sender, String permNode, String[] args, HashMap<DisguisePerm, HashMap<ArrayList<String>, Boolean>> permissionMap) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        HashMap<ArrayList<String>, Boolean> optionPermissions;
        if (permissionMap.isEmpty()) {
            throw new DisguiseParseException(ChatColor.RED + "You are forbidden to use this command.");
        }
        if (args.length == 0) {
            throw new DisguiseParseException("No arguments defined");
        }
        int toSkip = 1;
        ArrayList<String> usedOptions = new ArrayList<String>();
        Disguise disguise = null;
        if (args[0].startsWith("@")) {
            if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
                disguise = DisguiseUtilities.getClonedDisguise(args[0].toLowerCase());
                if (disguise == null) {
                    throw new DisguiseParseException(ChatColor.RED + "Cannot find a disguise under the reference " + args[0]);
                }
            } else {
                throw new DisguiseParseException(ChatColor.RED + "You do not have perimssion to use disguise references!");
            }
            optionPermissions = permissionMap.containsKey((Object)disguise.getType()) ? permissionMap.get((Object)disguise.getType()) : new HashMap();
        } else {
            DisguisePerm disguisePerm = DisguiseParser.getDisguisePerm(args[0]);
            Map.Entry<String, Disguise> customDisguise = DisguiseConfig.getCustomDisguise(args[0]);
            if (customDisguise != null) {
                disguise = customDisguise.getValue().clone();
            } else if (args[0].equalsIgnoreCase("p")) {
                disguisePerm = new DisguisePerm(DisguiseType.PLAYER);
            }
            if (disguisePerm == null) {
                throw new DisguiseParseException(ChatColor.RED + "Error! The disguise " + ChatColor.GREEN + args[0] + ChatColor.RED + " doesn't exist!");
            }
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(ChatColor.RED + "Error! You cannot disguise as " + ChatColor.GREEN + "Unknown!");
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(ChatColor.RED + "Error! This disguise couldn't be loaded!");
            }
            if (!permissionMap.containsKey(disguisePerm)) {
                throw new DisguiseParseException(ChatColor.RED + "You are forbidden to use this disguise.");
            }
            optionPermissions = permissionMap.get(disguisePerm);
            HashMap<String, Boolean> disguiseOptions = DisguiseParser.getDisguiseOptions(sender, permNode, disguisePerm);
            if (disguise == null) {
                if (disguisePerm.isPlayer()) {
                    if (args.length == 1) {
                        throw new DisguiseParseException(ChatColor.RED + "Error! You need to give a player name!");
                    }
                    if (!(disguiseOptions.isEmpty() || disguiseOptions.containsKey(args[1].toLowerCase()) && disguiseOptions.get(args[1].toLowerCase()).booleanValue())) {
                        throw new DisguiseParseException(ChatColor.RED + "Error! You don't have permission to use that name!");
                    }
                    args[1] = args[1].replace("\\_", " ");
                    disguise = new PlayerDisguise(ChatColor.translateAlternateColorCodes((char)'&', (String)args[1]));
                    ++toSkip;
                } else if (disguisePerm.isMob()) {
                    boolean adult = true;
                    if (args.length > 1 && (args[1].equalsIgnoreCase("baby") || args[1].equalsIgnoreCase("adult"))) {
                        usedOptions.add("setbaby");
                        DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        adult = args[1].equalsIgnoreCase("adult");
                        ++toSkip;
                    }
                    disguise = new MobDisguise(disguisePerm.getType(), adult);
                } else if (disguisePerm.isMisc()) {
                    int miscId = -1;
                    int miscData = -1;
                    String secondArg = null;
                    if (args.length > 1) {
                        if (args[1].contains(":")) {
                            String[] split = args[1].split(":");
                            if (DisguiseParser.isNumeric(split[1])) {
                                secondArg = split[1];
                            }
                            args[1] = split[0];
                        }
                        if (DisguiseParser.isNumeric(args[1])) {
                            miscId = Integer.parseInt(args[1]);
                        } else if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK || disguisePerm.getType() == DisguiseType.DROPPED_ITEM) {
                            for (String string : Material.values()) {
                                if (!string.name().replace("_", "").equalsIgnoreCase(args[1].replace("_", ""))) continue;
                                miscId = string.getId();
                                break;
                            }
                        }
                        if (miscId != -1) {
                            switch (disguisePerm.getType()) {
                                case FALLING_BLOCK: 
                                case PAINTING: 
                                case SPLASH_POTION: 
                                case FISHING_HOOK: 
                                case DROPPED_ITEM: 
                                case ARROW: 
                                case TIPPED_ARROW: 
                                case SPECTRAL_ARROW: 
                                case SMALL_FIREBALL: 
                                case FIREBALL: 
                                case WITHER_SKULL: {
                                    break;
                                }
                                default: {
                                    throw new DisguiseParseException(ChatColor.RED + "Error! " + disguisePerm.toReadable() + " doesn't know what to do with " + args[1] + "!");
                                }
                            }
                            ++toSkip;
                            if (args.length > 2 && secondArg == null && DisguiseParser.isNumeric(args[2])) {
                                secondArg = args[2];
                                ++toSkip;
                            }
                            if (secondArg != null) {
                                if (disguisePerm.getType() != DisguiseType.FALLING_BLOCK && disguisePerm.getType() != DisguiseType.DROPPED_ITEM) {
                                    throw new DisguiseParseException(ChatColor.RED + "Error! Only the disguises " + DisguiseType.FALLING_BLOCK.toReadable() + " and " + DisguiseType.DROPPED_ITEM.toReadable() + " uses a second number!");
                                }
                                miscData = Integer.parseInt(secondArg);
                            }
                        }
                    }
                    if (!disguiseOptions.isEmpty() && miscId != -1) {
                        String toCheck = "" + miscId;
                        if (miscData == 0 || miscData == -1) {
                            if (!disguiseOptions.containsKey(toCheck) || !disguiseOptions.get(toCheck).booleanValue()) {
                                toCheck = toCheck + ":0";
                            }
                        } else {
                            toCheck = toCheck + ":" + miscData;
                        }
                        if (!disguiseOptions.containsKey(toCheck) || !disguiseOptions.get(toCheck).booleanValue()) {
                            throw new DisguiseParseException(ChatColor.RED + "Error! You do not have permission to use the parameter " + toCheck + " on the " + disguisePerm.toReadable() + " disguise!");
                        }
                    }
                    if (miscId != -1) {
                        if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                            usedOptions.add("setblock");
                            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        } else if (disguisePerm.getType() == DisguiseType.PAINTING) {
                            usedOptions.add("setpainting");
                            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        } else if (disguisePerm.getType() == DisguiseType.SPLASH_POTION) {
                            usedOptions.add("setpotionid");
                            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
                        }
                    }
                    disguise = new MiscDisguise(disguisePerm.getType(), miscId, miscData);
                }
            }
        }
        String[] newArgs = new String[args.length - toSkip];
        System.arraycopy(args, toSkip, newArgs, 0, args.length - toSkip);
        DisguiseParser.callMethods(sender, disguise, optionPermissions, usedOptions, newArgs);
        return disguise;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void callMethods(CommandSender sender, Disguise disguise, HashMap<ArrayList<String>, Boolean> optionPermissions, ArrayList<String> usedOptions, String[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DisguiseParseException {
        Method[] methods = ReflectionFlagWatchers.getDisguiseWatcherMethods(disguise.getWatcher().getClass());
        for (int i = 0; i < args.length; i += 2) {
            void var10_10;
            String methodName = args[i];
            String valueString = args.length - 1 == i ? null : args[i + 1];
            Method methodToUse = null;
            Object var10_11 = null;
            DisguiseParseException storedEx = null;
            int c = 0;
            while (c < methods.length) {
                try {
                    Class<?> param;
                    block81: {
                        Map.Entry<Method, Integer> entry = DisguiseParser.getMethod(methods, methodName, c);
                        if (entry == null) break;
                        methodToUse = entry.getKey();
                        c = entry.getValue();
                        methodName = methodToUse.getName();
                        Class<?>[] types = methodToUse.getParameterTypes();
                        param = types[0];
                        if (valueString != null) {
                            if (Integer.TYPE == param) {
                                if (!DisguiseParser.isNumeric(valueString)) throw DisguiseParser.parseToException("number", valueString, methodName);
                                Integer n = Integer.parseInt(valueString);
                            } else {
                                if (WrappedGameProfile.class == param && valueString.length() > 20) {
                                    try {
                                        WrappedGameProfile wrappedGameProfile = ReflectionManager.parseGameProfile(valueString);
                                    }
                                    catch (Exception ex) {
                                        throw DisguiseParser.parseToException("gameprofile", valueString, methodName);
                                    }
                                }
                                if (Float.TYPE == param || Double.TYPE == param) {
                                    if (!DisguiseParser.isDouble(valueString)) throw DisguiseParser.parseToException("number.0", valueString, methodName);
                                    float obj = Float.parseFloat(valueString);
                                    if (param == Float.TYPE) {
                                        Float f = Float.valueOf(obj);
                                    } else if (param == Double.TYPE) {
                                        Double d = obj;
                                    }
                                } else if (param == String.class) {
                                    if (methodName.equalsIgnoreCase("setskin") && valueString.length() > 20) {
                                        String string = valueString;
                                    } else {
                                        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)valueString);
                                    }
                                } else {
                                    if (param == AnimalColor.class) {
                                        try {
                                            AnimalColor animalColor = AnimalColor.valueOf(valueString.toUpperCase());
                                        }
                                        catch (Exception ex) {
                                            throw DisguiseParser.parseToException("animal color", valueString, methodName);
                                        }
                                    }
                                    if (param == Llama.Color.class) {
                                        try {
                                            Llama.Color color = Llama.Color.valueOf((String)valueString.toUpperCase());
                                        }
                                        catch (Exception ex) {
                                            throw DisguiseParser.parseToException("llama color", valueString, methodName);
                                        }
                                    }
                                    if (param == ItemStack.class) {
                                        try {
                                            ItemStack itemStack = DisguiseParser.parseToItemstack(valueString);
                                        }
                                        catch (Exception ex) {
                                            throw new DisguiseParseException(String.format(ex.getMessage(), methodName));
                                        }
                                    }
                                    if (param == ItemStack[].class) {
                                        ItemStack[] items = new ItemStack[4];
                                        String[] split = valueString.split(",");
                                        if (split.length != 4) throw DisguiseParser.parseToException("item ID,ID,ID,ID" + ChatColor.RED + " or " + ChatColor.GREEN + "ID:Data,ID:Data,ID:Data,ID:Data combo", valueString, methodName);
                                        for (int a = 0; a < 4; ++a) {
                                            try {
                                                items[a] = DisguiseParser.parseToItemstack(split[a]);
                                                continue;
                                            }
                                            catch (Exception ex) {
                                                throw DisguiseParser.parseToException("item ID,ID,ID,ID" + ChatColor.RED + " or " + ChatColor.GREEN + "ID:Data,ID:Data,ID:Data,ID:Data combo", valueString, methodName);
                                            }
                                        }
                                        ItemStack[] itemStackArray = items;
                                    } else if (param.getSimpleName().equals("Color")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName, "a horse color");
                                    } else if (param.getSimpleName().equals("Style")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName, "a horse style");
                                    } else if (param.getSimpleName().equals("Profession")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName, "a villager profession");
                                    } else if (param.getSimpleName().equals("Art")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName, "a painting art");
                                    } else if (param.getSimpleName().equals("Type")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName, "a ocelot type");
                                    } else if (param.getSimpleName().equals("TreeSpecies")) {
                                        Object object = DisguiseParser.callValueOf(param, valueString, methodName, "a tree species");
                                    } else {
                                        if (param == PotionEffectType.class) {
                                            try {
                                                PotionEffectType potionType = PotionEffectType.getByName((String)valueString.toUpperCase());
                                                if (potionType == null && DisguiseParser.isNumeric(valueString)) {
                                                    potionType = PotionEffectType.getById((int)Integer.parseInt(valueString));
                                                }
                                                if (potionType == null) {
                                                    throw new DisguiseParseException();
                                                }
                                                PotionEffectType potionEffectType = potionType;
                                            }
                                            catch (Exception ex) {
                                                throw DisguiseParser.parseToException("a potioneffect type", valueString, methodName);
                                            }
                                        }
                                        if (param == int[].class) {
                                            String[] split = valueString.split(",");
                                            int[] values = new int[split.length];
                                            for (int b = 0; b < values.length; ++b) {
                                                try {
                                                    values[b] = Integer.parseInt(split[b]);
                                                    continue;
                                                }
                                                catch (NumberFormatException ex) {
                                                    throw DisguiseParser.parseToException("Number,Number,Number...", valueString, methodName);
                                                }
                                            }
                                            int[] nArray = values;
                                        } else {
                                            if (param == BlockFace.class) {
                                                try {
                                                    BlockFace face = BlockFace.valueOf((String)valueString.toUpperCase());
                                                    if (face.ordinal() > 5) {
                                                        throw new DisguiseParseException();
                                                    }
                                                    BlockFace blockFace = face;
                                                }
                                                catch (Exception ex) {
                                                    throw DisguiseParser.parseToException("a direction (north, east, south, west, up, down)", valueString, methodName);
                                                }
                                            }
                                            if (param == RabbitType.class) {
                                                try {
                                                    for (RabbitType type : RabbitType.values()) {
                                                        if (!type.name().replace("_", "").equalsIgnoreCase(valueString.replace("_", "").replace(" ", ""))) continue;
                                                        RabbitType rabbitType = type;
                                                        break;
                                                    }
                                                    if (var10_10 == null) {
                                                        throw new Exception();
                                                    }
                                                    break block81;
                                                }
                                                catch (Exception ex) {
                                                    throw DisguiseParser.parseToException("rabbit type (white, brown, patches...)", valueString, methodName);
                                                }
                                            }
                                            if (param == BlockPosition.class) {
                                                try {
                                                    String[] split = valueString.split(",");
                                                    assert (split.length == 3);
                                                    BlockPosition blockPosition = new BlockPosition(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                                                }
                                                catch (Exception ex) {
                                                    throw DisguiseParser.parseToException("three numbers Number,Number,Number", valueString, methodName);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (var10_10 == null && Boolean.TYPE == param) {
                        if (valueString == null) {
                            Boolean bl = true;
                            --i;
                        } else if (valueString.equalsIgnoreCase("true")) {
                            Boolean bl = true;
                        } else if (valueString.equalsIgnoreCase("false")) {
                            Boolean bl = false;
                        } else {
                            if (DisguiseParser.getMethod(methods, valueString, 0) == null) {
                                throw DisguiseParser.parseToException("true/false", valueString, methodName);
                            }
                            Boolean bl = true;
                            --i;
                        }
                    }
                    if (var10_10 == null) continue;
                    break;
                }
                catch (DisguiseParseException ex) {
                    storedEx = ex;
                    methodToUse = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    methodToUse = null;
                }
            }
            if (methodToUse == null) {
                if (storedEx == null) throw new DisguiseParseException(ChatColor.RED + "Cannot find the option " + methodName);
                throw storedEx;
            }
            if (var10_10 == null) {
                throw new DisguiseParseException(ChatColor.RED + "No value was given for the option " + methodName);
            }
            if (!usedOptions.contains(methodName.toLowerCase())) {
                usedOptions.add(methodName.toLowerCase());
            }
            DisguiseParser.doCheck(sender, optionPermissions, usedOptions);
            if (FlagWatcher.class.isAssignableFrom(methodToUse.getDeclaringClass())) {
                methodToUse.invoke((Object)disguise.getWatcher(), var10_10);
                continue;
            }
            methodToUse.invoke((Object)disguise, var10_10);
        }
    }

    private static DisguiseParseException parseToException(String expectedValue, String receivedInstead, String methodName) {
        return new DisguiseParseException(ChatColor.RED + "Expected " + ChatColor.GREEN + expectedValue + ChatColor.RED + ", received " + ChatColor.GREEN + receivedInstead + ChatColor.RED + " instead for " + ChatColor.GREEN + methodName);
    }

    private static ItemStack parseToItemstack(String string) throws Exception {
        String[] split = string.split(":", -1);
        int itemId = -1;
        if (DisguiseParser.isNumeric(split[0])) {
            itemId = Integer.parseInt(split[0]);
        } else {
            try {
                itemId = Material.valueOf((String)split[0].toUpperCase()).getId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (itemId != -1) {
            short itemDura = 0;
            if (split.length > 1) {
                if (DisguiseParser.isNumeric(split[1])) {
                    itemDura = Short.parseShort(split[1]);
                } else {
                    throw DisguiseParser.parseToException("item ID:Durability combo", string, "%s");
                }
            }
            return new ItemStack(itemId, 1, itemDura);
        }
        if (split.length == 1) {
            throw DisguiseParser.parseToException("item ID", string, "%s");
        }
        throw DisguiseParser.parseToException("item ID:Durability combo", string, "%s");
    }

    public static boolean passesCheck(CommandSender sender, HashMap<ArrayList<String>, Boolean> theirPermissions, ArrayList<String> usedOptions) {
        boolean hasPermission = false;
        for (ArrayList<String> list : theirPermissions.keySet()) {
            boolean myPerms = true;
            for (String option : usedOptions) {
                if (!sender.getName().equals("CONSOLE") && option.equalsIgnoreCase("setInvisible") && DisguiseConfig.isDisabledInvisibility()) {
                    myPerms = false;
                }
                if (theirPermissions.get(list).booleanValue() && list.contains("*") || list.contains(option) == theirPermissions.get(list).booleanValue()) continue;
                myPerms = false;
                break;
            }
            if (!myPerms) continue;
            hasPermission = true;
        }
        return hasPermission;
    }

    public static class DisguisePerm {
        private DisguiseType disguiseType;
        private String permName;

        public DisguisePerm(DisguiseType disguiseType) {
            this.disguiseType = disguiseType;
        }

        public DisguisePerm(DisguiseType disguiseType, String disguisePerm) {
            this.disguiseType = disguiseType;
            this.permName = disguisePerm;
        }

        public Class getEntityClass() {
            return this.getType().getEntityClass();
        }

        public EntityType getEntityType() {
            return this.getType().getEntityType();
        }

        public DisguiseType getType() {
            return this.disguiseType;
        }

        public Class<? extends FlagWatcher> getWatcherClass() {
            return this.getType().getWatcherClass();
        }

        public boolean isMisc() {
            return this.getType().isMisc();
        }

        public boolean isMob() {
            return this.getType().isMob();
        }

        public boolean isPlayer() {
            return this.getType().isPlayer();
        }

        public boolean isUnknown() {
            return this.getType().isUnknown();
        }

        public String name() {
            return this.permName == null ? this.getType().name() : this.permName;
        }

        public String toReadable() {
            return this.permName == null ? this.getType().toReadable() : this.permName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.disguiseType == null ? 0 : this.disguiseType.hashCode());
            result = 31 * result + (this.permName == null ? 0 : this.permName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DisguisePerm)) {
                return false;
            }
            DisguisePerm other = (DisguisePerm)obj;
            if (this.disguiseType != other.disguiseType) {
                return false;
            }
            return !(this.permName == null ? other.permName != null : !this.permName.equals(other.permName));
        }
    }

    public static class DisguiseParseException
    extends Exception {
        private static final long serialVersionUID = 1276971370793124510L;

        public DisguiseParseException() {
        }

        public DisguiseParseException(String string) {
            super(string);
        }
    }
}

