/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.ClassGetter;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.craftbukkit.v1_11_R1.command.CraftBlockCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisguiseRadiusCommand
extends DisguiseBaseCommand
implements TabCompleter {
    private int maxRadius = 30;
    private ArrayList<Class<? extends Entity>> validClasses = new ArrayList();

    public DisguiseRadiusCommand(int maxRadius) {
        this.maxRadius = maxRadius;
        for (Class<?> c : ClassGetter.getClassesForPackage("org.bukkit.entity")) {
            if (c == Entity.class || !Entity.class.isAssignableFrom(c) || c.getAnnotation(Deprecated.class) != null) continue;
            this.validClasses.add(c);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(ChatColor.RED + "You may not use this command from the console!");
            return true;
        }
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = this.getPermissions(sender);
        if (map.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        if (args[0].equalsIgnoreCase("entitytype") || args[0].equalsIgnoreCase("entitytypes")) {
            ArrayList<String> classes = new ArrayList<String>();
            for (Class<? extends Entity> c : this.validClasses) {
                classes.add(c.getSimpleName());
            }
            Collections.sort(classes);
            sender.sendMessage(ChatColor.DARK_GREEN + "EntityTypes usable are: " + ChatColor.GREEN + StringUtils.join(classes, (String)(ChatColor.DARK_GREEN + ", " + ChatColor.GREEN)) + ChatColor.DARK_GREEN + ".");
            return true;
        }
        Class<Entity> entityClass = Entity.class;
        EntityType type = null;
        int starting = 0;
        if (!this.isNumeric(args[0])) {
            for (Class<? extends Entity> c : this.validClasses) {
                if (!c.getSimpleName().equalsIgnoreCase(args[0])) continue;
                entityClass = c;
                starting = 1;
                break;
            }
            if (starting == 0) {
                try {
                    type = EntityType.valueOf((String)args[0].toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type == null) {
                    sender.sendMessage(ChatColor.RED + "Unrecognised EntityType " + args[0]);
                    return true;
                }
            }
        }
        if (args.length == starting + 1) {
            sender.sendMessage(ChatColor.RED + "You need to supply a disguise as well as the radius" + (starting != 0 ? " and EntityType" : ""));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "You need to supply a radius as well as the disguise");
            return true;
        }
        if (!this.isNumeric(args[starting])) {
            sender.sendMessage(ChatColor.RED + args[starting] + " is not a number");
            return true;
        }
        int radius = Integer.parseInt(args[starting]);
        if (radius > this.maxRadius) {
            sender.sendMessage(ChatColor.RED + "Limited radius to " + this.maxRadius + "! Don't want to make too much lag right?");
            radius = this.maxRadius;
        }
        String[] newArgs = new String[args.length - (starting + 1)];
        System.arraycopy(args, starting + 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, this.getPermNode(), newArgs, map);
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        int disguisedEntitys = 0;
        int miscDisguises = 0;
        Location center = sender instanceof Player ? ((Player)sender).getLocation() : ((CraftBlockCommandSender)sender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        for (Entity entity : center.getWorld().getNearbyEntities(center, (double)radius, (double)radius, (double)radius)) {
            if (entity == sender || !(type != null ? entity.getType() == type : entityClass.isAssignableFrom(entity.getClass()))) continue;
            if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
                ++miscDisguises;
                continue;
            }
            disguise = disguise.clone();
            if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
                disguise.getWatcher().setCustomName(((Player)entity).getDisplayName());
                if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                    disguise.getWatcher().setCustomNameVisible(true);
                }
            }
            DisguiseAPI.disguiseToAll(entity, disguise);
            if (!disguise.isDisguiseInUse()) continue;
            ++disguisedEntitys;
        }
        if (disguisedEntitys > 0) {
            sender.sendMessage(ChatColor.RED + "Successfully disguised " + disguisedEntitys + " entities!");
        } else {
            sender.sendMessage(ChatColor.RED + "Couldn't find any entities to disguise!");
        }
        if (miscDisguises > 0) {
            sender.sendMessage(ChatColor.RED + "Failed to disguise " + miscDisguises + " entities because the option to disguise a living entity as a non-living has been disabled in the config");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs;
        block21: {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            DisguiseParser.DisguisePerm disguiseType;
            int starting;
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms;
            String[] args;
            block22: {
                block20: {
                    tabs = new ArrayList<String>();
                    args = this.getArgs(origArgs);
                    perms = this.getPermissions(sender);
                    if (args.length == 0) {
                        for (Class<? extends Entity> entityClass : this.validClasses) {
                            tabs.add(entityClass.getSimpleName());
                        }
                        return this.filterTabs(tabs, origArgs);
                    }
                    starting = 1;
                    if (!this.isNumeric(args[0])) {
                        for (Class<? extends Entity> clazz : this.validClasses) {
                            if (!clazz.getSimpleName().equalsIgnoreCase(args[0])) continue;
                            starting = 2;
                            break;
                        }
                        if (starting == 1 || args.length == 1 || !this.isNumeric(args[1])) {
                            return this.filterTabs(tabs, origArgs);
                        }
                    }
                    if (args.length != starting) break block20;
                    for (String string : this.getAllowedDisguises(perms)) {
                        tabs.add(string);
                    }
                    break block21;
                }
                disguiseType = DisguiseParser.getDisguisePerm(args[starting]);
                if (disguiseType == null) {
                    return this.filterTabs(tabs, origArgs);
                }
                if (args.length != 1 + starting || disguiseType.getType() != DisguiseType.PLAYER) break block22;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tabs.add(player.getName());
                }
                break block21;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                int i;
                int n = i = disguiseType.getType() == DisguiseType.PLAYER ? starting + 2 : starting + 1;
                while (i < args.length) {
                    String arg = args[i];
                    if (method.getName().equalsIgnoreCase(arg)) {
                        arrayList.add(arg);
                    }
                    ++i;
                }
            }
            if (!this.passesCheck(sender, perms.get(disguiseType), arrayList)) break block21;
            boolean addMethods = true;
            if (args.length > 1 + starting && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    for (String e : info.getEnums(origArgs[origArgs.length - 1])) {
                        tabs.add(e);
                    }
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(ChatColor.DARK_GREEN + "Disguise all entities in a radius! Caps at " + this.maxRadius + " blocks!");
        sender.sendMessage(ChatColor.DARK_GREEN + "You can use the disguises: " + ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
        String optional = ChatColor.DARK_GREEN + "(" + ChatColor.GREEN + "Optional" + ChatColor.DARK_GREEN + ")";
        if (allowedDisguises.contains("player")) {
            sender.sendMessage((ChatColor.DARK_GREEN + "/disguiseradius <EntityType" + optional + "> <Radius> player <Name>").replace("<", "<" + ChatColor.GREEN).replace(">", ChatColor.DARK_GREEN + ">"));
        }
        sender.sendMessage((ChatColor.DARK_GREEN + "/disguiseradius <EntityType" + optional + "> <Radius> <DisguiseType> <Baby" + optional + ">").replace("<", "<" + ChatColor.GREEN).replace(">", ChatColor.DARK_GREEN + ">"));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage((ChatColor.DARK_GREEN + "/disguiseradius <EntityType" + optional + "> <Radius> <Dropped_Item/Falling_Block> <Id> <Durability" + optional + ">").replace("<", "<" + ChatColor.GREEN).replace(">", ChatColor.DARK_GREEN + ">"));
        }
        sender.sendMessage(ChatColor.DARK_GREEN + "See the EntityType's usable by " + ChatColor.GREEN + "/disguiseradius EntityTypes");
    }
}

