/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.ClassGetter;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.craftbukkit.v1_11_R1.command.CraftBlockCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class DisguiseModifyRadiusCommand
extends DisguiseBaseCommand
implements TabCompleter {
    private int maxRadius = 30;
    private ArrayList<Class<? extends Entity>> validClasses = new ArrayList();

    public DisguiseModifyRadiusCommand(int maxRadius) {
        this.maxRadius = maxRadius;
        for (Class<?> c : ClassGetter.getClassesForPackage("org.bukkit.entity")) {
            if (c == Entity.class || !Entity.class.isAssignableFrom(c) || c.getAnnotation(Deprecated.class) != null) continue;
            this.validClasses.add(c);
        }
    }

    private Collection<Entity> getNearbyEntities(CommandSender sender, int radius) {
        Location center = sender instanceof Player ? ((Player)sender).getLocation() : ((CraftBlockCommandSender)sender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        return center.getWorld().getNearbyEntities(center, (double)radius, (double)radius, (double)radius);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(ChatColor.RED + "You may not use this command from the console!");
            return true;
        }
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = this.getPermissions(sender);
        if (map.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        if (args[0].equalsIgnoreCase("entitytype") || args[0].equalsIgnoreCase("entitytypes")) {
            ArrayList<String> classes = new ArrayList<String>();
            for (Class<? extends Entity> c : this.validClasses) {
                classes.add(c.getSimpleName());
            }
            Collections.sort(classes);
            sender.sendMessage(ChatColor.DARK_GREEN + "EntityTypes usable are: " + ChatColor.GREEN + StringUtils.join(classes, (String)(ChatColor.DARK_GREEN + ", " + ChatColor.GREEN)) + ChatColor.DARK_GREEN + ".");
            return true;
        }
        Class<Entity> entityClass = Entity.class;
        EntityType type = null;
        int starting = 0;
        if (!this.isNumeric(args[0])) {
            for (Class<? extends Entity> c : this.validClasses) {
                if (!c.getSimpleName().equalsIgnoreCase(args[0])) continue;
                entityClass = c;
                starting = 1;
                break;
            }
            if (starting == 0) {
                try {
                    type = EntityType.valueOf((String)args[0].toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type == null) {
                    sender.sendMessage(ChatColor.RED + "Unrecognised EntityType " + args[0]);
                    return true;
                }
            }
        }
        if (args.length == starting + 1) {
            sender.sendMessage(ChatColor.RED + "You need to supply the disguise options as well as the radius" + (starting != 0 ? " and EntityType" : ""));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "You need to supply a radius as well as the disguise options");
            return true;
        }
        if (!this.isNumeric(args[starting])) {
            sender.sendMessage(ChatColor.RED + args[starting] + " is not a number");
            return true;
        }
        int radius = Integer.parseInt(args[starting]);
        if (radius > this.maxRadius) {
            sender.sendMessage(ChatColor.RED + "Limited radius to " + this.maxRadius + "! Don't want to make too much lag right?");
            radius = this.maxRadius;
        }
        String[] newArgs = new String[args.length - (starting + 1)];
        System.arraycopy(args, starting + 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        int modifiedDisguises = 0;
        int noPermission = 0;
        for (Entity entity : this.getNearbyEntities(sender, radius)) {
            if (entity == sender || (type == null ? !entityClass.isAssignableFrom(entity.getClass()) : entity.getType() != type)) continue;
            Disguise disguise = sender instanceof Player ? DisguiseAPI.getDisguise((Player)sender, entity) : DisguiseAPI.getDisguise(entity);
            if (!map.containsKey(new DisguiseParser.DisguisePerm(disguise.getType()))) {
                ++noPermission;
                continue;
            }
            try {
                DisguiseParser.callMethods(sender, disguise, map.get(new DisguiseParser.DisguisePerm(disguise.getType())), new ArrayList<String>(), newArgs);
                ++modifiedDisguises;
            }
            catch (DisguiseParser.DisguiseParseException ex) {
                if (ex.getMessage() != null) {
                    sender.sendMessage(ex.getMessage());
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return true;
            }
        }
        if (noPermission > 0) {
            sender.sendMessage(ChatColor.RED + "No permission to modify " + noPermission + " disguises!");
        }
        if (modifiedDisguises > 0) {
            sender.sendMessage(ChatColor.RED + "Successfully modified the disguises of " + modifiedDisguises + " entities!");
        } else {
            sender.sendMessage(ChatColor.RED + "Couldn't find any disguised entities!");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        int radius;
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms = this.getPermissions(sender);
        if (args.length == 0) {
            for (Class<? extends Entity> entityClass : this.validClasses) {
                tabs.add(entityClass.getSimpleName());
            }
            return this.filterTabs(tabs, origArgs);
        }
        int starting = 1;
        if (!this.isNumeric(args[0])) {
            for (Class<? extends Entity> c : this.validClasses) {
                if (!c.getSimpleName().equalsIgnoreCase(args[0])) continue;
                starting = 2;
                break;
            }
            if (starting == 1 || args.length == 1 || !this.isNumeric(args[1])) {
                return this.filterTabs(tabs, origArgs);
            }
        }
        if ((radius = Integer.parseInt(args[starting])) > this.maxRadius) {
            sender.sendMessage(ChatColor.RED + "Limited radius to " + this.maxRadius + "! Don't want to make too much lag right?");
            radius = this.maxRadius;
        }
        ArrayList<String> usedOptions = new ArrayList<String>();
        for (Entity entity : this.getNearbyEntities(sender, radius)) {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            int i;
            Disguise disguise = DisguiseAPI.getDisguise(entity);
            if (disguise == null) continue;
            DisguiseType disguiseType = disguise.getType();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                for (i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (!method.getName().equalsIgnoreCase(arg)) continue;
                    usedOptions.add(arg);
                }
            }
            if (!this.passesCheck(sender, perms.get((Object)disguiseType), usedOptions)) continue;
            boolean addMethods = true;
            if (args.length > 1 + starting && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    String[] stringArray = info.getEnums(origArgs[origArgs.length - 1]);
                    i = stringArray.length;
                    for (int j = 0; j < i; ++j) {
                        String e = stringArray[j];
                        tabs.add(e);
                    }
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (!addMethods) continue;
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                tabs.add(method.getName());
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(ChatColor.DARK_GREEN + "Modify the disguises in a radius! Caps at " + this.maxRadius + " blocks!");
        sender.sendMessage(ChatColor.DARK_GREEN + "You can modify the disguises: " + ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
        String optional = ChatColor.DARK_GREEN + "(" + ChatColor.GREEN + "Optional" + ChatColor.DARK_GREEN + ")";
        if (allowedDisguises.contains("player")) {
            sender.sendMessage((ChatColor.DARK_GREEN + "/disguiseradius <EntityType" + optional + "> <Radius> player <Name>").replace("<", "<" + ChatColor.GREEN).replace(">", ChatColor.DARK_GREEN + ">"));
        }
        sender.sendMessage((ChatColor.DARK_GREEN + "/disguiseradius <EntityType" + optional + "> <Radius> <DisguiseType> <Baby" + optional + ">").replace("<", "<" + ChatColor.GREEN).replace(">", ChatColor.DARK_GREEN + ">"));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage((ChatColor.DARK_GREEN + "/disguiseradius <EntityType" + optional + "> <Radius> <Dropped_Item/Falling_Block> <Id> <Durability" + optional + ">").replace("<", "<" + ChatColor.GREEN).replace(">", ChatColor.DARK_GREEN + ">"));
        }
        sender.sendMessage(ChatColor.DARK_GREEN + "See the EntityType's usable by " + ChatColor.GREEN + "/disguiseradius EntityTypes");
    }
}

