/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyPlayerCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = this.getPermissions(sender);
        if (map.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        Player player = Bukkit.getPlayer((String)args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Cannot find the player '" + args[0] + "'");
            return true;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, map);
            return true;
        }
        Disguise disguise = null;
        if (sender instanceof Player) {
            disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)player);
        }
        if (disguise == null) {
            disguise = DisguiseAPI.getDisguise((Entity)player);
        }
        if (disguise == null) {
            sender.sendMessage(ChatColor.RED + "The player '" + player.getName() + "' is not disguised");
            return true;
        }
        if (!map.containsKey(new DisguiseParser.DisguisePerm(disguise.getType()))) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to modify this disguise");
            return true;
        }
        try {
            DisguiseParser.callMethods(sender, disguise, map.get(new DisguiseParser.DisguisePerm(disguise.getType())), new ArrayList<String>(), newArgs);
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Modified the disguise of " + player.getName() + "!");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs;
        block18: {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms;
            String[] args;
            block17: {
                tabs = new ArrayList<String>();
                args = this.getArgs(origArgs);
                perms = this.getPermissions(sender);
                if (perms.isEmpty()) {
                    return tabs;
                }
                if (args.length != 0) break block17;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tabs.add(player.getName());
                }
                break block18;
            }
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Cannot find the player '" + args[0] + "'");
                return tabs;
            }
            Disguise disguise = null;
            if (sender instanceof Player) {
                disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)player);
            }
            if (disguise == null) {
                disguise = DisguiseAPI.getDisguise((Entity)player);
            }
            if (disguise == null) {
                sender.sendMessage(ChatColor.RED + "The player '" + player.getName() + "' is not disguised");
                return tabs;
            }
            DisguiseParser.DisguisePerm disguiseType = new DisguiseParser.DisguisePerm(disguise.getType());
            ArrayList<String> usedOptions = new ArrayList<String>();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (!method.getName().equalsIgnoreCase(arg)) continue;
                    usedOptions.add(arg);
                }
            }
            if (!this.passesCheck(sender, perms.get(disguiseType), usedOptions)) break block18;
            boolean addMethods = true;
            if (args.length > 1 && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    for (String e : info.getEnums(origArgs[origArgs.length - 1])) {
                        tabs.add(e);
                    }
                } else if (info.getParamClass() == String.class) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        tabs.add(p.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(ChatColor.DARK_GREEN + "Modify the disguise of another player!");
        sender.sendMessage(ChatColor.DARK_GREEN + "You can modify the disguises: " + ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
    }
}

