/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Entity)) {
            sender.sendMessage(ChatColor.RED + "You may not use this command from the console!");
            return true;
        }
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map = this.getPermissions(sender);
        if (map.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, this.getPermissions(sender));
            return true;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)sender);
        if (disguise == null) {
            sender.sendMessage(ChatColor.RED + "You are not disguised!");
            return true;
        }
        if (!map.containsKey(new DisguiseParser.DisguisePerm(disguise.getType()))) {
            sender.sendMessage(ChatColor.RED + "No permission to modify your disguise!");
            return true;
        }
        try {
            DisguiseParser.callMethods(sender, disguise, this.getPermissions(sender).get(new DisguiseParser.DisguisePerm(disguise.getType())), new ArrayList<String>(), args);
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Your disguise has been modified!");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return tabs;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)sender);
        if (disguise == null) {
            return tabs;
        }
        String[] args = this.getArgs(origArgs);
        HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms = this.getPermissions(sender);
        DisguiseParser.DisguisePerm disguiseType = new DisguiseParser.DisguisePerm(disguise.getType());
        ArrayList<String> usedOptions = new ArrayList<String>();
        for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            int i;
            int n = i = disguiseType.getType() == DisguiseType.PLAYER ? 2 : 1;
            while (i < args.length) {
                String arg = args[i];
                if (method.getName().equalsIgnoreCase(arg)) {
                    usedOptions.add(arg);
                }
                ++i;
            }
        }
        if (this.passesCheck(sender, perms.get(disguiseType), usedOptions)) {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            boolean addMethods = true;
            if (args.length > 1 && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    for (String e : info.getEnums(origArgs[origArgs.length - 1])) {
                        tabs.add(e);
                    }
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(ChatColor.DARK_GREEN + "Modify your own disguise as you wear it!");
        sender.sendMessage(ChatColor.DARK_GREEN + "/disguisemodify setBaby true setSprinting true");
        sender.sendMessage(ChatColor.DARK_GREEN + "You can modify the disguises: " + ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
    }
}

