/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DisguiseHelpCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        for (String node : new String[]{"disguise", "disguiseradius", "disguiseentity", "disguiseplayer"}) {
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> permMap = DisguiseParser.getPermissions(sender, "libsdisguises." + node + ".");
            if (permMap.isEmpty()) continue;
            if (args.length == 0) {
                this.sendCommandUsage(sender, null);
                return true;
            }
            ReflectionFlagWatchers.ParamInfo help = null;
            for (ReflectionFlagWatchers.ParamInfo s : ReflectionFlagWatchers.getParamInfos()) {
                String name = s.getName().replaceAll(" ", "");
                if (!args[0].equalsIgnoreCase(name) && !args[0].equalsIgnoreCase(name + "s")) continue;
                help = s;
                break;
            }
            if (help != null) {
                sender.sendMessage(ChatColor.RED + help.getName() + ": " + ChatColor.GREEN + StringUtils.join((Object[])help.getEnums(""), (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
                return true;
            }
            DisguiseParser.DisguisePerm type = DisguiseParser.getDisguisePerm(args[0]);
            if (type == null) {
                sender.sendMessage(ChatColor.RED + "Cannot find the disguise " + args[0]);
                return true;
            }
            if (!permMap.containsKey(type)) {
                sender.sendMessage(ChatColor.RED + "You do not have permission for that disguise!");
                return true;
            }
            ArrayList<String> methods = new ArrayList<String>();
            HashMap<String, ChatColor> map = new HashMap<String, ChatColor>();
            Class<? extends FlagWatcher> watcher = type.getWatcherClass();
            int ignored = 0;
            try {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(watcher)) {
                    Class<?> c;
                    ReflectionFlagWatchers.ParamInfo info;
                    if (args.length < 2 || !args[1].equalsIgnoreCase("show")) {
                        boolean allowed = false;
                        for (ArrayList<String> key : permMap.get(type).keySet()) {
                            if (permMap.get(type).get(key).booleanValue()) {
                                if (!key.contains("*") && !key.contains(method.getName().toLowerCase())) continue;
                                allowed = true;
                                break;
                            }
                            if (key.contains(method.getName().toLowerCase())) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) {
                            ++ignored;
                            continue;
                        }
                    }
                    if ((info = ReflectionFlagWatchers.getParamInfo(c = method.getParameterTypes()[0])) == null) continue;
                    ChatColor methodColor = ChatColor.YELLOW;
                    Class<?> declaring = method.getDeclaringClass();
                    if (declaring == LivingWatcher.class) {
                        methodColor = ChatColor.AQUA;
                    } else if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
                        methodColor = ChatColor.GRAY;
                    }
                    String str = method.getName() + ChatColor.DARK_RED + "(" + ChatColor.GREEN + info.getName() + ChatColor.DARK_RED + ")";
                    map.put(str, methodColor);
                    methods.add(str);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Collections.sort(methods, String.CASE_INSENSITIVE_ORDER);
            for (int i = 0; i < methods.size(); ++i) {
                methods.set(i, map.get(methods.get(i)) + (String)methods.get(i));
            }
            if (methods.isEmpty()) {
                methods.add(ChatColor.RED + "No options with permission to use");
            }
            sender.sendMessage(ChatColor.DARK_RED + type.toReadable() + " options: " + StringUtils.join(methods, (String)(ChatColor.DARK_RED + ", ")));
            if (ignored > 0) {
                sender.sendMessage(ChatColor.RED + "Ignored " + ignored + " options you do not have permission to use. Add 'show' to view unusable options.");
            }
            return true;
        }
        sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        for (String node : new String[]{"disguise", "disguiseradius", "disguiseentity", "disguiseplayer"}) {
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms = DisguiseParser.getPermissions(sender, "libsdisguises." + node + ".");
            if (args.length == 0) {
                for (DisguiseParser.DisguisePerm type : perms.keySet()) {
                    if (type.isUnknown()) continue;
                    tabs.add(type.toReadable().replaceAll(" ", "_"));
                }
                for (ReflectionFlagWatchers.ParamInfo s : ReflectionFlagWatchers.getParamInfos()) {
                    tabs.add(s.getName().replaceAll(" ", ""));
                }
                continue;
            }
            if (DisguiseParser.getDisguisePerm(args[0]) != null) continue;
            tabs.add("Show");
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        sender.sendMessage(ChatColor.RED + "/disguisehelp <DisguiseType> " + ChatColor.GREEN + "- View the options you can set on a disguise. Add 'show' to reveal the options you don't have permission to use");
        for (ReflectionFlagWatchers.ParamInfo s : ReflectionFlagWatchers.getParamInfos()) {
            sender.sendMessage(ChatColor.RED + "/disguisehelp " + s.getName().replaceAll(" ", "") + ChatColor.GREEN + " - " + s.getDescription());
        }
    }
}

