/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.ReflectionFlagWatchers;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisguiseEntityCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "You may not use this command from the console!");
            return true;
        }
        if (this.getPermissions(sender).isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, this.getPermissions(sender));
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, this.getPermNode(), args, this.getPermissions(sender));
        }
        catch (DisguiseParser.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            ex.printStackTrace();
            return true;
        }
        LibsDisguises.getInstance().getListener().setDisguiseEntity(sender.getName(), disguise);
        sender.sendMessage(ChatColor.RED + "Right click an entity in the next " + DisguiseConfig.getDisguiseEntityExpire() + " seconds to disguise it as a " + disguise.getType().toReadable() + "!");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs;
        block17: {
            String prevArg;
            ReflectionFlagWatchers.ParamInfo info;
            DisguiseParser.DisguisePerm disguiseType;
            HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> perms;
            String[] args;
            block18: {
                block16: {
                    tabs = new ArrayList<String>();
                    if (!(sender instanceof Player)) {
                        return tabs;
                    }
                    args = this.getArgs(origArgs);
                    perms = this.getPermissions(sender);
                    if (args.length != 0) break block16;
                    for (String type : this.getAllowedDisguises(perms)) {
                        tabs.add(type);
                    }
                    break block17;
                }
                disguiseType = DisguiseParser.getDisguisePerm(args[0]);
                if (disguiseType == null) {
                    return this.filterTabs(tabs, origArgs);
                }
                if (args.length != 1 || disguiseType.getType() != DisguiseType.PLAYER) break block18;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tabs.add(player.getName());
                }
                break block17;
            }
            ArrayList<String> usedOptions = new ArrayList<String>();
            for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                int i;
                int n = i = disguiseType.getType() == DisguiseType.PLAYER ? 2 : 1;
                while (i < args.length) {
                    String arg = args[i];
                    if (method.getName().equalsIgnoreCase(arg)) {
                        usedOptions.add(arg);
                    }
                    ++i;
                }
            }
            if (!this.passesCheck(sender, perms.get(disguiseType), usedOptions)) break block17;
            boolean addMethods = true;
            if (args.length > 1 && (info = ReflectionFlagWatchers.getParamInfo(disguiseType, prevArg = args[args.length - 1])) != null) {
                if (info.getParamClass() != Boolean.TYPE) {
                    addMethods = false;
                }
                if (info.isEnums()) {
                    for (String e : info.getEnums(origArgs[origArgs.length - 1])) {
                        tabs.add(e);
                    }
                } else if (info.getParamClass() == String.class) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        tabs.add(player.getName());
                    }
                }
            }
            if (addMethods) {
                for (Method method : ReflectionFlagWatchers.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                    tabs.add(method.getName());
                }
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(ChatColor.DARK_GREEN + "Choose a disguise then right click a entity to disguise it!");
        sender.sendMessage(ChatColor.DARK_GREEN + "You can use the disguises: " + ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(ChatColor.DARK_GREEN + "/disguiseentity player <Name>");
        }
        sender.sendMessage(ChatColor.DARK_GREEN + "/disguiseentity <DisguiseType> <Baby>");
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(ChatColor.DARK_GREEN + "/disguiseentity <Dropped_Item/Falling_Block> <Id> <Durability>");
        }
    }
}

