/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.utilities.DisguiseParser;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCloneCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(ChatColor.RED + "You may not use this command from the console!");
            return true;
        }
        if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
            int i;
            boolean doEquipment = true;
            boolean doSneak = false;
            boolean doSprint = false;
            Player player = null;
            if (args.length > 0) {
                player = Bukkit.getPlayerExact((String)args[0]);
            }
            int n = i = player == null ? 0 : 1;
            while (i < args.length) {
                String option = args[i];
                if (StringUtils.startsWithIgnoreCase((String)option, (String)"ignoreEquip") || StringUtils.startsWithIgnoreCase((String)option, (String)"ignoreEnquip")) {
                    doEquipment = false;
                } else if (option.equalsIgnoreCase("doSneakSprint")) {
                    doSneak = true;
                    doSprint = true;
                } else if (option.equalsIgnoreCase("doSneak")) {
                    doSneak = true;
                } else if (option.equalsIgnoreCase("doSprint")) {
                    doSprint = true;
                } else {
                    sender.sendMessage(ChatColor.DARK_RED + "Unknown option '" + option + "' - Valid options are 'IgnoreEquipment' 'DoSneakSprint' 'DoSneak' 'DoSprint'");
                    return true;
                }
                ++i;
            }
            Boolean[] options = new Boolean[]{doEquipment, doSneak, doSprint};
            if (player != null) {
                DisguiseUtilities.createClonedDisguise((Player)sender, (Entity)player, options);
            } else {
                LibsDisguises.getInstance().getListener().setDisguiseClone(sender.getName(), options);
                sender.sendMessage(ChatColor.RED + "Right click a entity in the next " + DisguiseConfig.getDisguiseCloneExpire() + " seconds to grab the disguise reference!");
            }
        } else {
            sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        if (args.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                tabs.add(player.getName());
            }
        }
        tabs.add("ignoreEquip");
        tabs.add("doSneakSprint");
        tabs.add("doSneak");
        tabs.add("doSprint");
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseParser.DisguisePerm, HashMap<ArrayList<String>, Boolean>> map) {
        sender.sendMessage(ChatColor.DARK_GREEN + "Right click a entity to get a disguise reference you can pass to other disguise commands!");
        sender.sendMessage(ChatColor.DARK_GREEN + "Security note: Any references you create will be available to all players able to use disguise references.");
        sender.sendMessage(ChatColor.DARK_GREEN + "/disguiseclone IgnoreEquipment" + ChatColor.DARK_GREEN + "(" + ChatColor.GREEN + "Optional" + ChatColor.DARK_GREEN + ")");
    }
}

