/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.LDGithub;
import me.libraryaddict.disguise.utilities.updates.LDJenkins;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final String resourceID;
    private final long started = System.currentTimeMillis();
    private PluginInformation lastDownload;
    private final AtomicBoolean downloading = new AtomicBoolean(false);
    private DisguiseUpdate update;
    private LDGithub githubUpdater = new LDGithub();
    private LDJenkins jenkinsUpdater = new LDJenkins();
    private String[] updateMessage = new String[0];

    public UpdateChecker(String resourceID) {
        this.resourceID = resourceID;
    }

    public boolean isServerLatestVersion() {
        return this.isOnLatestUpdate(false);
    }

    public boolean isOnLatestUpdate(boolean includeDownloaded) {
        boolean isRelease;
        if (this.getUpdate() == null) {
            return false;
        }
        boolean bl = includeDownloaded && this.getLastDownload() != null ? !this.getLastDownload().getVersion().contains("-SNAPSHOT") : (isRelease = LibsDisguises.getInstance().isReleaseBuild());
        if (this.getUpdate().isReleaseBuild() != isRelease) {
            return false;
        }
        String version = this.getUpdate().isReleaseBuild() ? (this.lastDownload != null && includeDownloaded ? this.lastDownload.getVersion() : LibsDisguises.getInstance().getDescription().getVersion()) : (this.lastDownload != null && includeDownloaded ? this.lastDownload.getBuildNumber() : LibsDisguises.getInstance().getBuildNo());
        return this.getUpdate() != null && this.getUpdate().getVersion().equals(version);
    }

    public boolean isDownloading() {
        return this.downloading.get();
    }

    public boolean isOldUpdate() {
        return this.getUpdate() == null || this.getUpdate().getFetched().before(new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L)));
    }

    public boolean isUsingReleaseBuilds() {
        DisguiseConfig.UpdatesBranch builds = DisguiseConfig.getUpdatesBranch();
        return builds == DisguiseConfig.UpdatesBranch.RELEASES || builds == DisguiseConfig.UpdatesBranch.SAME_BUILDS && DisguiseConfig.isUsingReleaseBuild();
    }

    public void notifyUpdate(CommandSender player) {
        if (!DisguiseConfig.isNotifyUpdate() || !player.hasPermission("libsdisguises.update")) {
            return;
        }
        if (this.updateMessage == null || this.updateMessage.length == 0) {
            return;
        }
        if (player instanceof Player) {
            player.sendMessage(this.updateMessage);
        } else {
            for (String s : this.updateMessage) {
                DisguiseUtilities.getLogger().info(s);
            }
        }
    }

    public void doAutoUpdateCheck() {
        try {
            DisguiseUpdate oldUpdate = this.getUpdate();
            this.updateMessage = new String[0];
            this.doUpdateCheck();
            if (this.isOnLatestUpdate(true) || oldUpdate != null && oldUpdate.getVersion().equals(this.getUpdate().getVersion())) {
                return;
            }
            this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
            if (DisguiseConfig.isAutoUpdate()) {
                this.grabJarDownload(this.getUpdate().getDownload());
                this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
            }
            Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.notifyUpdate((CommandSender)p);
                }
            });
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning(String.format("Failed to check for update: %s", ex.getMessage()));
        }
    }

    public PluginInformation doUpdate() {
        if (this.getUpdate() == null || this.getUpdate().getFetched().before(new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(6L)))) {
            this.doUpdateCheck();
        }
        if (this.getUpdate() == null) {
            return null;
        }
        return this.grabJarDownload(this.getUpdate().getDownload());
    }

    public LibsMsg doUpdateCheck() {
        this.downloading.set(false);
        try {
            this.update = null;
            this.update = this.isUsingReleaseBuilds() ? this.githubUpdater.getLatestRelease() : this.jenkinsUpdater.getLatestSnapshot();
        }
        finally {
            this.downloading.set(false);
        }
        if (this.getUpdate() == null) {
            return LibsMsg.UPDATE_FAILED;
        }
        if (this.getUpdate().isReleaseBuild()) {
            String currentVersion = LibsDisguises.getInstance().getDescription().getVersion();
            if (LibsDisguises.getInstance().isReleaseBuild() && !this.isNewerVersion(currentVersion, this.getUpdate().getVersion())) {
                return LibsMsg.UPDATE_ON_LATEST;
            }
            this.updateMessage = new String[]{LibsMsg.UPDATE_READY.get(currentVersion, this.getUpdate().getVersion()), LibsMsg.UPDATE_HOW.get(new Object[0])};
        } else {
            if (!this.getUpdate().getVersion().matches("[0-9]+")) {
                return LibsMsg.UPDATE_FAILED;
            }
            int newBuild = Integer.parseInt(this.getUpdate().getVersion());
            if (newBuild <= LibsDisguises.getInstance().getBuildNumber()) {
                return LibsMsg.UPDATE_ON_LATEST;
            }
            String build = LibsDisguises.getInstance().getBuildNo();
            this.updateMessage = new String[]{LibsMsg.UPDATE_READY_SNAPSHOT.get((build.matches("[0-9]+") ? "#" : "") + build, newBuild), LibsMsg.UPDATE_HOW.get(new Object[0])};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginInformation grabJarDownload(String urlString) {
        this.downloading.set(true);
        File dest = new File(Bukkit.getUpdateFolderFile(), LibsDisguises.getInstance().getFile().getName());
        DisguiseUtilities.getLogger().info("Now downloading build of Lib's Disguises from " + urlString + " to " + dest.getName());
        if (dest.exists()) {
            dest.delete();
        }
        dest.getParentFile().mkdirs();
        try {
            PluginInformation result;
            URL url = new URL(urlString);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            InputStream input = con.getInputStream();
            Object object = null;
            try {
                Files.copy(input, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (input != null) {
                    if (object != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        input.close();
                    }
                }
            }
            DisguiseUtilities.getLogger().info("Download success!");
            this.lastDownload = result = LibsPremium.getInformation(dest);
            this.updateMessage = new String[]{LibsMsg.UPDATE_SUCCESS.get(new Object[0]), LibsMsg.UPDATE_INFO.get(result.getVersion(), result.getBuildNumber(), result.getParsedBuildDate().toString(), result.getSize() / 1024L)};
            object = result;
            return object;
        }
        catch (Exception ex) {
            dest.delete();
            DisguiseUtilities.getLogger().warning("Failed to download snapshot build.");
            ex.printStackTrace();
        }
        finally {
            this.downloading.set(false);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchSpigotVersion() {
        try {
            URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceID);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                String version = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (version.isEmpty()) return null;
                String string = version;
                return string;
            }
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a update on spigot.");
        }
        return null;
    }

    private boolean isNewerVersion(String currentVersion, String newVersion) {
        int nVersion;
        int cVersion;
        currentVersion = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        newVersion = newVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        if (this.started + TimeUnit.HOURS.toMillis(6L) > System.currentTimeMillis() && currentVersion.matches("[0-9]+(\\.[0-9]+)*") && newVersion.matches("[0-9]+(\\.[0-9]+)*") && (cVersion = Integer.parseInt(currentVersion.replace(".", ""))) > (nVersion = Integer.parseInt(newVersion.replace(".", ""))) && nVersion + 3 > cVersion) {
            return false;
        }
        return !currentVersion.equals(newVersion);
    }

    public PluginInformation getLastDownload() {
        return this.lastDownload;
    }

    public DisguiseUpdate getUpdate() {
        return this.update;
    }

    public String[] getUpdateMessage() {
        return this.updateMessage;
    }
}

