/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.Arrays;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.plugin.Plugin;

public class PacketListenerDestroyEntity
extends PacketAdapter {
    public PacketListenerDestroyEntity(Plugin plugin) {
        super(plugin, new PacketType[]{PacketType.Play.Server.ENTITY_DESTROY});
    }

    public void onPacketSending(PacketEvent event) {
        int[] entityIds;
        int[] newEntityIds = entityIds = (int[])event.getPacket().getIntegerArrays().read(0);
        for (int entityId : entityIds) {
            int len;
            if (entityId == DisguiseAPI.getSelfDisguiseId()) {
                return;
            }
            Disguise disguise = DisguiseUtilities.getDisguise(event.getPlayer(), entityId);
            if (disguise == null || (len = disguise.getMultiNameLength()) == 0) continue;
            if (entityIds.length == newEntityIds.length && Arrays.stream(entityIds).anyMatch(id -> id == disguise.getArmorstandIds()[0])) {
                return;
            }
            newEntityIds = Arrays.copyOf(entityIds, entityIds.length + len);
            for (int a = 0; a < len; ++a) {
                newEntityIds[newEntityIds.length - (a + 1)] = disguise.getArmorstandIds()[a];
            }
        }
        if (entityIds.length == newEntityIds.length) {
            return;
        }
        event.getPacket().getIntegerArrays().write(0, (Object)newEntityIds);
    }
}

