/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class LDChangelog
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Collections.singletonList("changelog");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public String getPermission() {
        return "libsdisguises.update";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        UpdateChecker checker = LibsDisguises.getInstance().getUpdateChecker();
        if (checker.isDownloading()) {
            sender.sendMessage(LibsMsg.UPDATE_IN_PROGRESS.get(new Object[0]));
            return;
        }
        if (checker.getUpdate() == null) {
            sender.sendMessage(LibsMsg.UPDATE_REQUIRED.get(new Object[0]));
            return;
        }
        if (!checker.getUpdate().isReleaseBuild()) {
            sender.sendMessage(ChatColor.GOLD + "You are on build " + (LibsDisguises.getInstance().isNumberedBuild() ? "#" : "") + LibsDisguises.getInstance().getBuildNo());
        }
        for (String msg : checker.getUpdate().getChangelog()) {
            sender.sendMessage(ChatColor.GOLD + msg);
        }
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_CHANGELOG;
    }
}

