/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.modded;

import com.comphenix.protocol.utility.StreamSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ModdedManager
implements PluginMessageListener {
    private static final HashMap<NamespacedKey, ModdedEntity> entities = new HashMap();
    private static byte[] fmlHandshake;

    public ModdedManager(ArrayList<String> channels) {
        if (ModdedManager.getEntities().isEmpty()) {
            return;
        }
        if (ModdedManager.getEntities().values().stream().noneMatch(e -> e.getMod() != null)) {
            return;
        }
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)LibsDisguises.getInstance(), "fml:handshake");
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)LibsDisguises.getInstance(), "fml:handshake", (PluginMessageListener)this);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        StreamSerializer s = StreamSerializer.getDefault();
        try {
            s.serializeVarInt(output, 1);
            s.serializeVarInt(output, 0);
            s.serializeVarInt(output, channels.size());
            for (String channel : channels) {
                s.serializeString(output, channel.substring(0, channel.indexOf("|")));
                s.serializeString(output, channel.substring(channel.indexOf("|") + 1));
            }
            s.serializeVarInt(output, 0);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        fmlHandshake = stream.toByteArray();
    }

    public static void registerModdedEntity(NamespacedKey name, ModdedEntity entity, boolean register) {
        if (entities.keySet().stream().anyMatch(n -> n.toString().equalsIgnoreCase(name.toString()))) {
            throw new IllegalArgumentException(name + " has already been registered");
        }
        if (entities.values().stream().anyMatch(n -> n.getName().equalsIgnoreCase(entity.getName()))) {
            throw new IllegalArgumentException("Modded entity " + entity.getName() + " has already been registered");
        }
        if (register) {
            Object entityType = ReflectionManager.registerEntityType(name);
            int entityId = ReflectionManager.getEntityTypeId(entityType);
            entity.setTypeId(entityId);
            entity.setEntityType(entityType);
        } else {
            Object entityType = ReflectionManager.getEntityType(name);
            int entityId = ReflectionManager.getEntityTypeId(entityType);
            entity.setTypeId(entityId);
            entity.setEntityType(entityType);
        }
        entities.put(name, entity);
    }

    public static ModdedEntity getModdedEntity(NamespacedKey name) {
        return entities.get(name);
    }

    public static ModdedEntity getModdedEntity(String name) {
        for (ModdedEntity entity : entities.values()) {
            if (!entity.getName().equalsIgnoreCase(name)) continue;
            return entity;
        }
        return null;
    }

    public static ArrayList<DisguisePerm> getDisguiseTypes() {
        ArrayList<DisguisePerm> perms = new ArrayList<DisguisePerm>();
        for (Map.Entry<NamespacedKey, ModdedEntity> entry : entities.entrySet()) {
            perms.add(new DisguisePerm(entry.getValue().isLiving() ? DisguiseType.MODDED_LIVING : DisguiseType.MODDED_MISC, entry.getValue().getName()));
        }
        return perms;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] bytes) {
        if (player.hasMetadata("forge_mods")) {
            return;
        }
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            StreamSerializer s = StreamSerializer.getDefault();
            int packetId = s.deserializeVarInt(stream);
            if (packetId != 2) {
                return;
            }
            int count = s.deserializeVarInt(stream);
            ArrayList<String> mods = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                mods.add(s.deserializeString(stream, 256));
            }
            player.setMetadata("forge_mods", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), mods));
            for (ModdedEntity e : ModdedManager.getEntities().values()) {
                if (e.getMod() == null || mods.contains(e.getMod().toLowerCase()) || e.getRequired() == null) continue;
                player.kickPlayer(e.getRequired());
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<NamespacedKey, ModdedEntity> getEntities() {
        return entities;
    }

    public static byte[] getFmlHandshake() {
        return fmlHandshake;
    }
}

