/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.events.DisguiseEvent;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public abstract class Disguise {
    private static List<UUID> viewSelf = new ArrayList<UUID>();
    private transient boolean disguiseInUse;
    private DisguiseType disguiseType;
    private transient Entity entity;
    private boolean hearSelfDisguise = DisguiseConfig.isSelfDisguisesSoundsReplaced();
    private boolean hideArmorFromSelf = DisguiseConfig.isHidingArmorFromSelf();
    private boolean hideHeldItemFromSelf = DisguiseConfig.isHidingHeldItemFromSelf();
    private boolean keepDisguisePlayerDeath = DisguiseConfig.isKeepDisguiseOnPlayerDeath();
    private boolean modifyBoundingBox = DisguiseConfig.isModifyBoundingBox();
    private boolean playerHiddenFromTab = DisguiseConfig.isHideDisguisedPlayers();
    private boolean replaceSounds = DisguiseConfig.isSoundEnabled();
    private boolean mobsIgnoreDisguise;
    private transient BukkitTask task;
    private Runnable velocityRunnable;
    private boolean velocitySent = DisguiseConfig.isVelocitySent();
    private boolean viewSelfDisguise = DisguiseConfig.isViewDisguises();
    private DisguiseConfig.NotifyBar notifyBar = DisguiseConfig.getNotifyBar();
    private BarColor bossBarColor = DisguiseConfig.getBossBarColor();
    private BarStyle bossBarStyle = DisguiseConfig.getBossBarStyle();
    private final NamespacedKey bossBar = new NamespacedKey((Plugin)LibsDisguises.getInstance(), UUID.randomUUID().toString());
    private FlagWatcher watcher;
    private long disguiseExpires;
    private final HashMap<String, Object> customData = new HashMap();
    private String disguiseName;
    private boolean customName = true;
    private boolean hideTallSelfDisguise = DisguiseConfig.isHideTallSelfDisguises();

    public static List<UUID> getViewSelf() {
        return viewSelf;
    }

    public Disguise(DisguiseType disguiseType) {
        this.disguiseType = disguiseType;
        this.disguiseName = disguiseType.toReadable();
    }

    public void addCustomData(String key, Object data) {
        this.customData.put(key, data);
    }

    public boolean hasCustomData(String key) {
        return this.customData.containsKey(key);
    }

    public Object getCustomData(String key) {
        return this.customData.get(key);
    }

    public abstract Disguise clone();

    protected void clone(Disguise disguise) {
        disguise.setDisguiseName(this.getDisguiseName());
        disguise.setCustomName(this.isCustomName());
        disguise.setHideTallSelfDisguise(this.isHideTallSelfDisguise());
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
    }

    protected void createDisguise() {
        if (this.getType().getEntityType() == null) {
            throw new RuntimeException("DisguiseType " + (Object)((Object)this.getType()) + " was used in a futile attempt to construct a disguise, but this Minecraft version does not have that entity");
        }
        boolean isAdult = true;
        if (this instanceof MobDisguise) {
            isAdult = ((MobDisguise)this).isAdult();
        }
        if (this.getWatcher() == null) {
            try {
                this.setWatcher(this.getType().getWatcherClass().getConstructor(Disguise.class).newInstance(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getWatcher().setDisguise((TargetedDisguise)this);
        }
        if (!isAdult) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                ((AgeableWatcher)this.getWatcher()).setBaby(true);
            } else if (this.getWatcher() instanceof ZombieWatcher) {
                ((ZombieWatcher)this.getWatcher()).setBaby(true);
            }
        }
    }

    public boolean isDisguiseExpired() {
        return DisguiseConfig.isDynamicExpiry() ? this.disguiseExpires == 1L : this.disguiseExpires > 0L && this.disguiseExpires < System.currentTimeMillis();
    }

    public long getExpires() {
        return this.disguiseExpires;
    }

    public void setExpires(long timeToExpire) {
        this.disguiseExpires = timeToExpire;
        if (this.isDisguiseExpired()) {
            this.removeDisguise();
        }
    }

    public void setNotifyBar(DisguiseConfig.NotifyBar bar) {
        if (this.getNotifyBar() == bar) {
            return;
        }
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.BOSS_BAR) {
            Bukkit.removeBossBar((NamespacedKey)this.getBossBar());
        }
        this.notifyBar = bar;
        this.makeBossBar();
    }

    public void setBossBarColor(BarColor color) {
        if (this.getBossBarColor() == color) {
            return;
        }
        this.bossBarColor = color;
        this.makeBossBar();
    }

    public void setBossBarStyle(BarStyle style) {
        if (this.getBossBarStyle() == style) {
            return;
        }
        this.bossBarStyle = style;
        this.makeBossBar();
    }

    public void setBossBar(BarColor color, BarStyle style) {
        this.bossBarColor = color;
        this.bossBarStyle = style;
        this.setNotifyBar(DisguiseConfig.NotifyBar.BOSS_BAR);
    }

    private void makeBossBar() {
        if (this.getNotifyBar() != DisguiseConfig.NotifyBar.BOSS_BAR || !NmsVersion.v1_13.isSupported() || !(this.getEntity() instanceof Player)) {
            return;
        }
        if (this.getEntity().hasPermission("libsdisguises.noactionbar") || DisguiseAPI.getDisguise(this.getEntity()) != this) {
            return;
        }
        Bukkit.removeBossBar((NamespacedKey)this.getBossBar());
        KeyedBossBar bar = Bukkit.createBossBar((NamespacedKey)this.getBossBar(), (String)LibsMsg.ACTION_BAR_MESSAGE.get(this.getDisguiseName()), (BarColor)this.getBossBarColor(), (BarStyle)this.getBossBarStyle(), (BarFlag[])new BarFlag[0]);
        bar.setProgress(1.0);
        bar.addPlayer((Player)this.getEntity());
    }

    private void createRunnable() {
        Double vectorY;
        boolean alwaysSendVelocity;
        switch (this.getType()) {
            case EXPERIENCE_ORB: 
            case WITHER_SKULL: 
            case FIREWORK: {
                alwaysSendVelocity = true;
                break;
            }
            default: {
                alwaysSendVelocity = false;
            }
        }
        switch (this.getType()) {
            case WITHER_SKULL: 
            case FIREWORK: {
                vectorY = 1.0E-6;
                break;
            }
            case EXPERIENCE_ORB: {
                vectorY = 0.0221;
                break;
            }
            default: {
                vectorY = null;
            }
        }
        final TargetedDisguise disguise = (TargetedDisguise)this;
        this.velocityRunnable = new Runnable(){
            private int blockX;
            private int blockY;
            private int blockZ;
            private int facing;
            private int deadTicks = 0;
            private int refreshDisguise = 0;
            private int actionBarTicks = -1;

            @Override
            public void run() {
                if (++this.actionBarTicks % 15 == 0) {
                    this.actionBarTicks = 0;
                    if (Disguise.this.getNotifyBar() == DisguiseConfig.NotifyBar.ACTION_BAR && Disguise.this.getEntity() instanceof Player && !Disguise.this.getEntity().hasPermission("libsdisguises.noactionbar") && DisguiseAPI.getDisguise(Disguise.this.getEntity()) == Disguise.this) {
                        ((Player)Disguise.this.getEntity()).spigot().sendMessage(ChatMessageType.ACTION_BAR, new ComponentBuilder(LibsMsg.ACTION_BAR_MESSAGE.get(Disguise.this.getDisguiseName())).create());
                    }
                    if (Disguise.this instanceof PlayerDisguise && ((PlayerDisguise)Disguise.this).isDynamicName()) {
                        String name = Disguise.this.getEntity().getCustomName();
                        if (name == null) {
                            name = "";
                        }
                        if (!((PlayerDisguise)Disguise.this).getName().equals(name)) {
                            ((PlayerDisguise)Disguise.this).setName(name);
                        }
                    }
                }
                if (Disguise.this.getEntity() instanceof Player && !((Player)Disguise.this.getEntity()).isOnline()) {
                    Disguise.this.removeDisguise();
                } else if (Disguise.this.disguiseExpires > 0L && (DisguiseConfig.isDynamicExpiry() ? --Disguise.this.disguiseExpires == 1L : Disguise.this.disguiseExpires < System.currentTimeMillis())) {
                    Disguise.this.removeDisguise();
                    String expired = LibsMsg.EXPIRED_DISGUISE.get(new Object[0]);
                    if (Disguise.this.getEntity() instanceof Player && expired.length() > 0) {
                        Disguise.this.getEntity().sendMessage(expired);
                    }
                } else if (!Disguise.this.getEntity().isValid()) {
                    if (this.deadTicks++ > (Disguise.this.getType() == DisguiseType.ENDER_DRAGON ? 200 : 20)) {
                        this.deadTicks = 0;
                        if (Disguise.this.isRemoveDisguiseOnDeath()) {
                            Disguise.this.removeDisguise();
                        }
                    }
                } else {
                    this.deadTicks = 0;
                    if (Disguise.this.getType() == DisguiseType.FIREWORK) {
                        ++this.refreshDisguise;
                        if (this.refreshDisguise == 40) {
                            this.refreshDisguise = 0;
                            DisguiseUtilities.refreshTrackers(disguise);
                        }
                    } else if (Disguise.this.getType() == DisguiseType.EVOKER_FANGS) {
                        ++this.refreshDisguise;
                        if (this.refreshDisguise == 23) {
                            this.refreshDisguise = 0;
                            DisguiseUtilities.refreshTrackers(disguise);
                        }
                    } else if (Disguise.this.getType() == DisguiseType.ITEM_FRAME) {
                        Location loc = Disguise.this.getEntity().getLocation();
                        int newFacing = ((int)loc.getYaw() + 720 + 45) / 90 % 4;
                        if (loc.getBlockX() != this.blockX || loc.getBlockY() != this.blockY || loc.getBlockZ() != this.blockZ || newFacing != this.facing) {
                            this.blockX = loc.getBlockX();
                            this.blockY = loc.getBlockY();
                            this.blockZ = loc.getBlockZ();
                            this.facing = newFacing;
                            DisguiseUtilities.refreshTrackers(disguise);
                        }
                    }
                    if (Disguise.this.isModifyBoundingBox()) {
                        DisguiseUtilities.doBoundingBox(disguise);
                    }
                    if (Disguise.this.getType() == DisguiseType.BAT && !((BatWatcher)Disguise.this.getWatcher()).isHanging()) {
                        return;
                    }
                    if (Disguise.this.isVelocitySent() && vectorY != null && (alwaysSendVelocity || !Disguise.this.getEntity().isOnGround())) {
                        Vector vector = Disguise.this.getEntity().getVelocity();
                        if (!(vector.getY() == 0.0 || vector.getY() < 0.0 && alwaysSendVelocity && Disguise.this.getEntity().isOnGround())) {
                            return;
                        }
                        if (Disguise.this.getType() != DisguiseType.EXPERIENCE_ORB || !Disguise.this.getEntity().isOnGround()) {
                            PacketContainer lookPacket = null;
                            if (Disguise.this.getType() == DisguiseType.WITHER_SKULL && DisguiseConfig.isWitherSkullPacketsEnabled()) {
                                lookPacket = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
                                StructureModifier mods = lookPacket.getModifier();
                                lookPacket.getIntegers().write(0, (Object)Disguise.this.getEntity().getEntityId());
                                Location loc = Disguise.this.getEntity().getLocation();
                                mods.write(4, (Object)DisguiseUtilities.getYaw(Disguise.this.getType(), Disguise.this.getEntity().getType(), (byte)Math.floor(loc.getYaw() * 256.0f / 360.0f)));
                                mods.write(5, (Object)DisguiseUtilities.getPitch(Disguise.this.getType(), Disguise.this.getEntity().getType(), (byte)Math.floor(loc.getPitch() * 256.0f / 360.0f)));
                                if (Disguise.this.isSelfDisguiseVisible() && Disguise.this.getEntity() instanceof Player) {
                                    PacketContainer selfLookPacket = lookPacket.shallowClone();
                                    selfLookPacket.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                    try {
                                        ProtocolLibrary.getProtocolManager().sendServerPacket((Player)Disguise.this.getEntity(), selfLookPacket, false);
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            try {
                                PacketContainer velocityPacket = new PacketContainer(PacketType.Play.Server.ENTITY_VELOCITY);
                                StructureModifier mods = velocityPacket.getIntegers();
                                mods.write(0, (Object)Disguise.this.getEntity().getEntityId());
                                mods.write(1, (Object)((int)(vector.getX() * 8000.0)));
                                mods.write(3, (Object)((int)(vector.getZ() * 8000.0)));
                                for (Player player : DisguiseUtilities.getPerverts(disguise)) {
                                    PacketContainer tempVelocityPacket = velocityPacket.shallowClone();
                                    mods = tempVelocityPacket.getIntegers();
                                    if (Disguise.this.getEntity() == player) {
                                        if (!Disguise.this.isSelfDisguiseVisible()) continue;
                                        mods.write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                    }
                                    mods.write(2, (Object)((int)(8000.0 * (vectorY * ReflectionManager.getPing(player)) * 0.069)));
                                    if (lookPacket != null && player != Disguise.this.getEntity()) {
                                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, lookPacket, false);
                                    }
                                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, tempVelocityPacket, false);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (Disguise.this.getType() == DisguiseType.EXPERIENCE_ORB) {
                        PacketContainer packet = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
                        packet.getIntegers().write(0, (Object)Disguise.this.getEntity().getEntityId());
                        try {
                            for (Player player : DisguiseUtilities.getPerverts(disguise)) {
                                if (Disguise.this.getEntity() != player) {
                                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                                    continue;
                                }
                                if (!Disguise.this.isSelfDisguiseVisible()) continue;
                                PacketContainer selfPacket = packet.shallowClone();
                                selfPacket.getModifier().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                try {
                                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)Disguise.this.getEntity(), selfPacket, false);
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Disguise setEntity(Entity entity) {
        DisguiseValues values;
        if (this.getEntity() != null) {
            if (this.getEntity() == entity) {
                return this;
            }
            throw new RuntimeException("This disguise is already in use! Try .clone()");
        }
        if (this.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            throw new RuntimeException("Cannot disguise a living entity with a misc disguise. Reenable MiscDisguisesForLiving in the config to do this");
        }
        this.entity = entity;
        if (entity != null) {
            this.setupWatcher();
        }
        if (this.getEntity() instanceof Player && this.isSelfDisguiseVisible() && this.isHideTallSelfDisguise() && !this.getType().isCustom() && (values = DisguiseValues.getDisguiseValues(this.getType())) != null) {
            FakeBoundingBox box = null;
            if (this.isMobDisguise() && !((MobDisguise)this).isAdult()) {
                box = values.getBabyBox();
            }
            if (box == null) {
                box = values.getAdultBox();
            }
            if (box != null && box.getY() > 1.7) {
                this.setSelfDisguiseVisible(false);
            }
        }
        return this;
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    public FlagWatcher getWatcher() {
        return this.watcher;
    }

    @Deprecated
    public Disguise setWatcher(FlagWatcher newWatcher) {
        if (!this.getType().getWatcherClass().isInstance(newWatcher)) {
            throw new IllegalArgumentException((newWatcher == null ? "null" : newWatcher.getClass().getSimpleName()) + " is not a instance of " + this.getType().getWatcherClass().getSimpleName() + " for DisguiseType " + this.getType().name());
        }
        this.watcher = newWatcher;
        if (this.getEntity() != null) {
            this.setupWatcher();
        }
        return this;
    }

    public boolean isDisguiseInUse() {
        return this.disguiseInUse;
    }

    public boolean isHidePlayer() {
        return this.playerHiddenFromTab;
    }

    public void setHidePlayer(boolean hidePlayerInTab) {
        if (this.isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.playerHiddenFromTab = hidePlayerInTab;
    }

    @Deprecated
    public boolean isHidingArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Deprecated
    public boolean isHidingHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public boolean isHideArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    public Disguise setHideArmorFromSelf(boolean hideArmor) {
        this.hideArmorFromSelf = hideArmor;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public boolean isHideHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public Disguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        this.hideHeldItemFromSelf = hideHeldItem;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public boolean isKeepDisguiseOnPlayerDeath() {
        return this.keepDisguisePlayerDeath;
    }

    public Disguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        this.keepDisguisePlayerDeath = keepDisguise;
        return this;
    }

    public boolean isMiscDisguise() {
        return false;
    }

    public boolean isMobDisguise() {
        return false;
    }

    public boolean isModifyBoundingBox() {
        return this.modifyBoundingBox;
    }

    public Disguise setModifyBoundingBox(boolean modifyBox) {
        if (((TargetedDisguise)this).getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
            throw new RuntimeException("Cannot modify the bounding box of a disguise which is not TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS");
        }
        if (this.isModifyBoundingBox() != modifyBox) {
            this.modifyBoundingBox = modifyBox;
            if (DisguiseUtilities.isDisguiseInUse(this)) {
                DisguiseUtilities.doBoundingBox((TargetedDisguise)this);
            }
        }
        return this;
    }

    public boolean isPlayerDisguise() {
        return false;
    }

    public boolean isCustomDisguise() {
        return false;
    }

    public boolean isRemoveDisguiseOnDeath() {
        return this.getEntity() == null || (this.getEntity() instanceof Player ? !this.isKeepDisguiseOnPlayerDeath() : this.getEntity().isDead());
    }

    @Deprecated
    public boolean isSelfDisguiseSoundsReplaced() {
        return this.hearSelfDisguise;
    }

    public boolean isSelfDisguiseVisible() {
        return this.viewSelfDisguise;
    }

    public void setSelfDisguiseVisible(boolean selfDisguiseVisible) {
        this.setViewSelfDisguise(selfDisguiseVisible);
    }

    public boolean isSoundsReplaced() {
        return this.replaceSounds;
    }

    public boolean isVelocitySent() {
        return this.velocitySent;
    }

    public Disguise setVelocitySent(boolean sendVelocity) {
        this.velocitySent = sendVelocity;
        return this;
    }

    public boolean removeDisguise() {
        return this.removeDisguise(false);
    }

    public boolean removeDisguise(boolean disguiseBeingReplaced) {
        KeyedBossBar bar;
        PlayerDisguise disguise;
        if (!this.isDisguiseInUse()) {
            return false;
        }
        UndisguiseEvent event = new UndisguiseEvent(this.entity, this, disguiseBeingReplaced);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && (!(this.getEntity() instanceof Player) || ((Player)this.getEntity()).isOnline())) {
            return false;
        }
        this.disguiseInUse = false;
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.getEntity() == null) {
            HashMap<Integer, HashSet<TargetedDisguise>> future = DisguiseUtilities.getFutureDisguises();
            Iterator<Integer> itel = DisguiseUtilities.getFutureDisguises().keySet().iterator();
            while (itel.hasNext()) {
                int id = itel.next();
                if (!future.get(id).remove(this) || !future.get(id).isEmpty()) continue;
                itel.remove();
            }
            return true;
        }
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            PacketContainer deleteTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            deleteTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            deleteTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(disguise.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)disguise.getProfileName()))));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player) || !this.isSelfDisguiseVisible() && this.getEntity() == player) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, deleteTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (DisguiseUtilities.removeDisguise((TargetedDisguise)this)) {
            if (this.getEntity() instanceof Player) {
                DisguiseUtilities.removeSelfDisguise((Player)this.getEntity());
            }
            if (this.getEntity().isValid()) {
                DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
            } else {
                DisguiseUtilities.destroyEntity((TargetedDisguise)this);
            }
        }
        if (this.isHidePlayer() && this.getEntity() instanceof Player && ((Player)this.getEntity()).isOnline()) {
            PlayerInfoData playerInfo = new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.fromBukkit((GameMode)((Player)this.getEntity()).getGameMode()), WrappedChatComponent.fromText((String)DisguiseUtilities.getPlayerListName((Player)this.getEntity())));
            PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            addTab.getPlayerInfoDataLists().write(0, Collections.singletonList(playerInfo));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player) || !this.isSelfDisguiseVisible() && this.getEntity() == player) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.getEntity().hasMetadata("LastDisguise")) {
            this.getEntity().removeMetadata("LastDisguise", (Plugin)LibsDisguises.getInstance());
        }
        this.getEntity().setMetadata("LastDisguise", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
        if (NmsVersion.v1_13.isSupported() && (bar = Bukkit.getBossBar((NamespacedKey)this.getBossBar())) != null) {
            bar.removeAll();
            Bukkit.removeBossBar((NamespacedKey)this.getBossBar());
        }
        return true;
    }

    public boolean isHearSelfDisguise() {
        return this.hearSelfDisguise;
    }

    public Disguise setHearSelfDisguise(boolean hearSelfDisguise) {
        this.hearSelfDisguise = hearSelfDisguise;
        return this;
    }

    public Disguise setReplaceSounds(boolean areSoundsReplaced) {
        this.replaceSounds = areSoundsReplaced;
        return this;
    }

    private void setupWatcher() {
        ArrayList<MetaIndex> disguiseFlags = MetaIndex.getMetaIndexes(this.getType().getWatcherClass());
        ArrayList<MetaIndex> entityFlags = MetaIndex.getMetaIndexes(DisguiseType.getType(this.getEntity().getType()).getWatcherClass());
        for (MetaIndex flag : entityFlags) {
            if (disguiseFlags.contains(flag)) continue;
            MetaIndex backup = null;
            for (MetaIndex flagType : disguiseFlags) {
                if (flagType.getIndex() != flag.getIndex()) continue;
                backup = flagType;
            }
            this.getWatcher().setBackupValue(flag, backup == null ? null : backup.getDefault());
        }
        if (this.getEntity() instanceof Player && !this.getWatcher().hasCustomName()) {
            this.getWatcher().setCustomName("");
            this.getWatcher().setCustomNameVisible(false);
        }
        if ((this.getEntity() instanceof Boat || this.getEntity() instanceof AbstractHorse) && (this.getWatcher() instanceof BoatWatcher || this.getWatcher() instanceof AbstractHorseWatcher)) {
            this.getWatcher().setNoGravity(!this.getEntity().hasGravity());
        } else {
            this.getWatcher().setNoGravity(true);
        }
    }

    @Deprecated
    public Disguise setViewSelfDisguise(boolean viewSelfDisguise) {
        if (this.isSelfDisguiseVisible() != viewSelfDisguise) {
            this.viewSelfDisguise = viewSelfDisguise;
            if (this.getEntity() != null && this.getEntity() instanceof Player && DisguiseAPI.getDisguise((Player)this.getEntity(), this.getEntity()) == this) {
                if (this.isSelfDisguiseVisible()) {
                    DisguiseUtilities.setupFakeDisguise(this);
                } else {
                    DisguiseUtilities.removeSelfDisguise((Player)this.getEntity());
                }
            }
        }
        return this;
    }

    public boolean startDisguise() {
        PlayerDisguise disguise;
        if (this.isDisguiseInUse() || this.isDisguiseExpired()) {
            return false;
        }
        if (this.getEntity() == null) {
            throw new IllegalStateException("No entity is assigned to this disguise!");
        }
        if (LibsPremium.getUserID().equals("12345") || !LibsMsg.OWNED_BY.getRaw().contains("'")) {
            ((TargetedDisguise)this).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            if (this.getEntity() instanceof Player) {
                ((TargetedDisguise)this).addPlayer((Player)this.getEntity());
            }
            for (Entity ent : this.getEntity().getNearbyEntities(4.0, 4.0, 4.0)) {
                if (!(ent instanceof Player)) continue;
                ((TargetedDisguise)this).addPlayer((Player)ent);
            }
        }
        DisguiseUtilities.setPluginsUsed();
        DisguiseEvent event = new DisguiseEvent(this.entity, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.disguiseInUse = true;
        if (this.velocityRunnable == null) {
            this.createRunnable();
        }
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)LibsDisguises.getInstance(), this.velocityRunnable, 1L, 1L);
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            PacketContainer addTab = DisguiseUtilities.getTabPacket(disguise, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player) || !this.isSelfDisguiseVisible() && this.getEntity() == player) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        DisguiseUtilities.addDisguise(this.entity.getUniqueId(), (TargetedDisguise)this);
        if (this.isSelfDisguiseVisible() && this.getEntity() instanceof Player) {
            DisguiseUtilities.removeSelfDisguise((Player)this.getEntity());
        }
        DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

            @Override
            public void run() {
                DisguiseUtilities.setupFakeDisguise(Disguise.this);
            }
        }, 2L);
        if (this.isHidePlayer() && this.getEntity() instanceof Player) {
            PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            addTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)""))));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player) || !this.isSelfDisguiseVisible() && this.getEntity() == player) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!this.entity.isOp() && new Random().nextBoolean() && (!LibsMsg.OWNED_BY.getRaw().contains("'") || "%%__USER__%%".equals("12345"))) {
            this.setExpires(DisguiseConfig.isDynamicExpiry() ? 4800L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(330L));
        }
        this.makeBossBar();
        return true;
    }

    public boolean stopDisguise() {
        return this.removeDisguise();
    }

    public boolean isMobsIgnoreDisguise() {
        return this.mobsIgnoreDisguise;
    }

    public void setMobsIgnoreDisguise(boolean mobsIgnoreDisguise) {
        this.mobsIgnoreDisguise = mobsIgnoreDisguise;
    }

    public DisguiseConfig.NotifyBar getNotifyBar() {
        return this.notifyBar;
    }

    public BarColor getBossBarColor() {
        return this.bossBarColor;
    }

    public BarStyle getBossBarStyle() {
        return this.bossBarStyle;
    }

    private NamespacedKey getBossBar() {
        return this.bossBar;
    }

    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    public String getDisguiseName() {
        return this.disguiseName;
    }

    public void setDisguiseName(String disguiseName) {
        this.disguiseName = disguiseName;
    }

    public boolean isCustomName() {
        return this.customName;
    }

    public void setCustomName(boolean customName) {
        this.customName = customName;
    }

    public boolean isHideTallSelfDisguise() {
        return this.hideTallSelfDisguise;
    }

    public void setHideTallSelfDisguise(boolean hideTallSelfDisguise) {
        this.hideTallSelfDisguise = hideTallSelfDisguise;
    }
}

