/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.libs.org.apache.commons.io.FileUtils;

public class UpdateChecker {
    private final String resourceID;
    private String latestVersion;
    private int latestSnapshot;
    private final long started = System.currentTimeMillis();
    private int lastDownload;

    public UpdateChecker(String resourceID) {
        this.resourceID = resourceID;
    }

    public PluginInformation grabSnapshotBuild() {
        if (this.getLatestSnapshot() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.lastDownload == -1) {
            return null;
        }
        if (this.getLatestSnapshot() == this.lastDownload) {
            return null;
        }
        return this.grabSnapshotBuild(this.getLatestSnapshot());
    }

    public PluginInformation grabSnapshotBuild(int buildNo) {
        PluginInformation result = this.grabSnapshotBuild("https://ci.md-5.net/job/LibsDisguises/" + buildNo + "/artifact/target/LibsDisguises.jar");
        if (result != null) {
            this.lastDownload = buildNo;
        }
        return result;
    }

    public PluginInformation grabLatestSnapshot() {
        PluginInformation result = this.grabSnapshotBuild("https://ci.md-5.net/job/LibsDisguises/lastSuccessfulBuild/artifact/target/LibsDisguises.jar");
        if (result != null) {
            this.lastDownload = LibsDisguises.getInstance().getBuildNumber();
        }
        return result;
    }

    public boolean isDownloading() {
        return this.lastDownload == -1;
    }

    public int getLastDownload() {
        return this.lastDownload;
    }

    public PluginInformation grabSnapshotBuild(String urlString) {
        DisguiseUtilities.getLogger().info("Now downloading latest build of Lib's Disguises from " + urlString);
        this.lastDownload = -1;
        File dest = new File(Bukkit.getUpdateFolderFile(), "LibsDisguises.jar");
        if (dest.exists()) {
            dest.delete();
        }
        dest.getParentFile().mkdirs();
        try {
            URL url = new URL(urlString);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                FileUtils.copyInputStreamToFile((InputStream)input, (File)dest);
            }
            DisguiseUtilities.getLogger().info("Download success!");
            return LibsPremium.getInformation(dest);
        }
        catch (Exception ex) {
            dest.delete();
            DisguiseUtilities.getLogger().warning("Failed to download snapshot build.");
            this.lastDownload = 0;
            ex.printStackTrace();
            return null;
        }
    }

    public void checkSnapshotUpdate(int buildNumber) {
        Map<String, Object> lastBuild = this.fetchLastSnapshotBuild();
        if (lastBuild == null || !lastBuild.containsKey("id") || !lastBuild.containsKey("timestamp")) {
            return;
        }
        int newBuildNumber = Integer.parseInt((String)lastBuild.get("id"));
        if (newBuildNumber <= buildNumber) {
            return;
        }
        Date newBuildDate = new Date(((Number)lastBuild.get("timestamp")).longValue());
        this.latestSnapshot = newBuildNumber;
    }

    public void checkOfficialUpdate(String currentVersion) {
        String version = this.fetchSpigotVersion();
        if (version == null) {
            return;
        }
        if (!this.isNewerVersion(currentVersion, version)) {
            return;
        }
        this.latestVersion = version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchSpigotVersion() {
        try {
            URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceID);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                String version = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (version.isEmpty()) return null;
                String string = version;
                return string;
            }
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a update on spigot.");
        }
        return null;
    }

    private boolean isNewerVersion(String currentVersion, String newVersion) {
        int nVersion;
        int cVersion;
        currentVersion = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        newVersion = newVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        if (this.started + TimeUnit.HOURS.toMillis(6L) > System.currentTimeMillis() && currentVersion.matches("[0-9]+(\\.[0-9]+)*") && newVersion.matches("[0-9]+(\\.[0-9]+)*") && (cVersion = Integer.parseInt(currentVersion.replace(".", ""))) > (nVersion = Integer.parseInt(newVersion.replace(".", ""))) && nVersion + 3 > cVersion) {
            return false;
        }
        return !currentVersion.equals(newVersion);
    }

    private Map<String, Object> fetchLastSnapshotBuild() {
        try {
            Map jsonObject;
            URL url = new URL("https://ci.md-5.net/job/LibsDisguises/lastSuccessfulBuild/api/json");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                jsonObject = (Map)new Gson().fromJson(json, Map.class);
            }
            return jsonObject;
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a snapshot update on jenkins.");
            return null;
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public int getLatestSnapshot() {
        return this.latestSnapshot;
    }
}

