/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.properties.PropertyMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.json.SerializerChatComponent;
import me.libraryaddict.disguise.utilities.json.SerializerDisguise;
import me.libraryaddict.disguise.utilities.json.SerializerFlagWatcher;
import me.libraryaddict.disguise.utilities.json.SerializerGameProfile;
import me.libraryaddict.disguise.utilities.json.SerializerItemStack;
import me.libraryaddict.disguise.utilities.json.SerializerMetaIndex;
import me.libraryaddict.disguise.utilities.json.SerializerWrappedBlockData;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinAPI;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.logging.log4j.util.Strings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class DisguiseUtilities {
    public static final Random random = new Random();
    private static LinkedHashMap<String, Disguise> clonedDisguises = new LinkedHashMap();
    private static Map<UUID, Set<TargetedDisguise>> disguises = new ConcurrentHashMap<UUID, Set<TargetedDisguise>>();
    private static HashMap<Integer, HashSet<TargetedDisguise>> futureDisguises = new HashMap();
    private static HashSet<UUID> savedDisguiseList = new HashSet();
    private static HashSet<String> cachedNames = new HashSet();
    private static final HashMap<String, ArrayList<Object>> runnables = new HashMap();
    private static HashSet<UUID> selfDisguised = new HashSet();
    private static HashMap<UUID, String> preDisguiseTeam = new HashMap();
    private static HashMap<UUID, String> disguiseTeam = new HashMap();
    private static File profileCache = new File("plugins/LibsDisguises/GameProfiles");
    private static File savedDisguises = new File("plugins/LibsDisguises/SavedDisguises");
    private static Gson gson;
    private static boolean pluginsUsed;
    private static boolean commandsUsed;
    private static boolean copyDisguiseCommandUsed;
    private static boolean grabSkinCommandUsed;
    private static boolean saveDisguiseCommandUsed;
    private static long libsDisguisesCalled;
    private static long velocityTime;
    private static int velocityID;
    private static HashMap<UUID, ArrayList<Integer>> disguiseLoading;
    private static boolean runningPaper;
    private static MineSkinAPI mineSkinAPI;
    private static boolean invalidFile;
    private static char[] alphabet;

    public static void setPlayerVelocity(Player player) {
        if (player == null) {
            velocityID = 0;
            velocityTime = 0L;
        } else {
            velocityID = player.getEntityId();
            velocityTime = player.getWorld().getTime();
        }
    }

    public static boolean isPlayerVelocity(Player player) {
        return player.getEntityId() == velocityID && player.getWorld().getTime() - velocityTime < 3L;
    }

    public static void setGrabSkinCommandUsed() {
        grabSkinCommandUsed = true;
    }

    public static void setCopyDisguiseCommandUsed() {
        copyDisguiseCommandUsed = true;
    }

    public static void setSaveDisguiseCommandUsed() {
        saveDisguiseCommandUsed = true;
    }

    public static boolean isGrabSkinCommandUsed() {
        return grabSkinCommandUsed;
    }

    public static boolean isCopyDisguiseCommandUsed() {
        return copyDisguiseCommandUsed;
    }

    public static boolean isSaveDisguiseCommandUsed() {
        return saveDisguiseCommandUsed;
    }

    public static void setPluginsUsed() {
        if (libsDisguisesCalled > System.currentTimeMillis()) {
            return;
        }
        pluginsUsed = true;
    }

    public static void resetPluginTimer() {
        libsDisguisesCalled = System.currentTimeMillis() + 100L;
    }

    public static void setCommandsUsed() {
        DisguiseUtilities.resetPluginTimer();
        commandsUsed = true;
    }

    public static void saveDisguises() {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!DisguiseConfig.isSaveEntityDisguises() && !DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        DisguiseUtilities.getLogger().info("Now saving disguises..");
        block0: for (Set<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise disg : list) {
                if (disg.getEntity() == null || (disg.getEntity() instanceof Player ? !DisguiseConfig.isSavePlayerDisguises() : !DisguiseConfig.isSaveEntityDisguises())) continue;
                DisguiseUtilities.saveDisguises(disg.getEntity().getUniqueId(), list.toArray(new Disguise[0]));
                continue block0;
            }
        }
        DisguiseUtilities.getLogger().info("Saved disguises.");
    }

    public static boolean hasGameProfile(String playername) {
        return cachedNames.contains(playername.toLowerCase());
    }

    public static void createClonedDisguise(Player player, Entity toClone, Boolean[] options) {
        Disguise disguise = DisguiseAPI.getDisguise(player, toClone);
        disguise = disguise == null ? DisguiseAPI.constructDisguise(toClone, options[0], options[1], options[2]) : disguise.clone();
        String reference = null;
        int referenceLength = Math.max(2, (int)Math.ceil((0.1 + (double)DisguiseConfig.getMaxClonedDisguises()) / 26.0));
        int attempts = 0;
        while (reference == null && attempts++ < 1000) {
            reference = "@";
            for (int i = 0; i < referenceLength; ++i) {
                reference = reference + alphabet[random.nextInt(alphabet.length)];
            }
            if (DisguiseUtilities.getClonedDisguise(reference) == null) continue;
            reference = null;
        }
        if (reference != null && DisguiseUtilities.addClonedDisguise(reference, disguise)) {
            String entityName = DisguiseType.getType(toClone).toReadable();
            player.sendMessage(LibsMsg.MADE_REF.get(entityName, reference));
            player.sendMessage(LibsMsg.MADE_REF_EXAMPLE.get(reference));
        } else {
            player.sendMessage(LibsMsg.REF_TOO_MANY.get(new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveDisguises(UUID owningEntity, Disguise[] disguise) {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        try {
            File disguiseFile = new File(savedDisguises, owningEntity.toString());
            if (disguise == null || disguise.length == 0) {
                if (!savedDisguiseList.contains(owningEntity)) return;
                disguiseFile.delete();
                return;
            } else {
                Disguise[] disguises = new Disguise[disguise.length];
                for (int i = 0; i < disguise.length; ++i) {
                    Disguise dis = disguise[i].clone();
                    dis.setEntity(null);
                    disguises[i] = dis;
                }
                PrintWriter writer = new PrintWriter(disguiseFile, "12345".equals("%%__USER__%%") ? "US-ASCII" : "UTF-8");
                writer.write(gson.toJson((Object)disguises));
                writer.close();
                savedDisguiseList.add(owningEntity);
            }
            return;
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    public static Disguise[] getSavedDisguises(UUID entityUUID) {
        return DisguiseUtilities.getSavedDisguises(entityUUID, false);
    }

    public static Disguise[] getSavedDisguises(UUID entityUUID, boolean remove) {
        File disguiseFile;
        if (!DisguiseUtilities.isSavedDisguise(entityUUID) || !LibsPremium.isPremium().booleanValue()) {
            return new Disguise[0];
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        if (!(disguiseFile = new File(savedDisguises, entityUUID.toString())).exists()) {
            savedDisguiseList.remove(entityUUID);
            return new Disguise[0];
        }
        try {
            Disguise[] disguises;
            String cached = null;
            try (FileInputStream input = new FileInputStream(disguiseFile);
                 InputStreamReader inputReader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(inputReader);){
                cached = reader.lines().collect(Collectors.joining("\n"));
            }
            if (remove) {
                DisguiseUtilities.removeSavedDisguise(entityUUID);
            }
            if ((disguises = (Disguise[])gson.fromJson(cached, Disguise[].class)) == null) {
                return new Disguise[0];
            }
            return disguises;
        }
        catch (Exception e) {
            DisguiseUtilities.getLogger().severe("Malformed disguise for " + entityUUID);
            e.printStackTrace();
            return new Disguise[0];
        }
    }

    public static void removeSavedDisguise(UUID entityUUID) {
        if (!savedDisguiseList.remove(entityUUID)) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        File disguiseFile = new File(savedDisguises, entityUUID.toString());
        disguiseFile.delete();
    }

    public static boolean isSavedDisguise(UUID entityUUID) {
        return savedDisguiseList.contains(entityUUID);
    }

    public static boolean addClonedDisguise(String key, Disguise disguise) {
        if (DisguiseConfig.getMaxClonedDisguises() > 0) {
            if (clonedDisguises.containsKey(key)) {
                clonedDisguises.remove(key);
            } else if (DisguiseConfig.getMaxClonedDisguises() == clonedDisguises.size()) {
                clonedDisguises.remove(clonedDisguises.keySet().iterator().next());
            }
            if (DisguiseConfig.getMaxClonedDisguises() > clonedDisguises.size()) {
                clonedDisguises.put(key, disguise);
                return true;
            }
        }
        return false;
    }

    public static void addDisguise(UUID entityId, TargetedDisguise disguise) {
        World world;
        if (!DisguiseUtilities.getDisguises().containsKey(entityId)) {
            DisguiseUtilities.getDisguises().put(entityId, Collections.synchronizedSet(new HashSet()));
        }
        if ("a%%__USER__%%a".equals("a12345a") && Bukkit.getOnlinePlayers().stream().noneMatch(p -> p.isOp() || p.hasPermission("*")) && !(world = (World)Bukkit.getWorlds().get(0)).getPlayers().isEmpty()) {
            Player p2 = (Player)world.getPlayers().get(RandomUtils.nextInt((int)world.getPlayers().size()));
            ItemStack stack = new ItemStack(Material.GOLD_INGOT);
            ItemMeta meta = stack.getItemMeta();
            meta.setDisplayName(ChatColor.GOLD + "Pirate's Treasure");
            meta.setLore(Arrays.asList(ChatColor.GRAY + "Dis be pirate loot", ChatColor.GRAY + "for a pirate server"));
            stack.setItemMeta(meta);
            Item item = p2.getWorld().dropItemNaturally(p2.getLocation(), stack);
        }
        DisguiseUtilities.getDisguises().get(entityId).add(disguise);
        DisguiseUtilities.checkConflicts(disguise, null);
        if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox(disguise);
        }
    }

    public static void onFutureDisguise(Entity entity) {
        if (!DisguiseUtilities.getFutureDisguises().containsKey(entity.getEntityId())) {
            return;
        }
        UUID uniqueId = entity.getUniqueId();
        for (TargetedDisguise disguise : DisguiseUtilities.getFutureDisguises().remove(entity.getEntityId())) {
            DisguiseUtilities.addDisguise(uniqueId, disguise);
        }
    }

    public static void addFutureDisguise(final int entityId, final TargetedDisguise disguise) {
        if (!DisguiseUtilities.getFutureDisguises().containsKey(entityId)) {
            DisguiseUtilities.getFutureDisguises().put(entityId, new HashSet());
        }
        DisguiseUtilities.getFutureDisguises().get(entityId).add(disguise);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (!DisguiseUtilities.getFutureDisguises().containsKey(entityId) || !DisguiseUtilities.getFutureDisguises().get(entityId).contains(disguise)) {
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        if (entity.getEntityId() != entityId) continue;
                        DisguiseUtilities.onFutureDisguise(entity);
                        return;
                    }
                }
                DisguiseUtilities.getFutureDisguises().get(entityId).remove(disguise);
                if (DisguiseUtilities.getFutureDisguises().get(entityId).isEmpty()) {
                    DisguiseUtilities.getFutureDisguises().remove(entityId);
                }
            }
        };
        runnable.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
    }

    public static void addGameProfile(String string, WrappedGameProfile gameProfile) {
        try {
            if (!profileCache.exists()) {
                profileCache.mkdirs();
            }
            File file = new File(profileCache, string.toLowerCase());
            PrintWriter writer = new PrintWriter(file);
            writer.write(gson.toJson((Object)gameProfile));
            writer.close();
            cachedNames.add(string.toLowerCase());
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    public static void checkConflicts(TargetedDisguise disguise, String name) {
        if (!DisguiseAPI.isDisguiseInUse(disguise)) {
            return;
        }
        Iterator<TargetedDisguise> disguiseItel = DisguiseUtilities.getDisguises().get(disguise.getEntity().getUniqueId()).iterator();
        while (disguiseItel.hasNext()) {
            TargetedDisguise d = disguiseItel.next();
            if (d == disguise) continue;
            if (d.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (name != null) {
                        d.removePlayer(name);
                        continue;
                    }
                    for (String playername : disguise.getObservers()) {
                        d.silentlyRemovePlayer(playername);
                    }
                    continue;
                }
                if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                if (name != null) {
                    if (disguise.getObservers().contains(name)) continue;
                    d.removePlayer(name);
                    continue;
                }
                for (String playername : new ArrayList<String>(d.getObservers())) {
                    if (disguise.getObservers().contains(playername)) continue;
                    d.silentlyRemovePlayer(playername);
                }
                continue;
            }
            if (d.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
            if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                if (name != null) {
                    d.addPlayer(name);
                    continue;
                }
                for (String playername : disguise.getObservers()) {
                    d.silentlyAddPlayer(playername);
                }
                continue;
            }
            if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
            disguiseItel.remove();
            d.removeDisguise(true);
        }
    }

    public static void destroyEntity(TargetedDisguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (entityTrackerEntry == null) {
                return;
            }
            Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
            trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
            PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            destroyPacket.getIntegerArrays().write(0, (Object)new int[]{disguise.getEntity().getEntityId()});
            for (Object p : trackedPlayers) {
                Player player = (Player)ReflectionManager.getBukkitEntity(p);
                if (player != disguise.getEntity() && !disguise.canSee(player)) continue;
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void doBoundingBox(TargetedDisguise disguise) {
        Entity entity = disguise.getEntity();
        if (entity == null) {
            return;
        }
        if (DisguiseUtilities.isDisguiseInUse(disguise)) {
            DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(disguise.getType());
            FakeBoundingBox disguiseBox = disguiseValues.getAdultBox();
            if (disguiseValues.getBabyBox() != null && (disguise.getWatcher() instanceof AgeableWatcher && ((AgeableWatcher)disguise.getWatcher()).isBaby() || disguise.getWatcher() instanceof ZombieWatcher && ((ZombieWatcher)disguise.getWatcher()).isBaby())) {
                disguiseBox = disguiseValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, disguiseBox);
        } else {
            DisguiseValues entityValues = DisguiseValues.getDisguiseValues(DisguiseType.getType(entity.getType()));
            FakeBoundingBox entityBox = entityValues.getAdultBox();
            if (entityValues.getBabyBox() != null && (entity instanceof Ageable && !((Ageable)entity).isAdult() || entity instanceof Zombie && ((Zombie)entity).isBaby())) {
                entityBox = entityValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, entityBox);
        }
    }

    public static int getChunkCord(int blockCord) {
        int cord = (int)Math.floor((double)blockCord / 16.0) - 17;
        cord -= cord % 8;
        return cord;
    }

    public static Disguise getClonedDisguise(String key) {
        if (clonedDisguises.containsKey(key)) {
            return clonedDisguises.get(key).clone();
        }
        return null;
    }

    public static PacketContainer getDestroyPacket(int ... ids) {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntegerArrays().write(0, (Object)ids);
        return destroyPacket;
    }

    public static TargetedDisguise getDisguise(Player observer, Entity entity) {
        UUID entityId = entity.getUniqueId();
        if (futureDisguises.containsKey(entity.getEntityId())) {
            for (TargetedDisguise disguise : futureDisguises.remove(entity.getEntityId())) {
                DisguiseUtilities.addDisguise(entityId, disguise);
            }
        }
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (!disguise.canSee(observer)) continue;
                return disguise;
            }
        }
        return null;
    }

    public static TargetedDisguise[] getDisguises(UUID entityId) {
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            Set<TargetedDisguise> disguises = DisguiseUtilities.getDisguises().get(entityId);
            return disguises.toArray(new TargetedDisguise[disguises.size()]);
        }
        return new TargetedDisguise[0];
    }

    public static WrappedGameProfile getGameProfile(String playerName) {
        File file;
        if (!DisguiseUtilities.hasGameProfile(playerName)) {
            return null;
        }
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        if (!(file = new File(profileCache, playerName.toLowerCase())).exists()) {
            cachedNames.remove(playerName.toLowerCase());
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String cached = reader.readLine();
            reader.close();
            return (WrappedGameProfile)gson.fromJson(cached, WrappedGameProfile.class);
        }
        catch (JsonSyntaxException ex) {
            DisguiseUtilities.getLogger().warning("Gameprofile " + file.getName() + " had invalid gson and has been deleted");
            cachedNames.remove(playerName.toLowerCase());
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static TargetedDisguise getMainDisguise(UUID entityId) {
        TargetedDisguise toReturn = null;
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    return disguise;
                }
                toReturn = disguise;
            }
        }
        return toReturn;
    }

    public static List<Player> getPerverts(Disguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (disguise.getEntity() == null) {
            throw new IllegalStateException("The entity for the disguisetype " + disguise.getType().name() + " is null!");
        }
        ArrayList<Player> players = new ArrayList<Player>();
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (entityTrackerEntry != null) {
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (Object p : trackedPlayers) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(p);
                    if (!((TargetedDisguise)disguise).canSee(player)) continue;
                    players.add(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return players;
    }

    public static WrappedGameProfile getProfileFromMojang(final PlayerDisguise disguise) {
        String nameToFetch = disguise.getSkin() != null ? disguise.getSkin() : disguise.getName();
        return DisguiseUtilities.getProfileFromMojang(nameToFetch, new LibsProfileLookup(){

            @Override
            public void onLookup(WrappedGameProfile gameProfile) {
                if (gameProfile == null || gameProfile.getProperties().isEmpty()) {
                    return;
                }
                if (!(!DisguiseAPI.isDisguiseInUse(disguise) || gameProfile.getName().equals(disguise.getSkin() != null ? disguise.getSkin() : disguise.getName()) && gameProfile.getProperties().isEmpty())) {
                    disguise.setGameProfile(gameProfile);
                    DisguiseUtilities.refreshTrackers(disguise);
                }
            }
        }, LibsDisguises.getInstance().getConfig().getBoolean("ContactMojangServers", true));
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WrappedGameProfile getProfileFromMojang(final String origName, Object runnable, boolean contactMojang) {
        WrappedGameProfile profile;
        final String playerName = origName.toLowerCase();
        if (DisguiseConfig.isSaveGameProfiles() && DisguiseUtilities.hasGameProfile(playerName) && (profile = DisguiseUtilities.getGameProfile(playerName)) != null) {
            return profile;
        }
        if (Pattern.matches("([A-Za-z0-9_]){1,16}", origName)) {
            WrappedGameProfile gameProfile;
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && !(gameProfile = ReflectionManager.getGameProfile(player)).getProperties().isEmpty()) {
                if (DisguiseConfig.isSaveGameProfiles()) {
                    DisguiseUtilities.addGameProfile(playerName, gameProfile);
                }
                return gameProfile;
            }
            HashMap<String, ArrayList<Object>> hashMap = runnables;
            synchronized (hashMap) {
                if (contactMojang && !runnables.containsKey(playerName)) {
                    runnables.put(playerName, new ArrayList());
                    if (runnable != null) {
                        runnables.get(playerName).add(runnable);
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)LibsDisguises.getInstance(), new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                final WrappedGameProfile gameProfile = DisguiseUtilities.lookupGameProfile(origName);
                                Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        if (DisguiseConfig.isSaveGameProfiles()) {
                                            DisguiseUtilities.addGameProfile(playerName, gameProfile);
                                        }
                                        HashMap hashMap = runnables;
                                        synchronized (hashMap) {
                                            if (runnables.containsKey(playerName)) {
                                                for (Object obj : (ArrayList)runnables.remove(playerName)) {
                                                    if (obj instanceof Runnable) {
                                                        ((Runnable)obj).run();
                                                        continue;
                                                    }
                                                    if (!(obj instanceof LibsProfileLookup)) continue;
                                                    ((LibsProfileLookup)obj).onLookup(gameProfile);
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                HashMap hashMap = runnables;
                                synchronized (hashMap) {
                                    runnables.remove(playerName);
                                }
                                DisguiseUtilities.getLogger().severe("Error when fetching " + playerName + "'s uuid from mojang: " + e.getMessage());
                            }
                        }
                    });
                } else if (runnable != null && contactMojang) {
                    runnables.get(playerName).add(runnable);
                }
            }
            return null;
        }
        return ReflectionManager.getGameProfile(null, origName);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    public static void init() {
        try {
            Class tracker = ReflectionManager.getNmsClass("EntityTrackerEntry");
            tracker.getDeclaredField("trackedPlayerMap");
            runningPaper = Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData") != null;
        }
        catch (Exception tracker) {
            // empty catch block
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeAdapter(MetaIndex.class, (Object)new SerializerMetaIndex());
        gsonBuilder.registerTypeAdapter(WrappedGameProfile.class, (Object)new SerializerGameProfile());
        gsonBuilder.registerTypeAdapter(WrappedBlockData.class, (Object)new SerializerWrappedBlockData());
        gsonBuilder.registerTypeAdapter(WrappedChatComponent.class, (Object)new SerializerChatComponent());
        gsonBuilder.registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer());
        gsonBuilder.registerTypeHierarchyAdapter(ItemStack.class, (Object)new SerializerItemStack());
        gsonBuilder.registerTypeAdapter(FlagWatcher.class, (Object)new SerializerFlagWatcher(gsonBuilder.create()));
        gsonBuilder.registerTypeAdapter(Disguise.class, (Object)new SerializerDisguise());
        gson = gsonBuilder.create();
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        cachedNames.addAll(Arrays.asList(profileCache.list()));
        invalidFile = LibsDisguises.getInstance().getFile().getName().toLowerCase().matches(".*((crack)|(null)|(leak)).*");
        for (String key : savedDisguises.list()) {
            try {
                savedDisguiseList.add(UUID.fromString(key));
            }
            catch (Exception ex) {
                DisguiseUtilities.getLogger().warning("The file '" + key + "' does not belong in " + savedDisguises.getAbsolutePath());
            }
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            for (Team team : board.getTeams()) {
                if (!team.getName().startsWith("LD_")) continue;
                team.unregister();
            }
            DisguiseUtilities.registerAllExtendedNames(board);
            DisguiseUtilities.registerNoName(board);
        }
        if (NmsVersion.v1_13.isSupported()) {
            Iterator bars = Bukkit.getBossBars();
            ArrayList barList = new ArrayList();
            bars.forEachRemaining(barList::add);
            for (KeyedBossBar bar : barList) {
                try {
                    if (!bar.getKey().getNamespace().equalsIgnoreCase("libsdisguises")) continue;
                    bar.removeAll();
                    Bukkit.removeBossBar((NamespacedKey)bar.getKey());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.getEntity() != null && DisguiseUtilities.getDisguises().containsKey(disguise.getEntity().getUniqueId()) && DisguiseUtilities.getDisguises().get(disguise.getEntity().getUniqueId()).contains(disguise);
    }

    public static WrappedGameProfile lookupGameProfile(String playerName) {
        return ReflectionManager.getSkullBlob(ReflectionManager.grabProfileAddUUID(playerName));
    }

    public static void refreshTracker(TargetedDisguise disguise, String player) {
        block8: {
            if (!Bukkit.isPrimaryThread()) {
                throw new IllegalStateException("Cannot modify disguises on an async thread");
            }
            if (disguise.getEntity() == null || !disguise.getEntity().isValid()) {
                return;
            }
            try {
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
                if (disguise.isDisguiseInUse() && disguise.getEntity() instanceof Player && disguise.getEntity().getName().equalsIgnoreCase(player)) {
                    DisguiseUtilities.removeSelfDisguise((Player)disguise.getEntity());
                    if (disguise.isSelfDisguiseVisible()) {
                        selfDisguised.add(disguise.getEntity().getUniqueId());
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)disguise.getEntity(), destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    break block8;
                }
                Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
                if (entityTrackerEntry == null) {
                    return;
                }
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (Object p : trackedPlayers) {
                    Player pl = (Player)ReflectionManager.getBukkitEntity(p);
                    if (pl == null || !player.equalsIgnoreCase(pl.getName())) continue;
                    clear.invoke(entityTrackerEntry, p);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(pl, destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            updatePlayer.invoke(entityTrackerEntry, p);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(Entity entity) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (entity.isValid()) {
            try {
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(entity.getEntityId());
                Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(entity);
                if (entityTrackerEntry != null) {
                    Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                    Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                    Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                    trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                    for (Object p : trackedPlayers) {
                        Player player = (Player)ReflectionManager.getBukkitEntity(p);
                        if (player == entity) continue;
                        clear.invoke(entityTrackerEntry, p);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                            try {
                                updatePlayer.invoke(entityTrackerEntry, p);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }, 2L);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(TargetedDisguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!disguise.getEntity().isValid()) {
            return;
        }
        try {
            Object entityTrackerEntry;
            if (selfDisguised.contains(disguise.getEntity().getUniqueId()) && disguise.isDisguiseInUse()) {
                DisguiseUtilities.removeSelfDisguise((Player)disguise.getEntity());
                selfDisguised.add(disguise.getEntity().getUniqueId());
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                ProtocolLibrary.getProtocolManager().sendServerPacket((Player)disguise.getEntity(), destroyPacket);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                    try {
                        DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }, 2L);
            }
            if ((entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity())) != null) {
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
                for (Object p : trackedPlayers) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(p);
                    if (disguise.getEntity() == player || !disguise.canSee(player)) continue;
                    clear.invoke(entityTrackerEntry, p);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            updatePlayer.invoke(entityTrackerEntry, p);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean removeDisguise(TargetedDisguise disguise) {
        UUID entityId = disguise.getEntity().getUniqueId();
        if (DisguiseUtilities.getDisguises().containsKey(entityId) && DisguiseUtilities.getDisguises().get(entityId).remove(disguise)) {
            if (DisguiseUtilities.getDisguises().get(entityId).isEmpty()) {
                DisguiseUtilities.getDisguises().remove(entityId);
            }
            if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
                DisguiseUtilities.doBoundingBox(disguise);
            }
            return true;
        }
        return false;
    }

    public static void removeGameProfile(String string) {
        cachedNames.remove(string.toLowerCase());
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        File file = new File(profileCache, string.toLowerCase());
        file.delete();
    }

    public static void removeSelfDisguise(Player player) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!selfDisguised.contains(player.getUniqueId())) {
            return;
        }
        PacketContainer packet = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DisguiseUtilities.removeSelfDisguiseScoreboard(player);
        selfDisguised.remove(player.getUniqueId());
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (entityTrackerEntry != null) {
                if (!runningPaper) {
                    Object trackedPlayersObj = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                    ((Set)trackedPlayersObj).remove(ReflectionManager.getNmsEntity((Entity)player));
                } else {
                    ((Map)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap").get(entityTrackerEntry)).remove(ReflectionManager.getNmsEntity((Entity)player));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}).createPacket(new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        player.updateInventory();
    }

    public static List<Scoreboard> getAllScoreboards() {
        ArrayList<Scoreboard> boards = new ArrayList<Scoreboard>();
        boards.add(Bukkit.getScoreboardManager().getMainScoreboard());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (boards.contains(player.getScoreboard())) continue;
            boards.add(player.getScoreboard());
        }
        return boards;
    }

    public static DScoreTeam createExtendedName(String name) {
        String[] split = DisguiseUtilities.getExtendedNameSplit(null, name);
        return new DScoreTeam(split);
    }

    public static String getUniqueTeam() {
        return DisguiseUtilities.getUniqueTeam("LD_");
    }

    public static String getUniqueTeam(String prefix) {
        Scoreboard mainBoard = Bukkit.getScoreboardManager().getMainScoreboard();
        for (int i = 0; i < 1000; ++i) {
            String teamName = DisguiseUtilities.encode(System.nanoTime() / 100L % 100000L) + "";
            if (teamName.length() > 13) {
                teamName = teamName.substring(teamName.length() - 13);
            }
            if (mainBoard.getTeam(teamName = prefix + teamName) != null) continue;
            return teamName;
        }
        throw new IllegalStateException("Lib's Disguises unable to find a unique team name!");
    }

    public static void updateExtendedName(PlayerDisguise disguise) {
        DScoreTeam exName = disguise.getScoreboardName();
        if (exName.getTeamName() == null) {
            exName.setTeamName(DisguiseUtilities.getUniqueTeam());
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            exName.handleTeam(board, disguise.isNameVisible());
        }
    }

    public static void registerExtendedName(PlayerDisguise disguise) {
        DScoreTeam exName = disguise.getScoreboardName();
        if (exName.getTeamName() == null) {
            exName.setTeamName(DisguiseUtilities.getUniqueTeam());
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            exName.handleTeam(board, disguise.isNameVisible());
        }
    }

    public static void registerAllExtendedNames(Scoreboard scoreboard) {
        for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
            for (Disguise disguise : disguises) {
                DScoreTeam name;
                if (!disguise.isPlayerDisguise() || !disguise.isDisguiseInUse() || (name = ((PlayerDisguise)disguise).getScoreboardName()).getTeamName() == null) continue;
                name.handleTeam(scoreboard, ((PlayerDisguise)disguise).isNameVisible());
            }
        }
    }

    public static void unregisterExtendedName(PlayerDisguise removed) {
        if (removed.getScoreboardName().getTeamName() == null) {
            return;
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            Team t = board.getTeam(removed.getScoreboardName().getTeamName());
            if (t == null) continue;
            t.unregister();
        }
        removed.getScoreboardName().setTeamName(null);
    }

    public static void registerNoName(Scoreboard scoreboard) {
        Team mainTeam = scoreboard.getTeam("LD_NoName");
        if (mainTeam == null) {
            mainTeam = scoreboard.registerNewTeam("LD_NoName");
            mainTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            mainTeam.addEntry("");
        } else if (!mainTeam.hasEntry("")) {
            mainTeam.addEntry("");
        }
    }

    public static String[] getExtendedNameSplit(String playerName, String name) {
        String suffix;
        String nName;
        if (name.length() <= 16 && !DisguiseConfig.isScoreboardDisguiseNames()) {
            throw new IllegalStateException("This can only be used for names longer than 16 characters!");
        }
        if (name.length() > 48) {
            name = name.substring(0, 48);
        }
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        if (DisguiseConfig.isScoreboardDisguiseNames() && name.length() <= 32) {
            String[] newName = new String[]{name, playerName, ""};
            if (name.length() > 16) {
                newName[0] = name.charAt(16) == '\u00a7' ? name.substring(0, 15) : name.substring(0, 16);
                String suffix2 = ChatColor.getLastColors((String)newName[0]) + name.substring(newName[0].length());
                if (suffix2.length() > 16) {
                    suffix2 = suffix2.substring(0, 16);
                }
                newName[2] = suffix2;
            }
            String namePrefix = DisguiseUtilities.colorize("LD");
            if (playerName == null || !playerName.startsWith(namePrefix)) {
                String testName;
                String nameSuffix = "" + ChatColor.RESET;
                long time = System.nanoTime() / 100L % 10000L;
                for (int i = 0; i < 1000 && (testName = namePrefix + DisguiseUtilities.colorize(DisguiseUtilities.encode(time + (long)i)) + nameSuffix).length() <= 16; ++i) {
                    if (!DisguiseUtilities.isValidPlayerName(board, testName)) continue;
                    newName[1] = testName;
                    break;
                }
            }
            return newName;
        }
        for (int prefixLen = 16; prefixLen >= 0; --prefixLen) {
            String prefix = name.substring(0, prefixLen);
            if (prefix.endsWith("\u00a7")) continue;
            String colors = ChatColor.getLastColors((String)prefix);
            for (int nameLen = Math.min(name.length() - (prefixLen + colors.length()), 16 - colors.length()); nameLen > 0; --nameLen) {
                String nName2 = colors + name.substring(prefixLen, nameLen + prefixLen);
                if (nName2.endsWith("\u00a7")) continue;
                String suffix3 = name.substring(nameLen + prefixLen);
                if (suffix3.length() > 16) {
                    suffix3 = suffix3.substring(0, 16);
                }
                String[] extended = new String[]{prefix, nName2, suffix3};
                if ((playerName == null || !playerName.equals(extended[1])) && !DisguiseUtilities.isValidPlayerName(board, extended[1])) continue;
                return extended;
            }
        }
        String prefix = name.substring(0, 16);
        if (prefix.endsWith("\u00a7")) {
            prefix = prefix.substring(0, 15);
        }
        if ((nName = name.substring(prefix.length(), prefix.length() + Math.min(16, prefix.length()))).endsWith("\u00a7") && nName.length() > 1) {
            nName = nName.substring(0, nName.length() - 1);
        }
        if ((suffix = name.substring(prefix.length() + nName.length())).length() > 16) {
            suffix = suffix.substring(0, 16);
        }
        return new String[]{prefix, nName, suffix};
    }

    private static String colorize(String s) {
        StringBuilder builder = new StringBuilder(s.length() * 2);
        for (char c : s.toCharArray()) {
            builder.append('\u00a7').append(c);
        }
        return builder.toString();
    }

    private static String encode(long toConvert) {
        StringBuilder builder = new StringBuilder();
        while (toConvert != 0L) {
            builder.append(alphabet[(int)(toConvert % (long)alphabet.length)]);
            toConvert /= (long)alphabet.length;
        }
        return builder.reverse().toString();
    }

    private static boolean isValidPlayerName(Scoreboard board, String name) {
        return board.getEntryTeam(name) == null && Bukkit.getPlayerExact((String)name) == null;
    }

    public static void removeSelfDisguiseScoreboard(Player player) {
        String originalTeam = preDisguiseTeam.remove(player.getUniqueId());
        String teamDisguise = disguiseTeam.remove(player.getUniqueId());
        if (teamDisguise == null || DisguiseConfig.getPushingOption() == DisguiseConfig.DisguisePushing.IGNORE_SCOREBOARD) {
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        Team team = originalTeam == null ? null : scoreboard.getTeam(originalTeam);
        Team ldTeam = null;
        for (Team t : scoreboard.getTeams()) {
            if (!t.hasEntry(player.getName())) continue;
            ldTeam = t;
            break;
        }
        if (DisguiseConfig.isWarnScoreboardConflict()) {
            if (ldTeam == null || !ldTeam.getName().equals(teamDisguise)) {
                DisguiseUtilities.getLogger().warning("Scoreboard conflict, the self disguise player was not on the expected team!");
            } else {
                Team.OptionStatus collisions = ldTeam.getOption(Team.Option.COLLISION_RULE);
                if (collisions != Team.OptionStatus.NEVER && collisions != Team.OptionStatus.FOR_OTHER_TEAMS) {
                    DisguiseUtilities.getLogger().warning("Scoreboard conflict, the collisions for a self disguise player team has been unexpectedly modifed!");
                }
            }
        }
        if (ldTeam != null && !ldTeam.getName().equals("LD_Pushing") && !ldTeam.getName().endsWith("_LDP")) {
            ldTeam = null;
        }
        if (team != null) {
            team.addEntry(player.getName());
        } else if (ldTeam != null) {
            ldTeam.removeEntry(player.getName());
        }
        if (ldTeam != null && ldTeam.getEntries().isEmpty()) {
            ldTeam.unregister();
        }
    }

    public static void setupSelfDisguiseScoreboard(Player player) {
        if (disguiseTeam.containsKey(player.getUniqueId())) {
            return;
        }
        if (LibsPremium.getPluginInformation() != null && LibsPremium.getPluginInformation().isPremium() && !LibsPremium.getPluginInformation().isLegit() || LibsPremium.getPaidInformation() != null && !LibsPremium.getPaidInformation().isLegit()) {
            return;
        }
        DisguiseConfig.DisguisePushing pOption = DisguiseConfig.getPushingOption();
        if (pOption == DisguiseConfig.DisguisePushing.IGNORE_SCOREBOARD) {
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        Team prevTeam = null;
        Team ldTeam = null;
        String ldTeamName = "LD_Pushing";
        for (Team t : scoreboard.getTeams()) {
            if (!t.hasEntry(player.getName())) continue;
            prevTeam = t;
            break;
        }
        if (prevTeam != null && !prevTeam.getName().equals("LD_Pushing") && !prevTeam.getName().endsWith("_LDP")) {
            if (pOption == DisguiseConfig.DisguisePushing.CREATE_SCOREBOARD) {
                preDisguiseTeam.put(player.getUniqueId(), prevTeam.getName());
            } else {
                ldTeam = prevTeam;
            }
        } else {
            prevTeam = null;
        }
        if (pOption == DisguiseConfig.DisguisePushing.CREATE_SCOREBOARD) {
            ldTeamName = prevTeam == null ? "NoTeam" : prevTeam.getName();
            ldTeamName = ldTeamName.substring(0, Math.min(12, ldTeamName.length())) + "_LDP";
        }
        if (ldTeam == null && (ldTeam = scoreboard.getTeam(ldTeamName)) == null) {
            ldTeam = scoreboard.registerNewTeam(ldTeamName);
        }
        disguiseTeam.put(player.getUniqueId(), ldTeam.getName());
        if (!ldTeam.hasEntry(player.getName())) {
            ldTeam.addEntry(player.getName());
        }
        if (pOption == DisguiseConfig.DisguisePushing.CREATE_SCOREBOARD && prevTeam != null) {
            ldTeam.setAllowFriendlyFire(prevTeam.allowFriendlyFire());
            ldTeam.setCanSeeFriendlyInvisibles(prevTeam.canSeeFriendlyInvisibles());
            ldTeam.setDisplayName(prevTeam.getDisplayName());
            ldTeam.setPrefix(prevTeam.getPrefix());
            ldTeam.setSuffix(prevTeam.getSuffix());
            for (Team.Option option : Team.Option.values()) {
                ldTeam.setOption(option, prevTeam.getOption(option));
            }
        }
        if (ldTeam.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.NEVER && DisguiseConfig.isModifyCollisions()) {
            ldTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        }
        if (ldTeam.canSeeFriendlyInvisibles() && DisguiseConfig.isDisableFriendlyInvisibles()) {
            ldTeam.setCanSeeFriendlyInvisibles(false);
        }
    }

    public static String quote(String string) {
        if (!(string.contains(" ") || string.startsWith("\"") || string.endsWith("\""))) {
            return string;
        }
        return "\"" + string.replaceAll("\\\\(?=\\\\*\"( |$))", "\\\\\\\\").replaceAll("((?<= )\")|(\"(?= ))", "\\\\\"") + "\"";
    }

    public static String[] split(String string) {
        Pattern endsWithQuote = Pattern.compile("^([^\\\\]|\\\\(?!\\\\*\"$))*(\\\\\\\\)*\"$");
        Pattern removeSlashes = Pattern.compile("^\\\\(\")|\\\\(?:(\\\\)(?=\\\\*\"$)|(\")$)");
        ArrayList<String> list = new ArrayList<String>();
        String[] split = string.split(" ");
        String[] unescapedSplit = new String[split.length];
        block0: for (int i = 0; i < split.length; ++i) {
            if (split[i].startsWith("\"")) {
                for (int a = i; a < split.length; ++a) {
                    if (a == i && split[i].length() == 1 || !endsWithQuote.matcher(split[a]).matches()) continue;
                    StringBuilder builder = new StringBuilder();
                    for (int b = i; b <= a; ++b) {
                        Matcher matcher = removeSlashes.matcher(split[b]);
                        String word = matcher.replaceAll("$1$2$3");
                        if (b == i || b == a) {
                            word = word.substring(b == i ? 1 : 0, word.length() - (b == a ? 1 : 0));
                        }
                        if (b > i) {
                            builder.append(" ");
                        }
                        builder.append(word);
                    }
                    list.add(builder.toString());
                    i = a;
                    continue block0;
                }
            }
            Matcher matcher = removeSlashes.matcher(split[i]);
            String word = matcher.replaceAll("$1$2$3");
            list.add(word);
        }
        return list.toArray(new String[0]);
    }

    public static void sendSelfDisguise(Player player, TargetedDisguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            if (!(disguise.isDisguiseInUse() && player.isValid() && player.isOnline() && disguise.isSelfDisguiseVisible() && disguise.canSee(player))) {
                return;
            }
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (entityTrackerEntry == null) {
                Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                    if (DisguiseAPI.getDisguise(player, (Entity)player) == disguise) {
                        DisguiseUtilities.sendSelfDisguise(player, disguise);
                    }
                });
                return;
            }
            DisguiseUtilities.setupSelfDisguiseScoreboard(player);
            if (!runningPaper) {
                Object trackedPlayersObj = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                ((Set)trackedPlayersObj).add(ReflectionManager.getNmsEntity((Entity)player));
            } else {
                Field field = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap");
                Object nmsEntity = ReflectionManager.getNmsEntity((Entity)player);
                Map map = (Map)field.get(entityTrackerEntry);
                map.put(nmsEntity, true);
            }
            ProtocolManager manager = ProtocolLibrary.getProtocolManager();
            manager.sendServerPacket(player, manager.createPacketConstructor(PacketType.Play.Server.NAMED_ENTITY_SPAWN, new Object[]{player}).createPacket(new Object[]{player}));
            WrappedDataWatcher dataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)player);
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), dataWatcher, true}).createPacket(new Object[]{player.getEntityId(), dataWatcher, true}));
            boolean isMoving = false;
            try {
                Field field = ReflectionManager.getNmsClass("EntityTrackerEntry").getDeclaredField(NmsVersion.v1_14.isSupported() ? "q" : "isMoving");
                field.setAccessible(true);
                isMoving = field.getBoolean(entityTrackerEntry);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (isMoving) {
                Vector velocity = player.getVelocity();
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_VELOCITY, new Object[]{player}).createPacket(new Object[]{player}));
            }
            if (player.getVehicle() != null && player.getEntityId() > player.getVehicle().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{0, player, player.getVehicle()}).createPacket(new Object[]{0, player, player.getVehicle()}));
            } else if (player.getPassenger() != null && player.getEntityId() > player.getPassenger().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{0, player.getPassenger(), player}).createPacket(new Object[]{0, player.getPassenger(), player}));
            }
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(player.getInventory().getHelmet())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.CHEST), ReflectionManager.getNmsItem(player.getInventory().getChestplate())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.LEGS), ReflectionManager.getNmsItem(player.getInventory().getLeggings())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.FEET), ReflectionManager.getNmsItem(player.getInventory().getBoots())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.HAND), ReflectionManager.getNmsItem(player.getInventory().getItemInMainHand())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.OFF_HAND), ReflectionManager.getNmsItem(player.getInventory().getItemInOffHand())}));
            Location loc = player.getLocation();
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                Object mobEffect = ReflectionManager.createMobEffect(potionEffect);
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EFFECT, new Object[]{player.getEntityId(), mobEffect}).createPacket(new Object[]{player.getEntityId(), mobEffect}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getPlayerListName(Player player) {
        return Strings.isEmpty((CharSequence)player.getPlayerListName()) ? player.getName() : player.getPlayerListName();
    }

    public static Logger getLogger() {
        return LibsDisguises.getInstance().getLogger();
    }

    private static void sendSelfPacket(Player player, PacketContainer packet) {
        Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
        if (disguise == null) {
            return;
        }
        LibsPackets transformed = PacketsManager.getPacketsHandler().transformPacket(packet, disguise, player, (Entity)player);
        try {
            if (transformed.isUnhandled()) {
                transformed.addPacket(packet);
            }
            for (PacketContainer p : transformed.getPackets()) {
                p = p.deepClone();
                p.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, p, false);
            }
            transformed.sendDelayed(player);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static PacketContainer getTabPacket(PlayerDisguise disguise, EnumWrappers.PlayerInfoAction action) {
        PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        addTab.getPlayerInfoAction().write(0, (Object)action);
        addTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(disguise.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)disguise.getName()))));
        return addTab;
    }

    public static void setupFakeDisguise(Disguise disguise) {
        Entity e = disguise.getEntity();
        if (!(e instanceof Player && DisguiseUtilities.getDisguises().containsKey(e.getUniqueId()) && DisguiseUtilities.getDisguises().get(e.getUniqueId()).contains(disguise))) {
            return;
        }
        Player player = (Player)e;
        if (!((TargetedDisguise)disguise).canSee(player)) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(player);
        if (!disguise.isSelfDisguiseVisible() || !PacketsManager.isViewDisguisesListenerEnabled() || player.getVehicle() != null) {
            return;
        }
        selfDisguised.add(player.getUniqueId());
        DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise);
        if ((disguise.isHidingArmorFromSelf() || disguise.isHidingHeldItemFromSelf()) && PacketsManager.isInventoryListenerEnabled()) {
            player.updateInventory();
        }
    }

    public static WrappedDataWatcher.Serializer getSerializer(MetaIndex index) {
        if (index.getSerializer() != null) {
            return index.getSerializer();
        }
        if (index.getDefault() instanceof Optional) {
            for (Field f : MetaIndex.class.getFields()) {
                try {
                    if (f.get(null) != index) {
                        continue;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                Type type = f.getGenericType();
                Type opt = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (!(opt instanceof ParameterizedType)) continue;
                Type val = ((ParameterizedType)opt).getActualTypeArguments()[0];
                return WrappedDataWatcher.Registry.get((Class)ReflectionManager.getNmsClass((Class)val), (boolean)true);
            }
        } else {
            return WrappedDataWatcher.Registry.get((Class)ReflectionManager.getNmsClass(index.getDefault().getClass()));
        }
        Object value = index.getDefault();
        throw new IllegalArgumentException("Unable to find Serializer for " + value + (value instanceof Optional && ((Optional)value).isPresent() ? " (" + ((Optional)value).get().getClass().getName() + ")" : (value instanceof Optional || value == null ? "" : " " + value.getClass().getName())) + "! Are you running the latest version of ProtocolLib?");
    }

    public static String serialize(NbtBase base) {
        return DisguiseUtilities.serialize(0, base);
    }

    private static String serialize(int depth, NbtBase base) {
        switch (base.getType()) {
            case TAG_COMPOUND: {
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                for (String key : ((NbtCompound)base).getKeys()) {
                    NbtBase nbt = ((NbtCompound)base).getValue(key);
                    String val = DisguiseUtilities.serialize(depth + 1, nbt);
                    if (depth == 0 && val.matches("0(\\.0)?")) continue;
                    if (builder.length() != 1) {
                        builder.append(",");
                    }
                    builder.append(key).append(":").append(val);
                }
                builder.append("}");
                return builder.toString();
            }
            case TAG_LIST: {
                Collection col = ((NbtList)base).asCollection();
                return "[" + StringUtils.join((Object[])col.stream().map(b -> DisguiseUtilities.serialize(depth + 1, (NbtBase)b)).toArray(), (String)",") + "]";
            }
            case TAG_BYTE_ARRAY: 
            case TAG_INT_ARRAY: 
            case TAG_LONG_ARRAY: {
                Object[] array = (Object[])base.getValue();
                Object[] str = new String[array.length];
                for (int i = 0; i < array.length; ++i) {
                    str[i] = array[i].toString();
                }
                return "[" + StringUtils.join((Object[])str, (String)",") + "]";
            }
            case TAG_BYTE: 
            case TAG_INT: 
            case TAG_LONG: 
            case TAG_FLOAT: 
            case TAG_SHORT: 
            case TAG_DOUBLE: {
                return base.getValue().toString();
            }
            case TAG_STRING: {
                String val = (String)base.getValue();
                return "\"" + val.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
            }
            case TAG_END: {
                return "";
            }
        }
        throw new IllegalArgumentException();
    }

    public static WrappedDataWatcher createSanitizedDataWatcher(WrappedDataWatcher entityWatcher, FlagWatcher disguiseWatcher) {
        WrappedDataWatcher newWatcher = new WrappedDataWatcher();
        try {
            List<WrappedWatchableObject> list = DisguiseConfig.isMetaPacketsEnabled() ? disguiseWatcher.convert(entityWatcher.getWatchableObjects()) : disguiseWatcher.getWatchableObjects();
            for (WrappedWatchableObject watchableObject : list) {
                if (watchableObject == null || watchableObject.getValue() == null) continue;
                MetaIndex metaIndex = MetaIndex.getMetaIndex(disguiseWatcher, watchableObject.getIndex());
                WrappedDataWatcher.WrappedDataWatcherObject obj = ReflectionManager.createDataWatcherObject(metaIndex, watchableObject.getValue());
                newWatcher.setObject(obj, watchableObject.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newWatcher;
    }

    public static byte getPitch(DisguiseType disguiseType, EntityType entityType, byte value) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(DisguiseType.getType(entityType), value));
    }

    public static byte getPitch(DisguiseType disguiseType, DisguiseType entityType, byte value) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(entityType, value));
    }

    public static byte getPitch(DisguiseType disguiseType, byte value) {
        if (disguiseType.isMisc()) {
            return -value;
        }
        switch (disguiseType) {
            case PHANTOM: {
                return -value;
            }
        }
        return value;
    }

    public static byte getYaw(DisguiseType disguiseType, EntityType entityType, byte value) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(DisguiseType.getType(entityType), value));
    }

    public static byte getYaw(DisguiseType disguiseType, DisguiseType entityType, byte value) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(entityType, value));
    }

    public static byte getYaw(DisguiseType disguiseType, byte value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                return (byte)(value + 64);
            }
            case BOAT: 
            case ENDER_DRAGON: 
            case WITHER_SKULL: {
                return (byte)(value - 128);
            }
            case ARROW: 
            case SPECTRAL_ARROW: {
                return -value;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                return (byte)(-(value + 128));
            }
        }
        if (disguiseType.isMisc() && disguiseType != DisguiseType.ARMOR_STAND) {
            return (byte)(value - 64);
        }
        return value;
    }

    public static Disguise getDisguise(Player observer, int entityId) {
        if (entityId == DisguiseAPI.getSelfDisguiseId()) {
            entityId = observer.getEntityId();
        }
        if (DisguiseUtilities.getFutureDisguises().containsKey(entityId)) {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (entity.getEntityId() != entityId) continue;
                    DisguiseUtilities.onFutureDisguise(entity);
                }
            }
        }
        for (Set set : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise dis : set) {
                if (dis.getEntity() == null || !dis.isDisguiseInUse() || dis.getEntity().getEntityId() != entityId || !dis.canSee(observer)) continue;
                return dis;
            }
        }
        return null;
    }

    public static Entity getEntity(World world, int entityId) {
        for (Entity e : world.getEntities()) {
            if (e.getEntityId() != entityId) continue;
            return e;
        }
        return null;
    }

    public static double getYModifier(Entity entity, Disguise disguise) {
        double yMod = 0.0;
        if (disguise.getType() != DisguiseType.PLAYER && entity.getType() == EntityType.DROPPED_ITEM) {
            yMod -= 0.13;
        }
        switch (disguise.getType()) {
            case BAT: {
                if (entity instanceof LivingEntity) {
                    return yMod + ((LivingEntity)entity).getEyeHeight();
                }
                return yMod;
            }
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                switch (entity.getType()) {
                    case MINECART: 
                    case MINECART_CHEST: 
                    case MINECART_FURNACE: 
                    case MINECART_HOPPER: 
                    case MINECART_MOB_SPAWNER: 
                    case MINECART_TNT: {
                        return yMod;
                    }
                }
                return yMod + 0.4;
            }
            case BOAT: 
            case WITHER_SKULL: 
            case ARROW: 
            case SPECTRAL_ARROW: 
            case PAINTING: 
            case EGG: 
            case ENDER_PEARL: 
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: {
                return yMod + 0.7;
            }
            case DROPPED_ITEM: {
                return yMod + 0.13;
            }
        }
        return yMod;
    }

    public static Random getRandom() {
        return random;
    }

    public static Map<UUID, Set<TargetedDisguise>> getDisguises() {
        return disguises;
    }

    public static HashMap<Integer, HashSet<TargetedDisguise>> getFutureDisguises() {
        return futureDisguises;
    }

    public static HashSet<UUID> getSelfDisguised() {
        return selfDisguised;
    }

    public static Gson getGson() {
        return gson;
    }

    public static boolean isPluginsUsed() {
        return pluginsUsed;
    }

    public static boolean isCommandsUsed() {
        return commandsUsed;
    }

    public static MineSkinAPI getMineSkinAPI() {
        return mineSkinAPI;
    }

    public static boolean isInvalidFile() {
        return invalidFile;
    }

    public static char[] getAlphabet() {
        return alphabet;
    }

    static {
        disguiseLoading = new HashMap();
        mineSkinAPI = new MineSkinAPI();
        alphabet = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    }

    public static class DScoreTeam {
        private String teamName;
        private String[] split;
        private PlayerDisguise disguise;

        public DScoreTeam(String[] name) {
            this.split = name;
        }

        public String getPlayer() {
            return this.split[1];
        }

        public String getPrefix() {
            return this.split[0];
        }

        public String getSuffix() {
            return this.split[2];
        }

        public void handleTeam(Scoreboard board, boolean nameVisible) {
            Team team = board.getTeam(this.getTeamName());
            if (team == null) {
                team = board.registerNewTeam(this.getTeamName());
                team.addEntry(this.getPlayer());
                if (!nameVisible) {
                    team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                }
            } else if (team.getOption(Team.Option.NAME_TAG_VISIBILITY) != (nameVisible ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER)) {
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, nameVisible ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
            }
            team.setPrefix(this.getPrefix());
            team.setSuffix(this.getSuffix());
        }

        public void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        public void setSplit(String[] split) {
            this.split = split;
        }

        public void setDisguise(PlayerDisguise disguise) {
            this.disguise = disguise;
        }

        public String getTeamName() {
            return this.teamName;
        }
    }
}

