/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.inventory.MainHand;

public class PlayerWatcher
extends LivingWatcher {
    private boolean alwaysShowInTab = DisguiseConfig.isShowDisguisedPlayersInTab();

    public PlayerWatcher(Disguise disguise) {
        super(disguise);
        this.setData(MetaIndex.PLAYER_SKIN, MetaIndex.PLAYER_SKIN.getDefault());
        this.setData(MetaIndex.PLAYER_HAND, (byte)1);
    }

    public boolean isDisplayedInTab() {
        return this.alwaysShowInTab;
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        if (this.getDisguise().isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.alwaysShowInTab = showPlayerInTab;
    }

    public boolean isNameVisible() {
        return ((PlayerDisguise)this.getDisguise()).isNameVisible();
    }

    public void setNameVisible(boolean nameVisible) {
        ((PlayerDisguise)this.getDisguise()).setNameVisible(nameVisible);
    }

    @RandomDefaultValue
    public String getName() {
        return ((PlayerDisguise)this.getDisguise()).getName();
    }

    @RandomDefaultValue
    public void setName(String name) {
        ((PlayerDisguise)this.getDisguise()).setName(name);
    }

    @Override
    public PlayerWatcher clone(Disguise disguise) {
        PlayerWatcher watcher = (PlayerWatcher)super.clone(disguise);
        watcher.alwaysShowInTab = this.alwaysShowInTab;
        return watcher;
    }

    public MainHand getMainHand() {
        return MainHand.values()[this.getData(MetaIndex.PLAYER_HAND)];
    }

    public void setMainHand(MainHand mainHand) {
        this.setData(MetaIndex.PLAYER_HAND, (byte)mainHand.ordinal());
        this.sendData(MetaIndex.PLAYER_HAND);
    }

    private boolean isSkinFlag(int i) {
        return (this.getData(MetaIndex.PLAYER_SKIN) & 1 << i) != 0;
    }

    public boolean isCapeEnabled() {
        return this.isSkinFlag(1);
    }

    public void setCapeEnabled(boolean enabled) {
        this.setSkinFlags(1, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isJacketEnabled() {
        return this.isSkinFlag(2);
    }

    public void setJacketEnabled(boolean enabled) {
        this.setSkinFlags(2, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isLeftSleeveEnabled() {
        return this.isSkinFlag(3);
    }

    public void setLeftSleeveEnabled(boolean enabled) {
        this.setSkinFlags(3, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isRightSleeveEnabled() {
        return this.isSkinFlag(4);
    }

    public void setRightSleeveEnabled(boolean enabled) {
        this.setSkinFlags(4, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isLeftPantsEnabled() {
        return this.isSkinFlag(5);
    }

    public void setLeftPantsEnabled(boolean enabled) {
        this.setSkinFlags(5, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isRightPantsEnabled() {
        return this.isSkinFlag(6);
    }

    public void setRightPantsEnabled(boolean enabled) {
        this.setSkinFlags(6, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isHatEnabled() {
        return this.isSkinFlag(7);
    }

    public void setHatEnabled(boolean enabled) {
        this.setSkinFlags(7, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public WrappedGameProfile getSkin() {
        return ((PlayerDisguise)this.getDisguise()).getGameProfile();
    }

    public void setSkin(String playerName) {
        ((PlayerDisguise)this.getDisguise()).setSkin(playerName);
    }

    @RandomDefaultValue
    public void setSkin(WrappedGameProfile profile) {
        ((PlayerDisguise)this.getDisguise()).setSkin(profile);
    }

    private void setSkinFlags(int i, boolean flag) {
        byte b0 = this.getData(MetaIndex.PLAYER_SKIN);
        if (flag) {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 | 1 << i));
        } else {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 & -2 << i));
        }
    }
}

