/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.ComponentConverter;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.LibsEquipment;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FlagWatcher {
    private boolean addEntityAnimations = DisguiseConfig.isAddEntityAnimations();
    private HashMap<Integer, Object> backupEntityValues = new HashMap();
    private transient TargetedDisguise disguise;
    private HashMap<Integer, Object> entityValues = new HashMap();
    private LibsEquipment equipment;
    private boolean hasDied;
    private boolean[] modifiedEntityAnimations = new boolean[8];
    private transient List<WrappedWatchableObject> watchableObjects;
    private boolean sleeping;
    private boolean swimming;

    public FlagWatcher(Disguise disguise) {
        this.disguise = (TargetedDisguise)disguise;
        this.equipment = new LibsEquipment(this);
    }

    private byte addEntityAnimations(byte originalValue, byte entityValue) {
        for (int i = 0; i < 6; ++i) {
            if ((entityValue & 1 << i) == 0 || this.modifiedEntityAnimations[i]) continue;
            originalValue = (byte)(originalValue | 1 << i);
        }
        return originalValue;
    }

    public FlagWatcher clone(Disguise owningDisguise) {
        FlagWatcher cloned;
        try {
            cloned = (FlagWatcher)this.getClass().getConstructor(Disguise.class).newInstance(owningDisguise);
        }
        catch (Exception e) {
            e.printStackTrace();
            cloned = new FlagWatcher(owningDisguise);
        }
        cloned.entityValues = (HashMap)this.entityValues.clone();
        cloned.equipment = this.equipment.clone(cloned);
        cloned.modifiedEntityAnimations = Arrays.copyOf(this.modifiedEntityAnimations, this.modifiedEntityAnimations.length);
        cloned.addEntityAnimations = this.addEntityAnimations;
        return cloned;
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    public void setHelmet(ItemStack itemStack) {
        this.getEquipment().setHelmet(itemStack);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    public void setBoots(ItemStack itemStack) {
        this.getEquipment().setBoots(itemStack);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    public void setLeggings(ItemStack itemStack) {
        this.getEquipment().setLeggings(itemStack);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    public void setChestplate(ItemStack itemStack) {
        this.getEquipment().setChestplate(itemStack);
    }

    public List<WrappedWatchableObject> convert(List<WrappedWatchableObject> list) {
        ArrayList<WrappedWatchableObject> newList = new ArrayList<WrappedWatchableObject>();
        HashSet<Integer> sentValues = new HashSet<Integer>();
        boolean sendAllCustom = false;
        for (WrappedWatchableObject watch : list) {
            boolean isDirty;
            int id = watch.getIndex();
            sentValues.add(id);
            if (id == MetaIndex.ENTITY_AIR_TICKS.getIndex()) {
                sendAllCustom = true;
            }
            Object value = null;
            if (this.entityValues.containsKey(id)) {
                if (this.entityValues.get(id) == null) continue;
                value = this.entityValues.get(id);
            } else if (this.backupEntityValues.containsKey(id)) {
                if (this.backupEntityValues.get(id) == null) continue;
                value = this.backupEntityValues.get(id);
            }
            if (value != null) {
                if (this.isEntityAnimationsAdded() && id == 0) {
                    value = this.addEntityAnimations((Byte)value, (Byte)watch.getValue());
                }
                isDirty = watch.getDirtyState();
                watch = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, id), value);
                if (watch == null) continue;
                if (!isDirty) {
                    watch.setDirtyState(false);
                }
            } else {
                isDirty = watch.getDirtyState();
                watch = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, id), watch.getValue());
                if (watch == null) continue;
                if (!isDirty) {
                    watch.setDirtyState(false);
                }
            }
            newList.add(watch);
        }
        if (sendAllCustom) {
            for (Integer id : this.entityValues.keySet()) {
                WrappedWatchableObject watch;
                Object value;
                if (sentValues.contains(id) || (value = this.entityValues.get(id)) == null || (watch = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, (int)id), value)) == null) continue;
                newList.add(watch);
            }
        }
        if (this.getDisguise().isSelfDisguiseVisible() && this.getDisguise().getEntity() != null && this.getDisguise().getEntity() instanceof Player) {
            for (WrappedWatchableObject watch : newList) {
                Object value;
                if (watch.getIndex() != 6 || !((value = watch.getValue()) instanceof Float)) continue;
                float newHealth = ((Float)value).floatValue();
                if (newHealth > 0.0f && this.hasDied) {
                    this.hasDied = false;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)this.getDisguise().getEntity(), this.getDisguise());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    continue;
                }
                if (!(newHealth <= 0.0f) || this.hasDied) continue;
                this.hasDied = true;
            }
        }
        return newList;
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    public EntityPose getEntityPose() {
        return this.getData(MetaIndex.ENTITY_POSE);
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    public void setEntityPose(EntityPose entityPose) {
        this.setData(MetaIndex.ENTITY_POSE, entityPose);
        this.sendData(MetaIndex.ENTITY_POSE);
    }

    public ItemStack[] getArmor() {
        return this.getEquipment().getArmorContents();
    }

    public void setArmor(ItemStack[] items) {
        this.getEquipment().setArmorContents(items);
    }

    public String getCustomName() {
        if (!NmsVersion.v1_13.isSupported()) {
            return this.getData(MetaIndex.ENTITY_CUSTOM_NAME_OLD);
        }
        Optional<WrappedChatComponent> optional = this.getData(MetaIndex.ENTITY_CUSTOM_NAME);
        if (optional.isPresent()) {
            BaseComponent[] base = ComponentConverter.fromWrapper((WrappedChatComponent)optional.get());
            return TextComponent.toLegacyText((BaseComponent[])base);
        }
        return null;
    }

    public void setCustomName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            if (NmsVersion.v1_13.isSupported()) {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME, Optional.empty());
            } else {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, "");
            }
        } else {
            if (name.length() > 64) {
                name = name.substring(0, 64);
            }
            if (NmsVersion.v1_13.isSupported()) {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME, Optional.of(WrappedChatComponent.fromText((String)name)));
            } else {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, name);
            }
        }
        if (NmsVersion.v1_13.isSupported()) {
            this.sendData(MetaIndex.ENTITY_CUSTOM_NAME);
        } else {
            this.sendData(MetaIndex.ENTITY_CUSTOM_NAME_OLD);
        }
    }

    protected TargetedDisguise getDisguise() {
        return this.disguise;
    }

    protected void setDisguise(TargetedDisguise disguise) {
        this.disguise = disguise;
        this.equipment.setFlagWatcher(this);
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public ItemStack getItemInMainHand() {
        return this.equipment.getItemInMainHand();
    }

    public void setItemInMainHand(ItemStack itemstack) {
        this.setItemStack(EquipmentSlot.HAND, itemstack);
    }

    public ItemStack getItemInOffHand() {
        return this.equipment.getItemInOffHand();
    }

    public void setItemInOffHand(ItemStack itemstack) {
        this.setItemStack(EquipmentSlot.OFF_HAND, itemstack);
    }

    public ItemStack getItemStack(EquipmentSlot slot) {
        return this.equipment.getItem(slot);
    }

    protected <Y> Y getData(MetaIndex<Y> flagType) {
        if (flagType == null) {
            return null;
        }
        if (this.entityValues.containsKey(flagType.getIndex())) {
            return (Y)this.entityValues.get(flagType.getIndex());
        }
        return flagType.getDefault();
    }

    public List<WrappedWatchableObject> getWatchableObjects() {
        if (this.watchableObjects == null) {
            this.rebuildWatchableObjects();
        }
        return this.watchableObjects;
    }

    public boolean hasCustomName() {
        return this.getCustomName() != null;
    }

    public boolean hasValue(MetaIndex no) {
        if (no == null) {
            return false;
        }
        return this.entityValues.containsKey(no.getIndex());
    }

    public boolean isBurning() {
        return this.getEntityFlag(0);
    }

    public void setBurning(boolean setBurning) {
        this.setEntityFlag(0, setBurning);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isCustomNameVisible() {
        return this.getData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    public void setCustomNameVisible(boolean display) {
        this.setData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE, display);
        this.sendData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    @Deprecated
    public boolean isEntityAnimationsAdded() {
        return this.addEntityAnimations;
    }

    public boolean isFlyingWithElytra() {
        return this.getEntityFlag(7);
    }

    public void setFlyingWithElytra(boolean flying) {
        this.setEntityFlag(7, flying);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isGlowing() {
        return this.getEntityFlag(6);
    }

    public void setGlowing(boolean glowing) {
        this.setEntityFlag(6, glowing);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isInvisible() {
        return this.getEntityFlag(5);
    }

    public void setInvisible(boolean setInvis) {
        this.setEntityFlag(5, setInvis);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isNoGravity() {
        return this.getData(MetaIndex.ENTITY_NO_GRAVITY);
    }

    public void setNoGravity(boolean noGravity) {
        this.setData(MetaIndex.ENTITY_NO_GRAVITY, noGravity);
        this.sendData(MetaIndex.ENTITY_NO_GRAVITY);
    }

    public boolean isRightClicking() {
        return this.getEntityFlag(4);
    }

    public void setRightClicking(boolean setRightClicking) {
        this.setEntityFlag(4, setRightClicking);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    public void setSneaking(boolean setSneaking) {
        this.setEntityFlag(1, setSneaking);
        this.sendData(MetaIndex.ENTITY_META);
        if (NmsVersion.v1_14.isSupported()) {
            this.updatePose();
        }
    }

    public boolean isSprinting() {
        return this.getEntityFlag(3);
    }

    public void setSprinting(boolean setSprinting) {
        this.setEntityFlag(3, setSprinting);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public void rebuildWatchableObjects() {
        this.watchableObjects = new ArrayList<WrappedWatchableObject>();
        for (int i = 0; i <= 31; ++i) {
            WrappedWatchableObject watchable;
            if (this.entityValues.containsKey(i) && this.entityValues.get(i) != null) {
                watchable = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, i), this.entityValues.get(i));
            } else {
                if (!this.backupEntityValues.containsKey(i) || this.backupEntityValues.get(i) == null) continue;
                watchable = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, i), this.backupEntityValues.get(i));
            }
            if (watchable == null) continue;
            this.watchableObjects.add(watchable);
        }
    }

    protected void sendData(MetaIndex ... dataValues) {
        if (this.getDisguise() == null || !DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this) {
            return;
        }
        ArrayList<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
        for (MetaIndex data : dataValues) {
            WrappedWatchableObject watch;
            if (data == null || !this.entityValues.containsKey(data.getIndex()) || this.entityValues.get(data.getIndex()) == null) continue;
            Object value = this.entityValues.get(data.getIndex());
            if (this.isEntityAnimationsAdded() && DisguiseConfig.isMetaPacketsEnabled() && data == MetaIndex.ENTITY_META) {
                value = this.addEntityAnimations((Byte)value, WrappedDataWatcher.getEntityWatcher((Entity)this.disguise.getEntity()).getByte(0));
            }
            if ((watch = ReflectionManager.createWatchable(data, value)) == null) continue;
            list.add(watch);
        }
        if (!list.isEmpty()) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            StructureModifier mods = packet.getModifier();
            mods.write(0, (Object)this.getDisguise().getEntity().getEntityId());
            packet.getWatchableCollectionModifier().write(0, list);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    if (player == this.getDisguise().getEntity()) {
                        PacketContainer temp = packet.shallowClone();
                        temp.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, temp);
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isAddEntityAnimations() {
        return this.isEntityAnimationsAdded();
    }

    public void setAddEntityAnimations(boolean isEntityAnimationsAdded) {
        this.addEntityAnimations = isEntityAnimationsAdded;
    }

    protected void setBackupValue(MetaIndex no, Object value) {
        if (no == null) {
            return;
        }
        this.backupEntityValues.put(no.getIndex(), value);
    }

    private boolean getEntityFlag(int byteValue) {
        return (this.getData(MetaIndex.ENTITY_META) & 1 << byteValue) != 0;
    }

    private void setEntityFlag(int byteValue, boolean flag) {
        this.modifiedEntityAnimations[byteValue] = true;
        byte b0 = this.getData(MetaIndex.ENTITY_META);
        if (flag) {
            this.setData(MetaIndex.ENTITY_META, (byte)(b0 | 1 << byteValue));
        } else {
            this.setData(MetaIndex.ENTITY_META, (byte)(b0 & ~(1 << byteValue)));
        }
    }

    @Deprecated
    public void setItemInHand(ItemStack itemstack) {
        this.setItemInMainHand(itemstack);
    }

    public void setItemStack(EquipmentSlot slot, ItemStack itemStack) {
        this.equipment.setItem(slot, itemStack);
    }

    protected void sendItemStack(EquipmentSlot slot, ItemStack itemStack) {
        if (!DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this || this.getDisguise().getEntity() == null) {
            return;
        }
        if (itemStack == null && this.getDisguise().getEntity() instanceof LivingEntity) {
            EntityEquipment equip = ((LivingEntity)this.getDisguise().getEntity()).getEquipment();
            switch (slot) {
                case HAND: {
                    itemStack = equip.getItemInMainHand();
                    break;
                }
                case OFF_HAND: {
                    itemStack = equip.getItemInOffHand();
                    break;
                }
                case HEAD: {
                    itemStack = equip.getHelmet();
                    break;
                }
                case CHEST: {
                    itemStack = equip.getChestplate();
                    break;
                }
                case LEGS: {
                    itemStack = equip.getLeggings();
                    break;
                }
                case FEET: {
                    itemStack = equip.getBoots();
                    break;
                }
            }
        }
        Object itemToSend = ReflectionManager.getNmsItem(itemStack);
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        StructureModifier mods = packet.getModifier();
        mods.write(0, (Object)this.getDisguise().getEntity().getEntityId());
        mods.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
        mods.write(2, itemToSend);
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    public boolean isSleeping() {
        return this.sleeping;
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    public void setSleeping(boolean sleeping) {
        if (this.isSleeping() == sleeping) {
            return;
        }
        this.sleeping = sleeping;
        this.updatePose();
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    public boolean isSwimming() {
        return this.swimming;
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    public void setSwimming(boolean swimming) {
        if (this.isSwimming() == swimming) {
            return;
        }
        this.swimming = swimming;
        this.updatePose();
    }

    @NmsAddedIn(val=NmsVersion.v1_14)
    protected void updatePose() {
        if (this.isSleeping()) {
            this.setEntityPose(EntityPose.SLEEPING);
        } else if (this.isSwimming()) {
            this.setEntityPose(EntityPose.SWIMMING);
        } else if (this.isSneaking()) {
            this.setEntityPose(EntityPose.SNEAKING);
        } else {
            this.setEntityPose(EntityPose.STANDING);
        }
    }

    protected <Y> void setData(MetaIndex<Y> id, Y value) {
        if (id == null) {
            return;
        }
        if (id.getIndex() == -1) {
            throw new IllegalArgumentException("You can't do that in this version of Minecraft! I can't use " + MetaIndex.getName(id) + "!");
        }
        if (value == null && id.getDefault() instanceof ItemStack) {
            throw new IllegalArgumentException("Cannot use null ItemStacks");
        }
        this.entityValues.put(id.getIndex(), value);
        if (!DisguiseConfig.isMetaPacketsEnabled()) {
            this.rebuildWatchableObjects();
        }
    }

    protected HashMap<Integer, Object> getBackupEntityValues() {
        return this.backupEntityValues;
    }

    protected HashMap<Integer, Object> getEntityValues() {
        return this.entityValues;
    }
}

