/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Arrays;
import java.util.List;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.UpdateChecker;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUpdate
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("update", "update!");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.update";
    }

    @Override
    public void onCommand(final CommandSender sender, String[] args) {
        final UpdateChecker checker = LibsDisguises.getInstance().getUpdateChecker();
        if (checker.isDownloading()) {
            sender.sendMessage(LibsMsg.UPDATE_IN_PROGRESS.get(new Object[0]));
            return;
        }
        final boolean force = args[0].endsWith("!");
        if (!force) {
            if (checker.getLatestSnapshot() <= 0) {
                sender.sendMessage(LibsMsg.UPDATE_NOT_READY.get(new Object[0]));
                return;
            }
            if (checker.getLatestSnapshot() == LibsDisguises.getInstance().getBuildNumber()) {
                sender.sendMessage(LibsMsg.UPDATE_ON_LATEST.get(new Object[0]));
                return;
            }
        }
        new BukkitRunnable(){

            public void run() {
                boolean result = force ? checker.grabLatestSnapshot() : checker.grabSnapshotBuild();
                if (!result) {
                    sender.sendMessage(LibsMsg.UPDATE_FAILED.get(new Object[0]));
                    return;
                }
                sender.sendMessage(LibsMsg.UPDATE_SUCCESS.get(new Object[0]));
                if (sender instanceof Player) {
                    Bukkit.getConsoleSender().sendMessage(LibsMsg.UPDATE_SUCCESS.get(new Object[0]));
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPDATE;
    }
}

